/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.softwaremanager;

import com.tridium.platDaemon.ui.softwaremanager.BInstallerTableRowFilter;
import com.tridium.platDaemon.ui.softwaremanager.InstallerTableRow;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BStatusFilter
extends BInstallerTableRowFilter {
    public static final Property statusString = BStatusFilter.newProperty((int)0, (String)"", null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$platDaemon$ui$softwaremanager$BStatusFilter == null ? (class$com$tridium$platDaemon$ui$softwaremanager$BStatusFilter = BStatusFilter.class$("com.tridium.platDaemon.ui.softwaremanager.BStatusFilter")) : class$com$tridium$platDaemon$ui$softwaremanager$BStatusFilter));
    private int[] statusValues;
    private boolean formatting = false;
    private static Map statusTextMap = null;
    static /* synthetic */ Class class$com$tridium$platDaemon$ui$softwaremanager$BStatusFilter;

    public String getStatusString() {
        return this.getString(statusString);
    }

    public void setStatusString(String string) {
        this.setString(statusString, string, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BStatusFilter() {
        this(new int[0]);
    }

    public BStatusFilter(int[] nArray) {
        this.statusValues = nArray;
        this.formatStatusString();
    }

    protected synchronized boolean doAccept(InstallerTableRow installerTableRow) {
        for (int i = 0; i < this.statusValues.length; ++i) {
            if (installerTableRow.getStatus() != this.statusValues[i]) continue;
            return true;
        }
        return false;
    }

    public synchronized void include(int n) {
        this.include(new int[]{n});
    }

    public synchronized void include(int[] nArray) {
        boolean bl = false;
        for (int i = 0; i < nArray.length; ++i) {
            int n;
            if (nArray[i] == 3 || nArray[i] == 12 || nArray[i] == 4 || (n = this.indexOf(nArray[i])) >= 0) continue;
            int[] nArray2 = new int[this.statusValues.length + 1];
            nArray2[0] = nArray[i];
            System.arraycopy(this.statusValues, 0, nArray2, 1, this.statusValues.length);
            this.statusValues = nArray2;
            bl = true;
        }
        if (bl) {
            this.formatStatusString();
        }
    }

    public synchronized void exclude(int n) {
        this.exclude(new int[]{n});
    }

    public synchronized void exclude(int[] nArray) {
        boolean bl = false;
        for (int i = 0; i < nArray.length; ++i) {
            int n;
            if (nArray[i] == 3 || nArray[i] == 12 || nArray[i] == 4 || (n = this.indexOf(nArray[i])) < 0) continue;
            int[] nArray2 = new int[this.statusValues.length - 1];
            if (n > 0) {
                System.arraycopy(this.statusValues, 0, nArray2, 0, n);
            }
            if (n < this.statusValues.length - 1) {
                System.arraycopy(this.statusValues, n + 1, nArray2, n, this.statusValues.length - n - 1);
            }
            this.statusValues = nArray2;
            bl = true;
        }
        if (bl) {
            this.formatStatusString();
        }
    }

    private synchronized int indexOf(int n) {
        for (int i = 0; i < this.statusValues.length; ++i) {
            if (this.statusValues[i] != n) continue;
            return i;
        }
        return -1;
    }

    public String[] getStatusStrings() {
        return TextUtil.split((String)this.getStatusString(), (char)'|');
    }

    public static String[] getAvailableStrings() {
        return new String[]{BStatusFilter.statusToString(6), BStatusFilter.statusToString(13), BStatusFilter.statusToString(2), BStatusFilter.statusToString(7), BStatusFilter.statusToString(8), BStatusFilter.statusToString(11)};
    }

    public static String statusToString(int n) {
        switch (n) {
            case 6: {
                return TYPE.getModule().getLexicon().getText("SoftwareManager.status.notInstalled");
            }
            case 13: {
                return TYPE.getModule().getLexicon().getText("SoftwareManager.status.needCommissioningMissing");
            }
            case 1: 
            case 2: 
            case 5: {
                return TYPE.getModule().getLexicon().getText("SoftwareManager.status.upToDate");
            }
            case 7: {
                return TYPE.getModule().getLexicon().getText("SoftwareManager.status.badInstallable");
            }
            case 8: 
            case 9: {
                return TYPE.getModule().getLexicon().getText("SoftwareManager.status.badTarget");
            }
            case 11: {
                return TYPE.getModule().getLexicon().getText("SoftwareManager.status.noLocal");
            }
        }
        return "";
    }

    public static int[] stringToStatus(String string) {
        Array array = (Array)BStatusFilter.getStatusTextMap().get(string);
        if (array == null) {
            return new int[0];
        }
        int[] nArray = new int[array.size()];
        for (int i = 0; i < array.size(); ++i) {
            nArray[i] = (Integer)array.get(i);
        }
        return nArray;
    }

    private static Map getStatusTextMap() {
        if (statusTextMap == null) {
            statusTextMap = new HashMap();
            BStatusFilter.updateMapEntry(0, statusTextMap);
            BStatusFilter.updateMapEntry(1, statusTextMap);
            BStatusFilter.updateMapEntry(2, statusTextMap);
            BStatusFilter.updateMapEntry(5, statusTextMap);
            BStatusFilter.updateMapEntry(6, statusTextMap);
            BStatusFilter.updateMapEntry(13, statusTextMap);
            BStatusFilter.updateMapEntry(7, statusTextMap);
            BStatusFilter.updateMapEntry(8, statusTextMap);
            BStatusFilter.updateMapEntry(9, statusTextMap);
            BStatusFilter.updateMapEntry(11, statusTextMap);
        }
        return statusTextMap;
    }

    private static void updateMapEntry(int n, Map map) {
        String string = BStatusFilter.statusToString(n);
        Array array = (Array)map.get(string);
        if (array == null) {
            array = new Array();
            map.put(string, array);
        }
        array.add((Object)new Integer(n));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseStatusString() {
        if (this.formatting) {
            return;
        }
        Property property = statusString;
        synchronized (property) {
            String[] stringArray = this.getStatusStrings();
            int[] nArray = new int[50];
            int n = 0;
            for (int i = 0; i < stringArray.length; ++i) {
                int[] nArray2 = BStatusFilter.stringToStatus(stringArray[i]);
                for (int j = 0; j < nArray2.length; ++j) {
                    nArray[n++] = nArray2[j];
                }
            }
            int[] nArray3 = new int[n];
            System.arraycopy(nArray, 0, nArray3, 0, n);
            this.statusValues = nArray3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void formatStatusString() {
        Property property = statusString;
        synchronized (property) {
            this.formatting = true;
            StringBuffer stringBuffer = new StringBuffer();
            HashSet<String> hashSet = new HashSet<String>();
            for (int i = 0; i < this.statusValues.length; ++i) {
                hashSet.add(BStatusFilter.statusToString(this.statusValues[i]));
            }
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append("|");
                }
                stringBuffer.append(iterator.next());
            }
            this.setStatusString(stringBuffer.toString());
            this.formatting = false;
        }
    }

    public void changed(Property property, Context context) {
        if (property == statusString) {
            this.parseStatusString();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

