/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.softwaremanager;

import com.tridium.install.BDependency;
import com.tridium.install.BPartInstallStatus;
import com.tridium.install.installable.BInstallable;
import com.tridium.install.installable.LocalInstallableRegistry;
import com.tridium.install.part.BModulePart;
import com.tridium.platDaemon.ui.BDaemonSessionView;
import com.tridium.platDaemon.ui.softwaremanager.BInstallerTableFilterPrompt;
import com.tridium.platDaemon.ui.softwaremanager.BPartDetailsPane;
import com.tridium.platDaemon.ui.softwaremanager.BSoftwareManagerFilter;
import com.tridium.platDaemon.ui.softwaremanager.CancelDowngradeCommand;
import com.tridium.platDaemon.ui.softwaremanager.CancelInstallCommand;
import com.tridium.platDaemon.ui.softwaremanager.CancelReinstallCommand;
import com.tridium.platDaemon.ui.softwaremanager.CancelUninstallCommand;
import com.tridium.platDaemon.ui.softwaremanager.CancelUpgradeCommand;
import com.tridium.platDaemon.ui.softwaremanager.CommitCommand;
import com.tridium.platDaemon.ui.softwaremanager.DowngradeCommand;
import com.tridium.platDaemon.ui.softwaremanager.InstallCommand;
import com.tridium.platDaemon.ui.softwaremanager.InstallVersionCommand;
import com.tridium.platDaemon.ui.softwaremanager.InstallerCellRenderer;
import com.tridium.platDaemon.ui.softwaremanager.InstallerTableModel;
import com.tridium.platDaemon.ui.softwaremanager.ReinstallCommand;
import com.tridium.platDaemon.ui.softwaremanager.ResetCommand;
import com.tridium.platDaemon.ui.softwaremanager.UninstallCommand;
import com.tridium.platDaemon.ui.softwaremanager.UpgradeCommand;
import com.tridium.platDaemon.ui.softwaremanager.UpgradeOutOfDateCommand;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.DaemonFileUtil;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import com.tridium.platform.ui.util.AsyncCommand;
import com.tridium.platform.ui.util.AsyncGroup;
import com.tridium.platform.ui.util.BBox;
import com.tridium.platform.ui.util.CommandUtil;
import com.tridium.platform.ui.util.LabelUtil;
import com.tridium.ui.theme.Theme;
import java.net.ConnectException;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.BLocalFileStore;
import javax.baja.file.FilePath;
import javax.baja.file.zip.BZipSpace;
import javax.baja.gx.BBrush;
import javax.baja.gx.BInsets;
import javax.baja.gx.IInsets;
import javax.baja.gx.Insets;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.UnresolvedException;
import javax.baja.security.AuthenticationException;
import javax.baja.space.BSpace;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BAbstractButton;
import javax.baja.ui.BActionMenuItem;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BMenu;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BScrollBarPolicy;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.file.BDirectoryChooser;
import javax.baja.ui.file.BFileChooser;
import javax.baja.ui.options.BOptions;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BFlowPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableCellRenderer;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.util.LexiconText;

public class BSoftwareManager
extends BDaemonSessionView {
    public static final Action handleTableModified = BSoftwareManager.newAction((int)0, null);
    public static final Action handleSelectionModified = BSoftwareManager.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$platDaemon$ui$softwaremanager$BSoftwareManager == null ? (class$com$tridium$platDaemon$ui$softwaremanager$BSoftwareManager = BSoftwareManager.class$("com.tridium.platDaemon.ui.softwaremanager.BSoftwareManager")) : class$com$tridium$platDaemon$ui$softwaremanager$BSoftwareManager));
    BTable table;
    InstallerTableModel tableModel;
    private BButton leftButton;
    private BButton rightButton;
    private BButton resetButton;
    private BButton commitButton;
    private static String swPath = null;
    private BLabel currentSpaceLabel;
    private BLabel spaceDeltaLabel;
    private BLabel afterSpaceLabel;
    private long currentFreeSpace;
    boolean trapSelectionModified = true;
    private AsyncCommand cancelInstallCommand;
    private AsyncCommand cancelUninstallCommand;
    private AsyncCommand cancelUpgradeCommand;
    private AsyncCommand cancelReinstallCommand;
    private AsyncCommand cancelDowngradeCommand;
    private AsyncCommand commitCommand;
    private AsyncCommand installCommand;
    private AsyncCommand resetCommand;
    private AsyncCommand uninstallCommand;
    private AsyncCommand upgradeCommand;
    private AsyncCommand reinstallCommand;
    private AsyncCommand downgradeCommand;
    private AsyncCommand upgradeOODCommand;
    private Command[] leftButtonCommands;
    private Command[] rightButtonCommands;
    static /* synthetic */ Class class$com$tridium$platDaemon$ui$softwaremanager$BSoftwareManager;

    public void handleTableModified() {
        this.invoke(handleTableModified, null, null);
    }

    public void handleSelectionModified() {
        this.invoke(handleSelectionModified, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BSoftwareManager() {
        BGridPane bGridPane = new BGridPane(7);
        BLabel bLabel = new BLabel(DaemonFileUtil.kbFormat.format(88888888L));
        bLabel.computePreferredSize();
        BLabel bLabel2 = new BLabel(DaemonFileUtil.kbFormat.format(88888L));
        bLabel2.computePreferredSize();
        bGridPane.add(null, (BValue)new BNullWidget());
        bGridPane.add(null, (BValue)new BNullWidget());
        bGridPane.add(null, (BValue)new BBox((double)((int)bLabel.getPreferredWidth() + 5), 0.0));
        bGridPane.add(null, (BValue)new BNullWidget());
        bGridPane.add(null, (BValue)new BBox((double)((int)bLabel2.getPreferredWidth() + 5), 0.0));
        bGridPane.add(null, (BValue)new BNullWidget());
        bGridPane.add(null, (BValue)new BBox((double)((int)bLabel.getPreferredWidth() + 5), 0.0));
        bGridPane.setHalign(BHalign.left);
        BButton bButton = new BButton((Command)new EditFilterCommand(), false, true);
        bGridPane.add("editFilter", (BValue)bButton);
        bButton.setButtonStyle(BButtonStyle.toolBar);
        this.currentSpaceLabel = new BLabel();
        LabelUtil.addLabelWidgetPair((BGridPane)bGridPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"SoftwareManager.currentSpaceLabel"), (BWidget)this.currentSpaceLabel);
        this.spaceDeltaLabel = new BLabel();
        LabelUtil.addLabelWidgetPair((BGridPane)bGridPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"SoftwareManager.spaceDeltaLabel"), (BWidget)this.spaceDeltaLabel);
        this.afterSpaceLabel = new BLabel();
        LabelUtil.addLabelWidgetPair((BGridPane)bGridPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"SoftwareManager.afterSpaceLabel"), (BWidget)this.afterSpaceLabel);
        BGridPane bGridPane2 = new BGridPane(1);
        bGridPane2.setHalign(BHalign.left);
        bGridPane2.add(null, (BValue)new BBorderPane((BWidget)bGridPane, 0.0, 0.0, 4.0, 0.0));
        this.tableModel = new InstallerTableModel();
        this.table = new BTable((TableModel)this.tableModel);
        this.tableModel.setFilter(this.loadFilter());
        this.table.setCellRenderer((TableCellRenderer)new InstallerCellRenderer());
        this.table.setController((TableController)new ModuleTableController());
        AsyncGroup asyncGroup = new AsyncGroup();
        this.cancelInstallCommand = new CancelInstallCommand((BWidget)this, this.tableModel);
        asyncGroup.add((AsyncGroup.AsyncGroupMember)this.cancelInstallCommand);
        this.cancelUninstallCommand = new CancelUninstallCommand((BWidget)this, this.tableModel);
        asyncGroup.add((AsyncGroup.AsyncGroupMember)this.cancelUninstallCommand);
        this.cancelUpgradeCommand = new CancelUpgradeCommand((BWidget)this, this.tableModel);
        asyncGroup.add((AsyncGroup.AsyncGroupMember)this.cancelUpgradeCommand);
        this.cancelReinstallCommand = new CancelReinstallCommand((BWidget)this, this.tableModel);
        asyncGroup.add((AsyncGroup.AsyncGroupMember)this.cancelReinstallCommand);
        this.cancelDowngradeCommand = new CancelDowngradeCommand((BWidget)this, this.tableModel);
        asyncGroup.add((AsyncGroup.AsyncGroupMember)this.cancelDowngradeCommand);
        this.commitCommand = new CommitCommand(this);
        asyncGroup.add((AsyncGroup.AsyncGroupMember)this.commitCommand);
        this.installCommand = new InstallCommand((BWidget)this, this.tableModel);
        asyncGroup.add((AsyncGroup.AsyncGroupMember)this.installCommand);
        this.resetCommand = new ResetCommand((BWidget)this, this.tableModel);
        asyncGroup.add((AsyncGroup.AsyncGroupMember)this.resetCommand);
        this.uninstallCommand = new UninstallCommand((BWidget)this, this.tableModel);
        asyncGroup.add((AsyncGroup.AsyncGroupMember)this.uninstallCommand);
        this.upgradeCommand = new UpgradeCommand((BWidget)this, this.tableModel);
        asyncGroup.add((AsyncGroup.AsyncGroupMember)this.upgradeCommand);
        this.reinstallCommand = new ReinstallCommand((BWidget)this, this.tableModel);
        asyncGroup.add((AsyncGroup.AsyncGroupMember)this.reinstallCommand);
        this.downgradeCommand = new DowngradeCommand((BWidget)this, this.tableModel);
        asyncGroup.add((AsyncGroup.AsyncGroupMember)this.downgradeCommand);
        this.upgradeOODCommand = new UpgradeOutOfDateCommand((BWidget)this, this.tableModel);
        asyncGroup.add((AsyncGroup.AsyncGroupMember)this.upgradeOODCommand);
        this.resetCommand.setEnabled(false);
        this.installCommand.setEnabled(false);
        this.uninstallCommand.setEnabled(false);
        this.commitCommand.setEnabled(false);
        this.upgradeOODCommand.setEnabled(false);
        this.leftButtonCommands = new Command[]{this.installCommand, this.reinstallCommand, this.upgradeCommand, this.downgradeCommand, this.cancelInstallCommand, this.cancelUpgradeCommand, this.cancelUpgradeCommand, this.cancelDowngradeCommand};
        this.rightButtonCommands = new Command[]{this.uninstallCommand, this.cancelUninstallCommand};
        this.linkTo((BComponent)this.table, (Slot)BTable.selectionModified, (Slot)handleSelectionModified);
        this.linkTo((BComponent)this.table, (Slot)BTable.tableModified, (Slot)handleTableModified);
        Insets insets = new Insets(4.0, 3.0, 4.0, 3.0);
        BFlowPane bFlowPane = new BFlowPane(BHalign.center);
        bButton = new BButton((Command)this.upgradeOODCommand, true, false);
        bFlowPane.add("upgradeOOD", (BValue)bButton);
        bButton.setPadding(BInsets.make((IInsets)insets));
        bFlowPane.add("spacer1", (BValue)new BBox(3.0, 0.0));
        bButton = new BButton((Command)new ImportSoftwareCommand(), true, false);
        bButton.setPadding(BInsets.make((IInsets)insets));
        bButton.setMenuController((BAbstractButton.MenuController)new ImportMenuController());
        bFlowPane.add("import", (BValue)bButton);
        bFlowPane.add("spacer2", (BValue)new BBox(3.0, 0.0));
        this.leftButton = new BButton((Command)this.installCommand, true, false);
        bFlowPane.add("leftButton", (BValue)this.leftButton);
        this.leftButton.setPadding(BInsets.make((IInsets)insets));
        this.rightButton = new BButton((Command)this.uninstallCommand, true, false);
        bFlowPane.add("rightButton", (BValue)this.rightButton);
        this.rightButton.setPadding(BInsets.make((IInsets)insets));
        this.resetButton = new BButton((Command)this.resetCommand, true, false);
        bFlowPane.add("resetButton", (BValue)this.resetButton);
        this.resetButton.setPadding(BInsets.make((IInsets)insets));
        this.commitButton = new BButton((Command)this.commitCommand, true, false);
        bFlowPane.add("commitButton", (BValue)this.commitButton);
        this.commitButton.setPadding(BInsets.make((IInsets)insets));
        this.setContent((BWidget)new BEdgePane((BWidget)new BBorderPane((BWidget)bGridPane2, 0.0, 0.0, 0.0, 4.0), (BWidget)new BBorderPane((BWidget)bFlowPane, 4.0, 0.0, 4.0, 0.0), null, null, (BWidget)new BBorderPane((BWidget)new BBorderPane((BWidget)this.table, BBorder.inset, BInsets.DEFAULT), 0.0, 4.0, 0.0, 0.0)));
    }

    protected final void doLoadSession(BDaemonSession bDaemonSession, Context context) throws AuthenticationException {
        try {
            LocalInstallableRegistry.getInstance().init((DaemonSessionTaskListener)this);
            this.tableModel.init(bDaemonSession, this);
            this.currentFreeSpace = DaemonFileUtil.getFilesystemAttributes((BDaemonSession)bDaemonSession, (FilePath)new FilePath("!modules")).getFreeSpace();
            this.currentSpaceLabel.setText(DaemonFileUtil.kbFormat.format(this.currentFreeSpace));
            this.spaceDeltaLabel.setText(DaemonFileUtil.kbFormat.format(0L));
            this.afterSpaceLabel.setText(DaemonFileUtil.kbFormat.format(this.currentFreeSpace));
        }
        catch (AuthenticationException authenticationException) {
            throw authenticationException;
        }
        catch (ConnectException connectException) {
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new BajaRuntimeException((Throwable)exception);
        }
    }

    protected BSoftwareManagerFilter loadFilter() {
        BSoftwareManagerFilter bSoftwareManagerFilter;
        try {
            BOptions bOptions = BOptions.load((String)this.getType().toString(), (Type)BOptions.TYPE);
            bSoftwareManagerFilter = (BSoftwareManagerFilter)bOptions.get("filter");
            if (bSoftwareManagerFilter == null) {
                bSoftwareManagerFilter = new BSoftwareManagerFilter();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            bSoftwareManagerFilter = new BSoftwareManagerFilter();
        }
        return bSoftwareManagerFilter;
    }

    protected void saveFilter(BSoftwareManagerFilter bSoftwareManagerFilter) {
        try {
            BOptions bOptions = BOptions.load((String)this.getType().toString(), (Type)BOptions.TYPE);
            if (bOptions.get("filter") == null) {
                bOptions.add("filter", bSoftwareManagerFilter.newCopy());
            } else {
                bOptions.set("filter", bSoftwareManagerFilter.newCopy());
            }
            bOptions.save();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void doHandleTableModified() {
        boolean bl = false;
        boolean bl2 = false;
        if (!this.getDaemonSession().usesLocalNiagaraEnvironment()) {
            for (int i = 0; i < this.tableModel.getRowCount(); ++i) {
                int n;
                if (this.tableModel.getInstallStatusAt(i) != BPartInstallStatus.noChange && this.tableModel.getInstallStatusAt(i) != BPartInstallStatus.notFound) {
                    bl = true;
                }
                if ((n = this.tableModel.getStatusAt(i)) == 3 || n == 4) {
                    bl2 = true;
                }
                if (bl && bl2) break;
            }
        }
        this.commitCommand.setEnabled(bl);
        this.upgradeOODCommand.setEnabled(bl2);
        long l = (int)(this.tableModel.getSizeDeltaOnCommit() / 1024L);
        this.spaceDeltaLabel.setText(DaemonFileUtil.kbFormat.format(l));
        long l2 = this.currentFreeSpace - l;
        this.afterSpaceLabel.setText(DaemonFileUtil.kbFormat.format(l2));
        this.handleSelectionModified();
    }

    public void doHandleSelectionModified() {
        boolean bl;
        BPartInstallStatus bPartInstallStatus;
        if (!this.trapSelectionModified) {
            return;
        }
        this.resetCommand.setEnabled(true);
        int[] nArray = this.table.getSelection().getRows();
        if (nArray.length == 0) {
            this.setLeftButtonCommand((Command)this.installCommand, false);
            this.setRightButtonCommand((Command)this.uninstallCommand, false);
            return;
        }
        if (nArray.length > 1) {
            bPartInstallStatus = this.tableModel.getInstallStatusAt(nArray[0]);
            for (bl = true; bl < nArray.length; bl += 1) {
                if (this.tableModel.getInstallStatusAt(nArray[bl]) == bPartInstallStatus) continue;
                this.setLeftButtonCommand((Command)this.installCommand, false);
                this.setRightButtonCommand((Command)this.uninstallCommand, false);
                return;
            }
        }
        if (this.tableModel.getInstallStatusAt(nArray[0]) == BPartInstallStatus.noChange || this.tableModel.getInstallStatusAt(nArray[0]) == BPartInstallStatus.notFound) {
            bPartInstallStatus = null;
            bl = true;
            boolean bl2 = true;
            boolean bl3 = false;
            for (int i = 0; i < nArray.length; ++i) {
                int n = this.tableModel.getStatusAt(nArray[i]);
                if (this.tableModel.getInstallableVersionAt(nArray[i]) == null) {
                    bPartInstallStatus = this.installCommand;
                    bl = false;
                } else {
                    switch (n) {
                        case 7: 
                        case 9: {
                            bPartInstallStatus = this.installCommand;
                            bl = false;
                            break;
                        }
                        case 0: 
                        case 6: 
                        case 13: {
                            bPartInstallStatus = this.installCommand;
                            break;
                        }
                        case 2: 
                        case 4: 
                        case 5: 
                        case 8: {
                            if (bPartInstallStatus != null) break;
                            bPartInstallStatus = this.reinstallCommand;
                            break;
                        }
                        case 3: 
                        case 12: {
                            if (bPartInstallStatus != null) break;
                            bPartInstallStatus = this.upgradeCommand;
                            break;
                        }
                        default: {
                            if (bPartInstallStatus != null) break;
                            bPartInstallStatus = this.downgradeCommand;
                        }
                    }
                }
                if (this.getDaemonSession().usesLocalNiagaraEnvironment()) {
                    bl2 = false;
                    bl = false;
                    continue;
                }
                if (n == 0 || n == 6) {
                    bl2 = false;
                    continue;
                }
                if (!bl2) continue;
                bl3 = true;
                if (this.tableModel.isModule(nArray[i])) {
                    BModulePart bModulePart = (BModulePart)this.tableModel.getCurrentPartAt(nArray[i]);
                    if (bModulePart != null && !bModulePart.getPartName().equals("wbapplet") && !bModulePart.getPartName().equals("build")) continue;
                    bl2 = false;
                    continue;
                }
                bl2 = false;
            }
            if (bPartInstallStatus == null) {
                this.setLeftButtonCommand((Command)this.installCommand, false);
            } else {
                this.setLeftButtonCommand((Command)bPartInstallStatus, bl);
            }
            this.setRightButtonCommand((Command)this.uninstallCommand, bl2 && bl3);
        } else {
            switch (this.tableModel.getInstallStatusAt(nArray[0]).getOrdinal()) {
                case 2: {
                    this.setLeftButtonCommand((Command)this.cancelInstallCommand, true);
                    this.setRightButtonCommand((Command)this.uninstallCommand, false);
                    return;
                }
                case 3: {
                    this.setLeftButtonCommand((Command)this.cancelUpgradeCommand, true);
                    this.setRightButtonCommand((Command)this.uninstallCommand, false);
                    return;
                }
                case 5: {
                    this.setLeftButtonCommand((Command)this.cancelDowngradeCommand, true);
                    this.setRightButtonCommand((Command)this.uninstallCommand, false);
                    return;
                }
                case 4: {
                    this.setLeftButtonCommand((Command)this.cancelReinstallCommand, true);
                    this.setRightButtonCommand((Command)this.uninstallCommand, false);
                    return;
                }
                case 6: {
                    this.setLeftButtonCommand((Command)this.installCommand, false);
                    this.setRightButtonCommand((Command)this.cancelUninstallCommand, true);
                    return;
                }
            }
            BDaemonSessionView.log.warning("unrecognized action " + this.tableModel.getInstallStatusAt(nArray[0]));
        }
    }

    private String getSwPath() {
        if (swPath == null) {
            try {
                swPath = BFileSystem.INSTANCE.pathToLocalFile(new FilePath("!sw")).getCanonicalPath();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new BajaRuntimeException((Throwable)exception);
            }
        }
        return swPath;
    }

    private void setLeftButtonCommand(Command command, boolean bl) {
        for (int i = 0; i < this.leftButtonCommands.length; ++i) {
            this.leftButtonCommands[i].setEnabled(this.leftButtonCommands[i] == command ? bl : false);
        }
        if (command != this.leftButton.getCommand()) {
            this.leftButton.setCommand(command, true, false);
            this.leftButton.relayout();
            this.relayout();
        }
    }

    private void setRightButtonCommand(Command command, boolean bl) {
        for (int i = 0; i < this.rightButtonCommands.length; ++i) {
            this.rightButtonCommands[i].setEnabled(this.rightButtonCommands[i] == command ? bl : false);
        }
        if (command != this.rightButton.getCommand()) {
            this.rightButton.setCommand(command, true, false);
            this.rightButton.relayout();
            this.relayout();
        }
    }

    protected BOrd loadImportDirectory() {
        try {
            BOptions bOptions = BOptions.load((Type)TYPE);
            return (BOrd)bOptions.get("importDir");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    protected void saveImportDirectory(BOrd bOrd) {
        if (bOrd == null) {
            return;
        }
        try {
            BOptions bOptions = BOptions.load((Type)TYPE);
            if (bOptions.get("importDir") == null) {
                bOptions.add("importDir", (BValue)bOrd);
            } else {
                bOptions.set("importDir", (BValue)bOrd);
            }
            bOptions.save();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class ModuleTableController
    extends TableController {
        private ModuleTableController() {
        }

        protected void cellPressed(BMouseEvent bMouseEvent, int n, int n2) {
            if (bMouseEvent.isPopupTrigger()) {
                super.cellPressed(bMouseEvent, n, n2);
                return;
            }
            if (n2 != 0 || bMouseEvent.getX() > 14.0) {
                if (bMouseEvent.getClickCount() > 1) {
                    new DetailCommand(n).invoke();
                } else {
                    super.cellPressed(bMouseEvent, n, n2);
                }
                return;
            }
        }

        protected void cellPopup(BMouseEvent bMouseEvent, int n, int n2) {
            BMenu bMenu = new BMenu();
            bMenu.add(null, (BValue)new BActionMenuItem((Command)new DetailCommand(n)), null);
            if (BSoftwareManager.this.table.getSelection().getRowCount() == 1 && (BSoftwareManager.this.tableModel.getInstallStatusAt(n) == BPartInstallStatus.noChange || BSoftwareManager.this.tableModel.getInstallStatusAt(n) == BPartInstallStatus.notFound)) {
                try {
                    BInstallable[] bInstallableArray = LocalInstallableRegistry.getInstance().findInstallables(BDependency.forModule((String)BSoftwareManager.this.tableModel.getNameAt(n)), (DaemonSessionTaskListener)BSoftwareManager.this);
                    for (int i = 0; i < bInstallableArray.length; ++i) {
                        bMenu.add(null, (BValue)new BActionMenuItem((Command)new InstallVersionCommand(BSoftwareManager.this.tableModel, bInstallableArray[i])), null);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else {
                bMenu.add(null, (BValue)new BActionMenuItem(BSoftwareManager.this.leftButton.getCommand()), null);
            }
            bMenu.add(null, (BValue)new BActionMenuItem(BSoftwareManager.this.rightButton.getCommand()), null);
            bMenu.add(null, (BValue)new BSeparator());
            bMenu.add(null, (BValue)new BActionMenuItem((Command)BSoftwareManager.this.upgradeOODCommand), null);
            bMenu.add(null, (BValue)new BSeparator());
            bMenu.add(null, (BValue)new BActionMenuItem((Command)BSoftwareManager.this.commitCommand), null);
            bMenu.add(null, (BValue)new BActionMenuItem((Command)BSoftwareManager.this.resetCommand), null);
            bMenu.open((BWidget)BSoftwareManager.this.table, bMouseEvent.getX(), bMouseEvent.getY());
        }

        public int getTextSearchColumn() {
            return 0;
        }
    }

    private class DetailCommand
    extends Command {
        private int row;

        public DetailCommand(int n) {
            super((BWidget)BSoftwareManager.this, TYPE.getModule(), "SoftwareManager.command.details");
            this.row = n;
        }

        public CommandArtifact doInvoke() {
            try {
                BPartDetailsPane bPartDetailsPane = new BPartDetailsPane();
                bPartDetailsPane.loadValue(BSoftwareManager.this.tableModel.getCurrentPartAt(this.row), BSoftwareManager.this.tableModel.getInstallablePartAt(this.row), BSoftwareManager.this.tableModel.getTypeAt(this.row), BSoftwareManager.this.tableModel.getForwardDependenciesAt(this.row), BSoftwareManager.this.tableModel.getDependentPartsAt(this.row));
                BBrush bBrush = Theme.scrollPane().getControlBackground();
                BScrollPane bScrollPane = new BScrollPane((BWidget)new BBorderPane((BWidget)bPartDetailsPane, 10.0, 10.0, 5.0, 10.0));
                bScrollPane.setViewportBackground(bBrush);
                bScrollPane.setBorderPolicy(BScrollBarPolicy.asNeeded);
                BConstrainedPane bConstrainedPane = new BConstrainedPane((BWidget)bScrollPane);
                bConstrainedPane.setFixedSize(500.0, 350.0);
                BDialog.message((BWidget)BSoftwareManager.this, (String)BSoftwareManager.this.getLexicon().getText("SoftwareManager.command.details.dlgTitle"), (Object)bConstrainedPane);
            }
            catch (Throwable throwable) {
                CommandUtil.error((Command)this, (Throwable)throwable);
            }
            return null;
        }
    }

    private class EditFilterCommand
    extends Command {
        public EditFilterCommand() {
            super((BWidget)BSoftwareManager.this, TYPE.getModule(), "SoftwareManager.command.editFilter");
        }

        public CommandArtifact doInvoke() {
            try {
                BSoftwareManagerFilter bSoftwareManagerFilter = BInstallerTableFilterPrompt.getFilter((BWidget)BSoftwareManager.this, (BSoftwareManagerFilter)BSoftwareManager.this.tableModel.getFilter());
                if (bSoftwareManagerFilter != null) {
                    BSoftwareManager.this.tableModel.setFilter(bSoftwareManagerFilter);
                    BSoftwareManager.this.saveFilter(bSoftwareManagerFilter);
                }
            }
            catch (Throwable throwable) {
                CommandUtil.error((Command)this, (Throwable)throwable);
            }
            return null;
        }
    }

    private class ImportDirCommand
    extends AsyncCommand {
        public ImportDirCommand() {
            super((BWidget)BSoftwareManager.this, TYPE.getModule(), "SoftwareManager.command.importDir");
        }

        public void doInvokeAsync() {
            try {
                BOptions bOptions;
                BDirectoryChooser bDirectoryChooser = BDirectoryChooser.make((BWidget)BSoftwareManager.this);
                BOrd bOrd = BSoftwareManager.this.loadImportDirectory();
                if (bOrd != null) {
                    try {
                        bDirectoryChooser.setCurrentDirectory(bOrd);
                    }
                    catch (UnresolvedException unresolvedException) {
                        bOptions = BOptions.load((Type)TYPE);
                        bOptions.remove("importDir");
                        bOptions.save();
                    }
                }
                bDirectoryChooser.setSpaces((BSpace[])new BFileSystem[]{BFileSystem.INSTANCE});
                BOrd bOrd2 = bDirectoryChooser.show();
                if (bOrd2 != null) {
                    BSoftwareManager.this.saveImportDirectory(bDirectoryChooser.getCurrentDirectory());
                    bOptions = (BDirectory)bOrd2.get();
                    String string = ((BLocalFileStore)bOptions.getStore()).getLocalFile().getCanonicalPath();
                    if (string.startsWith(BSoftwareManager.this.getSwPath())) {
                        BDialog.warning((BWidget)BSoftwareManager.this, (String)BSoftwareManager.this.getLexicon().getText("SoftwareManager.command.importSoftware.invalidSource.title"), (Object)BSoftwareManager.this.getLexicon().getText("SoftwareManager.command.importSoftware.invalidSource.message", new Object[]{bOptions.getFileName()}));
                        return;
                    }
                    LocalInstallableRegistry.getInstance().importDirectory((BDirectory)bOptions, (DaemonSessionTaskListener)BSoftwareManager.this);
                    BSoftwareManager.this.tableModel.reload();
                }
            }
            catch (Throwable throwable) {
                CommandUtil.error((Command)this, (Throwable)throwable);
            }
        }
    }

    private class ImportFileCommand
    extends AsyncCommand {
        public ImportFileCommand() {
            super((BWidget)BSoftwareManager.this, TYPE.getModule(), "SoftwareManager.command.importFile");
        }

        public void doInvokeAsync() {
            try {
                BFileChooser bFileChooser = BFileChooser.makeOpen((BWidget)BSoftwareManager.this);
                BOrd bOrd = BSoftwareManager.this.loadImportDirectory();
                if (bOrd != null) {
                    try {
                        bFileChooser.setCurrentDirectory(bOrd);
                    }
                    catch (UnresolvedException unresolvedException) {
                        BOptions bOptions = BOptions.load((Type)TYPE);
                        bOptions.remove("importDir");
                        bOptions.save();
                    }
                }
                bFileChooser.setSpaces((BSpace[])new BFileSystem[]{BFileSystem.INSTANCE});
                BOrd[] bOrdArray = bFileChooser.show(true);
                if (bOrdArray != null && bOrdArray.length > 0) {
                    BSoftwareManager.this.saveImportDirectory(bFileChooser.getCurrentDirectory());
                    boolean bl = false;
                    for (int i = 0; i < bOrdArray.length; ++i) {
                        BIFile bIFile;
                        BOrd bOrd2;
                        Object object;
                        BObject bObject = bOrdArray[i].get();
                        if (bObject instanceof BZipSpace) {
                            object = bOrdArray[i].parse();
                            bOrd2 = BOrd.make((OrdQuery[])object, (int)0, (int)(((OrdQuery[])object).length - 1));
                            bIFile = (BIFile)bOrd2.get();
                        } else {
                            bIFile = (BIFile)bObject;
                        }
                        object = ((BLocalFileStore)bIFile.getStore()).getLocalFile().getCanonicalPath();
                        if (((String)object).startsWith(BSoftwareManager.this.getSwPath())) {
                            BDialog.warning((BWidget)BSoftwareManager.this, (String)BSoftwareManager.this.getLexicon().getText("SoftwareManager.command.importSoftware.invalidSource.title"), (Object)BSoftwareManager.this.getLexicon().getText("SoftwareManager.command.importSoftware.invalidSource.message", new Object[]{bIFile.getFileName()}));
                            return;
                        }
                        bOrd2 = BInstallable.make((BIFile)bIFile);
                        if (bOrd2 == null) {
                            BDialog.warning((BWidget)BSoftwareManager.this, (String)BSoftwareManager.this.getLexicon().getText("SoftwareManager.command.importSoftware.notInstallable.title"), (Object)BSoftwareManager.this.getLexicon().getText("SoftwareManager.command.importSoftware.notInstallable.message", new Object[]{bIFile.getFileName()}));
                            continue;
                        }
                        LocalInstallableRegistry.getInstance().register((BInstallable)bOrd2, (DaemonSessionTaskListener)BSoftwareManager.this);
                        bl = true;
                    }
                    if (bl) {
                        BSoftwareManager.this.tableModel.reload();
                    }
                }
            }
            catch (Throwable throwable) {
                CommandUtil.error((Command)this, (Throwable)throwable);
            }
        }
    }

    private class ImportSoftwareCommand
    extends AsyncCommand {
        public ImportSoftwareCommand() {
            super((BWidget)BSoftwareManager.this, TYPE.getModule(), "SoftwareManager.command.importSoftware");
        }

        public void doInvokeAsync() {
        }
    }

    private class ImportMenuController
    implements BAbstractButton.MenuController {
        public boolean isMenuDistinct() {
            return false;
        }

        public BMenu getMenu(BAbstractButton bAbstractButton) {
            BMenu bMenu = new BMenu();
            bMenu.add(null, (Command)new ImportFileCommand());
            bMenu.add(null, (Command)new ImportDirCommand());
            return bMenu;
        }
    }
}

