/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.r2tools.r2commissioningwizard;

import com.tridium.platDaemon.ui.r2tools.r2commissioningwizard.R2CommissioningWizardModel;
import com.tridium.platDaemon.ui.r2tools.r2commissioningwizard.R2CommissioningWizardStep;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.BR2StationSurrogate;
import com.tridium.platform.daemon.DaemonFileUtil;
import com.tridium.platform.daemon.file.BDaemonDirectoryStore;
import com.tridium.platform.daemon.file.BDaemonFileSpace;
import com.tridium.platform.daemon.message.FileTransferMessage;
import com.tridium.platform.ui.util.BBox;
import com.tridium.platform.ui.util.LabelUtil;
import com.tridium.ui.theme.Theme;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.BIFileStore;
import javax.baja.file.FilePath;
import javax.baja.gx.BInsets;
import javax.baja.nav.BINavNode;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.IFilter;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.ui.BBorder;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BScrollBarPolicy;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.list.BList;
import javax.baja.ui.list.ListController;
import javax.baja.ui.list.ListModel;
import javax.baja.ui.list.ListSelection;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.util.LexiconText;

public class R2StationStep
extends R2CommissioningWizardStep {
    private boolean stepInitialized = false;
    private R2StationListModel listModel;
    private BCheckBox autoStartCheckBox;
    private BCheckBox restartOnFailureCheckBox;
    private BR2StationSurrogate remoteR2Station = null;
    static /* synthetic */ Class class$javax$baja$file$BDirectory;

    public R2StationStep(R2CommissioningWizardModel r2CommissioningWizardModel) {
        super(r2CommissioningWizardModel);
        BGridPane bGridPane = new BGridPane(1);
        bGridPane.setHalign(BHalign.left);
        bGridPane.setValign(BValign.top);
        BGridPane bGridPane2 = new BGridPane(2);
        bGridPane2.setValign(BValign.top);
        bGridPane2.setRowAlign(BValign.top);
        bGridPane2.setHalign(BHalign.left);
        BListDropDown bListDropDown = new BListDropDown();
        this.listModel = new R2StationListModel();
        bListDropDown.getList().setModel((ListModel)this.listModel);
        bListDropDown.getList().setMultipleSelection(false);
        bListDropDown.getList().setController((ListController)new R2StationListController(this));
        LabelUtil.addLabelWidgetPair((BGridPane)bGridPane2, (LexiconText)this.getLexiconText("R2CommissioningWizard.stationStep.chooseStation"), (BWidget)bListDropDown);
        bGridPane.add(null, (BValue)bGridPane2);
        bGridPane.add(null, (BValue)new BBox(0.0, 5.0));
        this.autoStartCheckBox = new BCheckBox(lex.getText("StationCopier.StartStationStep.autoStart.description"));
        bGridPane.add(null, (BValue)this.autoStartCheckBox);
        this.autoStartCheckBox.setEnabled(false);
        this.restartOnFailureCheckBox = new BCheckBox(lex.getText("StationCopier.StartStationStep.autoRestart.description"));
        bGridPane.add(null, (BValue)this.restartOnFailureCheckBox);
        this.restartOnFailureCheckBox.setEnabled(false);
        this.setContent((BWidget)new BEdgePane((BWidget)new BLabel(lex.getText("R2CommissioningWizard.stationStep.header"), BHalign.left), null, null, null, (BWidget)new BBorderPane((BWidget)bGridPane, 4.0, 0.0, 0.0, 0.0)));
        DeleteStep deleteStep = new DeleteStep(r2CommissioningWizardModel);
        this.nextStep = deleteStep;
        deleteStep.priorStep = this;
        this.lastStep = deleteStep;
    }

    public String getStepName() {
        return "stationInstall";
    }

    public String getSectionName() {
        return "install";
    }

    public void enter() {
        this.initStep();
        int n = this.listModel.indexOfDirectory(this.wizardModel.r2StationDir);
        if (n >= 0) {
            this.listModel.getList().setSelectedIndex(n);
        } else {
            this.listModel.getList().getSelection().deselectAll();
        }
        if (this.autoStartCheckBox != null) {
            this.autoStartCheckBox.setSelected(this.wizardModel.autoStart);
        }
        if (this.restartOnFailureCheckBox != null) {
            this.restartOnFailureCheckBox.setSelected(this.wizardModel.restartOnFailure);
        }
    }

    public boolean exit(int n) {
        if (this.listModel.getList().getSelectedIndex() <= 0) {
            this.wizardModel.r2StationDir = null;
            this.wizardModel.targetR2StationName = null;
            this.wizardModel.r2StationSurrogate = null;
            return true;
        }
        this.wizardModel.r2StationDir = this.listModel.getStationDirectory(this.listModel.getList().getSelectedIndex());
        if (this.remoteR2Station == null) {
            this.wizardModel.targetR2StationName = this.wizardModel.r2StationDir.getFileName();
            this.wizardModel.r2StationSurrogate = null;
        } else {
            this.wizardModel.targetR2StationName = this.remoteR2Station.getR2StationName();
            this.wizardModel.r2StationSurrogate = this.remoteR2Station;
        }
        if (this.autoStartCheckBox != null) {
            this.wizardModel.autoStart = this.autoStartCheckBox.isSelected();
        }
        if (this.restartOnFailureCheckBox != null) {
            this.wizardModel.restartOnFailure = this.restartOnFailureCheckBox.isSelected();
        }
        return true;
    }

    public int getMode() {
        if (this.listModel.getList().getSelectedIndex() == 0 || this.listModel.getList().getSelectedIndex() > 0) {
            return 3;
        }
        return 1;
    }

    public boolean isSkipped() {
        return this.wizardModel.skipStationInstall;
    }

    private void initStep() {
        this.listModel.init();
        if (!this.stepInitialized) {
            try {
                if (this.wizardModel.remoteNiagaraR2Exists) {
                    BDaemonDirectoryStore bDaemonDirectoryStore = BDaemonDirectoryStore.make((BDaemonFileSpace)this.wizardModel.daemonSession.getFileSpace(), (FilePath)new FilePath("!niagaraR2/rel/stations"));
                    if (bDaemonDirectoryStore == null) {
                        DaemonFileUtil.transfer((BDaemonSession)this.wizardModel.daemonSession, (FileTransferMessage)FileTransferMessage.makeMkDir((FilePath)new FilePath("!niagaraR2/rel/stations"), (BDaemonFileSpace)this.wizardModel.daemonSession.getFileSpace()), null, null);
                        bDaemonDirectoryStore = BDaemonDirectoryStore.make((BDaemonFileSpace)this.wizardModel.daemonSession.getFileSpace(), (FilePath)new FilePath("!niagaraR2/rel/stations"));
                    }
                    this.wizardModel.targetR2StationsRoot = new BDirectory((BIFileStore)bDaemonDirectoryStore);
                } else {
                    this.wizardModel.targetR2StationsRoot = null;
                }
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new BajaRuntimeException((Throwable)exception);
            }
            this.stepInitialized = true;
        }
    }

    public void setStationName(String string) throws Exception {
        if (string == null) {
            this.remoteR2Station = null;
            if (this.autoStartCheckBox != null) {
                this.autoStartCheckBox.setEnabled(false);
            }
            if (this.restartOnFailureCheckBox != null) {
                this.restartOnFailureCheckBox.setEnabled(false);
            }
        } else {
            this.remoteR2Station = this.wizardModel.remoteNiagaraR2Exists ? BR2StationSurrogate.make((BDaemonSession)this.wizardModel.daemonSession, (String)string) : null;
            if (this.autoStartCheckBox != null) {
                this.autoStartCheckBox.setEnabled(true);
                this.autoStartCheckBox.setSelected(this.wizardModel.autoStart);
            }
            if (this.restartOnFailureCheckBox != null) {
                this.restartOnFailureCheckBox.setEnabled(true);
                this.restartOnFailureCheckBox.setSelected(this.wizardModel.restartOnFailure);
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class RemoteStationListSelection
    extends ListSelection {
        private R2CommissioningWizardStep step;

        public RemoteStationListSelection(R2CommissioningWizardStep r2CommissioningWizardStep) {
            this.step = r2CommissioningWizardStep;
        }

        public void select(int n, boolean bl) {
            super.select(n, bl);
            this.step.wizardModel.update(this.step.getMode());
        }

        public void select(int n, int n2, boolean bl) {
            super.select(n, n2, bl);
            this.step.wizardModel.update(this.step.getMode());
        }

        public void select(int[] nArray) {
            super.select(nArray);
            this.step.wizardModel.update(this.step.getMode());
        }

        public void deselect(int n) {
            super.deselect(n);
            this.step.wizardModel.update(this.step.getMode());
        }

        public void deselectAll() {
            super.deselectAll();
            this.step.wizardModel.update(this.step.getMode());
        }
    }

    private static class RemoteR2StationListModel
    extends ListModel {
        BR2StationSurrogate[] stations;

        public RemoteR2StationListModel(R2CommissioningWizardModel r2CommissioningWizardModel) {
            Array array = new Array((Object[])r2CommissioningWizardModel.getSurrogates());
            array = array.filter(new IFilter(){

                public boolean accept(Object object) {
                    return object instanceof BR2StationSurrogate;
                }
            });
            this.stations = new BR2StationSurrogate[array.size()];
            for (int i = 0; i < array.size(); ++i) {
                this.stations[i] = (BR2StationSurrogate)array.get(i);
            }
        }

        public Object getItem(int n) {
            return this.getR2Station(n).getR2StationName();
        }

        public BR2StationSurrogate getR2Station(int n) {
            return this.stations[n];
        }

        public int indexOfStation(BR2StationSurrogate bR2StationSurrogate) {
            if (bR2StationSurrogate == null) {
                return -1;
            }
            for (int i = 0; i < this.stations.length; ++i) {
                if (!bR2StationSurrogate.getR2StationName().equals(this.stations[i].getR2StationName())) continue;
                return i;
            }
            return -1;
        }

        public int getItemCount() {
            return this.stations.length;
        }
    }

    private static class DeleteStep
    extends R2CommissioningWizardStep {
        private RemoteR2StationListModel listModel = null;
        private boolean stepInitialized = false;

        public DeleteStep(R2CommissioningWizardModel r2CommissioningWizardModel) {
            super(r2CommissioningWizardModel);
        }

        public String getStepName() {
            return "stationDelete";
        }

        public String getSectionName() {
            return "install";
        }

        public void enter() {
            this.initStep();
            if (this.listModel.getList() != null) {
                this.listModel.getSelection().deselectAll();
                for (int i = 0; i < this.wizardModel.stationsToDelete.size(); ++i) {
                    int n = this.listModel.indexOfStation((BR2StationSurrogate)this.wizardModel.stationsToDelete.get(i));
                    if (n < 0) continue;
                    this.listModel.getList().getSelection().select(n);
                }
            }
        }

        public boolean exit(int n) {
            this.wizardModel.stationsToDelete.clear();
            if (this.listModel.getItemCount() > 1) {
                int[] nArray = this.listModel.getList().getSelectedIndices();
                for (int i = 0; i < nArray.length; ++i) {
                    this.wizardModel.stationsToDelete.add((Object)this.listModel.getR2Station(nArray[i]));
                }
            } else if (this.listModel.getItemCount() == 1) {
                this.wizardModel.stationsToDelete.add((Object)this.listModel.getR2Station(0));
            }
            return true;
        }

        public int getMode() {
            this.initStep();
            if (this.listModel.getItemCount() < 2 || this.listModel.getList().getSelectedIndex() >= 0) {
                return 3;
            }
            return 1;
        }

        public boolean isSkipped() {
            int n;
            if (this.wizardModel.skipStationInstall || this.wizardModel.targetR2StationName == null) {
                this.wizardModel.stationsToDelete.clear();
                return true;
            }
            int n2 = 0;
            for (n = 0; n < this.wizardModel.getSurrogates().length; ++n) {
                if (!(this.wizardModel.getSurrogates()[n] instanceof BR2StationSurrogate)) continue;
                ++n2;
            }
            n = this.wizardModel.daemonSession.getHostProperties().getMaxStations();
            return n2 < n;
        }

        private void initStep() {
            if (!this.stepInitialized) {
                this.listModel = new RemoteR2StationListModel(this.wizardModel);
                if (this.listModel.getItemCount() > 1) {
                    BScrollPane bScrollPane = new BScrollPane((BWidget)new BList((ListModel)this.listModel));
                    this.listModel.getList().setSelection((ListSelection)new RemoteStationListSelection(this));
                    bScrollPane.setViewportBackground(Theme.scrollPane().getControlBackground());
                    bScrollPane.setBorderPolicy(BScrollBarPolicy.asNeeded);
                    BLabel bLabel = new BLabel(BDialog.WARNING_ICON, lex.getText("CommissioningWizard.stationDeleteStep.chooseHeader", new Object[]{String.valueOf(this.wizardModel.daemonSession.getHostProperties().getMaxStations())}));
                    bLabel.setHalign(BHalign.left);
                    this.setContent((BWidget)new BEdgePane((BWidget)new BBorderPane((BWidget)bLabel, 0.0, 0.0, 5.0, 0.0), null, null, null, (BWidget)new BBorderPane((BWidget)bScrollPane, BBorder.inset, BInsets.DEFAULT)));
                } else if (this.listModel.getItemCount() == 1) {
                    BLabel bLabel = new BLabel(BDialog.WARNING_ICON, lex.getText("CommissioningWizard.stationDeleteStep.deleteHeader", new Object[]{this.listModel.getR2Station(0).getR2StationName()}));
                    bLabel.setHalign(BHalign.left);
                    this.setContent((BWidget)new BEdgePane((BWidget)bLabel, null, null, null, null));
                }
                this.stepInitialized = true;
            }
        }
    }

    private static class R2StationListModel
    extends ListModel {
        private Array r2StationDirs = new Array(class$javax$baja$file$BDirectory == null ? (class$javax$baja$file$BDirectory = R2StationStep.class$("javax.baja.file.BDirectory")) : class$javax$baja$file$BDirectory);

        public void init() {
            this.r2StationDirs.clear();
            String string = R2CommissioningWizardStep.r2ToolOptions.getLocalR2Installation();
            BIFile bIFile = BFileSystem.INSTANCE.resolveFile(new FilePath(string));
            if (bIFile == null) {
                return;
            }
            StringBuffer stringBuffer = new StringBuffer(bIFile.getFilePath().getBody());
            stringBuffer.append("/stations");
            BDirectory bDirectory = (BDirectory)BFileSystem.INSTANCE.findFile(new FilePath(stringBuffer.toString()));
            if (bDirectory != null) {
                BIFile[] bIFileArray = bDirectory.listFiles();
                for (int i = 0; i < bIFileArray.length; ++i) {
                    BINavNode bINavNode;
                    if (!(bIFileArray[i] instanceof BDirectory) || (bINavNode = bIFileArray[i].getNavChild("config.sns")) == null) continue;
                    this.r2StationDirs.add((Object)bIFileArray[i]);
                }
            }
        }

        public int indexOfDirectory(BDirectory bDirectory) {
            if (bDirectory == null) {
                return 0;
            }
            int n = this.r2StationDirs.indexOf((Object)bDirectory);
            if (n >= 0) {
                return n + 1;
            }
            return -1;
        }

        public int getItemCount() {
            return this.r2StationDirs.size() + 1;
        }

        public BDirectory getStationDirectory(int n) {
            if (n == 0) {
                return null;
            }
            return (BDirectory)this.r2StationDirs.get(n - 1);
        }

        public Object getItem(int n) {
            if (n == 0) {
                return lex.getText("R2CommissioningWizard.stationStep.noStation");
            }
            return this.getStationDirectory(n).getFileName();
        }
    }

    private static class R2StationListController
    extends ListController {
        private R2StationStep step;

        R2StationListController(R2StationStep r2StationStep) {
            this.step = r2StationStep;
        }

        protected void handleEnter(BKeyEvent bKeyEvent) {
            super.handleEnter(bKeyEvent);
            this.updateEnabledStates(this.getList().getSelection().getItem());
        }

        protected void checkSelection(BMouseEvent bMouseEvent, int n) {
            super.checkSelection(bMouseEvent, n);
            this.updateEnabledStates(n);
        }

        public void itemEntered(BMouseEvent bMouseEvent, int n) {
            this.getSelection().deselectAll();
            this.getSelection().select(n);
        }

        public void updateEnabledStates(int n) {
            try {
                if (n < 1) {
                    this.step.setStationName(null);
                } else {
                    this.step.setStationName(this.step.listModel.getStationDirectory(n).getFileName());
                }
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new BajaRuntimeException((Throwable)exception);
            }
        }
    }
}

