/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.r2tools.r2commissioningwizard;

import com.tridium.platDaemon.ui.r2tools.BR2PlatformTool;
import com.tridium.platDaemon.ui.r2tools.r2commissioningwizard.R2CommissioningWizardModel;
import com.tridium.platDaemon.ui.r2tools.r2commissioningwizard.R2CommissioningWizardStep;
import com.tridium.platform.ui.util.BIndentPane;
import com.tridium.platform.ui.util.BToolTipTextField;
import javax.baja.gx.BImage;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.ui.BButton;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.pane.BGridPane;

public class R2LocalInstallStep
extends R2CommissioningWizardStep {
    String r2Installation = null;
    String enteredInstallationText = null;
    BToolTipTextField r2InstallationDirectoryTextEditor = null;
    BR2PlatformTool.BrowseR2InstallationCommand r2InstallationCommand = null;
    BButton r2InstallationDirectoryButton = null;
    BLabel warning = null;

    public R2LocalInstallStep(R2CommissioningWizardModel r2CommissioningWizardModel) {
        super(r2CommissioningWizardModel);
        BIndentPane bIndentPane = new BIndentPane();
        bIndentPane.setRowAlign(BValign.top);
        bIndentPane.setHalign(BHalign.left);
        bIndentPane.setColumnAlign(BHalign.left);
        bIndentPane.setRowGap(20.0);
        BLabel bLabel = new BLabel();
        bLabel.setHalign(BHalign.left);
        bLabel.setText(BR2PlatformTool.LEX.get("R2CommissioningWizard.chooseLocal.installationChoice"));
        bIndentPane.add((BWidget)bLabel);
        this.r2InstallationDirectoryTextEditor = new BToolTipTextField("", 32);
        this.r2InstallationDirectoryTextEditor.setCaretBlinking(false);
        this.r2InstallationDirectoryTextEditor.setEditable(false);
        this.r2InstallationDirectoryButton = new BButton();
        this.r2InstallationDirectoryButton.setButtonStyle(BButtonStyle.toolBar);
        this.r2InstallationCommand = new BR2PlatformTool.BrowseR2InstallationCommand(this.getWidget(), this.r2InstallationDirectoryTextEditor);
        this.r2InstallationDirectoryButton.setCommand((Command)this.r2InstallationCommand, true, true);
        BGridPane bGridPane = new BGridPane(2);
        bGridPane.setRowAlign(BValign.top);
        bGridPane.setHalign(BHalign.left);
        bGridPane.setColumnAlign(BHalign.left);
        bIndentPane.indent();
        bGridPane.add(null, (BValue)this.r2InstallationDirectoryTextEditor);
        bGridPane.add(null, (BValue)this.r2InstallationDirectoryButton);
        bIndentPane.add((BWidget)bGridPane);
        this.warning = new BLabel();
        this.warning.setHalign(BHalign.left);
        this.warning.setText(BR2PlatformTool.LEX.get("R2CommissioningWizard.chooseLocal.installationChoiceInvalid"));
        this.warning.setImage(BImage.make((BIcon)BIcon.std((String)"warning.png")));
        this.warning.setVisible(false);
        bIndentPane.add(null, (BValue)this.warning);
        this.setContent((BWidget)bIndentPane);
    }

    public String getStepName() {
        return "chooseLocal";
    }

    public String getSectionName() {
        return "install";
    }

    public void enter() {
        this.warning.setVisible(false);
        if (r2ToolOptions.getLocalR2Installation() != null && r2ToolOptions.getLocalR2Installation().length() != 0) {
            this.enteredInstallationText = r2ToolOptions.getLocalR2Installation();
            this.r2InstallationDirectoryTextEditor.setText(this.enteredInstallationText);
        }
    }

    public boolean checkNext() {
        if (!BR2PlatformTool.verifyR2Path(this.r2InstallationDirectoryTextEditor.getText())) {
            this.warning.setVisible(true);
            return false;
        }
        return true;
    }

    public boolean exit(int n) {
        if (this.checkNext()) {
            r2ToolOptions.setLocalR2Installation(this.r2InstallationDirectoryTextEditor.getText());
            r2ToolOptions.save();
        }
        if (!this.enteredInstallationText.equalsIgnoreCase(this.r2InstallationDirectoryTextEditor.getText())) {
            this.wizardModel.stationsToDelete.clear();
            this.wizardModel.autoStart = true;
            this.wizardModel.restartOnFailure = true;
            this.wizardModel.r2StationDir = null;
            this.wizardModel.targetR2StationName = null;
            this.wizardModel.r2StationSurrogate = null;
            this.wizardModel.modulesToInstall.clear();
            this.wizardModel.licensesToInstall.clear();
            this.wizardModel.lexiconsToInstall.clear();
        }
        return true;
    }

    public int getMode() {
        return 3;
    }

    public boolean isSkipped() {
        return this.wizardModel.skipSelectLocalInstall;
    }

    public boolean cancel() {
        return true;
    }
}

