/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.r2tools.r2commissioningwizard;

import com.tridium.platDaemon.ui.DaemonSessionTaskHandler;
import com.tridium.platDaemon.ui.r2tools.r2commissioningwizard.R2CommissioningWizardModel;
import com.tridium.platDaemon.ui.widget.TaskDetailDialog;
import com.tridium.platDaemon.ui.widget.TaskDetailPane;
import com.tridium.platform.daemon.BAppSurrogate;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.BR2StationSurrogate;
import com.tridium.platform.daemon.DaemonFileUtil;
import com.tridium.platform.daemon.file.BDaemonFileSpace;
import com.tridium.platform.daemon.message.DaemonMessage;
import com.tridium.platform.daemon.message.DeleteFileTransferMessageElement;
import com.tridium.platform.daemon.message.DeleteR2StationMessage;
import com.tridium.platform.daemon.message.FileTransferMessage;
import com.tridium.platform.daemon.message.FileTransferMessageElement;
import com.tridium.platform.daemon.message.OSUpdateMessage;
import com.tridium.platform.daemon.message.UpdateR2StationMessage;
import com.tridium.platform.daemon.task.CancelableDaemonSessionTask;
import com.tridium.platform.daemon.task.DaemonSessionTask;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import java.net.SocketException;
import java.util.HashMap;
import java.util.HashSet;
import javax.baja.file.BIFileStore;
import javax.baja.file.FilePath;
import javax.baja.gx.BImage;
import javax.baja.job.BJobState;
import javax.baja.nre.util.Array;
import javax.baja.platform.ICancelHint;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.util.Lexicon;

public class R2FinishPane
extends TaskDetailDialog
implements DaemonSessionTaskListener {
    private String lastText = null;
    private R2CommissioningWizardModel wizardModel;
    private TaskDetailPane.TaskItem uninstallItem;
    private TaskDetailPane.TaskItem stopAppsItem;
    private TaskDetailPane.TaskItem deleteStationsItem;
    private TaskDetailPane.TaskItem installItem;
    private TaskDetailPane.TaskItem osInstallItem;
    private TaskDetailPane.TaskItem rebootItem;
    private TaskDetailPane.TaskItem reconnectItem;
    private Array items = null;
    private static Lexicon lex = Lexicon.make((String)"platDaemon");
    static /* synthetic */ Class class$com$tridium$platDaemon$ui$widget$TaskDetailPane$TaskItem;

    private R2FinishPane(R2CommissioningWizardModel r2CommissioningWizardModel) {
        this.wizardModel = r2CommissioningWizardModel;
        this.stopAppsItem = new TaskDetailPane.TaskItem(lex.getText("R2CommissioningWizard.finish.item.stopApps"));
        this.uninstallItem = new TaskDetailPane.TaskItem(lex.getText("R2CommissioningWizard.finish.item.uninstall"));
        this.deleteStationsItem = new TaskDetailPane.TaskItem(lex.getText("R2CommissioningWizard.finish.item.deleteStations"));
        this.installItem = new TaskDetailPane.TaskItem(lex.getText("R2CommissioningWizard.finish.item.install"));
        this.osInstallItem = new TaskDetailPane.TaskItem(lex.getText("R2CommissioningWizard.finish.item.osInstall"));
        this.rebootItem = new TaskDetailPane.TaskItem(lex.getText("R2CommissioningWizard.finish.item.reboot"));
        this.reconnectItem = new TaskDetailPane.TaskItem(lex.getText("R2CommissioningWizard.finish.item.reconnect"));
        this.init(r2CommissioningWizardModel.owner);
    }

    public static void openDialog(R2CommissioningWizardModel r2CommissioningWizardModel) {
        new R2FinishPane(r2CommissioningWizardModel).open();
    }

    public String getDialogTitle() {
        return lex.getText("R2CommissioningWizard.title", new Object[]{this.wizardModel.daemonSession.getRemoteHost().getNavDisplayName(null)});
    }

    public String getHeadingTitle() {
        return lex.getText("R2CommissioningWizard.finish.mainHeading");
    }

    public BImage getHeadingIcon() {
        return BImage.make((String)lex.getText("R2CommissioningWizard.wizard.sectionIcon"));
    }

    public String getItemListHeading() {
        return lex.getText("R2CommissioningWizard.finish.itemHeading");
    }

    public TaskDetailPane.TaskItem[] makeTaskItems() {
        boolean bl = false;
        this.items = new Array(class$com$tridium$platDaemon$ui$widget$TaskDetailPane$TaskItem == null ? (class$com$tridium$platDaemon$ui$widget$TaskDetailPane$TaskItem = R2FinishPane.class$("com.tridium.platDaemon.ui.widget.TaskDetailPane$TaskItem")) : class$com$tridium$platDaemon$ui$widget$TaskDetailPane$TaskItem);
        this.items.add((Object)this.stopAppsItem);
        if (this.wizardModel.filesToDelete.size() > 0) {
            this.items.add((Object)this.uninstallItem);
        }
        if (this.wizardModel.stationsToDelete.size() > 0) {
            this.items.add((Object)this.deleteStationsItem);
        }
        if (this.wizardModel.distSolution.hasChanges()) {
            this.items.add((Object)this.installItem);
            if ((this.wizardModel.distSolution.getProcessingFlags() & 0x20000L) > 0L) {
                bl = true;
            }
        }
        if (bl) {
            this.items.add((Object)this.osInstallItem);
        }
        this.items.add((Object)this.rebootItem);
        return (TaskDetailPane.TaskItem[])this.items.trim();
    }

    public void taskStarted(DaemonSessionTask daemonSessionTask) {
        if (this.lastText == null || !daemonSessionTask.getMessage().equals(this.lastText)) {
            this.getLog().append(daemonSessionTask.getMessage() + "\n");
            this.lastText = daemonSessionTask.getMessage();
        }
    }

    public void taskUpdated(DaemonSessionTask daemonSessionTask) {
        if (this.lastText == null || !daemonSessionTask.getMessage().equals(this.lastText)) {
            this.getLog().append(daemonSessionTask.getMessage() + "\n");
            this.lastText = daemonSessionTask.getMessage();
        }
        if (daemonSessionTask instanceof CancelableDaemonSessionTask && !((CancelableDaemonSessionTask)daemonSessionTask).isCancelEnabled()) {
            this.setCancelEnabled(false);
        }
    }

    public void taskFinished(DaemonSessionTask daemonSessionTask) {
    }

    public void updateFileTransferStatus(FileTransferMessageElement fileTransferMessageElement, int n, int n2) {
        this.updateStatusMessage(fileTransferMessageElement.getProgressText());
    }

    public void updateStatusMessage(String string) {
        if (this.lastText == null || !string.equals(this.lastText)) {
            this.getLog().append(string + "\n");
            this.lastText = string;
        }
    }

    public void run() {
        try {
            BR2StationSurrogate bR2StationSurrogate;
            int n;
            FileTransferMessage fileTransferMessage;
            HashMap<Type, BR2StationSurrogate> hashMap = new HashMap<Type, BR2StationSurrogate>();
            if (this.items.contains((Object)this.stopAppsItem)) {
                this.setCurrentItem(this.stopAppsItem, BJobState.running);
                this.getLog().append(lex.getText("R2CommissioningWizard.finish.stopApps"));
                this.getLog().append("\n");
                fileTransferMessage = BAppSurrogate.stopAllApps((BDaemonSession)this.wizardModel.daemonSession, null, null, (DaemonSessionTaskListener)new DaemonSessionTaskHandler((BWidget)this.getDialog()));
                if (((BAppSurrogate[])fileTransferMessage).length == 0) {
                    this.getLog().append(lex.getText("R2CommissioningWizard.finish.stopApps.noneRunning"));
                    this.getLog().append("\n");
                } else {
                    for (n = 0; n < ((FileTransferMessage)fileTransferMessage).length; ++n) {
                        bR2StationSurrogate = (BR2StationSurrogate)hashMap.get(fileTransferMessage[n].getType());
                        if (bR2StationSurrogate == null) {
                            bR2StationSurrogate = new HashSet();
                            hashMap.put(fileTransferMessage[n].getType(), bR2StationSurrogate);
                        }
                        bR2StationSurrogate.add(fileTransferMessage[n].getAppName());
                        this.getLog().append(lex.getText("R2CommissioningWizard.finish.item.stopApps", new Object[]{fileTransferMessage[n].toString(null)}));
                        this.getLog().append("\n");
                    }
                }
                this.updateCurrentItemState(BJobState.success);
            }
            if (this.items.contains((Object)this.uninstallItem)) {
                this.setCurrentItem(this.uninstallItem, BJobState.running);
                this.checkCanceled();
                this.getLog().append(lex.getText("R2CommissioningWizard.finish.uninstallSoftware"));
                this.getLog().append("\n");
                fileTransferMessage = new FileTransferMessage((BDaemonFileSpace)this.wizardModel.daemonSession.getFileSpace());
                for (n = 0; n < this.wizardModel.filesToDelete.size(); ++n) {
                    bR2StationSurrogate = (BIFileStore)this.wizardModel.filesToDelete.get(n);
                    fileTransferMessage.addElement((FileTransferMessageElement)new DeleteFileTransferMessageElement(bR2StationSurrogate.getFilePath(), (BDaemonFileSpace)this.wizardModel.daemonSession.getFileSpace()));
                }
                DaemonFileUtil.transfer((BDaemonSession)this.wizardModel.daemonSession, (FileTransferMessage)fileTransferMessage, (ICancelHint)this, (DaemonSessionTaskListener)this);
                this.updateCurrentItemState(BJobState.success);
            }
            if (this.items.contains((Object)this.deleteStationsItem)) {
                this.setCurrentItem(this.deleteStationsItem, BJobState.running);
                this.checkCanceled();
                this.getLog().append(lex.getText("R2CommissioningWizard.finish.deleteStations"));
                this.getLog().append("\n");
                fileTransferMessage = new FileTransferMessage((BDaemonFileSpace)this.wizardModel.daemonSession.getFileSpace());
                for (n = 0; n < this.wizardModel.stationsToDelete.size(); ++n) {
                    bR2StationSurrogate = (BR2StationSurrogate)this.wizardModel.stationsToDelete.get(n);
                    fileTransferMessage.addElement((FileTransferMessageElement)new DeleteFileTransferMessageElement(new FilePath("!niagaraR2/rel/stations/" + bR2StationSurrogate.getR2StationName()), (BDaemonFileSpace)this.wizardModel.daemonSession.getFileSpace()));
                    HashSet hashSet = (HashSet)hashMap.get(bR2StationSurrogate.getType());
                    if (hashSet == null) continue;
                    hashSet.remove(bR2StationSurrogate.getAppName());
                }
                DaemonFileUtil.transfer((BDaemonSession)this.wizardModel.daemonSession, (FileTransferMessage)fileTransferMessage, (ICancelHint)this, (DaemonSessionTaskListener)this);
                for (n = 0; n < this.wizardModel.stationsToDelete.size(); ++n) {
                    bR2StationSurrogate = (BR2StationSurrogate)this.wizardModel.stationsToDelete.get(n);
                    this.wizardModel.daemonSession.sendMessage((DaemonMessage)new DeleteR2StationMessage(bR2StationSurrogate.getR2StationName()));
                }
                this.updateCurrentItemState(BJobState.success);
            }
            if (this.items.contains((Object)this.installItem)) {
                this.setCurrentItem(this.installItem, BJobState.running);
                this.checkCanceled();
                this.wizardModel.distSolution.commit((DaemonSessionTaskListener)this, (ICancelHint)this);
                this.updateCurrentItemState(BJobState.success);
            }
            if (this.items.contains((Object)this.osInstallItem)) {
                this.setCurrentItem(this.osInstallItem, BJobState.running);
                this.getLog().append(lex.getText("CommissioningWizard.finish.osInstall"));
                this.getLog().append("\n");
                this.wizardModel.daemonSession.sendMessage((DaemonMessage)OSUpdateMessage.getInstance(), 60000);
                this.updateCurrentItemState(BJobState.success);
            }
            this.wizardModel.daemonSession.sendMessage((DaemonMessage)new R2CommissioningWizardModel.SetR2EnabledMessage(true), 20000);
            if (this.wizardModel.targetR2StationName != null) {
                this.wizardModel.daemonSession.sendMessage((DaemonMessage)new UpdateR2StationMessage());
                this.wizardModel.daemonSession.sendMessage((DaemonMessage)new UpdateR2StationMessage(this.wizardModel.targetR2StationName, false, this.wizardModel.autoStart, this.wizardModel.restartOnFailure, true));
            }
            if (this.items.contains((Object)this.rebootItem)) {
                this.setCurrentItem(this.rebootItem, BJobState.running);
                this.getLog().append(lex.getText("CommissioningWizard.finish.reboot"));
                this.getLog().append("\n");
                this.wizardModel.daemonSession.sendRebootRequest();
                this.wizardModel.reconnectOnFinish = false;
                this.updateCurrentItemState(BJobState.success);
            }
            this.checkCanceled();
            this.getLog().append(lex.getText("R2CommissioningWizard.finish.done"));
            this.getLog().append("\n");
            this.setBottomLabelText(lex.getText("R2CommissioningWizard.finish.done"));
        }
        catch (ICancelHint.CanceledException canceledException) {
            this.updateCurrentItemState(BJobState.canceled);
            this.getLog().append(lex.getText("R2CommissioningWizard.finish.canceled"));
            this.getLog().append("\n");
            this.setBottomLabelText(lex.getText("R2CommissioningWizard.finish.canceled"));
        }
        catch (Throwable throwable) {
            this.setCancelEnabled(true);
            this.cancel(false);
            this.updateCurrentItemState(BJobState.failed);
            throwable.printStackTrace();
            this.getLog().append(throwable);
            this.setBottomLabelText(lex.getText("R2CommissioningWizard.finish.failed"));
        }
    }

    public void reconnect() throws Exception {
        this.updateCurrentItemState(BJobState.success);
        this.setCurrentItem(this.reconnectItem, BJobState.running);
        this.getLog().append(lex.getText("R2CommissioningWizard.finish.reconnect"));
        this.getLog().append("\n");
        String string = this.wizardModel.daemonSession.getHostProperties().getSessionTimestamp();
        Dots dots = new Dots();
        dots.start();
        while (!this.isCanceled()) {
            try {
                this.wizardModel.daemonSession.reloadHostProperties(15000);
                if (this.wizardModel.daemonSession.getHostProperties().getSessionTimestamp().equals(string)) continue;
                dots.cancel();
                this.getLog().append(lex.getText("R2CommissioningWizard.finish.reconnected"));
                this.getLog().append("\n");
                this.updateCurrentItemState(BJobState.success);
                Thread.sleep(5000L);
                break;
            }
            catch (SocketException socketException) {
            }
        }
        dots.cancel();
        this.updateCurrentItemState(BJobState.success);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class Dots
    extends Thread {
        private boolean dotCanceled = false;
        private boolean dotRunning = true;
        private int i = 0;

        private Dots() {
        }

        public void run() {
            while (!this.dotCanceled) {
                try {
                    Thread.sleep(1000L);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (this.i++ > 60) {
                    R2FinishPane.this.getLog().append("\n");
                    this.i = 0;
                }
                R2FinishPane.this.getLog().append(".");
            }
            R2FinishPane.this.getLog().append("\n");
            this.dotRunning = false;
        }

        public synchronized void cancel() {
            this.dotCanceled = true;
            while (this.dotRunning) {
                try {
                    Thread.sleep(300L);
                }
                catch (Throwable throwable) {}
            }
        }
    }
}

