/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.r2tools;

import com.tridium.platDaemon.ui.BDaemonSessionView;
import com.tridium.platDaemon.ui.r2tools.BR2DbAdministration;
import com.tridium.platDaemon.ui.r2tools.BR2FileTransferClient;
import com.tridium.platDaemon.ui.r2tools.BR2InstallationSelectDialog;
import com.tridium.platDaemon.ui.r2tools.BR2PlatformConfigurationManager;
import com.tridium.platDaemon.ui.r2tools.BR2PlatformToolOptions;
import com.tridium.platDaemon.ui.r2tools.BR2TransferTypeEnum;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.file.BDaemonDirectoryStore;
import com.tridium.platform.daemon.file.BDaemonFileSpace;
import com.tridium.platform.ui.util.BToolTipTextField;
import com.tridium.platform.ui.util.LabelUtil;
import java.io.File;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.naming.UnresolvedException;
import javax.baja.security.AuthenticationException;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.file.BDirectoryChooser;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BLabelPane;
import javax.baja.ui.pane.BTabbedPane;
import javax.baja.util.Lexicon;
import javax.baja.util.LexiconText;
import javax.baja.workbench.BWbShell;

public class BR2PlatformTool
extends BDaemonSessionView {
    public static final Action handleR2InstallationChanged = BR2PlatformTool.newAction((int)4, null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$platDaemon$ui$r2tools$BR2PlatformTool == null ? (class$com$tridium$platDaemon$ui$r2tools$BR2PlatformTool = BR2PlatformTool.class$("com.tridium.platDaemon.ui.r2tools.BR2PlatformTool")) : class$com$tridium$platDaemon$ui$r2tools$BR2PlatformTool));
    BGridPane installationPane = new BGridPane(2);
    BToolTipTextField r2InstallationDirectoryTextEditor = null;
    BrowseR2InstallationCommand r2InstallationCommand = null;
    BButton r2InstallationDirectoryButton = null;
    BEdgePane mainPane = null;
    BGridPane invalidDirectoryWarningPane = null;
    BBorderPane toolsBorderPane;
    BR2FileTransferClient softwareManager = null;
    BR2FileTransferClient stationManager = null;
    BR2PlatformConfigurationManager platformManager = null;
    BR2DbAdministration dbManager = null;
    private BDaemonSession session = null;
    private BR2PlatformToolOptions options = null;
    public static final Lexicon LEX = Lexicon.make((String)"platDaemon");
    protected static final Log log = Log.getLog((String)"R2PlatformTool");
    static /* synthetic */ Class class$com$tridium$platDaemon$ui$r2tools$BR2PlatformTool;

    public void handleR2InstallationChanged() {
        this.invoke(handleR2InstallationChanged, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BR2PlatformTool() {
        this.installationPane.setRowAlign(BValign.center);
        this.installationPane.setHalign(BHalign.left);
        this.installationPane.setColumnAlign(BHalign.left);
        this.installationPane.setRowGap(5.0);
        this.installationPane.setStretchColumn(1);
        this.r2InstallationDirectoryTextEditor = new BToolTipTextField("", 32);
        this.r2InstallationDirectoryTextEditor.setCaretBlinking(false);
        this.r2InstallationDirectoryTextEditor.setEditable(false);
        this.r2InstallationDirectoryButton = new BButton();
        this.r2InstallationDirectoryButton.setButtonStyle(BButtonStyle.toolBar);
        this.r2InstallationCommand = new BrowseR2InstallationCommand((BWidget)this, this.r2InstallationDirectoryTextEditor);
        this.r2InstallationDirectoryButton.setCommand((Command)this.r2InstallationCommand, true, true);
        BGridPane bGridPane = new BGridPane(2);
        bGridPane.setRowAlign(BValign.center);
        bGridPane.setHalign(BHalign.left);
        bGridPane.setColumnAlign(BHalign.left);
        bGridPane.add(null, (BValue)this.r2InstallationDirectoryTextEditor);
        bGridPane.add(null, (BValue)this.r2InstallationDirectoryButton);
        this.linkTo((BComponent)this.r2InstallationDirectoryTextEditor, (Slot)BTextField.textModified, (Slot)handleR2InstallationChanged);
        this.installationPane.add(null, (BValue)LabelUtil.makeLabel((LexiconText)LexiconText.make((Type)TYPE, (String)"R2PlatformTool.installationChoiceLabel"), (boolean)false));
        this.installationPane.add(null, (BValue)bGridPane);
        this.invalidDirectoryWarningPane = new BGridPane(1);
        this.invalidDirectoryWarningPane.setRowAlign(BValign.center);
        this.invalidDirectoryWarningPane.setColumnAlign(BHalign.center);
        this.invalidDirectoryWarningPane.setHalign(BHalign.center);
        this.invalidDirectoryWarningPane.setValign(BValign.center);
        this.invalidDirectoryWarningPane.setUniformColumnWidth(false);
        this.invalidDirectoryWarningPane.setUniformRowHeight(false);
        BLabel bLabel = new BLabel();
        bLabel.setImage(BImage.make((String)"module://icons/x32/error.png"));
        bLabel.setValign(BValign.center);
        bLabel.setHalign(BHalign.center);
        bLabel.setText(LexiconText.make((Type)TYPE, (String)"R2PlatformTool.invalidInstallationChoice").getText(null));
        this.invalidDirectoryWarningPane.add(null, (BValue)bLabel);
        BTabbedPane bTabbedPane = new BTabbedPane();
        this.softwareManager = new BR2FileTransferClient();
        this.softwareManager.setTransferType(BR2TransferTypeEnum.softwareTransfer);
        this.stationManager = new BR2FileTransferClient();
        this.stationManager.setTransferType(BR2TransferTypeEnum.stationTransfer);
        this.platformManager = new BR2PlatformConfigurationManager();
        this.dbManager = new BR2DbAdministration();
        bTabbedPane.addPane(new BLabelPane(LexiconText.make((Type)TYPE, (String)"R2PlatformTool.softwareLabel").getText((Context)BFacets.NULL), BImage.make((BIcon)BIcon.std((String)"modules.png")), (BWidget)new BBorderPane((BWidget)this.softwareManager)));
        bTabbedPane.addPane(new BLabelPane(LexiconText.make((Type)TYPE, (String)"R2PlatformTool.stationLabel").getText((Context)BFacets.NULL), BImage.make((BIcon)BIcon.std((String)"r2/station.png")), (BWidget)new BBorderPane((BWidget)this.stationManager)));
        bTabbedPane.addPane(new BLabelPane(LexiconText.make((Type)TYPE, (String)"R2PlatformTool.platformLabel").getText((Context)BFacets.NULL), BImage.make((BIcon)BIcon.std((String)"platform.png")), (BWidget)new BBorderPane((BWidget)this.platformManager)));
        bTabbedPane.addPane(new BLabelPane(LexiconText.make((Type)TYPE, (String)"R2PlatformTool.dbLabel").getText((Context)BFacets.NULL), BImage.make((BIcon)BIcon.std((String)"database.png")), (BWidget)new BBorderPane((BWidget)this.dbManager)));
        this.options = BR2PlatformToolOptions.make();
        this.mainPane = new BEdgePane();
        BBorderPane bBorderPane = new BBorderPane((BWidget)this.installationPane, LabelUtil.makeLabel((LexiconText)LexiconText.make((Type)TYPE, (String)"R2PlatformTool.installationBorderLabel"), (boolean)true));
        this.mainPane.setTop((BWidget)bBorderPane);
        this.toolsBorderPane = new BBorderPane((BWidget)bTabbedPane, BInsets.make((double)5.0, (double)0.0, (double)0.0, (double)0.0));
        this.mainPane.setCenter((BWidget)this.toolsBorderPane);
        this.setContent((BWidget)this.mainPane);
    }

    protected final void doLoadSession(BDaemonSession bDaemonSession, Context context) throws AuthenticationException {
        this.session = bDaemonSession;
        String string = this.options.getLocalR2Installation();
        log.trace("Verifying R2 Installation Path: \"" + string + "\"");
        if (!BR2PlatformTool.verifyR2Path(string)) {
            try {
                BR2InstallationSelectDialog bR2InstallationSelectDialog = new BR2InstallationSelectDialog((BWidget)this);
                bR2InstallationSelectDialog.setBoundsCenteredOnOwner();
                bR2InstallationSelectDialog.open();
                if (bR2InstallationSelectDialog.getResult() != 1) {
                    this.mainPane.setCenter((BWidget)this.invalidDirectoryWarningPane);
                    return;
                }
                string = bR2InstallationSelectDialog.getInstallation();
            }
            catch (Exception exception) {
                log.error(LEX.get("R2PlatformTool.installationChoiceDialog.error"), (Throwable)exception);
                this.mainPane.setCenter((BWidget)this.invalidDirectoryWarningPane);
                return;
            }
        }
        try {
            if (BDaemonDirectoryStore.make((BDaemonFileSpace)bDaemonSession.getFileSpace(), (FilePath)new FilePath("/niagara/niagaraR2")) == null) {
                BDialog.error((BWidget)this, (String)LEX.get("R2PlatformTool.remoteNiagaraR2Missing.title"), (Object)LEX.get("R2PlatformTool.remoteNiagaraR2Missing.messsage"));
                this.mainPane.setEnabled(false);
                return;
            }
        }
        catch (Exception exception) {
            this.mainPane.setEnabled(false);
            return;
        }
        this.r2InstallationDirectoryTextEditor.setText(new FilePath(string).getBody());
    }

    public final void doHandleR2InstallationChanged() {
        BWbShell bWbShell = this.getWbShell();
        try {
            bWbShell.enterBusy();
            String string = this.r2InstallationDirectoryTextEditor.getText();
            if (!BR2PlatformTool.verifyR2Path(string)) {
                this.mainPane.setCenter((BWidget)this.invalidDirectoryWarningPane);
            } else {
                this.mainPane.setCenter((BWidget)this.toolsBorderPane);
                this.options.setLocalR2Installation(string);
                this.options.save();
                this.softwareManager.setLocalR2Installation(string);
                this.stationManager.setLocalR2Installation(string);
                this.softwareManager.loadValue((BObject)this.session, this.getCurrentContext());
                this.stationManager.loadValue((BObject)this.session, this.getCurrentContext());
                this.platformManager.loadValue((BObject)this.session, this.getCurrentContext());
                this.dbManager.loadValue((BObject)this.session, this.getCurrentContext());
            }
        }
        finally {
            bWbShell.exitBusy();
        }
    }

    public static final boolean verifyR2Path(String string) {
        int n;
        if (string == null) {
            return false;
        }
        if (string.trim().length() == 0) {
            return false;
        }
        File file = new File(string);
        if (!file.exists()) {
            return false;
        }
        if (!file.isDirectory()) {
            return false;
        }
        File[] fileArray = file.listFiles();
        File file2 = null;
        File file3 = null;
        File file4 = null;
        for (n = 0; n < fileArray.length; ++n) {
            file2 = fileArray[n];
            if (file2.getName().equals("nre") && file2.isDirectory()) {
                file3 = file2;
                continue;
            }
            if (!file2.getName().equals("stations") || !file2.isDirectory()) continue;
            file4 = file2;
        }
        if (file3 == null || file4 == null) {
            return false;
        }
        fileArray = file3.listFiles();
        n = 0;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        for (int i = 0; i < fileArray.length; ++i) {
            file2 = fileArray[i];
            if (file2.getName().equals("bin") && file2.isDirectory()) {
                n = 1;
                continue;
            }
            if (file2.getName().equals("jre") && file2.isDirectory()) {
                bl = true;
                continue;
            }
            if (file2.getName().equals("lib") && file2.isDirectory()) {
                bl2 = true;
                continue;
            }
            if (!file2.getName().equals("modules") || !file2.isDirectory()) continue;
            bl3 = true;
        }
        return n != 0 && bl && bl2 && bl3;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class BrowseR2InstallationCommand
    extends Command {
        BToolTipTextField directoryEditor;

        public BrowseR2InstallationCommand(BWidget bWidget, BToolTipTextField bToolTipTextField) {
            super(bWidget, "");
            this.directoryEditor = bToolTipTextField;
        }

        public BImage getIcon() {
            return BImage.make((String)"module://icons/x16/open.png");
        }

        public CommandArtifact doInvoke() {
            BDirectoryChooser bDirectoryChooser = BDirectoryChooser.make((BWidget)this.getOwner());
            bDirectoryChooser.setTitle(LEX.get("R2PlatformTool.installationChoiceDialog.title"));
            String string = this.directoryEditor.getText();
            if (string == null || string.trim().equals("")) {
                bDirectoryChooser.setCurrentDirectory(BFileSystem.INSTANCE.getSysHome().getOrdInHost());
            } else {
                try {
                    string = BFileSystem.INSTANCE.resolveFile(new FilePath(string)).toString();
                    bDirectoryChooser.setCurrentDirectory(BOrd.make((String)string));
                }
                catch (UnresolvedException unresolvedException) {
                    bDirectoryChooser.setCurrentDirectory(BFileSystem.INSTANCE.getSysHome().getOrdInHost());
                }
            }
            BOrd bOrd = bDirectoryChooser.show();
            if (bOrd != null) {
                BIFile bIFile = (BIFile)bOrd.get();
                this.directoryEditor.setText(bIFile.getFilePath().getBody());
            }
            return null;
        }
    }
}

