/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.r2tools;

import com.tridium.install.InstallScenario;
import com.tridium.install.installable.BFileInstallable;
import com.tridium.install.installable.BInstallable;
import com.tridium.install.installable.InstallableRegistry;
import com.tridium.install.installable.LocalInstallableRegistry;
import com.tridium.platDaemon.ui.BDaemonSessionView;
import com.tridium.platDaemon.ui.filetransfer.BDirectoryTable;
import com.tridium.platDaemon.ui.r2tools.BR2PlatformToolOptions;
import com.tridium.platDaemon.ui.r2tools.BR2TransferTypeEnum;
import com.tridium.platDaemon.ui.widget.BDirectoryChoice;
import com.tridium.platform.daemon.BAppSurrogate;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.BR2StationSurrogate;
import com.tridium.platform.daemon.DaemonFileUtil;
import com.tridium.platform.daemon.file.BDaemonDirectoryStore;
import com.tridium.platform.daemon.file.BDaemonFileSpace;
import com.tridium.platform.daemon.message.DaemonMessage;
import com.tridium.platform.daemon.message.DeleteFileTransferMessageElement;
import com.tridium.platform.daemon.message.DeleteR2StationMessage;
import com.tridium.platform.daemon.message.FileTransferMessage;
import com.tridium.platform.daemon.message.FileTransferMessageElement;
import com.tridium.platform.daemon.message.UpdateR2StationMessage;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import com.tridium.platform.ui.util.AsyncCommand;
import com.tridium.platform.ui.util.AsyncGroup;
import com.tridium.platform.ui.util.BCommandEnablePolicy;
import com.tridium.platform.ui.util.BIBeamPane;
import com.tridium.platform.ui.util.CommandBindings;
import com.tridium.platform.ui.util.CommandUtil;
import java.io.File;
import java.net.ConnectException;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSpace;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.BIFileStore;
import javax.baja.file.BLocalFileStore;
import javax.baja.file.FilePath;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.nav.BINavNode;
import javax.baja.nre.util.Array;
import javax.baja.security.AuthenticationException;
import javax.baja.space.Mark;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BFocusEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BFlowPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableController;
import javax.baja.util.PatternFilter;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.view.BWbView;

public class BR2FileTransferClient
extends BDaemonSessionView
implements CommandBindings.Support {
    public static final Property transferType = BR2FileTransferClient.newProperty((int)3, (BValue)BR2TransferTypeEnum.unknown, null);
    public static final Property localR2Installation = BR2FileTransferClient.newProperty((int)3, (String)new String(), null);
    public static final Action handleLocalDirChanged = BR2FileTransferClient.newAction((int)4, null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$platDaemon$ui$r2tools$BR2FileTransferClient == null ? (class$com$tridium$platDaemon$ui$r2tools$BR2FileTransferClient = BR2FileTransferClient.class$("com.tridium.platDaemon.ui.r2tools.BR2FileTransferClient")) : class$com$tridium$platDaemon$ui$r2tools$BR2FileTransferClient));
    BDirectoryTable localTable;
    BDirectoryTable remoteTable;
    private BDirectory localDir = null;
    private volatile String targetStationName = null;
    private BDirectory targetStationRoot = null;
    private BDirectory remoteStationsRoot = null;
    protected PatternFilter[] fileExcludePatterns = null;
    protected PatternFilter[] directoryExcludePatterns = null;
    public static FilePath REMOTE_R2STATIONS_PATH = new FilePath("/niagara/niagaraR2/rel/stations");
    public static FilePath REMOTE_R2MODULES_PATH = new FilePath("/niagara/niagaraR2/modules");
    private AsyncCommand uploadCommand;
    private AsyncCommand downloadCommand;
    private AsyncCommand deleteCommand;
    private UpLocalCommand upLocalCommand;
    private BDirectoryChoice localDirChoice;
    private BDirectoryChoice remoteDirChoice;
    private BLabel localLabel;
    private BLabel remoteLabel;
    private boolean softwareWarningPrinted = false;
    static /* synthetic */ Class class$com$tridium$platDaemon$ui$r2tools$BR2FileTransferClient;
    static /* synthetic */ Class class$com$tridium$install$installable$BInstallable;

    public BR2TransferTypeEnum getTransferType() {
        return (BR2TransferTypeEnum)this.get(transferType);
    }

    public void setTransferType(BR2TransferTypeEnum bR2TransferTypeEnum) {
        this.set(transferType, (BValue)bR2TransferTypeEnum, null);
    }

    public String getLocalR2Installation() {
        return this.getString(localR2Installation);
    }

    public void setLocalR2Installation(String string) {
        this.setString(localR2Installation, string, null);
    }

    public void handleLocalDirChanged() {
        this.invoke(handleLocalDirChanged, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BR2FileTransferClient() {
        BIBeamPane bIBeamPane = new BIBeamPane();
        BFlowPane bFlowPane = new BFlowPane(BHalign.left);
        AsyncGroup asyncGroup = new AsyncGroup();
        this.upLocalCommand = new UpLocalCommand();
        BButton bButton = new BButton((Command)this.upLocalCommand, false, true);
        bFlowPane.add(null, (BValue)bButton);
        asyncGroup.add((AsyncGroup.AsyncGroupMember)this.upLocalCommand);
        bButton.setButtonStyle(BButtonStyle.toolBar);
        this.localDirChoice = new BDirectoryChoice();
        bFlowPane.add(null, (BValue)this.localDirChoice);
        this.linkTo((BComponent)this.localDirChoice, (Slot)BDirectoryChoice.dirModified, (Slot)handleLocalDirChanged);
        this.localTable = new BDirectoryTable((BWbView)this, false, false);
        BBorderPane bBorderPane = new BBorderPane((BWidget)new BEdgePane((BWidget)new BBorderPane((BWidget)bFlowPane, 6.0, 0.0, 2.0, 0.0), null, null, null, (BWidget)new BBorderPane((BWidget)this.localTable, BBorder.inset, BInsets.DEFAULT)), 4.0, 2.0, 0.0, 2.0);
        bIBeamPane.setLeft((BWidget)bBorderPane);
        this.localLabel = new BLabel();
        bBorderPane.setLabel((BWidget)this.localLabel);
        bFlowPane = new BFlowPane(BHalign.left);
        this.remoteDirChoice = new BDirectoryChoice(null, (BFileSpace)BFileSystem.INSTANCE, false, 30);
        bFlowPane.add(null, (BValue)this.remoteDirChoice);
        this.remoteTable = new BDirectoryTable((BWbView)this, false, false);
        bBorderPane = new BBorderPane((BWidget)new BEdgePane((BWidget)new BBorderPane((BWidget)bFlowPane, 6.0, 0.0, 2.0, 0.0), null, null, null, (BWidget)new BBorderPane((BWidget)this.remoteTable, BBorder.inset, BInsets.DEFAULT)), 4.0, 2.0, 0.0, 2.0);
        bIBeamPane.setRight((BWidget)bBorderPane);
        this.remoteLabel = new BLabel();
        bBorderPane.setLabel((BWidget)this.remoteLabel);
        this.remoteTable.setOtherTable((BTable)this.localTable);
        this.remoteTable.setController((TableController)new DirectoryTableController(this.remoteTable.getCommandBindings()));
        this.localTable.setOtherTable((BTable)this.remoteTable);
        this.localTable.setController((TableController)new DirectoryTableController(this.localTable.getCommandBindings()));
        BGridPane bGridPane = new BGridPane(1);
        bGridPane.setColumnAlign(BHalign.fill);
        this.uploadCommand = new TransferCommand(this.localTable, this.remoteTable, "FileTransferClient.upload");
        bGridPane.add(null, (BValue)new BButton((Command)this.uploadCommand, false, true));
        asyncGroup.add((AsyncGroup.AsyncGroupMember)this.uploadCommand);
        this.downloadCommand = new TransferCommand(this.remoteTable, this.localTable, "FileTransferClient.download");
        bGridPane.add(null, (BValue)new BButton((Command)this.downloadCommand, false, true));
        asyncGroup.add((AsyncGroup.AsyncGroupMember)this.downloadCommand);
        this.deleteCommand = new DeleteCommand();
        bGridPane.add(null, (BValue)new BButton((Command)this.deleteCommand, false, true));
        asyncGroup.add((AsyncGroup.AsyncGroupMember)this.deleteCommand);
        bIBeamPane.setCenter((BWidget)new BBorderPane((BWidget)bGridPane, 0.0, 4.0, 0.0, 4.0));
        this.localTable.addCommand((Command)this.uploadCommand, BCommandEnablePolicy.anySelection);
        this.localTable.addCommand((Command)this.deleteCommand, BCommandEnablePolicy.anySelection);
        this.localTable.addCommand((Command)new RefreshCommand(this.localTable), BCommandEnablePolicy.always);
        this.localTable.setCommandSupport(this);
        this.localTable.setCommandEnabledStates();
        this.remoteTable.addCommand((Command)this.downloadCommand, BCommandEnablePolicy.anySelection);
        this.remoteTable.addCommand((Command)this.deleteCommand, BCommandEnablePolicy.anySelection);
        this.remoteTable.addCommand((Command)new RefreshCommand(this.remoteTable), BCommandEnablePolicy.always);
        this.remoteTable.setCommandSupport(this);
        this.remoteTable.setCommandEnabledStates();
        this.setContent((BWidget)bIBeamPane);
    }

    protected void doLoadSession(BDaemonSession bDaemonSession, Context context) throws AuthenticationException {
        try {
            String string;
            Object object;
            BR2TransferTypeEnum bR2TransferTypeEnum = this.getTransferType();
            FilePath filePath = null;
            FilePath filePath2 = null;
            BImage bImage = null;
            String string2 = null;
            String string3 = null;
            filePath = new FilePath(this.getLocalR2Installation());
            File file = BFileSystem.INSTANCE.pathToLocalFile(filePath);
            if (bR2TransferTypeEnum.getOrdinal() == 0) {
                file = new File(file, File.separatorChar + "emb");
                filePath = BFileSystem.INSTANCE.localFileToPath(file);
                filePath2 = REMOTE_R2MODULES_PATH;
                string2 = "R2FileTransferClient.local.softwareHeading";
                string3 = "R2FileTransferClient.remote.softwareHeading";
                bImage = BImage.make((String)"module://icons/x16/modules.png");
                this.fileExcludePatterns = PatternFilter.parseList((String)"*.dist");
            } else if (bR2TransferTypeEnum.getOrdinal() == 1) {
                object = BR2PlatformToolOptions.make();
                string = object.getFilePatternExcludeList();
                String string4 = object.getDirectoryPatternExcludeList();
                this.fileExcludePatterns = PatternFilter.parseList((String)string, (String)" ");
                this.directoryExcludePatterns = PatternFilter.parseList((String)string4, (String)" ");
                file = new File(file, File.separatorChar + "stations");
                filePath = BFileSystem.INSTANCE.localFileToPath(file);
                filePath2 = REMOTE_R2STATIONS_PATH;
                string2 = "R2FileTransferClient.local.stationHeading";
                string3 = "R2FileTransferClient.remote.stationHeading";
                bImage = BImage.make((String)"module://icons/x16/r2/station.png");
                this.localTable.setCopyEnabled(false);
                this.localTable.setCutEnabled(false);
                this.localTable.setDeleteEnabled(false);
                this.localTable.setDuplicateEnabled(false);
                this.localTable.setRenameEnabled(false);
                this.localTable.setPasteEnabled(false);
                this.localTable.setPasteSpecialEnabled(false);
                this.localTable.setMultipleSelection(false);
                this.localTable.setDragEnabled(false);
                this.remoteTable.setCutEnabled(false);
                this.remoteTable.setCopyEnabled(false);
                this.remoteTable.setDuplicateEnabled(false);
                this.remoteTable.setRenameEnabled(false);
                this.remoteTable.setPasteEnabled(false);
                this.remoteTable.setPasteSpecialEnabled(false);
                this.remoteTable.setMultipleSelection(false);
                this.remoteTable.setDragEnabled(false);
            } else {
                boolean bl = true;
                try {
                    bl = BAppSurrogate.isAnyAppRunning((Type)BR2StationSurrogate.TYPE, (BDaemonSession)this.getDaemonSession());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.localTable.setDragEnabled(!bl);
                this.remoteTable.setDragEnabled(!bl);
                filePath = BFileSystem.INSTANCE.localFileToPath(file);
                filePath2 = new FilePath("/niagara/niagaraR2");
                string2 = "R2FileTransferClient.local.defaultHeading";
                string3 = "R2FileTransferClient.remote.defaultHeading";
                bImage = BImage.make((String)"module://icons/x16/r2/file.png");
            }
            this.localDir = (BDirectory)BFileSystem.INSTANCE.findFile(filePath);
            if (this.localDir == null) {
                log.warning("Local directory \"" + filePath + "\" does not exist");
                if (this.getTransferType().getOrdinal() == 0) {
                    object = this.getLexicon().getText("R2CommissioningWizard.embNotFound", new Object[]{filePath});
                    BDialog.warning((BWidget)this.getParentWidget(), (String)this.getLexicon().getText("R2CommissioningWizard.embNotFound.title"), (Object)object);
                }
            } else {
                this.localDirChoice.setDirectory(this.localDir);
                this.localLabel.setText(this.getLexicon().getText(string2));
                this.localLabel.setImage(bImage);
                bDaemonSession.getFileSpace().listFiles();
            }
            if (BDaemonDirectoryStore.make((BDaemonFileSpace)bDaemonSession.getFileSpace(), (FilePath)filePath2.getParent()) == null) {
                this.remoteTable.setEnabled(false);
                return;
            }
            object = BDaemonDirectoryStore.make((BDaemonFileSpace)bDaemonSession.getFileSpace(), (FilePath)filePath2);
            if (object == null) {
                DaemonFileUtil.transfer((BDaemonSession)bDaemonSession, (FileTransferMessage)FileTransferMessage.makeMkDir((FilePath)filePath2, (BDaemonFileSpace)bDaemonSession.getFileSpace()), null, null);
                object = BDaemonDirectoryStore.make((BDaemonFileSpace)bDaemonSession.getFileSpace(), (FilePath)filePath2);
            }
            string = new BDirectory((BIFileStore)object);
            if (bR2TransferTypeEnum.getOrdinal() == 1) {
                this.remoteStationsRoot = string;
            }
            this.remoteDirChoice.setDirectory((BDirectory)string);
            this.remoteTable.load((BDirectory)string, this);
            this.remoteLabel.setText(this.getLexicon().getText(string3, new Object[]{bDaemonSession.getRemoteAddressString()}));
            this.remoteLabel.setImage(bImage);
        }
        catch (ConnectException connectException) {
            // empty catch block
        }
    }

    public void doHandleLocalDirChanged() {
        BDirectory bDirectory = this.localDirChoice.getDirectory();
        BWbShell bWbShell = this.getWbShell();
        try {
            bWbShell.enterBusy();
            if (this.getTransferType().getOrdinal() == 0) {
                this.localTable.load(bDirectory, this.fileExcludePatterns, this);
            } else {
                this.localTable.load(bDirectory, this);
            }
            this.upLocalCommand.checkEnabled(bDirectory);
        }
        finally {
            bWbShell.exitBusy();
        }
    }

    public void setBoundCommandEnabled(Command command, boolean bl) {
        if (command == this.deleteCommand) {
            this.deleteCommand.setEnabled(!this.localTable.getSelection().isEmpty() || !this.remoteTable.getSelection().isEmpty());
        } else if (!bl) {
            command.setEnabled(bl);
        } else if (command == this.uploadCommand && this.getTransferType().getOrdinal() == 1) {
            command.setEnabled(this.isStationDirSelected(this.localTable));
        } else if (command == this.downloadCommand && this.getTransferType().getOrdinal() == 1) {
            command.setEnabled(this.isStationDirSelected(this.remoteTable));
        } else {
            command.setEnabled(bl);
        }
    }

    private boolean isStationDirSelected(BDirectoryTable bDirectoryTable) {
        if (bDirectoryTable.getSelection().isEmpty()) {
            return false;
        }
        if (bDirectoryTable.getSelectedFiles()[0] instanceof BDirectory) {
            BDirectory bDirectory = (BDirectory)bDirectoryTable.getSelectedFiles()[0];
            BIFile[] bIFileArray = bDirectory.listFiles();
            BIFile bIFile = null;
            for (int i = 0; i < bIFileArray.length; ++i) {
                bIFile = bIFileArray[i];
                if (!bIFile.getFileName().equals("config.xml") && !bIFile.getFileName().equals("config.db") && !bIFile.getFileName().equals("config.sns")) continue;
                return true;
            }
        }
        return false;
    }

    private Array getStationTransferContents() {
        Array array = new Array();
        this.addAllDataFiles(this.targetStationRoot, array);
        return array;
    }

    private void addAllDataFiles(BDirectory bDirectory, Array array) {
        BIFile[] bIFileArray = bDirectory.listFiles();
        for (int i = 0; i < bIFileArray.length; ++i) {
            if (bIFileArray[i].isDirectory()) {
                if (this.ignoreDirectory((BDirectory)bIFileArray[i])) continue;
                this.addAllDataFiles((BDirectory)bIFileArray[i], array);
                continue;
            }
            if (this.ignoreFile(bIFileArray[i])) continue;
            array.add((Object)bIFileArray[i]);
        }
    }

    private boolean ignoreFile(BIFile bIFile) {
        for (int i = 0; i < this.fileExcludePatterns.length; ++i) {
            if (!this.fileExcludePatterns[i].accept(bIFile)) continue;
            return true;
        }
        return false;
    }

    private boolean ignoreDirectory(BDirectory bDirectory) {
        for (int i = 0; i < this.directoryExcludePatterns.length; ++i) {
            if (!this.directoryExcludePatterns[i].accept((BIFile)bDirectory)) continue;
            return true;
        }
        return false;
    }

    private FilePath getStationDestDir(FilePath filePath) {
        FilePath filePath2 = null;
        filePath2 = this.remoteStationsRoot != null ? this.remoteStationsRoot.getFilePath().merge(this.targetStationName) : new FilePath("/niagara/niagaraR2/rel/stations/" + this.targetStationName);
        for (int i = this.targetStationRoot.getFilePath().depth(); i < filePath.depth() - 1; ++i) {
            filePath2 = filePath2.merge(filePath.nameAt(i));
        }
        return filePath2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class RefreshCommand
    extends AsyncCommand {
        private BDirectoryTable table;

        public RefreshCommand(BDirectoryTable bDirectoryTable) {
            super((BWidget)BR2FileTransferClient.this, TYPE.getModule(), "FileTransferClient.refresh");
            this.table = bDirectoryTable;
        }

        public void doInvokeAsync() {
            try {
                this.table.refresh();
            }
            catch (Throwable throwable) {
                CommandUtil.error((Command)this, (Throwable)throwable);
            }
        }
    }

    class DeleteCommand
    extends AsyncCommand {
        public DeleteCommand() {
            super((BWidget)BR2FileTransferClient.this, TYPE.getModule(), "FileTransferClient.delete");
            this.setEnabled(false);
        }

        public void doInvokeAsync() {
            block11: {
                try {
                    if (BR2FileTransferClient.this.localTable.getSelection().getRows().length > 0) {
                        BR2FileTransferClient.this.localTable.doDelete();
                        BR2FileTransferClient.this.localTable.refresh();
                        break block11;
                    }
                    if (BR2FileTransferClient.this.getTransferType().getOrdinal() == 1) {
                        boolean bl = true;
                        try {
                            bl = BAppSurrogate.isAnyAppRunning((Type)BR2StationSurrogate.TYPE, (BDaemonSession)BR2FileTransferClient.this.getDaemonSession());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (bl && 4 != BDialog.confirm((BWidget)BR2FileTransferClient.this, (String)BR2FileTransferClient.this.getLexicon().getText("R2PlatformTool.confirmStopStation.delete.title"), (Object)BR2FileTransferClient.this.getLexicon().getText("R2PlatformTool.confirmStopStation.delete.message"))) {
                            return;
                        }
                        BAppSurrogate.stopAllApps((BDaemonSession)BR2FileTransferClient.this.getDaemonSession(), null, null, (DaemonSessionTaskListener)BR2FileTransferClient.this);
                        Mark mark = BR2FileTransferClient.this.remoteTable.getSelectedFilesAsMark();
                        BR2FileTransferClient.this.remoteTable.doDelete();
                        BR2FileTransferClient.this.remoteTable.refresh();
                        BIFile bIFile = (BIFile)mark.getValue(0);
                        BR2FileTransferClient.this.getDaemonSession().sendMessage((DaemonMessage)new DeleteR2StationMessage(bIFile.getFileName()));
                        BR2FileTransferClient.this.getDaemonSession().sendMessage((DaemonMessage)new UpdateR2StationMessage());
                        break block11;
                    }
                    boolean bl = true;
                    try {
                        bl = BAppSurrogate.isAnyAppRunning((Type)BR2StationSurrogate.TYPE, (BDaemonSession)BR2FileTransferClient.this.getDaemonSession());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (bl) {
                        BDialog.error((BWidget)BR2FileTransferClient.this, (String)BR2FileTransferClient.this.getLexicon().getText("R2FileTransferClient.stationRunning.error.title"), (Object)BR2FileTransferClient.this.getLexicon().getText("R2FileTransferClient.stationRunning.error.message"));
                    } else {
                        BR2FileTransferClient.this.remoteTable.doDelete();
                        BR2FileTransferClient.this.remoteTable.refresh();
                    }
                }
                catch (Throwable throwable) {
                    CommandUtil.error((Command)this, (Throwable)throwable);
                }
            }
        }
    }

    class TransferCommand
    extends AsyncCommand {
        private BDirectoryTable sourceTable;
        private BDirectoryTable targetTable;

        public TransferCommand(BDirectoryTable bDirectoryTable, BDirectoryTable bDirectoryTable2, String string) {
            super((BWidget)BR2FileTransferClient.this, TYPE.getModule(), string);
            this.sourceTable = bDirectoryTable;
            this.targetTable = bDirectoryTable2;
            this.setEnabled(false);
        }

        public void doInvokeAsync() {
            block25: {
                try {
                    if (BR2FileTransferClient.this.getTransferType().getOrdinal() == 1) {
                        int n;
                        Object object;
                        boolean bl = false;
                        if (this.targetTable == BR2FileTransferClient.this.remoteTable) {
                            bl = true;
                        }
                        Mark mark = this.sourceTable.getSelectedFilesAsMark();
                        BR2FileTransferClient.this.targetStationName = ((BIFile)mark.getValue(0)).getFileName();
                        BR2FileTransferClient.this.targetStationRoot = (BDirectory)mark.getValue(0);
                        if (bl) {
                            boolean bl2 = false;
                            object = BR2FileTransferClient.this.targetStationRoot.listFiles();
                            for (n = 0; n < ((BIFile[])object).length; ++n) {
                                if (!object[n].getFileName().equals("config.sns")) continue;
                                bl2 = true;
                            }
                            if (!bl2) {
                                BDialog.error((BWidget)BR2FileTransferClient.this, (Object)BR2FileTransferClient.this.getLexicon().getText("R2FileTransferClient.noSns.error"));
                                return;
                            }
                        }
                        if (bl && BR2FileTransferClient.this.remoteTable.getModel().getRowCount() != 0) {
                            BIFile bIFile;
                            int n2;
                            BR2FileTransferClient.this.localTable.getSelection().deselectAll();
                            BR2FileTransferClient.this.remoteTable.getSelection().selectAll();
                            if (!BR2FileTransferClient.this.remoteTable.isDeleteEnabled()) {
                                return;
                            }
                            Mark mark2 = BR2FileTransferClient.this.remoteTable.getSelectedFilesAsMark();
                            if (mark2 == null) {
                                return;
                            }
                            object = mark2.getValues();
                            if (((Object)object).length == 0) {
                                return;
                            }
                            n = 1;
                            try {
                                n = BAppSurrogate.isAnyAppRunning((Type)BR2StationSurrogate.TYPE, (BDaemonSession)BR2FileTransferClient.this.getDaemonSession()) ? 1 : 0;
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            if (n != 0 && 4 != BDialog.confirm((BWidget)BR2FileTransferClient.this, (String)BR2FileTransferClient.this.getLexicon().getText("R2PlatformTool.confirmStopStation.title"), (Object)BR2FileTransferClient.this.getLexicon().getText("R2PlatformTool.confirmStopStation.message"))) {
                                return;
                            }
                            BAppSurrogate.stopAllApps((BDaemonSession)BR2FileTransferClient.this.getDaemonSession(), null, null, (DaemonSessionTaskListener)BR2FileTransferClient.this);
                            FileTransferMessage fileTransferMessage = new FileTransferMessage((BDaemonFileSpace)BR2FileTransferClient.this.getDaemonSession().getFileSpace());
                            for (n2 = 0; n2 < ((Object)object).length; ++n2) {
                                bIFile = (BIFile)object[n2];
                                fileTransferMessage.addElement((FileTransferMessageElement)new DeleteFileTransferMessageElement(new FilePath("!niagaraR2/rel/stations/" + bIFile.getFileName()), (BDaemonFileSpace)BR2FileTransferClient.this.getDaemonSession().getFileSpace()));
                            }
                            DaemonFileUtil.transfer((BDaemonSession)BR2FileTransferClient.this.getDaemonSession(), (FileTransferMessage)fileTransferMessage, null, null);
                            for (n2 = 0; n2 < ((Object)object).length; ++n2) {
                                bIFile = (BIFile)object[n2];
                                BR2FileTransferClient.this.getDaemonSession().sendMessage((DaemonMessage)new DeleteR2StationMessage(bIFile.getFileName()));
                            }
                            BR2FileTransferClient.this.remoteTable.refresh();
                            BR2FileTransferClient.this.remoteTable.getSelection().deselectAll();
                            BR2FileTransferClient.this.localTable.getSelection().deselectAll();
                        }
                        if (bl) {
                            Array array = new Array(class$com$tridium$install$installable$BInstallable == null ? (class$com$tridium$install$installable$BInstallable = BR2FileTransferClient.class$("com.tridium.install.installable.BInstallable")) : class$com$tridium$install$installable$BInstallable);
                            object = BR2FileTransferClient.this.getStationTransferContents().iterator();
                            while (object.hasNext()) {
                                BIFile bIFile = (BIFile)object.next();
                                array.add((Object)new BFileInstallable(bIFile, BR2FileTransferClient.this.getStationDestDir(bIFile.getFilePath())));
                            }
                            object = new InstallScenario(BR2FileTransferClient.this.getDaemonPlatform(), null, null, null, (BInstallable[])array.trim(), (InstallableRegistry)LocalInstallableRegistry.getInstance());
                            object.solve();
                            object.commit((DaemonSessionTaskListener)BR2FileTransferClient.this, null);
                        } else {
                            this.targetTable.insertTransferData(mark);
                        }
                        if (bl) {
                            BR2FileTransferClient.this.remoteTable.refresh();
                            BR2FileTransferClient.this.getDaemonSession().sendMessage((DaemonMessage)new UpdateR2StationMessage());
                            BR2FileTransferClient.this.getDaemonSession().sendMessage((DaemonMessage)new UpdateR2StationMessage(BR2FileTransferClient.this.targetStationName, false, false, false, true));
                        } else {
                            BR2FileTransferClient.this.localTable.refresh();
                        }
                        break block25;
                    }
                    boolean bl = true;
                    try {
                        bl = BAppSurrogate.isAnyAppRunning((Type)BR2StationSurrogate.TYPE, (BDaemonSession)BR2FileTransferClient.this.getDaemonSession());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (bl) {
                        BDialog.error((BWidget)BR2FileTransferClient.this, (Object)BR2FileTransferClient.this.getLexicon().getText("R2FileTransferClient.stationRunning.error"));
                    } else {
                        this.targetTable.insertTransferData(this.sourceTable.getSelectedFilesAsMark());
                    }
                }
                catch (Throwable throwable) {
                    CommandUtil.error((Command)this, (Throwable)throwable);
                }
            }
        }
    }

    private class UpLocalCommand
    extends AsyncCommand {
        public UpLocalCommand() {
            super((BWidget)BR2FileTransferClient.this, TYPE.getModule(), "FileTransferClient.upLocal");
        }

        public void checkEnabled(BDirectory bDirectory) {
            Object object;
            String string = ((BLocalFileStore)bDirectory.getStore()).getLocalFile().getAbsolutePath();
            Object object2 = bDirectory.getNavParent();
            if (object2 == null || !(object2 instanceof BDirectory)) {
                object = BR2FileTransferClient.this.localDirChoice.getDirectory();
                FilePath filePath = DaemonFileUtil.getNormalizedFilePath((BIFileStore)object.getStore()).getParent();
                object2 = filePath == null ? null : BFileSystem.INSTANCE.findFile(filePath);
            }
            if (object2 != null && object2 instanceof BDirectory) {
                object = ((BLocalFileStore)((BDirectory)object2).getStore()).getLocalFile().getAbsolutePath();
                this.setEnabled(!string.equals(object));
            } else {
                this.setEnabled(false);
            }
        }

        public void doInvokeAsync() {
            try {
                FilePath filePath;
                BDirectory bDirectory = BR2FileTransferClient.this.localDirChoice.getDirectory();
                BINavNode bINavNode = bDirectory.getNavParent();
                if (!(bINavNode != null && bINavNode instanceof BDirectory || (filePath = DaemonFileUtil.getNormalizedFilePath((BIFileStore)bDirectory.getStore()).getParent()) == null)) {
                    bINavNode = BFileSystem.INSTANCE.findFile(filePath);
                }
                if (bINavNode != null && bINavNode instanceof BDirectory) {
                    BR2FileTransferClient.this.localTable.getSelection().deselectAll();
                    BR2FileTransferClient.this.localDirChoice.setDirectory((BDirectory)bINavNode);
                }
            }
            catch (Throwable throwable) {
                CommandUtil.error((Command)this, (Throwable)throwable);
            }
        }
    }

    private class DirectoryTableController
    extends CommandBindings.TableController {
        public DirectoryTableController(CommandBindings commandBindings) {
            super(commandBindings);
        }

        public void focusGained(BFocusEvent bFocusEvent) {
            if (BR2FileTransferClient.this.getTransferType().getOrdinal() == 1) {
                return;
            }
            super.focusGained(bFocusEvent);
        }

        protected void backgroundPressed(BMouseEvent bMouseEvent) {
            BR2FileTransferClient.this.remoteTable.getSelection().deselectAll();
            BR2FileTransferClient.this.localTable.getSelection().deselectAll();
            super.backgroundPressed(bMouseEvent);
        }

        protected void cellDoubleClicked(BMouseEvent bMouseEvent, int n, int n2) {
            BDirectoryTable bDirectoryTable = (BDirectoryTable)this.getTable();
            if (BR2FileTransferClient.this.getTransferType().getOrdinal() == 1) {
                if (!BR2FileTransferClient.this.isStationDirSelected(bDirectoryTable) && bDirectoryTable.isDirectory(n)) {
                    if (bDirectoryTable == BR2FileTransferClient.this.localTable) {
                        BR2FileTransferClient.this.localDirChoice.setDirectory(bDirectoryTable.getDirectory(n));
                    } else {
                        BR2FileTransferClient.this.remoteDirChoice.setDirectory(bDirectoryTable.getDirectory(n));
                    }
                }
            } else if (bDirectoryTable.isDirectory(n)) {
                if (bDirectoryTable == BR2FileTransferClient.this.localTable) {
                    BR2FileTransferClient.this.localDirChoice.setDirectory(bDirectoryTable.getDirectory(n));
                } else {
                    BR2FileTransferClient.this.remoteDirChoice.setDirectory(bDirectoryTable.getDirectory(n));
                }
            }
        }
    }
}

