/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.filetransfer;

import com.tridium.platDaemon.ui.BDaemonSessionView;
import com.tridium.platDaemon.ui.filetransfer.BFileTransferClient;
import com.tridium.platDaemon.ui.widget.BReplaceDialog;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.DaemonFileUtil;
import com.tridium.platform.daemon.file.BDaemonDirectoryStore;
import com.tridium.platform.daemon.file.BDaemonFileSpace;
import com.tridium.platform.daemon.message.DeleteFileTransferMessageElement;
import com.tridium.platform.daemon.message.FileFileTransferElement;
import com.tridium.platform.daemon.message.FileTransferMessage;
import com.tridium.platform.daemon.message.FileTransferMessageElement;
import com.tridium.platform.daemon.message.MkDirFileTransferMessageElement;
import com.tridium.platform.daemon.task.CancelableDaemonSessionTask;
import com.tridium.platform.daemon.task.DaemonSessionTask;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import com.tridium.platform.ui.util.BCommandBoundTable;
import com.tridium.platform.ui.util.CommandBindings;
import com.tridium.ui.theme.Theme;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSpace;
import javax.baja.file.BIDirectory;
import javax.baja.file.BIFile;
import javax.baja.file.BIFileStore;
import javax.baja.file.FilePath;
import javax.baja.gx.BImage;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.SortUtil;
import javax.baja.platform.ICancelHint;
import javax.baja.space.Mark;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.table.TableSelection;
import javax.baja.ui.transfer.BTransferWidget;
import javax.baja.ui.transfer.DragRenderer;
import javax.baja.ui.transfer.SimpleDragRenderer;
import javax.baja.ui.transfer.TransferContext;
import javax.baja.ui.transfer.TransferEnvelope;
import javax.baja.ui.transfer.TransferFormat;
import javax.baja.util.Lexicon;
import javax.baja.util.PatternFilter;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.view.BWbView;

public class BDirectoryTable
extends BCommandBoundTable {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$platDaemon$ui$filetransfer$BDirectoryTable == null ? (class$com$tridium$platDaemon$ui$filetransfer$BDirectoryTable = BDirectoryTable.class$("com.tridium.platDaemon.ui.filetransfer.BDirectoryTable")) : class$com$tridium$platDaemon$ui$filetransfer$BDirectoryTable));
    static Lexicon lex = BFileTransferClient.TYPE.getModule().getLexicon();
    static DecimalFormat numFormat = new DecimalFormat(lex.getText("Formats.num"));
    private TableSelection otherSelection = null;
    private BWbView view;
    private DaemonSessionTaskListener listener;
    private boolean dragEnabled = true;
    public static final int NAME_COL = 0;
    public static final int SIZE_COL = 1;
    public static final int CRC_COL = 2;
    static /* synthetic */ Class class$com$tridium$platDaemon$ui$filetransfer$BDirectoryTable;
    static /* synthetic */ Class class$com$tridium$platDaemon$ui$filetransfer$BDirectoryTable$Model$Item;

    public Type getType() {
        return TYPE;
    }

    public BDirectoryTable() {
        throw new UnsupportedOperationException();
    }

    public BDirectoryTable(BWbView bWbView) {
        this(bWbView, true, true);
    }

    public BDirectoryTable(BWbView bWbView, boolean bl, boolean bl2) {
        super((TableModel)new Model(bl, bl2));
        this.setSelection((TableSelection)new Selection());
        this.view = bWbView;
    }

    public void load(BDirectory bDirectory, DaemonSessionTaskListener daemonSessionTaskListener) {
        this.load(bDirectory, null, daemonSessionTaskListener);
    }

    public void load(BDirectory bDirectory, PatternFilter[] patternFilterArray, DaemonSessionTaskListener daemonSessionTaskListener) {
        ((Model)this.getModel()).load(bDirectory, patternFilterArray);
        this.listener = daemonSessionTaskListener;
    }

    public void setOtherTable(BTable bTable) {
        this.otherSelection = bTable.getSelection();
    }

    public boolean isDirectory(int n) {
        return ((Model)this.getModel()).isDirectory(n);
    }

    public BDirectory getDirectory(int n) {
        return ((Model)this.getModel()).getDirectory(n);
    }

    public BDirectory getDirectory() {
        return ((Model)this.getModel()).getDirectory();
    }

    public BIFile getFile(int n) {
        return ((Model)this.getModel()).getFile(n);
    }

    public FilePath getFilePath(int n) {
        return ((Model)this.getModel()).getFilePath(n);
    }

    public int indexOf(String string) {
        return ((Model)this.getModel()).indexOf(string);
    }

    public void refresh() {
        ((Model)this.getModel()).refresh();
    }

    public void makeSubDirectory(String string) {
        try {
            FilePath filePath = this.getDirectory().getFilePath().merge(string);
            BIFile bIFile = this.getDirectory().getFileSpace().findFile(filePath);
            if (bIFile != null) {
                BDialog.warning((BWidget)this, (String)lex.getText("FileTransferClient.dirExists.dlgTitle", new Object[]{string}), (Object)lex.getText("FileTransferClient.dirExists.dlgMessage", new Object[]{string}));
                return;
            }
            if (this.getDirectory().getFileSpace() instanceof BDaemonFileSpace) {
                BDaemonFileSpace bDaemonFileSpace = (BDaemonFileSpace)this.getDirectory().getFileSpace();
                DaemonFileUtil.transfer((BDaemonSession)bDaemonFileSpace.getDaemonSession(), (FileTransferMessage)FileTransferMessage.makeMkDir((FilePath)filePath, (BDaemonFileSpace)bDaemonFileSpace), null, null);
            } else {
                this.getDirectory().getFileSpace().makeDir(filePath);
            }
            this.refresh();
        }
        catch (Throwable throwable) {
            BDialog.error((BWidget)this, (String)lex.getText("CommissioningWizard.error.dlgTitle"), (Object)lex.getText("CommissioningWizard.error.dlgMessage"), (Throwable)throwable);
        }
    }

    public BIFile[] getSelectedFiles() {
        int[] nArray = this.getSelection().getRows();
        BIFile[] bIFileArray = new BIFile[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            bIFileArray[i] = this.getFile(nArray[i]);
        }
        return bIFileArray;
    }

    public Mark getSelectedFilesAsMark() {
        BIFile[] bIFileArray = this.getSelectedFiles();
        if (bIFileArray.length == 0) {
            return null;
        }
        String[] stringArray = new String[bIFileArray.length];
        BObject[] bObjectArray = new BObject[bIFileArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = bIFileArray[i].getFileName();
            bObjectArray[i] = (BObject)bIFileArray[i];
        }
        return new Mark(bObjectArray, stringArray);
    }

    public int dragOver(TransferContext transferContext) {
        if (this.dragEnabled && transferContext.getEnvelope().supports(TransferFormat.mark)) {
            int n = this.getRowAt(transferContext.getY());
            String string = null;
            BFileSpace bFileSpace = null;
            if (n < 0 || this.getDirectory(n) == null) {
                string = this.getDirectory().getFilePath().getBody();
                bFileSpace = this.getDirectory().getFileSpace();
            } else {
                string = this.getDirectory(n).getFilePath().getBody();
                bFileSpace = this.getDirectory(n).getFileSpace();
            }
            Mark mark = (Mark)transferContext.getEnvelope().getData(TransferFormat.mark);
            BObject[] bObjectArray = mark.getValues();
            for (int i = 0; i < bObjectArray.length; ++i) {
                if (bObjectArray[i] == null || !(bObjectArray[i] instanceof BIFile)) {
                    return 0;
                }
                BIFile bIFile = (BIFile)bObjectArray[i];
                if (bIFile.getFileSpace() != bFileSpace || !bIFile.getFilePath().getBody().equals(string) && !bIFile.getFilePath().getParent().getBody().equals(string)) continue;
                return 0;
            }
            return 16;
        }
        return 0;
    }

    public CommandArtifact drop(TransferContext transferContext) throws Exception {
        if (this.dragEnabled && transferContext.getEnvelope().supports(TransferFormat.mark)) {
            int n = this.getRowAt(transferContext.getY());
            BDirectory bDirectory = n < 0 || this.getDirectory(n) == null ? this.getDirectory() : this.getDirectory(n);
            if (4 != BDialog.confirm((BWidget)this, (String)this.getLexicon().getText("FileTransferClient.transfer.confirmTitle"), (Object)this.getLexicon().getText("FileTransferClient.transfer.confirmMessage", new Object[]{DaemonFileUtil.getNormalizedFilePath((BIFileStore)bDirectory.getStore()).getBody()}))) {
                return null;
            }
            return this.insertTransferData(transferContext);
        }
        return null;
    }

    public void mouseDragStarted(BMouseEvent bMouseEvent) {
        if (this.dragEnabled) {
            int[] nArray = this.getSelection().getRows();
            if (nArray.length == 0) {
                return;
            }
            int n = this.getRowAt(bMouseEvent.getY());
            boolean bl = false;
            for (int i = 0; i < nArray.length; ++i) {
                if (n != nArray[i]) continue;
                bl = true;
                break;
            }
            if (!bl) {
                return;
            }
            Mark mark = this.getSelectedFilesAsMark();
            SimpleDragRenderer simpleDragRenderer = new SimpleDragRenderer(mark);
            simpleDragRenderer.font = Theme.table().getCellFont();
            this.startDrag(bMouseEvent, TransferEnvelope.make((Mark)mark), (DragRenderer)simpleDragRenderer);
        }
    }

    public void setDragEnabled(boolean bl) {
        this.dragEnabled = bl;
    }

    public TransferEnvelope getTransferData() throws Exception {
        Mark mark = this.getSelectedFilesAsMark();
        if (mark == null) {
            return null;
        }
        return TransferEnvelope.make((Mark)mark);
    }

    public CommandArtifact insertTransferData(TransferContext transferContext) throws Exception {
        if (transferContext.getEnvelope().supports(TransferFormat.mark)) {
            return this.insertTransferData(this.getRowAt(transferContext.getY()), (Mark)transferContext.getEnvelope().getData(TransferFormat.mark));
        }
        return null;
    }

    public CommandArtifact insertTransferData(Mark mark) throws Exception {
        return this.insertTransferData(-1, mark);
    }

    public CommandArtifact insertTransferData(int n, Mark mark) throws Exception {
        if (mark == null || mark.getValues().length == 0) {
            return null;
        }
        FilePath filePath = null;
        BFileSpace bFileSpace = null;
        if (n < 0 || this.getDirectory(n) == null) {
            filePath = this.getDirectory().getFilePath();
            bFileSpace = this.getDirectory().getFileSpace();
        } else {
            filePath = this.getDirectory(n).getFilePath();
            bFileSpace = this.getDirectory(n).getFileSpace();
        }
        if (bFileSpace instanceof BDaemonFileSpace) {
            BDaemonSession bDaemonSession = ((BDaemonFileSpace)bFileSpace).getDaemonSession();
            BObject[] bObjectArray = mark.getValues();
            for (int i = 0; i < bObjectArray.length; ++i) {
                BDaemonSession bDaemonSession2;
                BFileSpace bFileSpace2 = ((BIFile)bObjectArray[i]).getFileSpace();
                if (!(bFileSpace2 instanceof BDaemonFileSpace) || !(bDaemonSession2 = ((BDaemonFileSpace)bFileSpace2).getDaemonSession()).getHostProperties().getHostId().equals(bDaemonSession.getHostProperties().getHostId())) continue;
                throw new LocalizableRuntimeException("platDaemon", "DirectoryTable.sourceTargetSameSession", new Object[]{bDaemonSession2.getHost().getNavDisplayName(null)});
            }
        }
        new TransferWorker(bFileSpace, filePath, mark.getValues()).open();
        return null;
    }

    public CommandArtifact removeTransferData(TransferContext transferContext) throws Exception {
        throw new UnsupportedOperationException();
    }

    public CommandArtifact doDelete() throws Exception {
        if (!this.isDeleteEnabled()) {
            return null;
        }
        Mark mark = this.getSelectedFilesAsMark();
        if (mark == null) {
            return null;
        }
        BObject[] bObjectArray = mark.getValues();
        if (bObjectArray.length == 0) {
            return null;
        }
        if (4 != BDialog.confirm((BWidget)this, (String)this.getLexicon().getText("FileTransferClient.delete.confirmTitle"), (Object)this.getLexicon().getText("FileTransferClient.delete.confirmMessage"))) {
            return null;
        }
        FileTransferMessage fileTransferMessage = null;
        BDaemonSession bDaemonSession = null;
        for (int i = 0; i < bObjectArray.length; ++i) {
            BIFile bIFile = (BIFile)bObjectArray[i];
            if (bIFile.getFileSpace() instanceof BDaemonFileSpace) {
                if (fileTransferMessage == null) {
                    fileTransferMessage = new FileTransferMessage((BDaemonFileSpace)bIFile.getFileSpace());
                    bDaemonSession = ((BDaemonFileSpace)bIFile.getFileSpace()).getDaemonSession();
                }
                fileTransferMessage.addElement((FileTransferMessageElement)new DeleteFileTransferMessageElement(bIFile.getFilePath(), (BDaemonFileSpace)bIFile.getFileSpace()));
                continue;
            }
            bIFile.delete();
        }
        if (fileTransferMessage != null) {
            DaemonFileUtil.transfer(bDaemonSession, fileTransferMessage, null, (DaemonSessionTaskListener)this.listener);
        }
        this.refresh();
        this.getSelection().deselectAll();
        return null;
    }

    public void deactivated() {
        Model model = (Model)this.getModel();
        model.deactivated();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class TransferWorker
    implements Runnable {
        private FileTransferMessage msg = null;
        private BDaemonSession dsession = null;
        private BObject[] vals;
        private FilePath targetFilePath;
        private BFileSpace targetFileSpace;
        private CancelableDaemonSessionTask task;

        public TransferWorker(BFileSpace bFileSpace, FilePath filePath, BObject[] bObjectArray) {
            this.targetFileSpace = bFileSpace;
            if (this.targetFileSpace instanceof BDaemonFileSpace) {
                this.msg = new FileTransferMessage((BDaemonFileSpace)this.targetFileSpace);
                this.dsession = ((BDaemonFileSpace)this.targetFileSpace).getDaemonSession();
            }
            this.targetFilePath = filePath;
            this.vals = bObjectArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            BWbShell bWbShell = BWbShell.getWbShell((BWidget)BDirectoryTable.this);
            if (bWbShell != null) {
                bWbShell.enterBusy();
            }
            this.task = this.msg == null ? new CancelableDaemonSessionTask(BDirectoryTable.this.getLexicon(), "DirectoryTable.transferringFiles", "DirectoryTable.transferringFiles", 100) : new CancelableDaemonSessionTask(BDirectoryTable.this.getLexicon(), "DirectoryTable.transferringFiles", "DirectoryTable.transferringFiles");
            this.task.setImmediate(true);
            BDirectoryTable.this.listener.taskStarted((DaemonSessionTask)this.task);
            try {
                int n;
                Array array = new Array();
                BReplaceDialog bReplaceDialog = new BReplaceDialog((BWidget)BDirectoryTable.this);
                for (n = 0; n < this.vals.length; ++n) {
                    if (this.addTransferItems(bReplaceDialog, (BIFile)this.vals[n], this.targetFilePath, array, this.msg)) continue;
                    BDialog.message((BWidget)BDirectoryTable.this, (String)BDirectoryTable.this.getLexicon().getText("FileTransferClient.transfer.dialogTitle"), (Object)new BBorderPane((BWidget)new BLabel(BDirectoryTable.this.getLexicon().getText("FileTransferClient.transfer.transferCancelled")), 10.0, 20.0, 10.0, 20.0));
                    return;
                }
                if (this.msg != null) {
                    BDirectoryTable.this.listener.taskFinished((DaemonSessionTask)this.task);
                    DaemonFileUtil.transfer((BDaemonSession)this.dsession, (FileTransferMessage)this.msg, null, (DaemonSessionTaskListener)BDirectoryTable.this.listener);
                } else {
                    for (n = 0; n < array.size(); ++n) {
                        this.transferLocal(array.get(n));
                    }
                }
                BDirectoryTable.this.refresh();
                BDirectoryTable.this.listener.taskFinished((DaemonSessionTask)this.task);
                BDialog.message((BWidget)BDirectoryTable.this, (String)BDirectoryTable.this.getLexicon().getText("FileTransferClient.transfer.dialogTitle"), (Object)new BBorderPane((BWidget)new BLabel(BDirectoryTable.this.getLexicon().getText("FileTransferClient.transfer.transferComplete")), 10.0, 20.0, 10.0, 20.0));
            }
            catch (Exception exception) {
                BDialog.error((BWidget)BDirectoryTable.this.view, (String)BDirectoryTable.this.getLexicon().getText("FileTransferClient.transferError.dlgTitle"), (Object)BDirectoryTable.this.getLexicon().getText("FileTransferClient.transferError.dlgMessage"), (Throwable)exception);
            }
            finally {
                if (bWbShell != null) {
                    bWbShell.exitBusy();
                }
                BDirectoryTable.this.listener.taskFinished((DaemonSessionTask)this.task);
            }
        }

        private boolean addTransferItems(BReplaceDialog bReplaceDialog, BIFile bIFile, FilePath filePath, Array array, FileTransferMessage fileTransferMessage) throws Exception {
            if (this.task.isCanceled()) {
                return false;
            }
            FilePath filePath2 = filePath.merge(bIFile.getFileName());
            BIFile bIFile2 = this.targetFileSpace.findFile(filePath2);
            this.task.setMessage(BDirectoryTable.this.getLexicon().getText("DirectoryTable.checking", new Object[]{filePath2.getBody()}));
            BDirectoryTable.this.listener.taskUpdated((DaemonSessionTask)this.task);
            int n = bIFile2 == null || bIFile2.isDirectory() ? 4 : bReplaceDialog.promptResult(bIFile2, bIFile);
            if (n == 4) {
                if (bIFile.isDirectory()) {
                    if (fileTransferMessage == null) {
                        array.add((Object)new MakeDirItem(filePath2));
                    } else {
                        fileTransferMessage.addElement((FileTransferMessageElement)new MkDirFileTransferMessageElement(filePath2, (BDaemonFileSpace)this.targetFileSpace));
                    }
                    BIFile[] bIFileArray = ((BIDirectory)bIFile).listFiles();
                    for (int i = 0; i < bIFileArray.length; ++i) {
                        if (this.addTransferItems(bReplaceDialog, bIFileArray[i], filePath2, array, fileTransferMessage)) continue;
                        return false;
                    }
                } else if (fileTransferMessage != null) {
                    fileTransferMessage.addElement((FileTransferMessageElement)new FileFileTransferElement(filePath2, bIFile, (BDaemonFileSpace)this.targetFileSpace));
                } else {
                    array.add((Object)new TransferItem(bIFile, filePath2));
                }
                return true;
            }
            return n != 2;
        }

        private void transferLocal(Object object) throws Exception {
            if (this.task.isCanceled()) {
                throw new ICancelHint.CanceledException();
            }
            if (object instanceof MakeDirItem) {
                MakeDirItem makeDirItem = (MakeDirItem)object;
                this.targetFileSpace.makeDir(makeDirItem.targetPath);
            } else if (object instanceof TransferItem) {
                TransferItem transferItem = (TransferItem)object;
                if (transferItem.source.isDirectory()) {
                    this.targetFileSpace.makeDir(transferItem.targetPath);
                    this.task.setMessage(Lexicon.make((String)"platform").getText("FileTransferMessageElement.progress", new Object[]{transferItem.targetPath.getBody()}));
                    this.task.setProgress(100);
                    BDirectoryTable.this.listener.taskUpdated((DaemonSessionTask)this.task);
                } else {
                    byte[] byArray = new byte[4096];
                    long l = 0L;
                    long l2 = transferItem.source.getSize();
                    boolean bl = false;
                    BIFile bIFile = this.targetFileSpace.findFile(transferItem.targetPath);
                    if (bIFile == null) {
                        bIFile = this.targetFileSpace.makeFile(transferItem.targetPath);
                        bl = true;
                    }
                    OutputStream outputStream = bIFile.getOutputStream();
                    InputStream inputStream = transferItem.source.getInputStream();
                    if (inputStream != null) {
                        this.task.setMessage(Lexicon.make((String)"platform").getText("FileTransferMessageElement.progress", new Object[]{transferItem.targetPath.getBody()}));
                        if (l2 > 0L) {
                            int n;
                            this.task.setProgress((int)(100L * l / l2));
                            BDirectoryTable.this.listener.taskUpdated((DaemonSessionTask)this.task);
                            while ((n = inputStream.read(byArray, 0, byArray.length)) > 0) {
                                outputStream.write(byArray, 0, n);
                                this.task.setProgress((int)(100L * (l += (long)n) / l2));
                                BDirectoryTable.this.listener.taskUpdated((DaemonSessionTask)this.task);
                            }
                        }
                        this.task.setProgress(100);
                        BDirectoryTable.this.listener.taskUpdated((DaemonSessionTask)this.task);
                        inputStream.close();
                        outputStream.close();
                    } else {
                        outputStream.close();
                        if (bl) {
                            this.targetFileSpace.delete(transferItem.targetPath);
                        }
                        throw new BajaRuntimeException(BDirectoryTable.this.getLexicon().get("FileTransferClient.transfer.transferErrorInputStream"));
                    }
                }
            }
        }

        public void open() throws Exception {
            new Thread(this).start();
        }
    }

    private class MakeDirItem {
        public FilePath targetPath;

        public MakeDirItem(FilePath filePath) {
            this.targetPath = filePath;
        }
    }

    private class TransferItem {
        public BIFile source;
        public FilePath targetPath;

        public TransferItem(BIFile bIFile, FilePath filePath) {
            this.source = bIFile;
            this.targetPath = filePath;
        }
    }

    private static class Model
    extends TableModel {
        private CrcWorker crcWorker = null;
        private BlockingQueue crcQueue = new LinkedBlockingQueue();
        private BDirectory dir = null;
        private PatternFilter[] fileExcludePatterns = null;
        private Array items = new Array(class$com$tridium$platDaemon$ui$filetransfer$BDirectoryTable$Model$Item == null ? (class$com$tridium$platDaemon$ui$filetransfer$BDirectoryTable$Model$Item = BDirectoryTable.class$("com.tridium.platDaemon.ui.filetransfer.BDirectoryTable$Model$Item")) : class$com$tridium$platDaemon$ui$filetransfer$BDirectoryTable$Model$Item);
        private boolean includeCrc;
        private boolean includeSize;
        private static final long MAX_FILE_SIZE_CRC = 0x20000000L;

        public Model(boolean bl, boolean bl2) {
            this.includeCrc = bl;
            this.includeSize = bl2;
        }

        public int getColumnCount() {
            return 1 + (this.includeCrc ? 1 : 0) + (this.includeSize ? 1 : 0);
        }

        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return BDaemonSessionView.lexicon.getText("DirectoryTable.column.name");
                }
                case 1: {
                    return BDaemonSessionView.lexicon.getText("DirectoryTable.column.size");
                }
                case 2: {
                    return BDaemonSessionView.lexicon.getText("DirectoryTable.column.crc");
                }
            }
            throw new ArrayIndexOutOfBoundsException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getRowCount() {
            Array array = this.items;
            synchronized (array) {
                return this.items.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Item getItem(int n) {
            Array array = this.items;
            synchronized (array) {
                return (Item)this.items.get(n);
            }
        }

        public BImage getRowIcon(int n) {
            return this.getItem((int)n).icon;
        }

        public BHalign getColumnAlignment(int n) {
            if (n == 0) {
                return BHalign.left;
            }
            return BHalign.right;
        }

        public Object getValueAt(int n, int n2) {
            switch (n2) {
                case 0: {
                    return this.getItem((int)n).file.getFileName();
                }
                case 1: {
                    return this.getItem((int)n).size;
                }
                case 2: {
                    return this.getItem((int)n).crc;
                }
            }
            throw new ArrayIndexOutOfBoundsException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void load(BDirectory bDirectory, PatternFilter[] patternFilterArray) {
            this.dir = bDirectory;
            this.fileExcludePatterns = patternFilterArray;
            if (this.dir.getStore() instanceof BDaemonDirectoryStore) {
                ((BDaemonDirectoryStore)this.dir.getStore()).reset();
            }
            BIFile[] bIFileArray = this.dir.listFiles();
            Array array = this.items;
            synchronized (array) {
                this.items.clear();
                if (this.crcQueue != null) {
                    this.resetQueue();
                }
                for (int i = 0; i < bIFileArray.length; ++i) {
                    boolean bl = false;
                    if (this.fileExcludePatterns != null) {
                        for (int j = 0; j < this.fileExcludePatterns.length; ++j) {
                            if (!this.fileExcludePatterns[j].accept(bIFileArray[i])) continue;
                            bl = true;
                            break;
                        }
                    }
                    if (bl) continue;
                    Item item = new Item(bIFileArray[i], this.includeCrc, this.includeSize);
                    if (item.shouldCalcCrc()) {
                        try {
                            if (this.crcWorker == null) {
                                this.crcWorker = new CrcWorker(this.crcQueue);
                            }
                            this.crcQueue.put(item);
                        }
                        catch (InterruptedException interruptedException) {
                            interruptedException.printStackTrace();
                        }
                    }
                    this.items.add((Object)item);
                }
                SortUtil.sort((Object[])this.items.trim());
                if (this.crcWorker != null) {
                    this.crcWorker.start();
                }
            }
            this.updateTable(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void deactivated() {
            Array array = this.items;
            synchronized (array) {
                this.resetQueue();
            }
        }

        private void resetQueue() {
            if (this.crcQueue != null) {
                this.crcQueue.clear();
            }
            if (this.crcWorker != null) {
                this.crcWorker.interrupt();
            }
            this.crcWorker = null;
        }

        public void refresh() {
            this.load(this.dir, this.fileExcludePatterns);
        }

        public boolean isDirectory(int n) {
            try {
                return this.getFile(n).isDirectory();
            }
            catch (Exception exception) {
                return false;
            }
        }

        public BDirectory getDirectory(int n) {
            try {
                return (BDirectory)this.getFile(n);
            }
            catch (Exception exception) {
                return null;
            }
        }

        public BDirectory getDirectory() {
            return this.dir;
        }

        public BIFile getFile(int n) {
            return this.getItem((int)n).file;
        }

        public FilePath getFilePath(int n) {
            try {
                return this.getFile(n).getFilePath();
            }
            catch (Exception exception) {
                return null;
            }
        }

        public int indexOf(String string) {
            for (int i = 0; i < this.getRowCount(); ++i) {
                if (!this.getFile(i).getFileName().equalsIgnoreCase(string)) continue;
                return i;
            }
            return -1;
        }

        public static boolean tooLargeForCRC(BIFile bIFile) {
            return bIFile.getSize() > 0x20000000L;
        }

        private class Item
        implements Comparable {
            public BIFile file;
            public String size;
            public String crc;
            public BImage icon;
            public boolean includeCrc;
            public boolean calcCrc = false;
            public boolean includeSize;

            public Item(BIFile bIFile, boolean bl, boolean bl2) {
                this.file = bIFile;
                this.icon = BImage.make((BIcon)((BObject)this.file).getIcon());
                this.includeCrc = bl;
                this.includeSize = bl2;
                this.size = this.file.isDirectory() || !this.includeSize ? "" : DaemonFileUtil.fileSize((long)this.file.getSize());
                if (this.file.isDirectory() || !this.includeCrc || Model.tooLargeForCRC(this.file)) {
                    this.crc = "";
                } else {
                    this.crc = TYPE.getModule().getLexicon().getText("FileTransferClient.calculating");
                    this.calcCrc = true;
                }
            }

            public void setCrc(String string) {
                this.crc = string;
                Model.this.getModel().updateTable(true);
            }

            public boolean shouldCalcCrc() {
                return this.calcCrc;
            }

            public int compareTo(Object object) {
                Item item = (Item)object;
                if (this.file.isDirectory()) {
                    if (item.file.isDirectory()) {
                        return this.file.getFileName().compareTo(item.file.getFileName());
                    }
                    return -1;
                }
                if (item.file.isDirectory()) {
                    return 1;
                }
                return this.file.getFileName().compareTo(item.file.getFileName());
            }
        }

        private class CrcWorker
        extends Thread {
            private BlockingQueue queue;

            public CrcWorker(BlockingQueue blockingQueue) {
                super("CrcWorkerThread");
                this.queue = blockingQueue;
            }

            public void run() {
                Item item = null;
                while ((item = (Item)this.queue.poll()) != null) {
                    String string;
                    try {
                        string = Long.toHexString(DaemonFileUtil.getCrc((BIFile)item.file));
                    }
                    catch (Exception exception) {
                        string = "Failed";
                    }
                    item.setCrc(string);
                }
            }
        }
    }

    private class Selection
    extends CommandBindings.TableSelection {
        private Selection() {
        }

        public void select(int n, boolean bl) {
            super.select(n, bl);
            this.checkOtherSelection();
            this.checkTransfer();
        }

        public void select(int n, int n2, boolean bl) {
            super.select(n, n2, bl);
            this.checkOtherSelection();
            this.checkTransfer();
        }

        public void select(int[] nArray) {
            super.select(nArray);
            this.checkOtherSelection();
            this.checkTransfer();
        }

        public void deselect(int n) {
            super.deselect(n);
            this.checkTransfer();
        }

        public void deselectAll() {
            super.deselectAll();
            this.checkTransfer();
        }

        private void checkTransfer() {
            if (this.isEmpty()) {
                BDirectoryTable.this.setDeleteEnabled(false);
            } else {
                BDirectoryTable.this.view.setTransferWidget((BTransferWidget)BDirectoryTable.this);
                BDirectoryTable.this.setDeleteEnabled(true);
            }
        }

        private void checkOtherSelection() {
            if (BDirectoryTable.this.otherSelection != null && !this.isEmpty()) {
                BDirectoryTable.this.otherSelection.deselectAll();
            }
        }
    }
}

