/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.distinstall;

import com.tridium.install.BDaemonPlatform;
import com.tridium.install.DaemonPlatformUtil;
import com.tridium.install.installable.BInstallable;
import com.tridium.install.part.BNrePart;
import com.tridium.install.part.BPart;
import com.tridium.platDaemon.ui.DaemonSessionTaskHandler;
import com.tridium.platDaemon.ui.distinstall.DistInstallWizardModel;
import com.tridium.platDaemon.ui.widget.TaskDetailDialog;
import com.tridium.platDaemon.ui.widget.TaskDetailPane;
import com.tridium.platform.daemon.BAppSurrogate;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.BStationSurrogate;
import com.tridium.platform.daemon.message.DaemonMessage;
import com.tridium.platform.daemon.message.OSUpdateMessage;
import com.tridium.platform.daemon.message.RefreshDaemonBinariesMessage;
import com.tridium.platform.daemon.task.CancelableDaemonSessionTask;
import com.tridium.platform.daemon.task.DaemonSessionTask;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import com.tridium.platform.tcpip.BTcpIpHostSettings;
import com.tridium.platform.tcpip.TcpUtil;
import java.net.SocketException;
import javax.baja.gx.BImage;
import javax.baja.job.BJobState;
import javax.baja.nre.util.Array;
import javax.baja.platform.BStationStatus;
import javax.baja.platform.ICancelHint;
import javax.baja.ui.BWidget;
import javax.baja.util.Lexicon;

public class FinishDistInstall
extends TaskDetailDialog
implements DaemonSessionTaskListener {
    private static Lexicon lex = Lexicon.make((String)"platDaemon");
    private String lastText = null;
    private boolean mustReboot = false;
    private DaemonSessionTaskListener taskListener;
    private DistInstallWizardModel model;
    private TaskDetailPane.TaskItem stopAllAppsItem = new TaskDetailPane.TaskItem(lex.getText("DistInstaller.FinishDistInstall.item.stopAllApps"));
    private TaskDetailPane.TaskItem installItem = new TaskDetailPane.TaskItem(lex.getText("DistInstaller.FinishDistInstall.item.install"));
    private TaskDetailPane.TaskItem installOsItem = new TaskDetailPane.TaskItem(lex.getText("DistInstaller.FinishDistInstall.item.installOs"));
    private TaskDetailPane.TaskItem rebootItem = new TaskDetailPane.TaskItem(lex.getText("DistInstaller.FinishDistInstall.item.reboot"));
    private TaskDetailPane.TaskItem tcpItem = new TaskDetailPane.TaskItem(lex.getText("DistInstaller.FinishDistInstall.item.updateTcp"));
    private TaskDetailPane.TaskItem refreshDaemonItem = new TaskDetailPane.TaskItem(lex.getText("DistInstaller.FinishDistInstall.item.refreshDaemon"));
    private TaskDetailPane.TaskItem reconnectItem = new TaskDetailPane.TaskItem(lex.getText("DistInstaller.FinishDistInstall.item.reconnect"));
    private TaskDetailPane.TaskItem startAppsItem = new TaskDetailPane.TaskItem(lex.getText("DistInstaller.FinishDistInstall.item.startApp"));
    private Array items;
    static /* synthetic */ Class class$com$tridium$platDaemon$ui$widget$TaskDetailPane$TaskItem;

    public FinishDistInstall(DistInstallWizardModel distInstallWizardModel) throws Exception {
        this.model = distInstallWizardModel;
        this.items = new Array(class$com$tridium$platDaemon$ui$widget$TaskDetailPane$TaskItem == null ? (class$com$tridium$platDaemon$ui$widget$TaskDetailPane$TaskItem = FinishDistInstall.class$("com.tridium.platDaemon.ui.widget.TaskDetailPane$TaskItem")) : class$com$tridium$platDaemon$ui$widget$TaskDetailPane$TaskItem);
        this.items.add((Object)this.stopAllAppsItem);
        this.items.add((Object)this.installItem);
        if (distInstallWizardModel.updateTcpIp()) {
            this.items.add((Object)this.tcpItem);
        }
        if ((distInstallWizardModel.getInstallScenario().getProcessingFlags() & 0x20000L) > 0L) {
            this.items.add((Object)this.installOsItem);
        }
        if ((distInstallWizardModel.getInstallScenario().getProcessingFlags() & 0x10000L) > 0L) {
            this.items.add((Object)this.rebootItem);
            this.mustReboot = true;
        } else if ((distInstallWizardModel.getInstallScenario().getProcessingFlags() & 0x40000L) > 0L) {
            this.items.add((Object)this.refreshDaemonItem);
            this.items.add((Object)this.reconnectItem);
        } else if (BAppSurrogate.isAnyAppRunning(null, (BDaemonSession)distInstallWizardModel.getSession())) {
            if (distInstallWizardModel.getSession().getHostProperties().getAllowStationRestart()) {
                this.items.add((Object)this.startAppsItem);
            } else {
                this.items.add((Object)this.rebootItem);
                this.mustReboot = true;
            }
        }
        this.init((BWidget)distInstallWizardModel.getWizard());
    }

    protected DistInstallWizardModel getWizardModel() {
        return this.model;
    }

    public String getHeadingTitle() {
        return lex.getText("DistInstaller.FinishDistInstall.dialogHeading");
    }

    public String getDialogTitle() {
        return lex.getText("DistInstaller.FinishDistInstall.dialogHeading");
    }

    public BImage getHeadingIcon() {
        return DistInstallWizardModel.wizImage;
    }

    public String getItemListHeading() {
        return lex.getText("DistInstaller.FinishDistInstall.itemHeading");
    }

    public TaskDetailPane.TaskItem[] makeTaskItems() {
        return (TaskDetailPane.TaskItem[])this.items.trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            Object object;
            int n;
            BDaemonPlatform bDaemonPlatform = this.getWizardModel().getPlatform();
            this.setCurrentItem(this.stopAllAppsItem, BJobState.running);
            this.taskListener = new DaemonSessionTaskHandler((BWidget)this.getDialog());
            BAppSurrogate[] bAppSurrogateArray = BAppSurrogate.stopAllApps((BDaemonSession)this.getWizardModel().getSession(), null, (ICancelHint)this, (DaemonSessionTaskListener)this.taskListener);
            BStationSurrogate[] bStationSurrogateArray = BStationSurrogate.makeAll((BDaemonSession)this.getWizardModel().getSession());
            block10: for (n = 0; n < bStationSurrogateArray.length; ++n) {
                if (bStationSurrogateArray[n].getStationStatus() == BStationStatus.idle) continue;
                object = this.getWizardModel().getInstallScenario().getToInstall();
                for (int i = 0; i < ((BInstallable[])object).length; ++i) {
                    BPart bPart = object[i].getPart();
                    if (bPart == null || !(bPart instanceof BNrePart)) continue;
                    DaemonPlatformUtil.doExtraStationShutdownTasks((BDaemonPlatform)bDaemonPlatform, (DaemonSessionTaskListener)this, (ICancelHint)this);
                    break block10;
                }
                break;
            }
            this.updateCurrentItemState(BJobState.success);
            this.setCurrentItem(this.installItem, BJobState.running);
            this.getWizardModel().getInstallScenario().commit((DaemonSessionTaskListener)this, (ICancelHint)this);
            this.checkCanceled();
            this.updateCurrentItemState(BJobState.success);
            this.getWizardModel().getSession().getHostProperties().reset();
            bDaemonPlatform.getModuleList().reset();
            if (this.getWizardModel().updateTcpIp()) {
                this.setCurrentItem(this.tcpItem, BJobState.running);
                this.getLog().append(lex.getText("DistInstaller.FinishDistInstall.updateTcpMessage"));
                this.getLog().append("\n");
                TcpUtil.saveToSession((BTcpIpHostSettings)this.getWizardModel().getInstallScenario().getTcpIpChanges(), (BDaemonSession)this.getWizardModel().getSession(), (boolean)false);
                this.updateCurrentItemState(BJobState.success);
            }
            if ((this.getWizardModel().getProcessingFlags() & 0x20000L) > 0L) {
                this.setCurrentItem(this.installOsItem, BJobState.running);
                this.getLog().append(lex.getText("DistInstaller.FinishDistInstall.osInstallMessage"));
                this.getLog().append("\n");
                this.getWizardModel().getSession().sendMessage((DaemonMessage)OSUpdateMessage.getInstance(), 60000);
                this.updateCurrentItemState(BJobState.success);
            }
            if (this.mustReboot) {
                this.setCurrentItem(this.rebootItem, BJobState.running);
                this.getWizardModel().getSession().sendRebootRequest();
                this.getLog().append(lex.getText("DistInstaller.FinishDistInstall.rebootMessage"));
                this.getLog().append("\n");
                this.updateCurrentItemState(BJobState.success);
            } else {
                if ((this.getWizardModel().getProcessingFlags() & 0x40000L) > 0L) {
                    String string = this.getWizardModel().getSession().getHostProperties().getSessionTimestamp();
                    this.setCurrentItem(this.refreshDaemonItem, BJobState.running);
                    try {
                        this.getWizardModel().getSession().sendMessage((DaemonMessage)RefreshDaemonBinariesMessage.getInstance());
                    }
                    catch (SocketException socketException) {
                        // empty catch block
                    }
                    this.getLog().append(lex.getText("DistInstaller.FinishDistInstall.updateDaemonMessage"));
                    this.getLog().append("\n");
                    this.updateCurrentItemState(BJobState.success);
                    this.setCancelEnabled(true);
                    this.setCurrentItem(this.reconnectItem, BJobState.running);
                    this.getLog().append(lex.getText("DistInstaller.FinishDistInstall.waitReconnect"));
                    this.getLog().append("\n");
                    object = new Dots();
                    ((Thread)object).start();
                    while (!this.isCanceled()) {
                        try {
                            this.getWizardModel().getSession().reloadHostProperties(15000);
                            if (this.getWizardModel().getSession().getHostProperties().getSessionTimestamp().equals(string)) continue;
                            ((Dots)object).cancel();
                            this.getLog().append(lex.getText("DistInstaller.FinishDistInstall.reconnected"));
                            this.getLog().append("\n");
                            this.updateCurrentItemState(BJobState.success);
                            break;
                        }
                        catch (SocketException socketException) {
                        }
                    }
                    try {
                        this.checkCanceled();
                    }
                    finally {
                        ((Dots)object).cancel();
                    }
                }
                if (bAppSurrogateArray.length > 0) {
                    if (!this.getWizardModel().getSession().getHostProperties().getAllowStationRestart()) {
                        this.setCurrentItem(this.rebootItem, BJobState.running);
                        this.getWizardModel().getSession().sendRebootRequest();
                        this.getLog().append(lex.getText("DistInstaller.FinishDistInstall.rebootMessage"));
                        this.getLog().append("\n");
                        this.updateCurrentItemState(BJobState.success);
                    } else {
                        this.setCancelEnabled(true);
                        this.setCurrentItem(this.startAppsItem, BJobState.running);
                        for (n = 0; n < bAppSurrogateArray.length; ++n) {
                            this.getLog().append(lex.getText("DistInstaller.FinishDistInstall.startApp", new Object[]{bAppSurrogateArray[n].toString(null)}));
                            this.getLog().append("\n");
                            bAppSurrogateArray[n].startAppAsync();
                        }
                        this.updateCurrentItemState(BJobState.success);
                        bDaemonPlatform.getModuleList().reset();
                    }
                }
            }
            this.getLog().append(lex.getText("DistInstaller.FinishDistInstall.complete"));
            this.getLog().append("\n");
            this.setBottomLabelText(lex.getText("DistInstaller.FinishDistInstall.complete"));
        }
        catch (ICancelHint.CanceledException canceledException) {
            this.cancel(false);
            this.getLog().append("\n");
            this.getLog().append(lex.getText("DistInstaller.FinishDistInstall.canceled"));
            this.setBottomLabelText(lex.getText("DistInstaller.FinishDistInstall.canceled"));
        }
        catch (Throwable throwable) {
            this.setCancelEnabled(true);
            this.updateCurrentItemState(BJobState.failed);
            this.setBottomLabelText(lex.getText("DistInstaller.FinishDistInstall.failed"));
            throwable.printStackTrace();
            this.getLog().append(throwable);
        }
    }

    public void taskStarted(DaemonSessionTask daemonSessionTask) {
        if (this.lastText == null || !daemonSessionTask.getMessage().equals(this.lastText)) {
            this.getLog().append(daemonSessionTask.getMessage() + "\n");
            this.lastText = daemonSessionTask.getMessage();
        }
    }

    public void taskUpdated(DaemonSessionTask daemonSessionTask) {
        if (this.lastText == null || !daemonSessionTask.getMessage().equals(this.lastText)) {
            this.getLog().append(daemonSessionTask.getMessage() + "\n");
            this.lastText = daemonSessionTask.getMessage();
        }
        if (daemonSessionTask instanceof CancelableDaemonSessionTask && !((CancelableDaemonSessionTask)daemonSessionTask).isCancelEnabled()) {
            this.setCancelEnabled(false);
        }
    }

    public void taskFinished(DaemonSessionTask daemonSessionTask) {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class Dots
    extends Thread {
        private boolean dotCanceled = false;
        private boolean dotRunning = true;
        private int i = 0;

        public Dots() {
            super("Ui:DotsThread");
        }

        public void run() {
            while (!this.dotCanceled) {
                try {
                    Thread.sleep(1000L);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (this.i++ > 60) {
                    FinishDistInstall.this.getLog().append("\n");
                    this.i = 0;
                }
                FinishDistInstall.this.getLog().append(".");
            }
            FinishDistInstall.this.getLog().append("\n");
            this.dotRunning = false;
        }

        public synchronized void cancel() {
            this.dotCanceled = true;
            while (this.dotRunning) {
                try {
                    Thread.sleep(300L);
                }
                catch (Throwable throwable) {}
            }
        }
    }
}

