/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.distinstall;

import com.tridium.install.BDaemonPlatform;
import com.tridium.install.BDependency;
import com.tridium.install.BRemoteDaemonPlatform;
import com.tridium.install.InstallScenario;
import com.tridium.install.UnmeetableDependency;
import com.tridium.install.installable.BDistribution;
import com.tridium.install.installable.BInstallable;
import com.tridium.install.installable.InstallableRegistry;
import com.tridium.install.installable.LocalInstallableRegistry;
import com.tridium.install.part.BPart;
import com.tridium.platDaemon.ui.BDaemonSessionView;
import com.tridium.platDaemon.ui.distinstall.BDistInstaller;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.file.StoreCache;
import com.tridium.platform.daemon.task.CancelableDaemonSessionTask;
import com.tridium.platform.daemon.task.DaemonSessionTask;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import java.util.Map;
import java.util.TreeMap;
import javax.baja.file.BDirectory;
import javax.baja.file.BIFile;
import javax.baja.gx.BImage;
import javax.baja.log.Log;
import javax.baja.nre.util.Array;
import javax.baja.platform.ICancelHint;
import javax.baja.security.AuthenticationException;
import javax.baja.sys.BIcon;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Clock;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.table.TableModel;

public class DistInstallerTableModel
extends TableModel {
    public static final int FILE_NAME_COL = 0;
    public static final int VERSION_COL = 1;
    public static final int STATUS_COL = 2;
    public static final int DESC_COL = 3;
    public static final int STATUS_DIFFERENT = 0;
    public static final int STATUS_WRONG_TARGET = 1;
    public static final int STATUS_SAME = 2;
    public static final int STATUS_UNMET_DEPS = 3;
    public static final int STATUS_INSUFFICIENT_PRIVS = 4;
    public static final int STATUS_OOD_DEPS = 5;
    public static final int STATUS_INVALID_FILE = 6;
    public static final int STATUS_EXCLUDED = 7;
    public static final int STATUS_NOT_INDEPENDENT = 8;
    private static final BIcon DIST_FILE_ICON_REF = BIcon.std((String)"modules.png");
    private BDaemonSession session = null;
    private BDirectory sourceDir = null;
    private Array distFiles = new Array();
    private StoreCache storeCache;
    private DaemonSessionTaskListener taskListener;
    private ICancelHint cancelHint;
    private boolean isAdmin = false;

    public int getColumnCount() {
        return 4;
    }

    public String getColumnName(int n) {
        switch (n) {
            case 0: {
                return BDaemonSessionView.lexicon.getText("DistInstaller.column.fileName");
            }
            case 1: {
                return BDaemonSessionView.lexicon.getText("DistInstaller.column.version");
            }
            case 2: {
                return BDaemonSessionView.lexicon.getText("DistInstaller.column.status");
            }
            case 3: {
                return BDaemonSessionView.lexicon.getText("DistInstaller.column.desc");
            }
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public int getRowCount() {
        return this.distFiles.size();
    }

    public BDirectory getSourceDirectory() {
        return this.sourceDir;
    }

    public BRemoteDaemonPlatform getDaemonPlatform() {
        if (this.session == null) {
            return null;
        }
        try {
            return BRemoteDaemonPlatform.make((BDaemonSession)this.session, (DaemonSessionTaskListener)this.taskListener);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new BajaRuntimeException((Throwable)exception);
        }
    }

    public Object getValueAt(int n, int n2) {
        switch (n2) {
            case 0: {
                return this.getRow((int)n).dist.getInstallableFileName();
            }
            case 1: {
                return this.getRow((int)n).dist.getVersion();
            }
            case 2: {
                switch (this.getRow((int)n).status) {
                    case 5: {
                        return BDistInstaller.TYPE.getModule().getLexicon().getText("DistInstaller.status.oodDeps");
                    }
                    case 2: {
                        return BDistInstaller.TYPE.getModule().getLexicon().getText("DistInstaller.status.same");
                    }
                    case 1: {
                        return BDistInstaller.TYPE.getModule().getLexicon().getText("DistInstaller.status.wrongTarget");
                    }
                    case 3: {
                        return BDistInstaller.TYPE.getModule().getLexicon().getText("DistInstaller.status.unmetDeps");
                    }
                    case 0: {
                        return BDistInstaller.TYPE.getModule().getLexicon().getText("DistInstaller.status.different");
                    }
                    case 4: {
                        return BDistInstaller.TYPE.getModule().getLexicon().getText("DistInstaller.status.insufficientPrivs");
                    }
                    case 6: {
                        return BDistInstaller.TYPE.getModule().getLexicon().getText("DistInstaller.status.invalidFile");
                    }
                    case 7: {
                        return BDistInstaller.TYPE.getModule().getLexicon().getText("DistInstaller.status.unmetDeps");
                    }
                    case 8: {
                        return BDistInstaller.TYPE.getModule().getLexicon().getText("DistInstaller.status.notIndependent");
                    }
                }
                return "";
            }
            case 3: {
                return this.getRow((int)n).dist.getDescription();
            }
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public void init(BDaemonSession bDaemonSession, BDirectory bDirectory, DaemonSessionTaskListener daemonSessionTaskListener, ICancelHint iCancelHint) {
        this.taskListener = daemonSessionTaskListener;
        this.session = bDaemonSession;
        this.sourceDir = bDirectory;
        this.storeCache = new StoreCache();
        this.cancelHint = iCancelHint;
        this.isAdmin = bDaemonSession.getHostProperties().hasFullAccess();
        this.rebuild();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebuild() throws AuthenticationException {
        if (this.session == null) {
            return;
        }
        long l = Clock.ticks();
        this.distFiles.clear();
        this.updateTable();
        Array array = new Array();
        if (this.sourceDir != null) {
            BIFile[] bIFileArray = this.sourceDir.listFiles();
            int n = 0;
            for (int i = 0; i < bIFileArray.length; ++i) {
                if (bIFileArray[i].isDirectory() || bIFileArray[i].getExtension() == null || !bIFileArray[i].getExtension().equalsIgnoreCase("dist")) continue;
                ++n;
            }
            if (n <= 1) {
                n = -1;
            }
            CancelableDaemonSessionTask cancelableDaemonSessionTask = new CancelableDaemonSessionTask(BDaemonSessionView.lexicon, "DistInstallerTableModel.loading.title", "DistInstallerTableModel.loading.message", n, this.cancelHint);
            try {
                this.taskListener.taskStarted((DaemonSessionTask)cancelableDaemonSessionTask);
                int n2 = 0;
                for (int i = 0; i < bIFileArray.length && !cancelableDaemonSessionTask.isCanceled(); ++i) {
                    try {
                        if (bIFileArray[i].isDirectory() || bIFileArray[i].getExtension() == null || !bIFileArray[i].getExtension().equalsIgnoreCase("dist")) continue;
                        BDistribution bDistribution = new BDistribution(bIFileArray[i], (ICancelHint)cancelableDaemonSessionTask);
                        array.add((Object)new DistRow(bDistribution, (ICancelHint)cancelableDaemonSessionTask));
                        cancelableDaemonSessionTask.setProgress(++n2);
                        this.taskListener.taskUpdated((DaemonSessionTask)cancelableDaemonSessionTask);
                        continue;
                    }
                    catch (ICancelHint.CanceledException canceledException) {
                        throw canceledException;
                    }
                    catch (AuthenticationException authenticationException) {
                        throw authenticationException;
                    }
                    catch (Exception exception) {
                        BDialog.error((BWidget)this.getTable(), (String)BDaemonSessionView.lexicon.getText("DistInstallerTableModel.readError.dlgTitle"), (Object)BDaemonSessionView.lexicon.getText("DistInstallerTableModel.readError.dlgMessage", new Object[]{bIFileArray[i].getFilePath().getBody()}), (Throwable)exception);
                        exception.printStackTrace();
                    }
                }
                if (cancelableDaemonSessionTask.isCanceled()) {
                    throw new ICancelHint.CanceledException();
                }
            }
            finally {
                this.taskListener.taskFinished((DaemonSessionTask)cancelableDaemonSessionTask);
            }
        }
        this.distFiles = array;
        this.updateTable(true);
        Log.getLog((String)"platform.daemonTuning").trace("DistInstallerTableModel.rebuild() complete " + (Clock.ticks() - l) + "ms");
    }

    public void reload() throws Exception {
        this.storeCache.clear();
        this.getTable().getSelection().deselectAll();
        if (this.session != null) {
            this.getDaemonPlatform().getModuleList().reload(this.taskListener);
            this.session.reloadHostProperties();
        }
        this.rebuild();
    }

    public void setSourceDirectory(BDirectory bDirectory) {
        this.sourceDir = bDirectory;
        this.rebuild();
    }

    protected DistRow getRow(int n) {
        return (DistRow)this.distFiles.get(n);
    }

    public BDistribution getDistribution(int n) {
        return this.getRow((int)n).dist;
    }

    public BDependency[] getUnmetDependencies(int n) {
        return this.getRow((int)n).unmetDependencies;
    }

    public UnmeetableDependency[] getUnmeetableDependencies(int n) {
        return this.getRow((int)n).unmeetableDependencies;
    }

    public Map getExcludedPlatformParts(int n) {
        return this.getRow((int)n).excludedPlatformParts;
    }

    public boolean isForTarget(int n) {
        return this.getRow((int)n).forTarget;
    }

    public boolean canInstall(int n) {
        return this.isForTarget(n) && this.getStatus(n) != 4;
    }

    public int getStatus(int n) {
        return this.getRow((int)n).status;
    }

    public BImage getRowIcon(int n) {
        return this.isForTarget(n) ? BImage.make((BIcon)DIST_FILE_ICON_REF) : BImage.make((BIcon)DIST_FILE_ICON_REF).getDisabledImage();
    }

    public StoreCache getCache() {
        return this.storeCache;
    }

    protected class DistRow {
        public BDependency[] unmetDependencies;
        public UnmeetableDependency[] unmeetableDependencies;
        public int status;
        public BDistribution dist;
        public boolean forTarget = true;
        public Map excludedPlatformParts;

        public DistRow(BDistribution bDistribution, ICancelHint iCancelHint) throws Exception {
            this.dist = bDistribution;
            if (!this.dist.getIsValid()) {
                this.status = 6;
                this.forTarget = false;
                this.unmetDependencies = new BDependency[0];
                this.unmeetableDependencies = new UnmeetableDependency[0];
                return;
            }
            BRemoteDaemonPlatform bRemoteDaemonPlatform = DistInstallerTableModel.this.getDaemonPlatform();
            InstallScenario installScenario = InstallScenario.solve((BDaemonPlatform)bRemoteDaemonPlatform, (DaemonSessionTaskListener)DistInstallerTableModel.this.taskListener, null, null, (BInstallable[])new BInstallable[]{this.dist}, (InstallableRegistry)LocalInstallableRegistry.getInstance());
            BInstallable[] bInstallableArray = installScenario.getExcludedInstallables();
            if (bInstallableArray.length > 0) {
                this.excludedPlatformParts = new TreeMap(BDependency.COMPARATOR);
                for (int i = 0; i < bInstallableArray.length; ++i) {
                    BDependency[] bDependencyArray = bInstallableArray[i].getAllExclusions();
                    for (int j = 0; j < bDependencyArray.length; ++j) {
                        BPart bPart = bRemoteDaemonPlatform.getPart(bDependencyArray[j]);
                        if (bPart == null || !bPart.meets(bDependencyArray[j])) continue;
                        this.excludedPlatformParts.put(bDependencyArray[j], bPart);
                    }
                }
                this.status = 7;
                this.forTarget = false;
                return;
            }
            this.unmetDependencies = installScenario.getUnmetDependencies();
            this.unmeetableDependencies = installScenario.getUnmeetableDependencies();
            if (this.unmetDependencies.length == 0) {
                long l = installScenario.getProcessingFlags();
                if (!(DistInstallerTableModel.this.isAdmin || (l & 0x10000L) <= 0L && (l & 0x80000L) <= 0L && (l & 0x20000L) <= 0L)) {
                    this.status = 4;
                    this.forTarget = false;
                } else if (this.dist.hasFileUpdates((BDaemonPlatform)bRemoteDaemonPlatform, DistInstallerTableModel.this.getCache(), iCancelHint, DistInstallerTableModel.this.taskListener)) {
                    if (this.dist.getPart() != null && !"true".equals(System.getProperty("distinstaller.showall", "false"))) {
                        this.status = 8;
                        this.forTarget = false;
                        this.unmetDependencies = new BDependency[0];
                    } else {
                        this.status = 0;
                    }
                } else if (installScenario.getToInstall().length > 1) {
                    BInstallable[] bInstallableArray2 = installScenario.getToInstall();
                    for (int i = 0; i < bInstallableArray2.length; ++i) {
                        if (bInstallableArray2[i] == this.dist) continue;
                        BDistribution.log.trace("ood dep on " + bInstallableArray2[i].getInstallableName() + " from " + this.dist.getInstallableName());
                    }
                    this.status = 5;
                } else if (this.dist.getPart() != null && !"true".equals(System.getProperty("distinstaller.showall", "false"))) {
                    this.status = 8;
                    this.forTarget = false;
                    this.unmetDependencies = new BDependency[0];
                } else {
                    this.status = 2;
                }
            } else {
                this.forTarget = false;
                this.status = 3;
                for (int i = 0; i < this.unmetDependencies.length; ++i) {
                    BPart bPart;
                    if (!this.unmetDependencies[i].canSolveWith("default") && (bPart = bRemoteDaemonPlatform.getPart(this.unmetDependencies[i])) != null && bPart.matchesName(this.unmetDependencies[i].getPartName())) {
                        this.status = 8;
                        continue;
                    }
                    if (!this.unmetDependencies[i].isPlatformDependency()) continue;
                    this.status = 1;
                    break;
                }
            }
        }
    }
}

