/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.distinstall;

import com.tridium.install.installable.LocalInstallableRegistry;
import com.tridium.platDaemon.ui.BDaemonSessionView;
import com.tridium.platDaemon.ui.BDistributionView;
import com.tridium.platDaemon.ui.distinstall.DistInstallWizardModel;
import com.tridium.platDaemon.ui.distinstall.DistInstallerCellRenderer;
import com.tridium.platDaemon.ui.distinstall.DistInstallerTableModel;
import com.tridium.platDaemon.ui.widget.BDirectoryChoice;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import com.tridium.platform.ui.util.AsyncCommand;
import com.tridium.platform.ui.util.BButtonPane;
import com.tridium.platform.ui.util.BCommandDialog;
import com.tridium.platform.ui.util.BIBeamPane;
import com.tridium.platform.ui.util.DialogCommand;
import com.tridium.platform.ui.util.FavoriteDirectory;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSystem;
import javax.baja.file.FilePath;
import javax.baja.gx.BInsets;
import javax.baja.platform.ICancelHint;
import javax.baja.security.AuthenticationException;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableCellRenderer;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.wizard.BWizard;
import javax.baja.ui.wizard.WizardModel;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbShell;

public class BDistInstaller
extends BDaemonSessionView {
    public static final Action handleInstallSourceChanged = BDistInstaller.newAction((int)0, null);
    public static final Action handleTableModified = BDistInstaller.newAction((int)0, null);
    public static final Action handleSelectionModified = BDistInstaller.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$platDaemon$ui$distinstall$BDistInstaller == null ? (class$com$tridium$platDaemon$ui$distinstall$BDistInstaller = BDistInstaller.class$("com.tridium.platDaemon.ui.distinstall.BDistInstaller")) : class$com$tridium$platDaemon$ui$distinstall$BDistInstaller));
    DistInstallerTableModel tableModel;
    BWidget tablePane;
    private BLabel messageLabel;
    private BButton button;
    private BDirectory defaultDir = null;
    private BDirectoryChoice dirChoice;
    boolean trapSelectionModified = true;
    private Command installCommand = new InstallDistCommand("DistInstaller.command.install");
    private Command reinstallCommand = new InstallDistCommand("DistInstaller.command.reinstall");
    static /* synthetic */ Class class$com$tridium$platDaemon$ui$distinstall$BDistInstaller;

    public void handleInstallSourceChanged() {
        this.invoke(handleInstallSourceChanged, null, null);
    }

    public void handleTableModified() {
        this.invoke(handleTableModified, null, null);
    }

    public void handleSelectionModified() {
        this.invoke(handleSelectionModified, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BDistInstaller() {
        BGridPane bGridPane = new BGridPane(1);
        bGridPane.setHalign(BHalign.left);
        bGridPane.setRowGap(4.0);
        BButtonPane bButtonPane = new BButtonPane();
        bButtonPane.setUniformColumnWidth(false);
        bButtonPane.setButtonStyle(BButtonStyle.toolBar);
        bGridPane.add("dirPane", (BValue)bButtonPane);
        this.messageLabel = new BLabel();
        bGridPane.add("dirMessage", (BValue)this.messageLabel);
        this.dirChoice = new BDirectoryChoice(false, 60);
        this.dirChoice.getChangeDirectoryCommand().setLabel(Lexicon.make((String)"platDaemon").getText("DistInstaller.command.chooseDirectory.label"));
        this.dirChoice.getChangeDirectoryCommand().setDescription(Lexicon.make((String)"platDaemon").getText("DistInstaller.command.chooseDirectory.description"));
        bButtonPane.add((BWidget)this.dirChoice);
        BIBeamPane bIBeamPane = new BIBeamPane();
        BGridPane bGridPane2 = new BGridPane(3);
        bIBeamPane.setCenter((BWidget)bGridPane2);
        bGridPane2.setColumnAlign(BHalign.center);
        bGridPane2.add(null, (BValue)new BButton((Command)this.dirChoice.getChangeDirectoryCommand()));
        bGridPane2.add(null, (BValue)new BButton((Command)new CleanDistsCommand()));
        bGridPane2.add(null, (BValue)new BButton((Command)new BackupsCommand()));
        BGridPane bGridPane3 = new BGridPane(1);
        this.button = new BButton(this.installCommand);
        bGridPane3.add(null, (BValue)this.button);
        bGridPane3.setColumnAlign(BHalign.fill);
        bGridPane3.setHalign(BHalign.center);
        bIBeamPane.setRight((BWidget)bGridPane3);
        this.installCommand.setEnabled(false);
        this.reinstallCommand.setEnabled(false);
        this.button.setVisible(false);
        this.tableModel = new DistInstallerTableModel();
        BTable bTable = new BTable((TableModel)this.tableModel);
        bTable.setCellRenderer((TableCellRenderer)new DistInstallerCellRenderer());
        bTable.setMultipleSelection(false);
        bTable.setController((TableController)new Controller());
        this.linkTo((BComponent)bTable, (Slot)BTable.selectionModified, (Slot)handleSelectionModified);
        this.linkTo((BComponent)bTable, (Slot)BTable.tableModified, (Slot)handleTableModified);
        this.tablePane = new BBorderPane((BWidget)bTable, BBorder.inset, BInsets.DEFAULT);
        this.tablePane.setVisible(false);
        this.setContent((BWidget)new BEdgePane((BWidget)bGridPane, (BWidget)new BBorderPane((BWidget)bIBeamPane, 4.0, 0.0, 4.0, 0.0), null, null, (BWidget)new BBorderPane(this.tablePane, 4.0, 0.0, 0.0, 4.0)));
    }

    protected final void doLoadSession(BDaemonSession bDaemonSession, Context context) throws AuthenticationException {
        try {
            LocalInstallableRegistry.getInstance().init((DaemonSessionTaskListener)this);
            BDirectory bDirectory = this.loadSelectedDirectory(bDaemonSession);
            this.dirChoice.setDirectory(bDirectory);
            if (this.getProperty("lkDirChanged") == null) {
                this.linkTo("lkDirChanged", (BComponent)this.dirChoice, (Slot)BDirectoryChoice.dirModified, (Slot)handleInstallSourceChanged);
            }
            this.tableModel.init(this.getDaemonSession(), bDirectory, this, this);
            if (this.tableModel.getRowCount() == 0) {
                this.messageLabel.setText(this.getLexicon().getText("DistInstaller.label.noDists", new Object[]{this.dirChoice.getDisplayPath()}));
                this.tablePane.setVisible(false);
                this.button.setVisible(false);
            } else {
                this.messageLabel.setText(this.getLexicon().getText("DistInstaller.label.foundDists", new Object[]{new Integer(this.tableModel.getRowCount()), this.dirChoice.getDisplayPath()}));
                this.tablePane.setVisible(true);
                this.button.setVisible(true);
            }
        }
        catch (ICancelHint.CanceledException canceledException) {
            this.tablePane.setVisible(false);
            this.button.setVisible(false);
            this.messageLabel.setText(this.getLexicon().getText("DistInstaller.label.canceled"));
            this.resetCanceled();
        }
        catch (AuthenticationException authenticationException) {
            throw authenticationException;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new BajaRuntimeException((Throwable)exception);
        }
    }

    protected BDirectory loadSelectedDirectory(BDaemonSession bDaemonSession) throws Exception {
        BDirectory bDirectory = FavoriteDirectory.loadByPath((String)this.getType().toString(), (String)"distDir", null);
        if (bDirectory == null) {
            bDirectory = (BDirectory)BFileSystem.INSTANCE.findFile(new FilePath("!backups"));
            if (bDirectory == null) {
                bDirectory = (BDirectory)BFileSystem.INSTANCE.findFile(new FilePath("!cleanDist"));
            }
            if (bDirectory == null) {
                bDirectory = BFileSystem.INSTANCE.makeDir(new FilePath("!sw"));
            }
        }
        this.defaultDir = bDirectory;
        return bDirectory;
    }

    protected void saveSelectedDirectory() {
        if (this.dirChoice.getDirectory() != null && this.defaultDir != null && !this.dirChoice.getDirectory().getFilePath().getBody().equals(this.defaultDir.getFilePath().getBody())) {
            FavoriteDirectory.savePath((String)this.getType().toString(), (String)"distDir", (BDirectory)this.dirChoice.getDirectory());
        }
    }

    public void doHandleInstallSourceChanged() throws Exception {
        this.tablePane.setVisible(false);
        this.button.setVisible(false);
        this.messageLabel.setText("");
        this.tableModel.setSourceDirectory(this.dirChoice.getDirectory());
        if (this.tableModel.getRowCount() == 0) {
            this.messageLabel.setText(this.getLexicon().getText("DistInstaller.label.noDists", new Object[]{this.dirChoice.getDisplayPath()}));
        } else {
            this.messageLabel.setText(this.getLexicon().getText("DistInstaller.label.foundDists", new Object[]{new Integer(this.tableModel.getRowCount()), this.dirChoice.getDisplayPath()}));
            this.tablePane.setVisible(true);
            this.button.setVisible(true);
        }
        this.saveSelectedDirectory();
    }

    public void doHandleTableModified() {
        this.handleSelectionModified();
    }

    public void doHandleSelectionModified() {
        if (!this.trapSelectionModified) {
            return;
        }
        int[] nArray = this.tableModel.getTable().getSelection().getRows();
        boolean bl = false;
        if (nArray.length == 0) {
            bl = false;
            this.button.setCommand(this.installCommand, true, true);
        } else if (nArray.length == 1) {
            if (this.tableModel.canInstall(nArray[0])) {
                bl = true;
                if (this.tableModel.getStatus(nArray[0]) == 2) {
                    this.button.setCommand(this.reinstallCommand, true, true);
                } else {
                    this.button.setCommand(this.installCommand, true, true);
                }
            } else {
                bl = false;
                this.button.setCommand(this.installCommand, true, true);
            }
        }
        this.installCommand.setEnabled(bl);
        this.reinstallCommand.setEnabled(bl);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class BackupsCommand
    extends Command {
        public BackupsCommand() {
            super((BWidget)BDistInstaller.this, BDistInstaller.this.getType().getModule(), "DistInstaller.command.backups");
            if (BFileSystem.INSTANCE.findFile(new FilePath("!backups")) == null) {
                this.setEnabled(false);
            }
        }

        public CommandArtifact doInvoke() {
            BDistInstaller.this.dirChoice.setDirectory((BDirectory)BFileSystem.INSTANCE.findFile(new FilePath("!backups")));
            return null;
        }
    }

    private class CleanDistsCommand
    extends Command {
        public CleanDistsCommand() {
            super((BWidget)BDistInstaller.this, BDistInstaller.this.getType().getModule(), "DistInstaller.command.cleanDists");
            if (BFileSystem.INSTANCE.findFile(new FilePath("!cleanDist")) == null) {
                this.setEnabled(false);
            }
        }

        public CommandArtifact doInvoke() {
            BDistInstaller.this.dirChoice.setDirectory((BDirectory)BFileSystem.INSTANCE.findFile(new FilePath("!cleanDist")));
            return null;
        }
    }

    private class InstallDialogCommand
    extends DialogCommand {
        protected InstallDialogCommand() {
            super((BWidget)BDistInstaller.this, 1, BDistInstaller.this.getType().getModule(), "DistInstaller.command.install");
            this.setEnabled(BDistInstaller.this.installCommand.isEnabled());
        }
    }

    private class Controller
    extends TableController {
        private Controller() {
        }

        protected void cellDoubleClicked(BMouseEvent bMouseEvent, int n, int n2) {
            BDistributionView bDistributionView = new BDistributionView(BDistInstaller.this.tableModel.getUnmeetableDependencies(n));
            BConstrainedPane bConstrainedPane = new BConstrainedPane((BWidget)new BBorderPane((BWidget)bDistributionView, 4.0, 4.0, 4.0, 4.0));
            bConstrainedPane.setFixedSize(500.0, 600.0);
            bDistributionView.loadValue((BObject)BDistInstaller.this.tableModel.getDistribution(n));
            if (1 == BCommandDialog.open((BWidget)BDistInstaller.this, (String)BDistInstaller.this.tableModel.getDistribution(n).getInstallableFileName(), (Object)bConstrainedPane, (DialogCommand[])new DialogCommand[]{new InstallDialogCommand(), DialogCommand.makeCancel((BWidget)BDistInstaller.this)})) {
                BDistInstaller.this.installCommand.invoke();
            }
        }
    }

    private class InstallDistCommand
    extends AsyncCommand {
        protected InstallDistCommand(String string) {
            super((BWidget)BDistInstaller.this, BDistInstaller.this.getType().getModule(), string);
        }

        public void doInvokeAsync() {
            BWbShell bWbShell = BDistInstaller.this.getWbShell();
            BDaemonSession bDaemonSession = BDistInstaller.this.getDaemonSession();
            try {
                if (bWbShell != null) {
                    bWbShell.enterBusy();
                }
                DistInstallWizardModel distInstallWizardModel = new DistInstallWizardModel(this.getOwner(), BDistInstaller.this.tableModel.getDistribution(BDistInstaller.this.tableModel.getTable().getSelection().getRow()), bDaemonSession);
                if (bWbShell != null) {
                    bWbShell.exitBusy();
                }
                if (distInstallWizardModel.hasNoSteps()) {
                    distInstallWizardModel.finish();
                } else {
                    BWizard.open((BWidget)this.getOwner(), (WizardModel)distInstallWizardModel);
                }
                if (!distInstallWizardModel.isCanceled()) {
                    if (bWbShell != null && (distInstallWizardModel.getProcessingFlags() & 0x40000L) > 0L) {
                        bWbShell.hyperlink(bDaemonSession.getAbsoluteOrd());
                    } else if (bDaemonSession.isConnected()) {
                        BDistInstaller.this.tableModel.reload();
                    }
                }
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new BajaRuntimeException((Throwable)exception);
            }
            finally {
                if (bWbShell != null) {
                    bWbShell.exitBusy();
                }
            }
        }
    }
}

