/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.console;

import com.tridium.platDaemon.ui.BDaemonSessionView;
import com.tridium.platDaemon.ui.appsurrogate.BAppSurrogateView;
import com.tridium.platDaemon.ui.appsurrogate.BR2StationSurrogateView;
import com.tridium.platDaemon.ui.appsurrogate.BSedonaSurrogateView;
import com.tridium.platDaemon.ui.appsurrogate.BStationSurrogateView;
import com.tridium.platDaemon.ui.r2tools.BR2PlatformToolOptions;
import com.tridium.platform.daemon.BAppSurrogate;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.BR2StationSurrogate;
import com.tridium.platform.daemon.BSedonaSurrogate;
import com.tridium.platform.daemon.BStationSurrogate;
import java.io.File;
import java.io.IOException;
import java.net.ConnectException;
import java.util.Comparator;
import javax.baja.file.FilePath;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.nre.util.Array;
import javax.baja.platform.BStationStatus;
import javax.baja.security.AuthenticationException;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BActionMenuItem;
import javax.baja.ui.BBorder;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BMenu;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.HyperlinkInfo;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BOrientation;
import javax.baja.ui.event.BInputEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.pane.BSplitPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.table.TableSelection;
import javax.baja.util.Lexicon;

public class BApplicationDirector
extends BDaemonSessionView {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$platDaemon$ui$console$BApplicationDirector == null ? (class$com$tridium$platDaemon$ui$console$BApplicationDirector = BApplicationDirector.class$("com.tridium.platDaemon.ui.console.BApplicationDirector")) : class$com$tridium$platDaemon$ui$console$BApplicationDirector));
    public static BIcon ICON = BIcon.std((String)"platform.png");
    private BTable table;
    private BLabel hostLabel;
    private AppSurrogateTableModel tableModel;
    private BSplitPane contentPane = new BSplitPane(BOrientation.vertical, -1.0);
    private boolean isActivated = false;
    private boolean inRefresh = false;
    private Object selectionToRestore = null;
    private BBorderPane appViewParent;
    BAppSurrogateView appView;
    private BAppSurrogateView sedonaView;
    private BStationSurrogateView stationView;
    private BR2StationSurrogateView r2stationView;
    private static final Lexicon lex = Lexicon.make((String)"platDaemon");
    public static final int APP_NAME_COL = 0;
    public static final int APP_TYPE_COL = 1;
    public static final int APP_STATUS_COL = 2;
    public static final int MISC_COL = 3;
    public static final int AUTO_START_COL = 4;
    public static final int AUTO_RESTART_COL = 5;
    public static Comparator[] columnComparators = new Comparator[6];
    static /* synthetic */ Class class$com$tridium$platDaemon$ui$console$BApplicationDirector;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$com$tridium$platform$daemon$BAppSurrogate;

    public Type getType() {
        return TYPE;
    }

    public BApplicationDirector() {
        BEdgePane bEdgePane = new BEdgePane();
        this.hostLabel = new BLabel("");
        bEdgePane.setTop((BWidget)new BBorderPane((BWidget)this.hostLabel, 0.0, 0.0, 3.0, 0.0));
        this.hostLabel.setHalign(BHalign.left);
        this.tableModel = new AppSurrogateTableModel();
        this.table = new BTable((TableModel)this.tableModel, (TableController)new AppSurrogateTableController());
        this.table.setMultipleSelection(false);
        bEdgePane.setCenter((BWidget)new BBorderPane((BWidget)new BScrollPane((BWidget)this.table), BBorder.inset, BInsets.DEFAULT));
        this.contentPane.setWidget1((BWidget)new BBorderPane((BWidget)bEdgePane, 3.0, 3.0, 0.0, 3.0));
        this.table.setSelection((TableSelection)new AppSurrogateTableSelection());
        this.sedonaView = new BSedonaSurrogateView(this);
        this.stationView = new BStationSurrogateView(this);
        this.r2stationView = new BR2StationSurrogateView(this);
        this.appView = this.stationView;
        this.setTransferWidget(this.appView.getTransferWidget());
        this.appViewParent = new BBorderPane((BWidget)this.appView, 3.0, 3.0, 0.0, 3.0);
        this.contentPane.setWidget2((BWidget)this.appViewParent);
        this.setContent((BWidget)this.contentPane);
    }

    private void setAppView(BAppSurrogateView bAppSurrogateView) {
        if (this.appView != bAppSurrogateView) {
            this.appView = bAppSurrogateView;
            this.setTransferWidget(this.appView.getTransferWidget());
            this.appViewParent.setContent((BWidget)this.appView);
        }
    }

    private BAppSurrogateView getAppView(BAppSurrogate bAppSurrogate) {
        if (bAppSurrogate instanceof BStationSurrogate) {
            return this.stationView;
        }
        if (bAppSurrogate instanceof BSedonaSurrogate) {
            return this.sedonaView;
        }
        if (bAppSurrogate instanceof BR2StationSurrogate) {
            return this.r2stationView;
        }
        return null;
    }

    private void loadAppSurrogate(BAppSurrogate bAppSurrogate) {
        this.setAppView(this.getAppView(bAppSurrogate));
        this.appView.loadValue((BObject)bAppSurrogate);
    }

    public void activated() {
        super.activated();
        if (this.getCurrentValue() != null && this.isRunning()) {
            this.startRefreshTimer();
        }
        this.appView.activated();
        this.isActivated = true;
    }

    public void deactivated() {
        super.deactivated();
        this.stopRefreshTimer();
        this.appView.deactivated();
        this.isActivated = false;
    }

    protected void doLoadSession(BDaemonSession bDaemonSession, Context context) throws AuthenticationException {
        this.hostLabel.setText(lex.getText("ApplicationDirector.label.connectedTo", new Object[]{bDaemonSession.getRemoteAddressString()}));
        this.inRefresh = true;
        this.startRefreshTimer();
        try {
            this.stationView.init(bDaemonSession, this.getCurrentValue());
            this.sedonaView.init(bDaemonSession, this.getCurrentValue());
            this.r2stationView.init(bDaemonSession, this.getCurrentValue());
            this.tableModel.loadApps();
            int n = -1;
            for (int i = 0; i < this.tableModel.getRowCount(); ++i) {
                BStationStatus bStationStatus = this.tableModel.getAppSurrogate(i).getAppStatus();
                if (bStationStatus == BStationStatus.running || bStationStatus == BStationStatus.starting) {
                    n = i;
                    break;
                }
                if (bStationStatus != BStationStatus.failed || n >= 0) continue;
                n = i;
            }
            if (n < 0) {
                n = 0;
            }
            this.table.getSelection().select(n);
        }
        catch (AuthenticationException authenticationException) {
            throw authenticationException;
        }
        catch (ConnectException connectException) {
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new BajaRuntimeException((Throwable)exception);
        }
        finally {
            this.inRefresh = false;
        }
    }

    public void started() throws Exception {
        super.started();
        if (this.isActivated && this.getCurrentValue() != null && !this.isRefreshTimerRunning()) {
            this.startRefreshTimer();
        }
    }

    public void stopped() throws Exception {
        super.stopped();
        this.stopRefreshTimer();
    }

    public BIcon getIcon() {
        return ICON;
    }

    public void doRefresh() {
        if (this.inRefresh) {
            return;
        }
        try {
            this.inRefresh = true;
            this.tableModel.loadApps();
        }
        catch (ConnectException connectException) {
            this.stopRefreshTimer();
        }
        catch (AuthenticationException authenticationException) {
            this.reauthenticate(authenticationException);
        }
        finally {
            this.inRefresh = false;
        }
    }

    public BAppSurrogate getSelectedAppSurrogate() {
        int n = this.table.getSelection().getRow();
        return n < 0 ? null : this.tableModel.getAppSurrogate(n);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        BApplicationDirector.columnComparators[0] = new Comparator(){

            public int compare(Object object, Object object2) {
                BAppSurrogate bAppSurrogate = (BAppSurrogate)object;
                BAppSurrogate bAppSurrogate2 = (BAppSurrogate)object2;
                int n = bAppSurrogate.getAppName().compareTo(bAppSurrogate2.getAppName());
                if (n == 0) {
                    n = bAppSurrogate.getType().getDisplayName(null).compareTo(bAppSurrogate2.getType().getDisplayName(null));
                }
                return n;
            }
        };
        BApplicationDirector.columnComparators[1] = new Comparator(){

            public int compare(Object object, Object object2) {
                BAppSurrogate bAppSurrogate = (BAppSurrogate)object;
                BAppSurrogate bAppSurrogate2 = (BAppSurrogate)object2;
                if (bAppSurrogate.getType().equals(bAppSurrogate2.getType())) {
                    return columnComparators[0].compare(object, object2);
                }
                String string = lex.getText("ApplicationDirector.column.appType." + bAppSurrogate.getAppTypeString());
                String string2 = lex.getText("ApplicationDirector.column.appType." + bAppSurrogate2.getAppTypeString());
                return string.compareTo(string2);
            }
        };
        BApplicationDirector.columnComparators[2] = new Comparator(){

            public int compare(Object object, Object object2) {
                BAppSurrogate bAppSurrogate = (BAppSurrogate)object;
                BAppSurrogate bAppSurrogate2 = (BAppSurrogate)object2;
                int n = bAppSurrogate.getAppStatus().toString().compareTo(bAppSurrogate2.getAppStatus().toString());
                if (n == 0) {
                    return columnComparators[0].compare(object, object2);
                }
                return n;
            }
        };
        BApplicationDirector.columnComparators[4] = new Comparator(){

            public int compare(Object object, Object object2) {
                BAppSurrogate bAppSurrogate = (BAppSurrogate)object;
                BAppSurrogate bAppSurrogate2 = (BAppSurrogate)object2;
                int n = String.valueOf(bAppSurrogate.getIsAutoStart()).compareTo(String.valueOf(bAppSurrogate2.getIsAutoStart()));
                if (n == 0) {
                    return columnComparators[0].compare(object, object2);
                }
                return n;
            }
        };
        BApplicationDirector.columnComparators[5] = new Comparator(){

            public int compare(Object object, Object object2) {
                BAppSurrogate bAppSurrogate = (BAppSurrogate)object;
                BAppSurrogate bAppSurrogate2 = (BAppSurrogate)object2;
                int n = String.valueOf(bAppSurrogate.getIsAutoRestart()).compareTo(String.valueOf(bAppSurrogate2.getIsAutoRestart()));
                if (n == 0) {
                    return columnComparators[0].compare(object, object2);
                }
                return n;
            }
        };
    }

    private class AppSurrogateTableModel
    extends TableModel {
        private Array apps = new Array(class$com$tridium$platform$daemon$BAppSurrogate == null ? (class$com$tridium$platform$daemon$BAppSurrogate = BApplicationDirector.class$("com.tridium.platform.daemon.BAppSurrogate")) : class$com$tridium$platform$daemon$BAppSurrogate);
        private boolean tableLoaded = false;
        private int sortCol = -1;
        private boolean sortAsc = true;

        private AppSurrogateTableModel() {
        }

        public synchronized void loadApps() throws ConnectException, AuthenticationException {
            if (BApplicationDirector.this.getCurrentValue() == null) {
                return;
            }
            if (this.getTable().getSelection().getRow() >= 0) {
                if (this.apps.size() > this.getTable().getSelection().getRow()) {
                    BApplicationDirector.this.selectionToRestore = this.apps.get(this.getTable().getSelection().getRow());
                } else {
                    BApplicationDirector.this.selectionToRestore = null;
                }
            }
            Array array = new Array(class$com$tridium$platform$daemon$BAppSurrogate == null ? (class$com$tridium$platform$daemon$BAppSurrogate = BApplicationDirector.class$("com.tridium.platform.daemon.BAppSurrogate")) : class$com$tridium$platform$daemon$BAppSurrogate);
            array.addAll((Object[])BApplicationDirector.this.getAppSurrogatesWithExceptions());
            this.sort(array, !this.tableLoaded);
            if (!this.tableLoaded) {
                BApplicationDirector.this.contentPane.getWidget1().computePreferredSize();
                BApplicationDirector.this.relayoutSync();
                int n = (int)BApplicationDirector.this.getHeight();
                if (n != 0) {
                    double d = (double)(n - BApplicationDirector.this.appView.getMinHeight()) - BApplicationDirector.this.contentPane.getDividerWidth() - 6.0;
                    double d2 = Math.min(BApplicationDirector.this.contentPane.getWidget1().getPreferredHeight(), d);
                    BApplicationDirector.this.contentPane.setAbsoluteDividerLocation(d2);
                    BApplicationDirector.this.contentPane.relayout();
                    this.tableLoaded = true;
                }
            }
        }

        private synchronized void sort(Array array, boolean bl) {
            if (this.sortCol < 0) {
                this.apps = array;
                this.updateTable(bl);
                BApplicationDirector.this.selectionToRestore = null;
                this.getTable().getSelection().select(this.getTable().getSelection().getRow(), true);
            } else {
                if (BApplicationDirector.this.selectionToRestore == null && this.getTable().getSelection().getRow() >= 0) {
                    BApplicationDirector.this.selectionToRestore = array.get(this.getTable().getSelection().getRow());
                }
                array = this.sortAsc ? array.sort(columnComparators[this.sortCol]) : array.sort(new Comparator(){

                    public int compare(Object object, Object object2) {
                        return -1 * columnComparators[AppSurrogateTableModel.this.sortCol].compare(object, object2);
                    }
                });
                this.apps = array;
                this.updateTable(bl);
                if (BApplicationDirector.this.selectionToRestore != null) {
                    for (int i = 0; i < array.size(); ++i) {
                        if (BApplicationDirector.this.selectionToRestore != array.get(i)) continue;
                        BApplicationDirector.this.selectionToRestore = null;
                        this.getTable().getSelection().select(i, true);
                        break;
                    }
                }
            }
            BApplicationDirector.this.selectionToRestore = null;
        }

        public int getRowCount() {
            return this.apps.size();
        }

        public int getColumnCount() {
            return 6;
        }

        public boolean isColumnSortable(int n) {
            return n != 3;
        }

        public synchronized void sortByColumn(int n, boolean bl) {
            if (this.sortCol != n || bl != this.sortAsc) {
                this.sortCol = n;
                this.sortAsc = bl;
                this.sort(this.apps, false);
            }
        }

        public BAppSurrogate getAppSurrogate(int n) {
            return (BAppSurrogate)this.apps.get(n);
        }

        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return lex.getText("ApplicationDirector.column.appName");
                }
                case 1: {
                    return lex.getText("ApplicationDirector.column.appType");
                }
                case 4: {
                    return lex.getText("ApplicationDirector.column.isAutoStart");
                }
                case 5: {
                    return lex.getText("ApplicationDirector.column.isAutoRestart");
                }
                case 3: {
                    return lex.getText("ApplicationDirector.column.misc");
                }
                case 2: {
                    return lex.getText("ApplicationDirector.column.appStatus");
                }
            }
            throw new IllegalArgumentException();
        }

        public Object getValueAt(int n, int n2) {
            switch (n2) {
                case 0: {
                    return this.getAppSurrogate(n).getAppName();
                }
                case 1: {
                    return lex.getText("ApplicationDirector.column.appType." + this.getAppSurrogate(n).getAppTypeString());
                }
                case 4: {
                    return BBoolean.make((boolean)this.getAppSurrogate(n).getIsAutoStart()).toString();
                }
                case 5: {
                    return BBoolean.make((boolean)this.getAppSurrogate(n).getIsAutoRestart()).toString();
                }
                case 3: {
                    return BApplicationDirector.this.getAppView(this.getAppSurrogate(n)).getExtraDetails(this.getAppSurrogate(n), null);
                }
                case 2: {
                    return this.getAppSurrogate(n).getAppStatus();
                }
            }
            throw new IllegalArgumentException();
        }

        public BImage getRowIcon(int n) {
            return BImage.make((BIcon)this.getAppSurrogate(n).getIcon());
        }
    }

    private class AppSurrogateTableController
    extends TableController {
        private AppSurrogateTableController() {
        }

        protected void cellPressed(BMouseEvent bMouseEvent, int n, int n2) {
            super.cellPressed(bMouseEvent, n, n2);
            if (bMouseEvent.getClickCount() != 2) {
                return;
            }
            BAppSurrogate bAppSurrogate = BApplicationDirector.this.tableModel.getAppSurrogate(n);
            if (bAppSurrogate.getAppStatus() == BStationStatus.running) {
                if (bAppSurrogate instanceof BStationSurrogate) {
                    if (((BStationSurrogate)bAppSurrogate).getFoxsPort() != -1) {
                        BApplicationDirector.this.getWbShell().hyperlink(new HyperlinkInfo(((BStationSurrogate)bAppSurrogate).getFoxsOrd(), (BInputEvent)bMouseEvent));
                    } else if (((BStationSurrogate)bAppSurrogate).getFoxPort() != -1) {
                        BApplicationDirector.this.getWbShell().hyperlink(new HyperlinkInfo(((BStationSurrogate)bAppSurrogate).getFoxOrd(), (BInputEvent)bMouseEvent));
                    }
                } else if (bAppSurrogate instanceof BSedonaSurrogate) {
                    BApplicationDirector.this.getWbShell().hyperlink(new HyperlinkInfo(((BSedonaSurrogate)bAppSurrogate).getSoxOrd(), (BInputEvent)bMouseEvent));
                } else if (bAppSurrogate instanceof BR2StationSurrogate) {
                    BR2PlatformToolOptions bR2PlatformToolOptions = BR2PlatformToolOptions.make();
                    FilePath filePath = new FilePath(bR2PlatformToolOptions.getLocalR2Installation() + "/nre/bin/fui.exe");
                    String string = filePath.getBody();
                    string = string.replace('/', File.separatorChar);
                    string = string.replace('\\', File.separatorChar);
                    string = string.substring(1);
                    File file = null;
                    file = new File(string);
                    if (file.exists()) {
                        Array array = new Array(class$java$lang$String == null ? (class$java$lang$String = BApplicationDirector.class$("java.lang.String")) : class$java$lang$String);
                        array.add((Object)file.getPath());
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("http://");
                        stringBuffer.append(bAppSurrogate.getDaemonSession().getRemoteAddressString());
                        BR2StationSurrogate bR2StationSurrogate = (BR2StationSurrogate)bAppSurrogate;
                        if (bR2StationSurrogate.getHttpPort() != 80) {
                            stringBuffer.append(bR2StationSurrogate.getHttpPort());
                        }
                        stringBuffer.append("/db/").append(bR2StationSurrogate.getAppName()).append("$Properties");
                        array.add((Object)stringBuffer.toString());
                        try {
                            ProcessBuilder processBuilder = new ProcessBuilder((String[])array.trim());
                            processBuilder.redirectErrorStream();
                            processBuilder.directory(file.getParentFile().getParentFile());
                            processBuilder.start();
                        }
                        catch (IOException iOException) {
                            BDialog.error((BWidget)BApplicationDirector.this.getWbShell(), (String)BApplicationDirector.this.getLexicon().get("R2PlatformTool.workplaceProFailedToLaunch.error"), (Object)iOException);
                        }
                    } else {
                        BDialog.error((BWidget)BApplicationDirector.this.getWbShell(), (Object)BApplicationDirector.this.getLexicon().get("R2PlatformTool.workplaceProUnavailable.error"));
                    }
                }
            }
        }

        protected void cellPopup(BMouseEvent bMouseEvent, int n, int n2) {
            BMenu bMenu = new BMenu();
            bMenu.add(null, (BValue)new BActionMenuItem((Command)BApplicationDirector.this.appView.startCommand), null);
            bMenu.add(null, (BValue)new BActionMenuItem((Command)BApplicationDirector.this.appView.stopCommand), null);
            bMenu.add(null, (BValue)new BActionMenuItem((Command)BApplicationDirector.this.appView.restartCommand), null);
            bMenu.add(null, (BValue)new BActionMenuItem((Command)BApplicationDirector.this.appView.killCommand), null);
            bMenu.add(null, (BValue)new BActionMenuItem((Command)BApplicationDirector.this.appView.clearOutputCommand), null);
            bMenu.open((BWidget)BApplicationDirector.this.table, bMouseEvent.getX(), bMouseEvent.getY());
        }
    }

    private class AppSurrogateTableSelection
    extends TableSelection {
        private AppSurrogateTableSelection() {
        }

        public void updateTable() {
            if (BApplicationDirector.this.selectionToRestore == null) {
                if (this.isEmpty()) {
                    BApplicationDirector.this.appView.clearValue();
                } else {
                    BApplicationDirector.this.loadAppSurrogate(BApplicationDirector.this.tableModel.getAppSurrogate(this.getRow()));
                }
            }
            super.updateTable();
        }
    }
}

