/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.config;

import com.tridium.nre.auth.SecurityUtil;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.DaemonResponseException;
import com.tridium.platform.daemon.message.DaemonMessage;
import com.tridium.platform.daemon.message.SystemPasswordMessageAX;
import com.tridium.platform.daemon.message.XmlResponseMessage;
import com.tridium.platform.ui.util.LabelUtil;
import com.tridium.ui.BOptionDialog;
import com.tridium.workbench.fieldeditors.BPasswordFE;
import java.io.InputStream;
import javax.baja.gx.BColor;
import javax.baja.security.BPassword;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.user.BPasswordStrength;
import javax.baja.util.Lexicon;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

public class SystemPasswordPrompt {
    BOptionDialog dialog;
    BLabel noticeLabel;
    BPasswordFE currentPasswordFE;
    BPasswordFE newPasswordFE1;
    BPasswordFE newPasswordFE2;
    static Lexicon lex = Lexicon.make((String)"platDaemon");

    public static boolean updateSettings(BWidget bWidget, BDaemonSession bDaemonSession) {
        try {
            boolean bl;
            XElem xElem;
            BOptionDialog bOptionDialog = new BOptionDialog(bWidget, lex.getText("SystemPasswordPrompt.dlgTitle"), (BWidget)new BNullWidget(), 3, null, null);
            SystemPasswordPrompt systemPasswordPrompt = new SystemPasswordPrompt(bOptionDialog);
            try {
                xElem = XParser.make((InputStream)bDaemonSession.getInputStream((DaemonMessage)new SystemPasswordMessageAX(), "text/xml")).parse();
                bl = xElem.getb("default", false);
            }
            catch (Exception exception) {
                bl = false;
            }
            if (bl) {
                systemPasswordPrompt.noticeLabel.setVisible(true);
            }
            bOptionDialog.setBoundsCenteredOnOwner();
            bOptionDialog.open();
            if (bOptionDialog.getResult() == 1) {
                xElem = (BPassword)systemPasswordPrompt.currentPasswordFE.saveValue();
                BPassword bPassword = (BPassword)systemPasswordPrompt.newPasswordFE1.saveValue();
                BPassword bPassword2 = (BPassword)systemPasswordPrompt.newPasswordFE2.saveValue();
                if (xElem == null || xElem.getValue().trim().length() == 0 || bPassword == null || bPassword.getValue().trim().length() == 0 || bPassword2 == null || bPassword2.getValue().trim().length() == 0) {
                    BDialog.error((BWidget)bWidget, (Object)lex.getText("UserManager.error.fieldRequired"));
                    return false;
                }
                if (!SystemPasswordPrompt.validatePassword(bWidget, bPassword, BPasswordStrength.STRONG)) {
                    return false;
                }
                if (!SystemPasswordPrompt.checkStatus(null, bDaemonSession, (XmlResponseMessage)new SystemPasswordMessageAX(null, (BPassword)xElem, true))) {
                    BDialog.error((BWidget)bWidget, (Object)lex.getText("SystemPassword.error.badPassword"));
                    return false;
                }
                if (!SystemPasswordPrompt.checkStatus(null, bDaemonSession, (XmlResponseMessage)new SystemPasswordMessageAX(bPassword, null, true))) {
                    BDialog.error((BWidget)bWidget, (Object)lex.getText("UserManager.error.invalidPasswordDefault"));
                    return false;
                }
                if (!SecurityUtil.equals((String)bPassword.getValue(), (String)bPassword2.getValue())) {
                    BDialog.error((BWidget)bWidget, (Object)lex.getText("UserManager.error.passwordMismatch"));
                    return false;
                }
                bDaemonSession.sendMessage((DaemonMessage)new SystemPasswordMessageAX(bPassword, (BPassword)xElem, false));
                BDialog.info((BWidget)bWidget, (Object)lex.getText("UserManager.success.passwordChanged"));
                return true;
            }
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new BajaRuntimeException((Throwable)exception);
        }
        return false;
    }

    public static boolean checkStatus(BWidget bWidget, BDaemonSession bDaemonSession, XmlResponseMessage xmlResponseMessage) throws Exception {
        Object object;
        try {
            object = (BDaemonSession.Stream)bDaemonSession.getInputStream((DaemonMessage)xmlResponseMessage, BDaemonSession.DEFAULT_TIMEOUT);
            if (object.getContentType() != null && object.getContentType().equals("text/xml")) {
                xmlResponseMessage.setResponse(XParser.make((InputStream)object).parse());
            } else {
                xmlResponseMessage.setResponse(new XElem("success"));
                object.close();
            }
        }
        catch (DaemonResponseException daemonResponseException) {
            xmlResponseMessage.setErrorMessage(daemonResponseException.getMessage());
        }
        object = xmlResponseMessage.getErrorMessage();
        return object == null;
    }

    public static boolean validatePassword(BWidget bWidget, BPassword bPassword, BPasswordStrength bPasswordStrength) {
        if (bPassword == null) {
            BDialog.error((BWidget)bWidget, (Object)lex.getText("UserManager.error.passwordRequired"));
            return false;
        }
        if (bPassword.getValue().length() < 1) {
            BDialog.error((BWidget)bWidget, (Object)lex.getText("UserManager.error.passwordTooShort"));
            return false;
        }
        char[] cArray = bPassword.getValue().toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if (c >= '!' && c <= '~') continue;
            BDialog.error((BWidget)bWidget, (Object)lex.getText("UserManager.error.invalidPasswordCharacter", new Object[]{String.valueOf(c)}));
            return false;
        }
        if (cArray.length > 64) {
            BDialog.error((BWidget)bWidget, (Object)lex.getText("UserManager.error.passwordTooLong"));
            return false;
        }
        if (bPasswordStrength != null) {
            try {
                bPasswordStrength.isPasswordValid(bPassword.getValue());
            }
            catch (Exception exception) {
                BDialog.error((BWidget)bWidget, (Object)exception.getLocalizedMessage());
                return false;
            }
        }
        return true;
    }

    private SystemPasswordPrompt(BOptionDialog bOptionDialog) {
        this.dialog = bOptionDialog;
        BGridPane bGridPane = new BGridPane(1);
        bGridPane.add(null, (BValue)new BLabel(lex.getText("SystemPasswordPrompt.description"), BHalign.left));
        this.noticeLabel = new BLabel(lex.getText("SystemPasswordPrompt.defaultNotice"), BHalign.left);
        bGridPane.add(null, (BValue)this.noticeLabel);
        this.noticeLabel.setForeground(BColor.red.toBrush());
        this.noticeLabel.setVisible(false);
        BGridPane bGridPane2 = new BGridPane(2);
        this.currentPasswordFE = new BPasswordFE();
        this.newPasswordFE1 = new BPasswordFE();
        this.newPasswordFE2 = new BPasswordFE();
        LabelUtil.addLabelWidgetPair((BGridPane)bGridPane2, (String)lex.getText("SystemPasswordPrompt.label.currentpassword"), (BWidget)this.currentPasswordFE);
        LabelUtil.addLabelWidgetPair((BGridPane)bGridPane2, (String)lex.getText("SystemPasswordPrompt.label.newpassword"), (BWidget)this.newPasswordFE1);
        LabelUtil.addLabelWidgetPair((BGridPane)bGridPane2, (String)lex.getText("SystemPasswordPrompt.label.newpassword2"), (BWidget)this.newPasswordFE2);
        bGridPane.add(null, (BValue)bGridPane2);
        bOptionDialog.setContent((BWidget)new BBorderPane((BWidget)bGridPane, 6.0, 6.0, 6.0, 6.0));
    }
}

