/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.config;

import com.tridium.platDaemon.ui.config.BVmHeapField;
import com.tridium.platDaemon.ui.config.BVmTuningPromptDialog;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.DaemonFileUtil;
import com.tridium.platform.daemon.file.BDaemonFileSpace;
import com.tridium.platform.daemon.file.FileCache;
import com.tridium.platform.daemon.message.ByteArrayFileTransferElement;
import com.tridium.platform.daemon.message.FileTransferMessage;
import com.tridium.platform.daemon.message.FileTransferMessageElement;
import com.tridium.platform.ui.util.BButtonPane;
import com.tridium.platform.ui.util.CommandUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import javax.baja.file.BFileSpace;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.gx.BImage;
import javax.baja.security.AuthenticationException;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BTextDropDown;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.ui.wizard.BWizardHeader;
import javax.baja.util.Lexicon;
import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;

public class BVmTuningPrompt
extends BEdgePane {
    public static final Action handleModified = BVmTuningPrompt.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$platDaemon$ui$config$BVmTuningPrompt == null ? (class$com$tridium$platDaemon$ui$config$BVmTuningPrompt = BVmTuningPrompt.class$("com.tridium.platDaemon.ui.config.BVmTuningPrompt")) : class$com$tridium$platDaemon$ui$config$BVmTuningPrompt));
    static BImage warningIcon = BImage.make((String)"module://icons/x32/warning.png");
    private BCheckBox heapEnabled;
    private BVmHeapField heapSize;
    private BCheckBox jitEnabled;
    private BTextDropDown jitOptions;
    private BCheckBox igcEnabled;
    private BCheckBox gcOutput;
    private BCheckBox sizesOutput;
    private BCheckBox classOutput;
    private BCheckBox stackOutput;
    private BTextField rawArgs;
    private Command saveCommand;
    private BDaemonSession daemonSession;
    private int result = 2;
    private BDialog dialog;
    private String vmVersion;
    private static Lexicon lex = Lexicon.make((String)"platDaemon");
    static /* synthetic */ Class class$com$tridium$platDaemon$ui$config$BVmTuningPrompt;

    public void handleModified() {
        this.invoke(handleModified, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    private BVmTuningPrompt(BDaemonSession bDaemonSession) throws ConnectException, AuthenticationException {
        this.daemonSession = bDaemonSession;
        this.vmVersion = bDaemonSession.getHostProperties().getVmVersion();
        BConstrainedPane bConstrainedPane = new BConstrainedPane((BWidget)new BWizardHeader(warningIcon, lex.getText("VmTuningPrompt.dlgTitle"), lex.getText("VmTuningPrompt.warningText")));
        bConstrainedPane.setMaxWidth(250.0);
        this.setTop((BWidget)bConstrainedPane);
        int n = bDaemonSession.getHostProperties().getTotalPhysicalMemory() / 1024;
        BGridPane bGridPane = new BGridPane(2);
        this.heapEnabled = new BCheckBox(lex.getText("VmTuningPrompt.heapSize"));
        bGridPane.add(null, (BValue)this.heapEnabled);
        this.heapSize = new BVmHeapField("", 5, false);
        bGridPane.add(null, (BValue)this.heapSize);
        this.heapSize.setBounds(8, n - 32);
        this.jitEnabled = new BCheckBox(lex.getText("VmTuningPrompt.jitEnabled"));
        this.jitOptions = new BTextDropDown();
        this.jitOptions.getList().addItem((Object)"optLevel=cold");
        BGridPane bGridPane2 = new BGridPane(2);
        bGridPane2.add(null, (BValue)this.jitEnabled);
        if (this.isV22()) {
            bGridPane2.add(null, (BValue)this.jitOptions);
        }
        this.igcEnabled = new BCheckBox(lex.getText("VmTuningPrompt.incrementalGC"));
        BGridPane bGridPane3 = new BGridPane(1);
        bGridPane3.add(null, (BValue)bGridPane2);
        if (this.isV22()) {
            bGridPane3.add(null, (BValue)this.igcEnabled);
        }
        this.gcOutput = new BCheckBox(lex.getText("VmTuningPrompt.gcOutput"));
        this.sizesOutput = new BCheckBox(lex.getText("VmTuningPrompt.sizesOutput"));
        this.classOutput = new BCheckBox(lex.getText("VmTuningPrompt.classOutput"));
        this.stackOutput = new BCheckBox(lex.getText("VmTuningPrompt.stackOutput"));
        BGridPane bGridPane4 = new BGridPane(5);
        bGridPane4.add(null, (BValue)new BLabel(lex.getText("VmTuningPrompt.vmOutputOptions")));
        bGridPane4.add(null, (BValue)this.gcOutput);
        bGridPane4.add(null, (BValue)this.sizesOutput);
        bGridPane4.add(null, (BValue)this.classOutput);
        bGridPane4.add(null, (BValue)this.stackOutput);
        BGridPane bGridPane5 = new BGridPane(1);
        bGridPane5.add(null, (BValue)bGridPane);
        bGridPane5.add(null, (BValue)bGridPane3);
        bGridPane5.add(null, (BValue)bGridPane4);
        this.rawArgs = new BTextField();
        BConstrainedPane bConstrainedPane2 = new BConstrainedPane((BWidget)this.rawArgs);
        bGridPane5.add(null, (BValue)bConstrainedPane2);
        bConstrainedPane2.setMinWidth(350.0);
        this.rawArgs.setEditable(false);
        bGridPane5.setStretchColumn(0);
        bGridPane5.setRowGap(10.0);
        this.setCenter((BWidget)new BBorderPane((BWidget)bGridPane5, 10.0, 10.0, 10.0, 10.0));
        bGridPane5.computePreferredSize();
        BButtonPane bButtonPane = new BButtonPane();
        bButtonPane.add((Command)new RestoreDefaultsCommand());
        this.saveCommand = new SaveCommand();
        bButtonPane.add(this.saveCommand);
        bButtonPane.add((Command)new CancelCommand());
        this.setBottom((BWidget)new BBorderPane((BWidget)bButtonPane, 0.0, 10.0, 10.0, 10.0));
        String string = this.getVmArgs();
        if (string != null) {
            this.parseArgString(string);
        } else {
            this.setDefaultArgs();
        }
        this.rawArgs.setText(this.createArgString());
        this.linkTo(null, (BComponent)this.heapEnabled, (Slot)BCheckBox.actionPerformed, (Slot)handleModified);
        this.linkTo(null, (BComponent)this.heapSize, (Slot)BVmHeapField.valueModified, (Slot)handleModified);
        this.linkTo(null, (BComponent)this.jitEnabled, (Slot)BCheckBox.actionPerformed, (Slot)handleModified);
        this.linkTo(null, (BComponent)this.jitOptions, (Slot)BTextDropDown.valueModified, (Slot)handleModified);
        this.linkTo(null, (BComponent)this.igcEnabled, (Slot)BCheckBox.actionPerformed, (Slot)handleModified);
        this.linkTo(null, (BComponent)this.gcOutput, (Slot)BCheckBox.actionPerformed, (Slot)handleModified);
        this.linkTo(null, (BComponent)this.sizesOutput, (Slot)BCheckBox.actionPerformed, (Slot)handleModified);
        this.linkTo(null, (BComponent)this.classOutput, (Slot)BCheckBox.actionPerformed, (Slot)handleModified);
        this.linkTo(null, (BComponent)this.stackOutput, (Slot)BCheckBox.actionPerformed, (Slot)handleModified);
    }

    public static boolean prompt(BWidget bWidget, BDaemonSession bDaemonSession) throws ConnectException, AuthenticationException {
        BVmTuningPrompt bVmTuningPrompt = new BVmTuningPrompt(bDaemonSession);
        BVmTuningPromptDialog bVmTuningPromptDialog = new BVmTuningPromptDialog(bWidget, (BWidget)bVmTuningPrompt);
        bVmTuningPrompt.dialog = bVmTuningPromptDialog;
        bVmTuningPromptDialog.setBoundsCenteredOnOwner();
        bVmTuningPromptDialog.open();
        return bVmTuningPrompt.result == 1;
    }

    private boolean isV22() {
        return this.vmVersion == null ? false : this.vmVersion.startsWith("2.2");
    }

    private int calcMaxHeap() {
        int n = this.daemonSession.getHostProperties().getTotalPhysicalMemory() / 1024;
        if (n <= 64) {
            return 14;
        }
        if (n <= 128) {
            return 48;
        }
        return 96;
    }

    private void setDefaultArgs() {
        this.heapEnabled.setSelected(true);
        this.heapSize.getTextField().setText("" + this.calcMaxHeap());
        this.jitEnabled.setSelected(true);
        if (this.isV22()) {
            this.jitOptions.setText("optLevel=cold");
            this.igcEnabled.setSelected(true);
        }
        this.classOutput.setSelected(false);
        this.stackOutput.setSelected(false);
        this.gcOutput.setSelected(false);
        this.sizesOutput.setSelected(false);
    }

    private void parseArgString(String string) {
        Perl5Compiler perl5Compiler = new Perl5Compiler();
        Perl5Matcher perl5Matcher = new Perl5Matcher();
        try {
            int n;
            String string2;
            MatchResult matchResult;
            Pattern pattern;
            if (this.isV22()) {
                pattern = perl5Compiler.compile("-jit:?(\\S*)");
                if (perl5Matcher.contains(string, pattern)) {
                    matchResult = perl5Matcher.getMatch();
                    this.jitEnabled.setSelected(true);
                    if (matchResult.group(1) != null) {
                        this.jitOptions.setText(matchResult.group(1));
                    } else {
                        this.jitOptions.setText("");
                    }
                } else {
                    this.jitEnabled.setSelected(false);
                    this.jitOptions.setText("");
                }
            } else {
                this.jitOptions.setText("");
                if (string.indexOf("-nojit") >= 0) {
                    this.jitEnabled.setSelected(false);
                } else {
                    this.jitEnabled.setSelected(true);
                }
            }
            pattern = perl5Compiler.compile("-verbose:?(\\S*)");
            if (perl5Matcher.contains(string, pattern)) {
                matchResult = perl5Matcher.getMatch();
                string2 = matchResult.group(1);
                n = 0;
                Pattern pattern2 = perl5Compiler.compile("class");
                if (perl5Matcher.contains(string2, pattern2)) {
                    this.classOutput.setSelected(true);
                    n = 1;
                } else {
                    this.classOutput.setSelected(false);
                }
                pattern2 = perl5Compiler.compile("stack");
                if (perl5Matcher.contains(string2, pattern2)) {
                    this.stackOutput.setSelected(true);
                    n = 1;
                } else {
                    this.stackOutput.setSelected(false);
                }
                pattern2 = perl5Compiler.compile("gc");
                if (perl5Matcher.contains(string2, pattern2)) {
                    this.gcOutput.setSelected(true);
                    n = 1;
                } else {
                    this.gcOutput.setSelected(false);
                }
                pattern2 = perl5Compiler.compile("sizes");
                if (perl5Matcher.contains(string2, pattern2)) {
                    this.sizesOutput.setSelected(true);
                    n = 1;
                } else {
                    this.sizesOutput.setSelected(false);
                }
                if (n == 0) {
                    this.classOutput.setSelected(true);
                }
            } else {
                this.classOutput.setSelected(false);
                this.stackOutput.setSelected(false);
                this.gcOutput.setSelected(false);
                this.sizesOutput.setSelected(false);
            }
            matchResult = perl5Compiler.compile("-Xmx(\\d+)([mMkK]?)");
            if (perl5Matcher.contains(string, (Pattern)matchResult)) {
                string2 = perl5Matcher.getMatch();
                n = Integer.parseInt(string2.group(1));
                if (!string2.group(2).equalsIgnoreCase("m")) {
                    n = string2.group(2).equalsIgnoreCase("k") ? (n /= 1024) : (n /= 0x100000);
                }
                this.heapEnabled.setSelected(true);
                this.heapSize.getTextField().setText("" + n);
            } else {
                this.heapEnabled.setSelected(false);
                this.heapSize.getTextField().setText("" + this.calcMaxHeap());
            }
            if (this.isV22()) {
                string2 = perl5Compiler.compile("-Xgcpolicy:optavgpause");
                if (perl5Matcher.contains(string, (Pattern)string2)) {
                    this.igcEnabled.setSelected(true);
                } else {
                    this.igcEnabled.setSelected(false);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String createArgString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.daemonSession.getHostProperties().getTotalPhysicalMemory() / 1024;
        if (this.isV22()) {
            if (n <= 64) {
                stringBuffer.append("-Xrunvmprof -Xmso128K -jcl:max");
            } else {
                stringBuffer.append("-Xrunvmprof -Xmn2M -Xmso128K -jcl:max");
            }
            if (this.jitEnabled.getSelected()) {
                stringBuffer.append(" -jit");
                if (this.jitOptions.getText().trim().length() > 0) {
                    stringBuffer.append(":").append(this.jitOptions.getText());
                }
            }
        } else if (!this.jitEnabled.getSelected()) {
            stringBuffer.append(" -nojit");
        }
        if (this.classOutput.getSelected() || this.stackOutput.getSelected() || this.gcOutput.getSelected() || this.sizesOutput.getSelected()) {
            stringBuffer.append(" -verbose:");
            boolean bl = false;
            if (this.classOutput.getSelected()) {
                stringBuffer.append("class");
                bl = true;
            }
            if (this.stackOutput.getSelected()) {
                if (bl) {
                    stringBuffer.append(",");
                }
                stringBuffer.append("stack");
                bl = true;
            }
            if (this.gcOutput.getSelected()) {
                if (bl) {
                    stringBuffer.append(",");
                }
                stringBuffer.append("gc");
                bl = true;
            }
            if (this.sizesOutput.getSelected()) {
                if (bl) {
                    stringBuffer.append(",");
                }
                stringBuffer.append("sizes");
                bl = true;
            }
        }
        if (this.heapEnabled.getSelected()) {
            String string = this.heapSize.getTextField().getText();
            if (string == null) {
                string = "" + this.calcMaxHeap();
            } else {
                try {
                    if (Integer.parseInt(string) <= 0) {
                        string = "" + this.calcMaxHeap();
                    }
                }
                catch (Exception exception) {
                    string = "" + this.calcMaxHeap();
                }
            }
            stringBuffer.append(" -Xmx").append(string).append("M");
        }
        if (this.igcEnabled.getSelected()) {
            stringBuffer.append(" -Xgcpolicy:optavgpause");
        }
        return stringBuffer.toString();
    }

    private String getVmArgs() {
        FileCache fileCache = new FileCache((BFileSpace)this.daemonSession.getFileSpace());
        FilePath filePath = new FilePath("/niagara/lib/vm.args");
        BIFile bIFile = DaemonFileUtil.findFile((BFileSpace)this.daemonSession.getFileSpace(), (FilePath)filePath, (FileCache)fileCache);
        if (bIFile == null) {
            return null;
        }
        byte[] byArray = new byte[8192];
        InputStream inputStream = null;
        StringBuffer stringBuffer = new StringBuffer();
        try {
            inputStream = bIFile.getInputStream();
            while (inputStream.read(byArray, 0, 8192) > 0) {
                stringBuffer.append(new String(byArray));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return stringBuffer.toString().trim();
    }

    private boolean putVmArgs(String string) {
        try {
            FilePath filePath = new FilePath("/niagara/lib/vm.args");
            FileTransferMessage fileTransferMessage = new FileTransferMessage((BDaemonFileSpace)this.daemonSession.getFileSpace());
            ByteArrayFileTransferElement byteArrayFileTransferElement = new ByteArrayFileTransferElement(filePath, string.getBytes(), (BDaemonFileSpace)this.daemonSession.getFileSpace());
            fileTransferMessage.addElement((FileTransferMessageElement)byteArrayFileTransferElement);
            return DaemonFileUtil.transfer((BDaemonSession)this.daemonSession, (FileTransferMessage)fileTransferMessage, null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public void doHandleModified() {
        this.saveCommand.setEnabled(true);
        this.rawArgs.setText(this.createArgString());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class CancelCommand
    extends Command {
        public CancelCommand() {
            super((BWidget)BVmTuningPrompt.this, UiLexicon.bajaui.getText("action.cancel"), null, null, null);
        }

        public CommandArtifact doInvoke() {
            BVmTuningPrompt.this.result = 2;
            BVmTuningPrompt.this.dialog.close();
            return null;
        }
    }

    private class SaveCommand
    extends Command {
        public SaveCommand() {
            super((BWidget)BVmTuningPrompt.this, UiLexicon.bajaui.getText("commands.save.label"), null, null, null);
            this.setEnabled(false);
        }

        public CommandArtifact doInvoke() {
            if (BVmTuningPrompt.this.putVmArgs(BVmTuningPrompt.this.createArgString())) {
                BVmTuningPrompt.this.result = 1;
                BVmTuningPrompt.this.dialog.close();
            }
            return null;
        }
    }

    private class RestoreDefaultsCommand
    extends Command {
        public RestoreDefaultsCommand() {
            super((BWidget)BVmTuningPrompt.this, lex.getText("VmTuningPrompt.restoreDefaults"), null, null, null);
        }

        public CommandArtifact doInvoke() {
            try {
                BVmTuningPrompt.this.setDefaultArgs();
                BVmTuningPrompt.this.dialog.repaint();
                BVmTuningPrompt.this.saveCommand.setEnabled(true);
            }
            catch (Throwable throwable) {
                CommandUtil.error((Command)this, (Throwable)throwable);
            }
            return null;
        }
    }
}

