/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.config;

import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.DaemonTimeUtil;
import com.tridium.platform.timezone.BDstSupportLevel;
import com.tridium.platform.timezone.TimeZoneUtil;
import com.tridium.platform.ui.util.BCommandDialog;
import com.tridium.platform.ui.util.CommandUtil;
import com.tridium.platform.ui.util.DialogCommand;
import com.tridium.platform.ui.util.LabelUtil;
import com.tridium.workbench.fieldeditors.BDateFE;
import java.net.ConnectException;
import javax.baja.security.AuthenticationException;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BMonth;
import javax.baja.sys.BObject;
import javax.baja.sys.BTime;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.list.ListModel;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;
import javax.baja.util.LexiconText;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

public class BTimePrompt
extends BEdgePane {
    public static final Action handleModified = BTimePrompt.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$platDaemon$ui$config$BTimePrompt == null ? (class$com$tridium$platDaemon$ui$config$BTimePrompt = BTimePrompt.class$("com.tridium.platDaemon.ui.config.BTimePrompt")) : class$com$tridium$platDaemon$ui$config$BTimePrompt));
    private BWbFieldEditor timeFE;
    private BDateFE dateFE;
    private BListDropDown timeZoneChoice;
    private DialogCommand useLocalCommand;
    private DialogCommand saveCommand;
    private BDaemonSession daemonSession;
    private BWidget mainContent;
    private BTimeZone[] timeZones;
    private static Lexicon lex = Lexicon.make((String)"platDaemon");
    private static final BFacets HOUR_MINUTE = BFacets.make((String)"timeFormat", (String)"HH:mm");
    static /* synthetic */ Class class$com$tridium$platDaemon$ui$config$BTimePrompt;

    public void handleModified() {
        this.invoke(handleModified, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    private BTimePrompt(BDaemonSession bDaemonSession, BTimeZone[] bTimeZoneArray) throws ConnectException, AuthenticationException {
        this.daemonSession = bDaemonSession;
        this.timeZones = bTimeZoneArray;
        BTimeZone bTimeZone = DaemonTimeUtil.getLocalTimeZone((BDaemonSession)bDaemonSession, (BTimeZone[])bTimeZoneArray);
        BAbsTime bAbsTime = DaemonTimeUtil.getLocalTime((BDaemonSession)bDaemonSession, (BTimeZone)bTimeZone, (BTimeZone[])bTimeZoneArray);
        BTime bTime = BTime.make((BAbsTime)bAbsTime);
        BGridPane bGridPane = new BGridPane(2);
        bGridPane.setRowGap(5.0);
        bGridPane.setHalign(BHalign.left);
        bGridPane.setValign(BValign.top);
        this.dateFE = new BDateFE(bAbsTime);
        LabelUtil.addLabelWidgetPair((BGridPane)bGridPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"PlatformAdministration.dialog.timePrompt.dateLabel"), (BWidget)this.dateFE);
        this.timeFE = BWbFieldEditor.makeFor((BObject)bTime, (Context)HOUR_MINUTE);
        LabelUtil.addLabelWidgetPair((BGridPane)bGridPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"PlatformAdministration.dialog.timePrompt.timeLabel"), (BWidget)this.timeFE);
        this.timeFE.loadValue((BObject)bTime, (Context)HOUR_MINUTE);
        this.timeZoneChoice = new BListDropDown();
        LabelUtil.addLabelWidgetPair((BGridPane)bGridPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"PlatformAdministration.dialog.timePrompt.tzLabel"), (BWidget)this.timeZoneChoice);
        this.timeZoneChoice.getList().setModel((ListModel)new TimeZoneListModel());
        this.timeZoneChoice.setSelectedItem((Object)bTimeZone);
        this.mainContent = new BBorderPane((BWidget)bGridPane, 10.0, 10.0, 10.0, 10.0);
        this.setCenter(this.mainContent);
        this.linkTo(null, (BComponent)this.dateFE, (Slot)BDateFE.pluginModified, (Slot)handleModified);
        this.linkTo(null, (BComponent)this.timeFE, (Slot)BWbFieldEditor.pluginModified, (Slot)handleModified);
        this.linkTo(null, (BComponent)this.timeZoneChoice, (Slot)BListDropDown.listActionPerformed, (Slot)handleModified);
        this.mainContent.computePreferredSize();
        this.useLocalCommand = new UseLocalCommand();
        this.saveCommand = new SaveCommand();
    }

    public static BTimePrompt prompt(BWidget bWidget, BDaemonSession bDaemonSession, BTimeZone[] bTimeZoneArray) throws ConnectException, AuthenticationException {
        BTimePrompt bTimePrompt = new BTimePrompt(bDaemonSession, bTimeZoneArray);
        if (1 == BCommandDialog.open((BWidget)bWidget, (String)lex.getText("PlatformAdministration.dialog.timePrompt.title"), (Object)((Object)bTimePrompt), (DialogCommand[])new DialogCommand[]{bTimePrompt.useLocalCommand, bTimePrompt.saveCommand, DialogCommand.makeCancel((BWidget)bTimePrompt)})) {
            return bTimePrompt;
        }
        return null;
    }

    public BAbsTime getDateTime() {
        try {
            BAbsTime bAbsTime = (BAbsTime)this.dateFE.saveValue();
            BTime bTime = (BTime)this.timeFE.saveValue();
            return BAbsTime.make((int)bAbsTime.getYear(), (BMonth)bAbsTime.getMonth(), (int)bAbsTime.getDay(), (int)bTime.getHour(), (int)bTime.getMinute(), (int)0, (int)0, (BTimeZone)this.getSelectedTimeZone());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private BTimeZone getSelectedTimeZone() {
        return (BTimeZone)this.timeZoneChoice.getSelectedItem();
    }

    public BTimeZone getTimeZone() {
        BDstSupportLevel bDstSupportLevel = this.getDaemonSession().getHostProperties().getTimezoneDayModeSupport();
        BAbsTime bAbsTime = this.getDateTime();
        BTimeZone bTimeZone = this.getSelectedTimeZone();
        try {
            bTimeZone = DaemonTimeUtil.getCompleteTimeZone((BDaemonSession)this.getDaemonSession(), (BTimeZone)bTimeZone);
        }
        catch (ConnectException connectException) {
            // empty catch block
        }
        if (TimeZoneUtil.isSupported((long)bAbsTime.getMillis(), (BTimeZone)bTimeZone, (BDstSupportLevel)bDstSupportLevel)) {
            return TimeZoneUtil.makeCompatible((long)bAbsTime.getMillis(), (BTimeZone)bTimeZone, (BDstSupportLevel)bDstSupportLevel);
        }
        return BTimeZone.UTC;
    }

    public String getBajaTimeZoneId() {
        return this.getSelectedTimeZone().getId();
    }

    private BDaemonSession getDaemonSession() {
        return this.daemonSession;
    }

    public void doHandleModified() {
        this.saveCommand.setEnabled(true);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class SaveCommand
    extends DialogCommand {
        public SaveCommand() {
            super((BWidget)BTimePrompt.this, 1, UiLexicon.bajaui.getText("commands.save.label"), null, null, null);
            this.setEnabled(false);
        }
    }

    private class UseLocalCommand
    extends DialogCommand {
        public UseLocalCommand() {
            super((BWidget)BTimePrompt.this, -1, lex.getText("PlatformAdministration.dialog.timePrompt.useLocal"), null, null, null);
        }

        public CommandArtifact doInvoke() {
            try {
                BAbsTime bAbsTime = BAbsTime.now();
                BTimePrompt.this.timeFE.loadValue((BObject)BTime.make((BAbsTime)bAbsTime), (Context)HOUR_MINUTE);
                BTimePrompt.this.dateFE.loadValue((BObject)bAbsTime);
                BTimeZone bTimeZone = DaemonTimeUtil.getEquivalentTimeZone((BTimeZone)BTimeZone.getLocal(), (BTimeZone[])BTimePrompt.this.timeZones);
                if (bTimeZone == null) {
                    boolean bl = false;
                    String string = BTimeZone.getLocal().getId();
                    for (int i = 0; i < BTimePrompt.this.timeZones.length; ++i) {
                        if (!BTimePrompt.this.timeZones[i].getId().equals(string)) continue;
                        BTimePrompt.this.timeZoneChoice.setSelectedItem((Object)BTimePrompt.this.timeZones[i]);
                        bl = true;
                        break;
                    }
                    if (!bl) {
                        bAbsTime = BAbsTime.make((BAbsTime)bAbsTime, (BTimeZone)((BTimeZone)BTimePrompt.this.timeZoneChoice.getSelectedItem()));
                        BTimePrompt.this.timeFE.loadValue((BObject)BTime.make((BAbsTime)bAbsTime), (Context)HOUR_MINUTE);
                        BTimePrompt.this.dateFE.loadValue((BObject)bAbsTime);
                    }
                } else {
                    BTimePrompt.this.timeZoneChoice.setSelectedItem((Object)bTimeZone);
                }
                this.getDialog().repaint();
                BTimePrompt.this.saveCommand.setEnabled(true);
            }
            catch (Throwable throwable) {
                CommandUtil.error((Command)this, (Throwable)throwable);
            }
            return null;
        }
    }

    private class TimeZoneListModel
    extends ListModel {
        public int getItemCount() {
            return BTimePrompt.this.timeZones.length;
        }

        public BTimeZone getTimeZone(int n) {
            return BTimePrompt.this.timeZones[n];
        }

        public Object getItem(int n) {
            return this.getTimeZone(n);
        }
    }
}

