/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.config;

import com.tridium.install.BDaemonPlatform;
import com.tridium.install.BRemoteDaemonPlatform;
import com.tridium.install.BVersion;
import com.tridium.install.part.BGenericPart;
import com.tridium.install.part.BModelPart;
import com.tridium.install.part.BNrePart;
import com.tridium.install.part.BOsPart;
import com.tridium.install.part.BPart;
import com.tridium.install.part.BVmPart;
import com.tridium.platDaemon.message.UpdateDaemonMessage;
import com.tridium.platDaemon.message.UpdateSSLSettingsMessage;
import com.tridium.platDaemon.ui.BDaemonLogSettingsView;
import com.tridium.platDaemon.ui.BDaemonSSLSettingsView;
import com.tridium.platDaemon.ui.BDaemonSessionView;
import com.tridium.platDaemon.ui.BOutputDialog;
import com.tridium.platDaemon.ui.appsurrogate.RebootCommand;
import com.tridium.platDaemon.ui.commissioningwizard.CommissioningWizardModel;
import com.tridium.platDaemon.ui.config.AdvancedOptionsPrompt;
import com.tridium.platDaemon.ui.config.AuthenticationWizardModel;
import com.tridium.platDaemon.ui.config.BConfigDetailsPane;
import com.tridium.platDaemon.ui.config.BPortPrompt;
import com.tridium.platDaemon.ui.config.BTimePrompt;
import com.tridium.platDaemon.ui.config.BVmTuningPrompt;
import com.tridium.platDaemon.ui.config.BackupDistCommand;
import com.tridium.platDaemon.ui.config.ModuleContentWizardModel;
import com.tridium.platDaemon.ui.config.SystemPasswordPrompt;
import com.tridium.platDaemon.ui.r2tools.r2commissioningwizard.R2CommissioningWizardModel;
import com.tridium.platform.BFilesystemAttributes;
import com.tridium.platform.BPlatformSSLSettings;
import com.tridium.platform.daemon.BDaemonAccessLevel;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.BStationSurrogate;
import com.tridium.platform.daemon.DaemonFileUtil;
import com.tridium.platform.daemon.DaemonTimeUtil;
import com.tridium.platform.daemon.file.BDaemonDirectoryStore;
import com.tridium.platform.daemon.file.BDaemonFileSpace;
import com.tridium.platform.daemon.message.DaemonDebugMessage;
import com.tridium.platform.daemon.message.DaemonMessage;
import com.tridium.platform.daemon.message.QnxInetdMessage;
import com.tridium.platform.daemon.message.QnxSshdMessage;
import com.tridium.platform.daemon.message.RefreshDaemonBinariesMessage;
import com.tridium.platform.daemon.message.SystemPasswordMessageAX;
import com.tridium.platform.daemon.message.UpdateTimeMessage;
import com.tridium.platform.daemon.message.XmlResponseMessage;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import com.tridium.platform.ewf.BEwfOverlayAttributes;
import com.tridium.platform.ui.util.AsyncCommand;
import com.tridium.platform.ui.util.BCommandDialog;
import com.tridium.platform.ui.util.CommandUtil;
import com.tridium.platform.ui.util.DialogCommand;
import com.tridium.platform.ui.util.LabelUtil;
import com.tridium.sys.Nre;
import com.tridium.ui.theme.Theme;
import com.tridium.workbench.auth.AuthUtil;
import com.tridium.workbench.shell.BNiagaraWbShell;
import com.tridium.workbench.shell.NHyperlinkInfo;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.ConnectException;
import java.text.DecimalFormat;
import javax.baja.file.FilePath;
import javax.baja.gx.BColor;
import javax.baja.gx.BImage;
import javax.baja.gx.Graphics;
import javax.baja.naming.BHost;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SlotPath;
import javax.baja.naming.UnresolvedException;
import javax.baja.naming.ViewQuery;
import javax.baja.nre.util.TextUtil;
import javax.baja.platform.install.BVersionRelation;
import javax.baja.security.AuthenticationException;
import javax.baja.security.BICredentials;
import javax.baja.security.BUsernameAndPassword;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BModule;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.ui.BAccelerator;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BHyperlinkMode;
import javax.baja.ui.BLabel;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.HyperlinkInfo;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BScrollBarPolicy;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.wizard.BWizard;
import javax.baja.ui.wizard.WizardModel;
import javax.baja.util.Lexicon;
import javax.baja.util.LexiconText;
import javax.baja.workbench.BWbShell;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

public class BPlatformAdministration
extends BDaemonSessionView {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$platDaemon$ui$config$BPlatformAdministration == null ? (class$com$tridium$platDaemon$ui$config$BPlatformAdministration = BPlatformAdministration.class$("com.tridium.platDaemon.ui.config.BPlatformAdministration")) : class$com$tridium$platDaemon$ui$config$BPlatformAdministration));
    private Command updatePortCommand;
    private Command authCommand;
    private Command updateTimeCommand;
    private Command detailsCommand;
    private Command logSettingsCommand;
    private Command outputDialogCommand;
    private RebootCommand rebootCommand;
    private Command moduleContentCommand;
    private Command vmTuningCommand;
    private Command commissioningCommand;
    private Command backupCommand;
    private SedonaCommand sedonaCommand;
    private NiagaraR2Command niagaraR2Command;
    private Command sslSettingsCommand;
    private Command systemPasswordCommand;
    private Command advancedOptionsCommand;
    private BLabel bajaVersionLabel;
    private BLabel homeDirLabel;
    private BLabel addressLabel;
    private BLabel hostIdLabel;
    private BLabel archLabel;
    private BLabel osLabel;
    private BLabel nreLabel;
    private BLabel portLabel;
    private BLabel modelLabel;
    private BLabel moduleContentLabel;
    private BLabel vmLabel;
    private BLabel niagaraStationsLabel;
    private BLabel sslSupportedLabel;
    private BLabel timeLabel;
    private BLabel dateLabel;
    private BLabel tzLabel;
    private BLabel stripLabel;
    private BLabel numCpusLabel;
    private BLabel currentCpuLabel;
    private BLabel overallCpuLabel;
    private BGridPane filesystemPane;
    private BLabel totalPhysicalMemoryLabel;
    private BLabel freePhysicalMemoryLabel;
    private BTimeZone[] timeZones;
    private boolean factoryDefaultCredentials;
    private boolean daemonDebugEnabled;
    private boolean ftpEnabled;
    private boolean telnetEnabled;
    private boolean sshdEnabled;
    private boolean factoryDefaultSystemPassword;
    private BLabel sedonaLabel;
    private BLabel sedonaStatus;
    private BLabel niagaraR2Label;
    private BLabel niagaraR2Status;
    private BLabel ewfLabel;
    private BLabel osEnableStateLabel;
    private BLabel osBootCommandLabel;
    private BLabel osRamUsageLabel;
    private BLabel historyEnableStateLabel;
    private BLabel historyBootCommandLabel;
    private BLabel historyRamUsageLabel;
    private BGridPane buttons;
    private BGridPane otherGrid;
    private BGridPane contentGrid;
    private BGridPane ewfGrid;
    private BGridPane ledger;
    private BScrollPane scrollPane;
    static BImage faultIcon = BImage.make((String)"module://icons/x32/warning.png");
    static BModule myModule = Sys.getModuleForClass((Class)(class$com$tridium$platDaemon$ui$config$BPlatformAdministration == null ? (class$com$tridium$platDaemon$ui$config$BPlatformAdministration = BPlatformAdministration.class$("com.tridium.platDaemon.ui.config.BPlatformAdministration")) : class$com$tridium$platDaemon$ui$config$BPlatformAdministration));
    public static DecimalFormat mbFormat = new DecimalFormat(Lexicon.make((String)"platform").getText("Formats.mb"));
    private Object RESTART_LOCK = new Object();
    private boolean restarting = false;
    private static final long WEBSERVER_RESTART_TIME = 3500L;
    static /* synthetic */ Class class$com$tridium$platDaemon$ui$config$BPlatformAdministration;
    static /* synthetic */ Class class$com$tridium$platform$ewf$BEwfOverlayAttributes;
    static /* synthetic */ Class class$javax$baja$ui$BWidget;
    static /* synthetic */ Class class$javax$baja$sys$BObject;

    public Type getType() {
        return TYPE;
    }

    public BPlatformAdministration() {
        this.ledger = new BGridPane(2);
        this.ledger.setRowAlign(BValign.top);
        this.ledger.setHalign(BHalign.left);
        this.ledger.setRowGap(5.0);
        this.bajaVersionLabel = new BLabel("", BHalign.left);
        LabelUtil.addLabelWidgetPair((BGridPane)this.ledger, (LexiconText)LexiconText.make((Type)TYPE, (String)"PlatformAdministration.bajaVersion"), (BWidget)this.bajaVersionLabel);
        this.homeDirLabel = new BLabel("", BHalign.left);
        LabelUtil.addLabelWidgetPair((BGridPane)this.ledger, (LexiconText)LexiconText.make((Type)TYPE, (String)"PlatformAdministration.homeDir"), (BWidget)this.homeDirLabel);
        this.addressLabel = new BLabel("", BHalign.left);
        LabelUtil.addLabelWidgetPair((BGridPane)this.ledger, (LexiconText)LexiconText.make((Type)TYPE, (String)"PlatformAdministration.address"), (BWidget)this.addressLabel);
        this.portLabel = new BLabel("", BHalign.left);
        LabelUtil.addLabelWidgetPair((BGridPane)this.ledger, (LexiconText)LexiconText.make((Type)TYPE, (String)"PlatformAdministration.port"), (BWidget)this.portLabel);
        this.hostIdLabel = new BLabel("", BHalign.left);
        LabelUtil.addLabelWidgetPair((BGridPane)this.ledger, (LexiconText)LexiconText.make((Type)TYPE, (String)"PlatformAdministration.hostId"), (BWidget)this.hostIdLabel);
        this.modelLabel = new BLabel("", BHalign.left);
        LabelUtil.addLabelWidgetPair((BGridPane)this.ledger, (LexiconText)LexiconText.make((Type)TYPE, (String)"PlatformAdministration.model"), (BWidget)this.modelLabel);
        this.dateLabel = new BLabel("", BHalign.left);
        LabelUtil.addLabelWidgetPair((BGridPane)this.ledger, (LexiconText)LexiconText.make((Type)TYPE, (String)"PlatformAdministration.date"), (BWidget)this.dateLabel);
        this.timeLabel = new BLabel("", BHalign.left);
        LabelUtil.addLabelWidgetPair((BGridPane)this.ledger, (LexiconText)LexiconText.make((Type)TYPE, (String)"PlatformAdministration.time"), (BWidget)this.timeLabel);
        this.tzLabel = new BLabel("", BHalign.left);
        LabelUtil.addLabelWidgetPair((BGridPane)this.ledger, (LexiconText)LexiconText.make((Type)TYPE, (String)"PlatformAdministration.tz"), (BWidget)this.tzLabel);
        this.osLabel = new BLabel("", BHalign.left);
        LabelUtil.addLabelWidgetPair((BGridPane)this.ledger, (LexiconText)LexiconText.make((Type)TYPE, (String)"PlatformAdministration.os"), (BWidget)this.osLabel);
        this.nreLabel = new BLabel("", BHalign.left);
        LabelUtil.addLabelWidgetPair((BGridPane)this.ledger, (LexiconText)LexiconText.make((Type)TYPE, (String)"PlatformAdministration.nre"), (BWidget)this.nreLabel);
        this.archLabel = new BLabel("", BHalign.left);
        LabelUtil.addLabelWidgetPair((BGridPane)this.ledger, (LexiconText)LexiconText.make((Type)TYPE, (String)"PlatformAdministration.arch"), (BWidget)this.archLabel);
        this.moduleContentLabel = new BLabel("", BHalign.left);
        LabelUtil.addLabelWidgetPair((BGridPane)this.ledger, (LexiconText)LexiconText.make((Type)TYPE, (String)"PlatformAdministration.moduleContent"), (BWidget)this.moduleContentLabel);
        this.stripLabel = new BLabel("", BHalign.left);
        LabelUtil.addLabelWidgetPair((BGridPane)this.ledger, (LexiconText)LexiconText.make((Type)TYPE, (String)"PlatformAdministration.stripLineNumbers"), (BWidget)this.stripLabel);
        this.vmLabel = new BLabel("", BHalign.left);
        LabelUtil.addLabelWidgetPair((BGridPane)this.ledger, (LexiconText)LexiconText.make((Type)TYPE, (String)"PlatformAdministration.vm"), (BWidget)this.vmLabel);
        this.niagaraStationsLabel = new BLabel("", BHalign.left);
        LabelUtil.addLabelWidgetPair((BGridPane)this.ledger, (LexiconText)LexiconText.make((Type)TYPE, (String)"PlatformAdministration.niagaraStationsEnabled"), (BWidget)this.niagaraStationsLabel);
        this.sedonaLabel = LabelUtil.makeLabel((LexiconText)LexiconText.make((Type)TYPE, (String)"PlatformAdministration.sedonaSupport"), (boolean)true);
        this.ledger.add(null, (BValue)this.sedonaLabel);
        this.sedonaStatus = new BLabel("", BHalign.left);
        this.ledger.add(null, (BValue)this.sedonaStatus);
        this.niagaraR2Label = LabelUtil.makeLabel((LexiconText)LexiconText.make((Type)TYPE, (String)"PlatformAdministration.niagaraR2Support"), (boolean)true);
        this.ledger.add(null, (BValue)this.niagaraR2Label);
        this.niagaraR2Status = new BLabel("", BHalign.left);
        this.ledger.add(null, (BValue)this.niagaraR2Status);
        this.sslSupportedLabel = new BLabel("", BHalign.left);
        LabelUtil.addLabelWidgetPair((BGridPane)this.ledger, (LexiconText)LexiconText.make((Type)TYPE, (String)"PlatformAdministration.sslSupport"), (BWidget)this.sslSupportedLabel);
        this.numCpusLabel = new BLabel();
        LabelUtil.addLabelWidgetPair((BGridPane)this.ledger, (LexiconText)LexiconText.make((Type)TYPE, (String)"PlatformAdministration.numCpus"), (BWidget)this.numCpusLabel);
        this.currentCpuLabel = new BLabel();
        LabelUtil.addLabelWidgetPair((BGridPane)this.ledger, (LexiconText)LexiconText.make((Type)TYPE, (String)"PlatformAdministration.currentCpuUsage"), (BWidget)this.currentCpuLabel);
        this.overallCpuLabel = new BLabel();
        LabelUtil.addLabelWidgetPair((BGridPane)this.ledger, (LexiconText)LexiconText.make((Type)TYPE, (String)"PlatformAdministration.overallCpuUsage"), (BWidget)this.overallCpuLabel);
        this.filesystemPane = new BGridPane(6);
        LabelUtil.addLabelWidgetPair((BGridPane)this.ledger, (LexiconText)LexiconText.make((Type)TYPE, (String)"PlatformAdministration.filesystem"), (BWidget)this.filesystemPane);
        this.filesystemPane.setColumnAlign(BHalign.fill);
        BGridPane bGridPane = new BGridPane(2);
        bGridPane.setColumnAlign(BHalign.fill);
        bGridPane.add(null, (BValue)LabelUtil.makeLabel((LexiconText)LexiconText.make((Type)TYPE, (String)"PlatformAdministration.totalKb"), (boolean)true));
        bGridPane.add(null, (BValue)LabelUtil.makeLabel((LexiconText)LexiconText.make((Type)TYPE, (String)"PlatformAdministration.freeKb"), (boolean)true));
        this.totalPhysicalMemoryLabel = new BLabel("", BHalign.right);
        bGridPane.add(null, (BValue)this.totalPhysicalMemoryLabel);
        this.freePhysicalMemoryLabel = new BLabel("", BHalign.right);
        bGridPane.add(null, (BValue)this.freePhysicalMemoryLabel);
        LabelUtil.addLabelWidgetPair((BGridPane)this.ledger, (LexiconText)LexiconText.make((Type)TYPE, (String)"PlatformAdministration.physicalMemory"), (BWidget)bGridPane);
        this.otherGrid = new BGridPane(1);
        LabelUtil.addLabelWidgetPair((BGridPane)this.ledger, (LexiconText)LexiconText.make((Type)TYPE, (String)"PlatformAdministration.other"), (BWidget)this.otherGrid);
        this.ewfLabel = LabelUtil.makeLabel((LexiconText)LexiconText.make((String)"platform", (String)"labels.system.nxs.overlays"), (boolean)true);
        this.ewfGrid = new BGridPane(4);
        this.ewfGrid.setColumnAlign(BHalign.fill);
        this.ewfGrid.add(null, (BValue)new BNullWidget());
        this.ewfGrid.add(null, (BValue)LabelUtil.makeLabel((LexiconText)LexiconText.make((String)"platform", (String)"labels.system.nxs.overlayState"), (boolean)true));
        this.ewfGrid.add(null, (BValue)LabelUtil.makeLabel((LexiconText)LexiconText.make((String)"platform", (String)"labels.system.nxs.overlayCommand"), (boolean)true));
        this.ewfGrid.add(null, (BValue)LabelUtil.makeLabel((LexiconText)LexiconText.make((String)"platform", (String)"labels.system.nxs.overlayRamUsage"), (boolean)true));
        this.ewfGrid.add(null, (BValue)LabelUtil.makeLabel((LexiconText)LexiconText.make((String)"platform", (String)"labels.system.nxs.osOverlay"), (boolean)false));
        this.osEnableStateLabel = new BLabel();
        this.ewfGrid.add(null, (BValue)this.osEnableStateLabel);
        this.osBootCommandLabel = new BLabel();
        this.ewfGrid.add(null, (BValue)this.osBootCommandLabel);
        this.osRamUsageLabel = new BLabel();
        this.ewfGrid.add(null, (BValue)this.osRamUsageLabel);
        this.ewfGrid.add(null, (BValue)LabelUtil.makeLabel((LexiconText)LexiconText.make((String)"platform", (String)"labels.system.nxs.historyOverlay"), (boolean)false));
        this.historyEnableStateLabel = new BLabel();
        this.ewfGrid.add(null, (BValue)this.historyEnableStateLabel);
        this.historyBootCommandLabel = new BLabel();
        this.ewfGrid.add(null, (BValue)this.historyBootCommandLabel);
        this.historyRamUsageLabel = new BLabel();
        this.ewfGrid.add(null, (BValue)this.historyRamUsageLabel);
        this.buttons = new BGridPane(1);
        this.buttons.setColumnAlign(BHalign.fill);
        this.buttons.setValign(BValign.top);
        this.detailsCommand = new ConfigDetailsCommand(this);
        this.authCommand = new AuthenticationCommand();
        this.sslSettingsCommand = new SSLSettingsCommand();
        this.updatePortCommand = new UpdatePortCommand();
        this.updateTimeCommand = new UpdateTimeCommand();
        this.logSettingsCommand = new LogSettingsCommand();
        this.outputDialogCommand = new OutputDialogCommand();
        this.moduleContentCommand = new ModuleContentCommand();
        this.rebootCommand = new RebootCommand(this);
        this.vmTuningCommand = new VmTuningCommand();
        this.systemPasswordCommand = new UpdateSystemPasswordCommand();
        this.commissioningCommand = new CommissioningCommand();
        this.backupCommand = new BackupCommand();
        this.sedonaCommand = new SedonaCommand();
        this.niagaraR2Command = new NiagaraR2Command();
        this.advancedOptionsCommand = new AdvancedOptionsCommand();
        this.contentGrid = new BGridPane(2);
        this.contentGrid.setRowAlign(BValign.fill);
        this.contentGrid.setHalign(BHalign.left);
        this.contentGrid.setValign(BValign.top);
        this.contentGrid.add(null, (BValue)new BBorderPane((BWidget)this.buttons, 4.0, 8.0, 4.0, 8.0));
        this.contentGrid.add(null, (BValue)new BBorderPane((BWidget)this.ledger, 0.0, 8.0, 0.0, 8.0));
        this.scrollPane = new BScrollPane((BWidget)this.contentGrid);
        this.scrollPane.setBorderPolicy(BScrollBarPolicy.asNeeded);
        this.scrollPane.setViewportBackground(Theme.scrollPane().getControlBackground());
    }

    protected void doLoadSession(BDaemonSession bDaemonSession, Context context) throws AuthenticationException {
        try {
            String string;
            String string2;
            BFilesystemAttributes bFilesystemAttributes;
            BDaemonPlatform bDaemonPlatform = this.getDaemonPlatform();
            if (bDaemonPlatform == null) {
                throw new ConnectException("Not connected to the platform!");
            }
            BPart bPart = bDaemonPlatform.getSingleModulePart("baja", (DaemonSessionTaskListener)this);
            if (bPart == null) {
                this.bajaVersionLabel.setText("");
            } else {
                this.bajaVersionLabel.setText(bPart.getVersion().toString(context));
            }
            BDaemonDirectoryStore bDaemonDirectoryStore = BDaemonDirectoryStore.make((BDaemonFileSpace)bDaemonSession.getFileSpace(), (FilePath)new FilePath("!"), (boolean)false, (boolean)false, (boolean)true, null);
            this.homeDirLabel.setText(bDaemonDirectoryStore.getLocalPath());
            try {
                this.timeZones = DaemonTimeUtil.getLocalTimeZones((BDaemonSession)bDaemonSession);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.timeZones = new BTimeZone[]{DaemonTimeUtil.getOsTimeZone((BDaemonSession)bDaemonSession)};
                Nre.dumpThreads();
            }
            this.addressLabel.setText(bDaemonSession.getRemoteHost().getNavDisplayName(null));
            this.portLabel.setText(String.valueOf(bDaemonPlatform.getPort()));
            this.hostIdLabel.setText(bDaemonPlatform.getHostId());
            this.moduleContentLabel.setText(this.getLexicon().getText("ModuleContent." + bDaemonPlatform.getModuleContent().getTag()));
            this.stripLabel.setText(String.valueOf(bDaemonPlatform.getStripLineNumbers()));
            this.archLabel.setText(bDaemonPlatform.getArchPart().getPartName());
            this.niagaraStationsLabel.setText(bDaemonPlatform.getNiagaraStationsEnabled() ? this.getLexicon().getText("PlatformAdministration.niagaraStationsEnabled.enabled") : this.getLexicon().getText("PlatformAdministration.niagaraStationsEnabled.disabled"));
            if (bDaemonPlatform.getSedonaSupported()) {
                this.sedonaStatus.setText(bDaemonPlatform.getSedonaEnabled() ? this.getLexicon().getText("PlatformAdministration.sedonaSupport.enabled") : this.getLexicon().getText("PlatformAdministration.sedonaSupport.disabled"));
            } else {
                this.sedonaStatus.setText(this.getLexicon().getText("PlatformAdministration.sedonaSupport.unsupported"));
                if (this.sedonaStatus.getParent() == this.ledger) {
                    this.ledger.remove((BComplex)this.sedonaStatus);
                }
                if (this.sedonaLabel.getParent() == this.ledger) {
                    this.ledger.remove((BComplex)this.sedonaLabel);
                }
            }
            this.sedonaCommand.update(bDaemonPlatform.getSedonaSupported(), bDaemonPlatform.getSedonaEnabled());
            if (bDaemonPlatform.getNiagaraR2Supported()) {
                this.niagaraR2Status.setText(bDaemonPlatform.getNiagaraR2Enabled() ? this.getLexicon().getText("PlatformAdministration.niagaraR2Support.enabled") : this.getLexicon().getText("PlatformAdministration.niagaraR2Support.disabled"));
            } else {
                this.niagaraR2Status.setText(this.getLexicon().getText("PlatformAdministration.niagaraR2Support.unsupported"));
                if (this.niagaraR2Status.getParent() == this.ledger) {
                    this.ledger.remove((BComplex)this.niagaraR2Status);
                }
                if (this.niagaraR2Label.getParent() == this.ledger) {
                    this.ledger.remove((BComplex)this.niagaraR2Label);
                }
            }
            this.niagaraR2Command.update(bDaemonPlatform.getNiagaraR2Supported(), bDaemonPlatform.getNiagaraR2Enabled());
            this.setSSLSupportedLabel(bDaemonSession);
            BOsPart bOsPart = bDaemonPlatform.getOsPart();
            String string3 = bOsPart.getDescription();
            if (string3 == null || string3.trim().length() == 0) {
                string3 = bOsPart.getPartName();
            }
            this.osLabel.setText(BVersion.formatNameVersion((String)string3, (BVersion)bOsPart.getVersion(), (Context)context));
            BNrePart bNrePart = bDaemonPlatform.getNrePart();
            if (bNrePart.isNull()) {
                this.nreLabel.setText(this.getLexicon().getText("PlatformAdministration.unknownValue"));
            } else {
                this.nreLabel.setText(BVersion.formatNameVersion((String)bNrePart.getPartName(), (BVersion)bNrePart.getVersion(), (Context)context));
            }
            BModelPart bModelPart = bDaemonPlatform.getModelPart();
            if (bModelPart == null || bModelPart.isNull()) {
                this.modelLabel.setText(this.getLexicon().getText("PlatformAdministration.noneValue"));
            } else {
                this.modelLabel.setText(bModelPart.getPartName());
            }
            BVmPart bVmPart = bDaemonPlatform.getVmPart();
            if (bVmPart == null || bVmPart.isNull()) {
                this.vmLabel.setText(this.getLexicon().getText("PlatformAdministration.noneValue"));
            } else if (bVmPart.getUnspecified()) {
                this.vmLabel.setText(Lexicon.make((String)"platform").getText("unspecifiedVm.label"));
            } else {
                this.vmLabel.setText(BVersion.formatNameVersion((BPart)bVmPart, (Context)context));
            }
            this.numCpusLabel.setText(String.valueOf(bDaemonSession.getHostProperties().getNumCpus()));
            int n = bDaemonSession.getHostProperties().getCurrentCpuUsage();
            if (n < 0) {
                this.currentCpuLabel.setText(this.getLexicon().getText("PlatformAdministration.unavailable"));
            } else {
                this.currentCpuLabel.setText(n + "%");
            }
            int n2 = bDaemonSession.getHostProperties().getOverallCpuUsage();
            if (n < 0) {
                this.overallCpuLabel.setText(this.getLexicon().getText("PlatformAdministration.unavailable"));
            } else {
                this.overallCpuLabel.setText(n2 + "%");
            }
            int n3 = bDaemonSession.getHostProperties().getFreePhysicalMemory();
            if (n3 < 0) {
                this.freePhysicalMemoryLabel.setText(this.getLexicon().getText("PlatformAdministration.unavailable"));
            } else {
                this.freePhysicalMemoryLabel.setText(DaemonFileUtil.kbFormat.format(n3));
            }
            int n4 = bDaemonSession.getHostProperties().getTotalPhysicalMemory();
            if (n4 < 0) {
                this.totalPhysicalMemoryLabel.setText(this.getLexicon().getText("PlatformAdministration.unavailable"));
            } else {
                this.totalPhysicalMemoryLabel.setText(DaemonFileUtil.kbFormat.format(n4));
            }
            this.filesystemPane.removeAll();
            this.filesystemPane.add(null, (BValue)new BNullWidget());
            this.filesystemPane.add(null, (BValue)LabelUtil.makeLabel((LexiconText)LexiconText.make((Type)TYPE, (String)"PlatformAdministration.totalKb"), (boolean)true, (BHalign)BHalign.center));
            this.filesystemPane.add(null, (BValue)LabelUtil.makeLabel((LexiconText)LexiconText.make((Type)TYPE, (String)"PlatformAdministration.freeKb"), (boolean)true, (BHalign)BHalign.center));
            this.filesystemPane.add(null, (BValue)LabelUtil.makeLabel((LexiconText)LexiconText.make((Type)TYPE, (String)"PlatformAdministration.blockSize"), (boolean)true, (BHalign)BHalign.center));
            if (bDaemonSession.getHostProperties().getOsName().toLowerCase().startsWith("qnx")) {
                this.filesystemPane.add(null, (BValue)LabelUtil.makeLabel((LexiconText)LexiconText.make((Type)TYPE, (String)"PlatformAdministration.currentFileCount"), (boolean)true, (BHalign)BHalign.center));
                this.filesystemPane.add(null, (BValue)LabelUtil.makeLabel((LexiconText)LexiconText.make((Type)TYPE, (String)"PlatformAdministration.maxFileCount"), (boolean)true, (BHalign)BHalign.center));
            } else {
                this.filesystemPane.add(null, (BValue)new BNullWidget());
                this.filesystemPane.add(null, (BValue)new BNullWidget());
            }
            Property[] propertyArray = bDaemonSession.getHostProperties().getFilesystemAttributes().getProperties();
            while (propertyArray.next()) {
                Property property = propertyArray.property();
                this.filesystemPane.add(null, (BValue)new BLabel(SlotPath.unescape((String)property.getName()), BHalign.left));
                bFilesystemAttributes = (BFilesystemAttributes)propertyArray.get();
                this.filesystemPane.add(property.getName() + "total", (BValue)new BLabel(DaemonFileUtil.kbFormat.format(bFilesystemAttributes.getTotalSpace()), BHalign.right));
                this.filesystemPane.add(property.getName() + "free", (BValue)new BLabel(DaemonFileUtil.kbFormat.format(bFilesystemAttributes.getFreeSpace()), BHalign.right));
                this.filesystemPane.add(property.getName() + "block", (BValue)new BLabel(DaemonFileUtil.byteFormat.format(bFilesystemAttributes.getBlockSize()), BHalign.right));
                if (bDaemonSession.getHostProperties().getOsName().toLowerCase().startsWith("qnx")) {
                    string2 = bFilesystemAttributes.getCurrentFileCount() < 0L ? this.getLexicon().getText("PlatformAdministration.unavailable") : String.valueOf(bFilesystemAttributes.getCurrentFileCount());
                    string = bFilesystemAttributes.getMaxFileCount() < 0L ? this.getLexicon().getText("PlatformAdministration.unavailable") : String.valueOf(bFilesystemAttributes.getMaxFileCount());
                    this.filesystemPane.add(property.getName() + "currentFile", (BValue)new BLabel(string2, BHalign.right));
                    this.filesystemPane.add(property.getName() + "maxFile", (BValue)new BLabel(string, BHalign.right));
                    continue;
                }
                this.filesystemPane.add(null, (BValue)new BNullWidget());
                this.filesystemPane.add(null, (BValue)new BNullWidget());
            }
            propertyArray = bDaemonPlatform.getOtherParts().getPropertiesArray();
            this.otherGrid.removeAll();
            if (propertyArray.length == 0) {
                this.otherGrid.add(null, (BValue)new BLabel(this.getLexicon().getText("PlatformAdministration.noneValue")));
            } else {
                for (int i = 0; i < propertyArray.length; ++i) {
                    bFilesystemAttributes = (BGenericPart)bDaemonPlatform.getOtherParts().get(propertyArray[i]);
                    this.otherGrid.add(null, (BValue)new BLabel(BVersion.formatNameVersion((BPart)bFilesystemAttributes, (Context)context)));
                }
            }
            this.displayEwf(bDaemonSession);
            this.buttons.removeAll();
            this.buttons.add(null, (BValue)new BButton(this.detailsCommand));
            this.buttons.add(null, (BValue)new BButton(this.authCommand));
            if (bDaemonSession.getHostProperties().supportsServlet("systempwax")) {
                this.buttons.add(null, (BValue)new BButton(this.systemPasswordCommand));
            }
            this.buttons.add(null, (BValue)new BButton(this.updatePortCommand));
            this.buttons.add(null, (BValue)new BButton(this.sslSettingsCommand));
            this.sslSettingsCommand.setEnabled(bDaemonSession.getHostProperties().getSslSupported() && bDaemonSession.getHostProperties().getSslSettings() != null && bDaemonSession.getHostProperties().getSslSettings().getSslLicensed());
            this.buttons.add(null, (BValue)new BButton(this.updateTimeCommand));
            if (bDaemonSession.getHostProperties().getOsName().toLowerCase().startsWith("qnx")) {
                this.buttons.add(null, (BValue)new BButton(this.advancedOptionsCommand));
            }
            this.buttons.add(null, (BValue)new BButton(this.logSettingsCommand));
            this.buttons.add(null, (BValue)new BButton(this.outputDialogCommand));
            this.buttons.add(null, (BValue)new BButton(this.moduleContentCommand));
            this.buttons.add(null, (BValue)new BButton(this.backupCommand));
            this.buttons.add(null, (BValue)new BButton(this.commissioningCommand));
            if (bDaemonSession.getHostProperties().getNiagaraR2Supported()) {
                this.buttons.add(null, (BValue)new BButton((Command)this.niagaraR2Command));
            }
            this.buttons.add(null, (BValue)new BButton((Command)this.rebootCommand));
            this.rebootCommand.checkEnabled();
            this.updateTimeCommand.setEnabled(bDaemonSession.getHostProperties().hasFullAccess() && this.timeZones.length > 0);
            this.commissioningCommand.setEnabled(!bDaemonSession.getHostProperties().getNiagaraR2Enabled() && !bDaemonSession.usesLocalNiagaraEnvironment());
            this.moduleContentCommand.setEnabled(!bDaemonSession.getHostProperties().getNiagaraR2Enabled() && !bDaemonSession.usesLocalNiagaraEnvironment());
            this.authCommand.setEnabled(bDaemonSession.getHostProperties().hasFullAccess() || bDaemonSession.getHostProperties().getAccessLevel() == BDaemonAccessLevel.restricted && bDaemonSession.getHostProperties().getOsName().equalsIgnoreCase("linux"));
            try {
                boolean bl = false;
                bFilesystemAttributes = XParser.make((InputStream)this.getDaemonSession().getInputStream((DaemonMessage)new XmlResponseMessage(){

                    public String getMessageString() {
                        return "auth";
                    }
                }, "text/xml")).parse();
                string2 = bFilesystemAttributes.elem("auth");
                string = string2.elem("user");
                if (string != null) {
                    bl = string.getb("default", false);
                }
                this.factoryDefaultCredentials = bl;
            }
            catch (Exception exception) {
                this.factoryDefaultCredentials = false;
            }
            try {
                if (bDaemonSession.getHostProperties().supportsServlet("qnxinetd")) {
                    XElem xElem = XParser.make((InputStream)bDaemonSession.getInputStream((DaemonMessage)QnxInetdMessage.getInstance(), 0)).parse();
                    this.ftpEnabled = xElem.geti("fp", -1) != -1;
                    this.telnetEnabled = xElem.geti("tp", -1) != -1;
                }
            }
            catch (Exception exception) {
                this.ftpEnabled = false;
                this.telnetEnabled = false;
            }
            if (bDaemonSession.getHostProperties().supportsServlet("qnxsshd")) {
                try {
                    XElem xElem = XParser.make((InputStream)bDaemonSession.getInputStream((DaemonMessage)QnxSshdMessage.getInstance(), 0)).parse();
                    this.sshdEnabled = xElem.geti("port", -1) != -1;
                }
                catch (Exception exception) {
                    this.sshdEnabled = false;
                }
            }
            if (bDaemonSession.getHostProperties().supportsServlet("systempwax")) {
                try {
                    XElem xElem = XParser.make((InputStream)bDaemonSession.getInputStream((DaemonMessage)new SystemPasswordMessageAX(), "text/xml")).parse();
                    this.factoryDefaultSystemPassword = xElem.getb("default", false);
                }
                catch (Exception exception) {
                    this.factoryDefaultSystemPassword = false;
                }
            }
            try {
                if (bDaemonSession.getHostProperties().supportsServlet("debug")) {
                    XElem xElem = XParser.make((InputStream)bDaemonSession.getInputStream((DaemonMessage)new DaemonDebugMessage())).parse();
                    this.daemonDebugEnabled = xElem.getb("daemonDebug", false);
                }
            }
            catch (Exception exception) {
                this.daemonDebugEnabled = false;
            }
            this.setContent((BWidget)this.scrollPane);
            this.startRefreshTimer();
        }
        catch (ConnectException connectException) {
        }
        catch (AuthenticationException authenticationException) {
            throw authenticationException;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new BajaRuntimeException((Throwable)exception);
        }
    }

    protected void setSSLSupportedLabel(BDaemonSession bDaemonSession) {
        BPlatformSSLSettings bPlatformSSLSettings;
        String string = null;
        string = bDaemonSession.getHostProperties().getSslSupported() ? ((bPlatformSSLSettings = bDaemonSession.getHostProperties().getSslSettings()).getSslLicensed() ? (bPlatformSSLSettings.getSslEnabled() ? (bPlatformSSLSettings.getSslOnly() ? "PlatformAdministration.command.sslSettings.status.sslOnly" : "PlatformAdministration.command.sslSettings.status.sslEnabled") : "PlatformAdministration.command.sslSettings.status.sslDisabled") : "PlatformAdministration.command.sslSettings.status.sslNotLicensed") : "PlatformAdministration.sslNotSupported";
        this.sslSupportedLabel.setText(TextUtil.toLowerCase((String)this.getLexicon().getText(string)));
    }

    private void displayEwf(BDaemonSession bDaemonSession) {
        Property property = this.ledger.getProperty("ewfLabel");
        Property property2 = this.ledger.getProperty("ewfGrid");
        boolean bl = false;
        SlotCursor slotCursor = bDaemonSession.getHostProperties().getEwfOverlays().getProperties();
        while (slotCursor.next(class$com$tridium$platform$ewf$BEwfOverlayAttributes == null ? BPlatformAdministration.class$("com.tridium.platform.ewf.BEwfOverlayAttributes") : class$com$tridium$platform$ewf$BEwfOverlayAttributes)) {
            BEwfOverlayAttributes bEwfOverlayAttributes = (BEwfOverlayAttributes)slotCursor.get();
            if (slotCursor.property().getName().charAt(0) == 'C' || slotCursor.property().getName().charAt(0) == 'C') {
                this.osEnableStateLabel.setText(bEwfOverlayAttributes.getEnableState().toString());
                this.osBootCommandLabel.setText(bEwfOverlayAttributes.getBootCommand().toString());
                this.osRamUsageLabel.setText(mbFormat.format(bEwfOverlayAttributes.getRamUsage()));
                bl = true;
                continue;
            }
            if (slotCursor.property().getName().charAt(0) != 'E' && slotCursor.property().getName().charAt(0) != 'C') continue;
            this.historyEnableStateLabel.setText(bEwfOverlayAttributes.getEnableState().toString());
            this.historyBootCommandLabel.setText(bEwfOverlayAttributes.getBootCommand().toString());
            this.historyRamUsageLabel.setText(mbFormat.format(bEwfOverlayAttributes.getRamUsage()));
            bl = true;
        }
        if (bl) {
            if (property == null) {
                this.ledger.add("ewfLabel", (BValue)this.ewfLabel);
                this.ledger.add("ewfGrid", (BValue)this.ewfGrid);
            }
        } else if (property != null) {
            this.ledger.remove(property);
            this.ledger.remove(property2);
        }
    }

    public void activated() {
        super.activated();
        this.startRefreshTimer();
    }

    public void deactivated() {
        super.deactivated();
        this.stopRefreshTimer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRefresh() {
        Object object = this.RESTART_LOCK;
        synchronized (object) {
            if (this.restarting || this.getDaemonSession() == null) {
                return;
            }
            try {
                int n;
                int n2;
                int n3;
                int n4;
                this.getDaemonSession().updateHostProperties();
                if (this.timeZones != null && this.timeZones.length > 0) {
                    XElem xElem = DaemonTimeUtil.getCurrentTimeElem((BDaemonSession)this.getDaemonSession());
                    BTimeZone bTimeZone = null;
                    BAbsTime bAbsTime = null;
                    if (xElem != null) {
                        bTimeZone = DaemonTimeUtil.getLocalTimeZone((XElem)xElem, (BTimeZone[])this.timeZones);
                        bAbsTime = DaemonTimeUtil.getLocalTime((BDaemonSession)this.getDaemonSession(), (XElem)xElem, (BTimeZone)bTimeZone, (BTimeZone[])this.timeZones);
                    }
                    this.tzLabel.setText(bTimeZone == null ? "" : bTimeZone.toString());
                    if (bAbsTime != null) {
                        this.dateLabel.setText(bAbsTime.toDateString(null));
                    }
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append(bAbsTime.getHour());
                    stringBuffer.append(':');
                    if (bAbsTime.getMinute() < 10) {
                        stringBuffer.append('0');
                    }
                    stringBuffer.append(bAbsTime.getMinute());
                    stringBuffer.append(" " + bAbsTime.getTimeZone().getDisplayName(bAbsTime.inDaylightTime(), null));
                    this.timeLabel.setText(stringBuffer.toString());
                }
                if ((n4 = this.getDaemonSession().getHostProperties().getCurrentCpuUsage()) >= 0) {
                    this.currentCpuLabel.setText(n4 + "%");
                }
                if ((n3 = this.getDaemonSession().getHostProperties().getOverallCpuUsage()) >= 0) {
                    this.overallCpuLabel.setText(n3 + "%");
                }
                if ((n2 = this.getDaemonSession().getHostProperties().getFreePhysicalMemory()) >= 0) {
                    this.freePhysicalMemoryLabel.setText(DaemonFileUtil.kbFormat.format(n2));
                }
                if ((n = this.getDaemonSession().getHostProperties().getTotalPhysicalMemory()) >= 0) {
                    this.totalPhysicalMemoryLabel.setText(DaemonFileUtil.kbFormat.format(n));
                }
                SlotCursor slotCursor = this.getDaemonSession().getHostProperties().getFilesystemAttributes().getProperties();
                while (slotCursor.next()) {
                    String string;
                    BLabel bLabel;
                    BLabel bLabel2;
                    Property property = slotCursor.property();
                    BFilesystemAttributes bFilesystemAttributes = (BFilesystemAttributes)slotCursor.get();
                    BLabel bLabel3 = (BLabel)this.filesystemPane.get(property.getName() + "total");
                    if (bLabel3 != null) {
                        bLabel3.setText(DaemonFileUtil.kbFormat.format(bFilesystemAttributes.getTotalSpace()));
                    }
                    if ((bLabel2 = (BLabel)this.filesystemPane.get(property.getName() + "free")) != null) {
                        bLabel2.setText(DaemonFileUtil.kbFormat.format(bFilesystemAttributes.getFreeSpace()));
                    }
                    if ((bLabel = (BLabel)this.filesystemPane.get(property.getName() + "currentFile")) != null) {
                        string = bFilesystemAttributes.getCurrentFileCount() < 0L ? this.getLexicon().getText("PlatformAdministration.unavailable") : String.valueOf(bFilesystemAttributes.getCurrentFileCount());
                        bLabel.setText(string);
                    }
                    if ((string = (BLabel)this.filesystemPane.get(property.getName() + "maxFile")) == null) continue;
                    String string2 = bFilesystemAttributes.getMaxFileCount() < 0L ? this.getLexicon().getText("PlatformAdministration.unavailable") : String.valueOf(bFilesystemAttributes.getMaxFileCount());
                    string.setText(string2);
                }
                this.displayEwf(this.getDaemonSession());
            }
            catch (ConnectException connectException) {
            }
            catch (AuthenticationException authenticationException) {
                this.reauthenticate(authenticationException);
            }
        }
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        StringBuilder stringBuilder = new StringBuilder();
        if (this.factoryDefaultCredentials) {
            stringBuilder.append(LexiconText.make((Type)TYPE, (String)"PlatformAdministration.defaultCredentialsWarning").getText(null));
        }
        if (this.telnetEnabled) {
            if (stringBuilder.length() != 0) {
                stringBuilder.append("\n");
            }
            stringBuilder.append(LexiconText.make((Type)TYPE, (String)"PlatformAdministration.telnetEnabledWarning").getText(null));
        }
        if (this.ftpEnabled) {
            if (stringBuilder.length() != 0) {
                stringBuilder.append("\n");
            }
            stringBuilder.append(LexiconText.make((Type)TYPE, (String)"PlatformAdministration.ftpEnabledWarning").getText(null));
        }
        if (this.sshdEnabled) {
            if (stringBuilder.length() != 0) {
                stringBuilder.append("\n");
            }
            stringBuilder.append(LexiconText.make((Type)TYPE, (String)"PlatformAdministration.sshdEnabledWarning").getText(null));
        }
        if (this.factoryDefaultSystemPassword) {
            if (stringBuilder.length() != 0) {
                stringBuilder.append("\n");
            }
            stringBuilder.append(LexiconText.make((Type)TYPE, (String)"PlatformAdministration.defaultSystemPasswordWarning").getText(null));
        }
        if (this.daemonDebugEnabled) {
            if (stringBuilder.length() != 0) {
                stringBuilder.append("\n");
            }
            stringBuilder.append(LexiconText.make((Type)TYPE, (String)"PlatformAdministration.daemonDebugEnabledWarning").getText(null));
        }
        if (stringBuilder.length() != 0) {
            double d = this.getWidth();
            double d2 = this.getHeight();
            BLabel bLabel = new BLabel(stringBuilder.toString(), BHalign.left);
            bLabel.setImage(faultIcon);
            bLabel.computePreferredSize();
            double d3 = bLabel.getPreferredWidth();
            double d4 = bLabel.getPreferredHeight();
            double d5 = Math.max(10.0, d - d3 - 20.0);
            double d6 = Math.max(10.0, d2 - d4 - 20.0);
            bLabel.setBounds(0.0, 0.0, d3, d4);
            bLabel.doLayout(null);
            graphics.setBrush(BColor.make((int)255, (int)255, (int)0, (int)180));
            graphics.fillRect(d5 - 10.0, d6 - 10.0, d3 + 20.0, d4 + 20.0);
            graphics.setBrush(BColor.black);
            graphics.strokeRect(d5 - 10.0, d6 - 10.0, d3 + 20.0, d4 + 20.0);
            graphics.translate(d5, d6);
            bLabel.paint(graphics);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class SetSedonaEnabledMessage
    extends XmlResponseMessage {
        private String path;

        public SetSedonaEnabledMessage(boolean bl) {
            this.path = "updatedaemon?sedonaEnabled=" + bl;
        }

        public String getMessageString() {
            return this.path;
        }
    }

    public class BackupCommand
    extends AsyncCommand {
        public BackupCommand() {
            super((BWidget)BPlatformAdministration.this, TYPE.getModule(), "PlatformAdministration.command.backup");
        }

        public void doInvokeAsync() {
            try {
                if (BStationSurrogate.isAnyStationRunning((BDaemonSession)BPlatformAdministration.this.getDaemonSession())) {
                    BStationSurrogate[] bStationSurrogateArray = BStationSurrogate.makeAll((BDaemonSession)BPlatformAdministration.this.getDaemonSession());
                    for (int i = 0; i < bStationSurrogateArray.length; ++i) {
                        if (!bStationSurrogateArray[i].isStationRunning()) continue;
                        if (4 != BDialog.confirm((BWidget)this.getOwner(), (String)BPlatformAdministration.this.getLexicon().getText("PlatformAdministration.command.backup.connectStationTitle"), (Object)BPlatformAdministration.this.getLexicon().getText("PlatformAdministration.command.backup.connectStationMessage", new Object[]{bStationSurrogateArray[i].getStationName()}), (int)12)) {
                            return;
                        }
                        BOrd bOrd = bStationSurrogateArray[i].getFoxsOrd();
                        if (bOrd.isNull()) {
                            bOrd = bStationSurrogateArray[i].getFoxOrd();
                        }
                        OrdTarget ordTarget = null;
                        while (ordTarget == null) {
                            try {
                                ordTarget = bOrd.resolve();
                            }
                            catch (AuthenticationException authenticationException) {
                                if (AuthUtil.challenge((BWidget)this.getOwner(), (AuthenticationException)authenticationException)) continue;
                                throw authenticationException;
                            }
                            catch (UnresolvedException unresolvedException) {
                                return;
                            }
                        }
                        Class clazz = Sys.loadClass((String)"backup", (String)"com.tridium.backup.ui.BBackupManager");
                        Method method = clazz.getMethod("stationBackupCommand", class$javax$baja$ui$BWidget == null ? (class$javax$baja$ui$BWidget = BPlatformAdministration.class$("javax.baja.ui.BWidget")) : class$javax$baja$ui$BWidget, class$javax$baja$sys$BObject == null ? (class$javax$baja$sys$BObject = BPlatformAdministration.class$("javax.baja.sys.BObject")) : class$javax$baja$sys$BObject);
                        method.invoke(null, this.getOwner(), ordTarget.get());
                        return;
                    }
                } else {
                    BackupDistCommand backupDistCommand = new BackupDistCommand(this.getOwner(), BPlatformAdministration.this.getDaemonPlatform(), BPlatformAdministration.this.getCurrentContext());
                    backupDistCommand.invoke();
                }
            }
            catch (Throwable throwable) {
                CommandUtil.error((Command)this, (Throwable)throwable);
            }
        }
    }

    public class CommissioningCommand
    extends Command {
        public CommissioningCommand() {
            super((BWidget)BPlatformAdministration.this, TYPE.getModule(), "PlatformAdministration.command.commissioning");
        }

        public CommandArtifact doInvoke() {
            try {
                BPlatformAdministration.this.stopRefreshTimer();
                BWizard.open((BWidget)this.getOwner(), (WizardModel)new CommissioningWizardModel(this.getOwner(), BPlatformAdministration.this.getDaemonSession(), false));
                BPlatformAdministration.this.loadValue((BObject)BPlatformAdministration.this.getDaemonSession());
            }
            catch (Throwable throwable) {
                CommandUtil.error((Command)this, (Throwable)throwable);
            }
            return null;
        }
    }

    public class AdvancedOptionsCommand
    extends Command {
        public AdvancedOptionsCommand() {
            super((BWidget)BPlatformAdministration.this, TYPE.getModule(), "PlatformAdministration.command.advancedOptions");
        }

        public CommandArtifact doInvoke() throws Exception {
            if (AdvancedOptionsPrompt.updateSettings((BWidget)BPlatformAdministration.this, BPlatformAdministration.this.getDaemonSession())) {
                BPlatformAdministration.this.doLoadSession(BPlatformAdministration.this.getDaemonSession(), null);
            }
            return null;
        }
    }

    private class UpdateSystemPasswordCommand
    extends Command {
        public UpdateSystemPasswordCommand() {
            super((BWidget)BPlatformAdministration.this, TYPE.getModule(), "PlatformAdministration.command.systemPassword");
        }

        public CommandArtifact doInvoke() throws Exception {
            int n;
            if (!BPlatformAdministration.this.getDaemonSession().isSecure() && (n = BDialog.open((BWidget)BPlatformAdministration.this, (String)BPlatformAdministration.this.getLexicon().getText("nonsecure.warning.dialog.title"), (Object)BPlatformAdministration.this.getLexicon().getText("nonsecure.warning.dialog.msg"), (int)12, (BImage)BDialog.WARNING_ICON, (String)null)) == 8) {
                return null;
            }
            if (SystemPasswordPrompt.updateSettings((BWidget)BPlatformAdministration.this, BPlatformAdministration.this.getDaemonSession())) {
                BPlatformAdministration.this.doLoadSession(BPlatformAdministration.this.getDaemonSession(), null);
            }
            return null;
        }
    }

    public class VmTuningCommand
    extends Command {
        public VmTuningCommand() {
            super((BWidget)BPlatformAdministration.this, TYPE.getModule(), "PlatformAdministration.command.vmTuning");
        }

        public CommandArtifact doInvoke() throws Exception {
            boolean bl = BVmTuningPrompt.prompt((BWidget)BPlatformAdministration.this, BPlatformAdministration.this.getDaemonSession());
            if (bl && BPlatformAdministration.this.areAppsRunning() && BPlatformAdministration.this.rebootCommand != null) {
                BPlatformAdministration.this.rebootCommand.invoke();
            }
            return null;
        }
    }

    public class ModuleContentCommand
    extends Command {
        public ModuleContentCommand() {
            super((BWidget)BPlatformAdministration.this, TYPE.getModule(), "PlatformAdministration.command.moduleContent");
        }

        public CommandArtifact doInvoke() throws Exception {
            BWizard.open((BWidget)BPlatformAdministration.this, (WizardModel)new ModuleContentWizardModel((BWidget)BPlatformAdministration.this, BPlatformAdministration.this.getDaemonSession()));
            BPlatformAdministration.this.moduleContentLabel.setText(BPlatformAdministration.this.getLexicon().getText("ModuleContent." + BPlatformAdministration.this.getDaemonPlatform().getModuleContent().getTag()));
            return null;
        }
    }

    private class OutputDialogCommand
    extends Command {
        public OutputDialogCommand() {
            super((BWidget)BPlatformAdministration.this, TYPE.getModule(), "PlatformAdministration.command.outputDialog");
        }

        public CommandArtifact doInvoke() throws Exception {
            new BOutputDialog(this.getOwner(), BPlatformAdministration.this.getDaemonSession()).open();
            return null;
        }
    }

    private class SSLSettingsCommand
    extends RestartSessionCommand {
        public SSLSettingsCommand() {
            super(BPlatformAdministration.this, TYPE.getModule(), "PlatformAdministration.command.sslSettings");
        }

        public CommandArtifact doInvoke() throws Exception {
            BDaemonSSLSettingsView bDaemonSSLSettingsView = new BDaemonSSLSettingsView();
            bDaemonSSLSettingsView.doLoadSession(BPlatformAdministration.this.getDaemonSession(), null);
            DialogCommand[] dialogCommandArray = new DialogCommand[]{bDaemonSSLSettingsView.getSaveCommand(), DialogCommand.makeCancel((BWidget)bDaemonSSLSettingsView)};
            String string = BPlatformAdministration.this.getLexicon().getText("PlatformAdministration.command.sslSettings");
            int n = BCommandDialog.open((BWidget)this.getOwner(), (String)string, (Object)bDaemonSSLSettingsView, (DialogCommand[])dialogCommandArray);
            if (n == 1) {
                BPlatformSSLSettings bPlatformSSLSettings = BPlatformAdministration.this.getDaemonPlatform().getPlatformSSLSettings();
                BPlatformSSLSettings bPlatformSSLSettings2 = bDaemonSSLSettingsView.getSettings();
                if (bPlatformSSLSettings != null && BPlatformAdministration.this.getDaemonSession().getRemotePort() == bPlatformSSLSettings.getSslPort()) {
                    this.send(new UpdateSSLSettingsMessage(bPlatformSSLSettings2), bPlatformSSLSettings2.getSslPort());
                } else {
                    this.send(new UpdateSSLSettingsMessage(bPlatformSSLSettings2), BPlatformAdministration.this.getDaemonSession().getRemotePort());
                }
            }
            return null;
        }
    }

    private class LogSettingsCommand
    extends Command {
        public LogSettingsCommand() {
            super((BWidget)BPlatformAdministration.this, TYPE.getModule(), "PlatformAdministration.command.logSettings");
        }

        public CommandArtifact doInvoke() {
            BDaemonLogSettingsView bDaemonLogSettingsView = new BDaemonLogSettingsView();
            bDaemonLogSettingsView.loadValue((BObject)BPlatformAdministration.this.getDaemonSession());
            BDialog.message((BWidget)this.getOwner(), (String)BPlatformAdministration.this.getLexicon().getText("PlatformAdministration.command.logSettings.dlgTitle"), (Object)bDaemonLogSettingsView);
            BPlatformAdministration.this.loadValue((BObject)BPlatformAdministration.this.getDaemonSession());
            return null;
        }
    }

    private class ConfigDetailsCommand
    extends AsyncCommand {
        private DaemonSessionTaskListener taskListener = null;

        public ConfigDetailsCommand(DaemonSessionTaskListener daemonSessionTaskListener) {
            super((BWidget)BPlatformAdministration.this, TYPE.getModule(), "PlatformAdministration.command.configDetails");
            this.taskListener = daemonSessionTaskListener;
        }

        public void doInvokeAsync() {
            try {
                BConfigDetailsPane bConfigDetailsPane = new BConfigDetailsPane((BRemoteDaemonPlatform)BPlatformAdministration.this.getDaemonPlatform(), BPlatformAdministration.this.getAppSurrogates(), this.taskListener);
                BCommandDialog.open((BWidget)BPlatformAdministration.this, (String)BPlatformAdministration.this.getLexicon().getText("PlatformAdministration.command.configDetails.label"), (Object)((Object)bConfigDetailsPane), (DialogCommand[])new DialogCommand[]{bConfigDetailsPane.getCopyCommand(), DialogCommand.makeClose((BWidget)bConfigDetailsPane)});
            }
            catch (Exception exception) {
                throw new BajaRuntimeException(BPlatformAdministration.this.getLexicon().getText("PlatformAdministration.command.configDetails.exception"), (Throwable)exception);
            }
        }
    }

    private class AuthenticationCommand
    extends Command {
        public AuthenticationCommand() {
            super((BWidget)BPlatformAdministration.this, TYPE.getModule(), "PlatformAdministration.command.updateAuth");
        }

        public CommandArtifact doInvoke() throws Exception {
            BPlatformAdministration.this.stopRefreshTimer();
            BWizard.open((BWidget)BPlatformAdministration.this, (WizardModel)new AuthenticationWizardModel(BPlatformAdministration.this.getDaemonSession()));
            BPlatformAdministration.this.loadValue((BObject)BPlatformAdministration.this.getDaemonSession());
            return null;
        }
    }

    private class UpdatePortCommand
    extends RestartSessionCommand {
        public UpdatePortCommand() {
            super(BPlatformAdministration.this, TYPE.getModule(), "PlatformAdministration.command.updatePort");
        }

        public CommandArtifact doInvoke() {
            try {
                int n = BPortPrompt.getPort((BWidget)BPlatformAdministration.this, Integer.valueOf(BPlatformAdministration.this.portLabel.getText()));
                if (n > 0 && n != Integer.valueOf(BPlatformAdministration.this.portLabel.getText())) {
                    if (BPlatformAdministration.this.getDaemonSession().getRemotePort() == BPlatformAdministration.this.getDaemonPlatform().getPort()) {
                        this.send((DaemonMessage)new UpdateDaemonMessage(n), n);
                    } else {
                        this.send((DaemonMessage)new UpdateDaemonMessage(n), BPlatformAdministration.this.getDaemonSession().getRemotePort());
                    }
                }
            }
            catch (Exception exception) {
                BDialog.error((BWidget)BPlatformAdministration.this, (String)BPlatformAdministration.this.getLexicon().getText("PlatformAdministration.command.updatePort.errorTitle"), (Object)BPlatformAdministration.this.getLexicon().getText("PlatformAdministration.command.updatePort.errorMessage"), (Throwable)exception);
            }
            return null;
        }
    }

    private class RestartSessionCommand
    extends Command {
        public RestartSessionCommand(BPlatformAdministration bPlatformAdministration2, BModule bModule, String string) {
            super((BWidget)bPlatformAdministration2, bModule, string);
        }

        public void send(UpdateSSLSettingsMessage updateSSLSettingsMessage, int n) throws ConnectException, AuthenticationException {
            BDaemonSession bDaemonSession = null;
            bDaemonSession = BPlatformAdministration.this.getDaemonSession().shouldDowngrade(updateSSLSettingsMessage.getSettings()) ? BDaemonSession.make((BHost)BPlatformAdministration.this.getDaemonSession().getHost(), (int)BPlatformAdministration.this.getDaemonSession().getHostProperties().getHttpPort(), (String[])null) : BPlatformAdministration.this.getDaemonSession().newSession(n);
            this.send((DaemonMessage)updateSSLSettingsMessage, n, bDaemonSession);
        }

        public void send(DaemonMessage daemonMessage, int n) throws ConnectException, AuthenticationException {
            this.send(daemonMessage, n, BPlatformAdministration.this.getDaemonSession().newSession(n));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void send(DaemonMessage daemonMessage, int n, BDaemonSession bDaemonSession) throws ConnectException, AuthenticationException {
            BPlatformAdministration.this.stopRefreshTimer();
            BUsernameAndPassword bUsernameAndPassword = (BUsernameAndPassword)BPlatformAdministration.this.getDaemonSession().getCredentials();
            BWidgetShell bWidgetShell = this.getOwner().getShell();
            BUsernameAndPassword bUsernameAndPassword2 = new BUsernameAndPassword(bUsernameAndPassword.getUsername(), bUsernameAndPassword.getPassword());
            bDaemonSession.setCredentials((BICredentials)bUsernameAndPassword2);
            Object object = BPlatformAdministration.this.RESTART_LOCK;
            synchronized (object) {
                BPlatformAdministration.this.restarting = true;
                this.sendMessage(daemonMessage, bWidgetShell);
                this.reconnect(bUsernameAndPassword2, bWidgetShell, bDaemonSession);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void sendMessage(DaemonMessage daemonMessage, BWidgetShell bWidgetShell) throws ConnectException {
            boolean bl = bWidgetShell != null && bWidgetShell instanceof BWbShell;
            try {
                if (bl) {
                    bWidgetShell.enterBusy();
                }
                BPlatformAdministration.this.getDaemonSession().sendMessage(daemonMessage);
                BPlatformAdministration.this.getDaemonSession().disconnect();
                Thread.sleep(3500L);
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                if (bl) {
                    bWidgetShell.exitBusy();
                }
            }
        }

        private void reconnect(BUsernameAndPassword bUsernameAndPassword, BWidgetShell bWidgetShell, BDaemonSession bDaemonSession) {
            if (bWidgetShell != null && bWidgetShell instanceof BWbShell) {
                BNiagaraWbShell bNiagaraWbShell;
                BWbShell bWbShell = (BWbShell)bWidgetShell;
                BOrd bOrd = BOrd.make((BOrd)bDaemonSession.getAbsoluteOrd().normalize(), (OrdQuery)new ViewQuery(TYPE.toString()));
                bWbShell.hyperlink((HyperlinkInfo)new NHyperlinkInfo(bOrd, BHyperlinkMode.replace, true, (BICredentials)bUsernameAndPassword));
                if (bWidgetShell instanceof BNiagaraWbShell && (bNiagaraWbShell = (BNiagaraWbShell)bWidgetShell).getActiveOrdTarget() != null) {
                    bNiagaraWbShell.syncTree();
                }
            }
        }
    }

    private class NiagaraR2Command
    extends Command {
        private boolean niagaraR2Enabled = false;

        public NiagaraR2Command() {
            super((BWidget)BPlatformAdministration.this, TYPE.getModule(), "PlatformAdministration.command.enableNiagaraR2");
        }

        public void update(boolean bl, boolean bl2) {
            this.niagaraR2Enabled = bl2;
            String string = bl2 ? "disableNiagaraR2" : "enableNiagaraR2";
            this.label = BPlatformAdministration.this.getLexicon().get("PlatformAdministration.command." + string + ".label");
            String string2 = BPlatformAdministration.this.getLexicon().get("PlatformAdministration.command." + string + ".icon");
            this.icon = string2 == null ? null : BImage.make((String)string2);
            String string3 = BPlatformAdministration.this.getLexicon().get("PlatformAdministration.command." + string + ".accelerator");
            this.accelerator = string3 == null ? null : BAccelerator.make((String)string3);
            this.description = BPlatformAdministration.this.getLexicon().get("PlatformAdministration.command." + string + ".description");
            this.setEnabled(bl);
        }

        public CommandArtifact doInvoke() {
            try {
                BPlatformAdministration.this.stopRefreshTimer();
                try {
                    BVersion bVersion = new BVersion(BPlatformAdministration.this.getDaemonSession().getHostProperties().getNrePartVersion());
                    if (!bVersion.meetsVersionRequirement(new BVersion("3.6.32"), BVersionRelation.minimum)) {
                        BDialog.error((BWidget)this.getOwner(), (Object)BPlatformAdministration.this.getLexicon().getText("R2CommissioningWizard.insufficientRemoteNreVersion", new Object[]{BPlatformAdministration.this.getDaemonSession().getHostProperties().getNrePartVersion()}));
                        return null;
                    }
                }
                catch (Exception exception) {
                    BDialog.error((BWidget)this.getOwner(), (Object)BPlatformAdministration.this.getLexicon().getText("R2CommissioningWizard.unknownRemoteNreVersion"));
                    return null;
                }
                BWizard.open((BWidget)this.getOwner(), (WizardModel)new R2CommissioningWizardModel(this.getOwner(), BPlatformAdministration.this.getDaemonSession(), !this.niagaraR2Enabled));
                BPlatformAdministration.this.loadValue((BObject)BPlatformAdministration.this.getDaemonSession());
            }
            catch (Throwable throwable) {
                CommandUtil.error((Command)this, (Throwable)throwable);
            }
            return null;
        }
    }

    private class SedonaCommand
    extends Command {
        private boolean sedonaEnabled = false;

        public SedonaCommand() {
            super((BWidget)BPlatformAdministration.this, TYPE.getModule(), "PlatformAdministration.command.enableSedona");
        }

        public void update(boolean bl, boolean bl2) {
            this.sedonaEnabled = bl2;
            String string = bl2 ? "disableSedona" : "enableSedona";
            this.label = BPlatformAdministration.this.getLexicon().get("PlatformAdministration.command." + string + ".label");
            String string2 = BPlatformAdministration.this.getLexicon().get("PlatformAdministration.command." + string + ".icon");
            this.icon = string2 == null ? null : BImage.make((String)string2);
            String string3 = BPlatformAdministration.this.getLexicon().get("PlatformAdministration.command." + string + ".accelerator");
            this.accelerator = string3 == null ? null : BAccelerator.make((String)string3);
            this.description = BPlatformAdministration.this.getLexicon().get("PlatformAdministration.command." + string + ".description");
            this.setEnabled(bl);
        }

        public CommandArtifact doInvoke() {
            String string;
            String string2 = this.sedonaEnabled ? "disableSedona" : "enableSedona";
            String string3 = string = BPlatformAdministration.this.getDaemonSession().getHostProperties().getOsName().startsWith("win") ? "restart" : "reboot";
            if (4 == BDialog.confirm((BWidget)this.getOwner(), (String)BPlatformAdministration.this.getLexicon().getText("PlatformAdministration.command." + string2 + ".confirmTitle"), (Object)BPlatformAdministration.this.getLexicon().getText("PlatformAdministration.command." + string2 + ".confirmMessage." + string), (int)12)) {
                try {
                    BPlatformAdministration.this.getDaemonSession().sendMessage((DaemonMessage)new SetSedonaEnabledMessage(!this.sedonaEnabled));
                    if (BPlatformAdministration.this.getDaemonSession().getHostProperties().getOsName().startsWith("win")) {
                        BPlatformAdministration.this.getDaemonSession().sendMessage((DaemonMessage)RefreshDaemonBinariesMessage.getInstance());
                    } else {
                        BPlatformAdministration.this.getDaemonSession().sendRebootRequest();
                    }
                }
                catch (Exception exception) {
                    CommandUtil.error((Command)this, (Throwable)exception);
                }
            }
            return null;
        }
    }

    private class UpdateTimeCommand
    extends AsyncCommand {
        public UpdateTimeCommand() {
            super((BWidget)BPlatformAdministration.this, TYPE.getModule(), "PlatformAdministration.command.updateTime");
        }

        public void doInvokeAsync() {
            try {
                BTimePrompt bTimePrompt = BTimePrompt.prompt((BWidget)BPlatformAdministration.this, BPlatformAdministration.this.getDaemonSession(), BPlatformAdministration.this.timeZones);
                if (bTimePrompt != null) {
                    BTimeZone bTimeZone = DaemonTimeUtil.getLocalTimeZone((BDaemonSession)BPlatformAdministration.this.getDaemonSession());
                    BPlatformAdministration.this.getDaemonSession().sendMessage((DaemonMessage)new UpdateTimeMessage(bTimePrompt.getDateTime(), bTimePrompt.getBajaTimeZoneId(), bTimePrompt.getTimeZone()));
                    if (!bTimePrompt.getTimeZone().getId().equals(bTimePrompt.getBajaTimeZoneId())) {
                        BDialog.warning((BWidget)BPlatformAdministration.this, (String)BPlatformAdministration.this.getLexicon().getText("PlatformAdministration.command.updateTime.usingUtcTitle"), (Object)BPlatformAdministration.this.getLexicon().getText("PlatformAdministration.command.updateTime.usingUtcMessage", new Object[]{bTimePrompt.getBajaTimeZoneId(), bTimePrompt.getTimeZone()}));
                    } else if (!bTimeZone.getId().equals(bTimePrompt.getTimeZone().getId())) {
                        if (BPlatformAdministration.this.getDaemonSession().getHostProperties().getModelName().equals("JNXS")) {
                            if (4 == BDialog.confirm((BWidget)BPlatformAdministration.this, (String)BPlatformAdministration.this.getLexicon().getText("PlatformAdministration.command.updateTime.tzTitle"), (Object)BPlatformAdministration.this.getLexicon().getText("PlatformAdministration.command.updateTime.nxs.tzMessage", new Object[]{bTimePrompt.getBajaTimeZoneId()}))) {
                                BPlatformAdministration.this.rebootCommand.doReboot();
                                return;
                            }
                        } else if (BPlatformAdministration.this.areAppsRunning()) {
                            BDialog.warning((BWidget)BPlatformAdministration.this, (String)BPlatformAdministration.this.getLexicon().getText("PlatformAdministration.command.updateTime.tzTitle"), (Object)BPlatformAdministration.this.getLexicon().getText("PlatformAdministration.command.updateTime.tzMessage", new Object[]{bTimePrompt.getBajaTimeZoneId()}));
                        }
                    }
                    BPlatformAdministration.this.refresh();
                }
            }
            catch (Throwable throwable) {
                CommandUtil.error((Command)this, (Throwable)throwable);
            }
        }
    }
}

