/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.config;

import com.tridium.install.BDaemonPlatform;
import com.tridium.install.BRemoteDaemonPlatform;
import com.tridium.install.part.BOsPart;
import com.tridium.net.HttpUtil;
import com.tridium.nre.auth.SecurityUtil;
import com.tridium.platDaemon.ui.acctmgt.WinNtAccount;
import com.tridium.platDaemon.ui.config.DigestFilePasswordController;
import com.tridium.platDaemon.ui.config.QnxUserNameController;
import com.tridium.platDaemon.ui.widget.DaemonCredentialsManager;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.message.DaemonMessage;
import com.tridium.platform.daemon.message.XmlResponseMessage;
import com.tridium.platform.ui.util.BBox;
import com.tridium.platform.ui.util.BIndentPane;
import com.tridium.platform.ui.util.LabelUtil;
import com.tridium.workbench.fieldeditors.BPasswordFE;
import java.io.InputStream;
import javax.baja.gx.BImage;
import javax.baja.gx.Size;
import javax.baja.nre.util.TextUtil;
import javax.baja.security.BICredentials;
import javax.baja.security.BPassword;
import javax.baja.security.BUsernameAndPassword;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BRadioButton;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.ToggleCommandGroup;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.text.TextController;
import javax.baja.ui.text.TextModel;
import javax.baja.ui.wizard.BWizardHeader;
import javax.baja.ui.wizard.WizardModel;
import javax.baja.util.Lexicon;
import javax.baja.util.LexiconText;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

public class AuthenticationWizardModel
extends WizardModel {
    private BDaemonSession session;
    private AuthWizardStep currentStep;
    private String authMethod;
    private String currentAuthMethod;
    private WinNtAccount userGroup = null;
    private WinNtAccount adminGroup = null;
    private String adminUser = "tridium";
    private BPassword adminPassword = BPassword.DEFAULT;
    private XElem authInfo;
    private boolean stationIsAdmin = true;
    private boolean nativeAuthSupported = false;
    private boolean usingDefaultDigestCredentials = false;
    private String queryUsername = "";
    private BPassword queryPassword = BPassword.DEFAULT;
    private UpdateAuthMessage initialAuthMessage = null;
    private static final BImage wizImage = BImage.make((String)"module://icons/x32/keys.png");
    private static final Lexicon lex = Lexicon.make((String)"platDaemon");

    public AuthenticationWizardModel(BDaemonSession bDaemonSession) throws Exception {
        this.session = bDaemonSession;
    }

    public String getTitle() {
        return lex.getText("AuthWizard.title");
    }

    public boolean cancel() {
        if (this.getCurrentStep().getMode() == 0) {
            return true;
        }
        return BDialog.confirm((BWidget)this.getWizard(), (String)lex.getText("AuthWizard.cancel.title"), (Object)lex.getText("AuthWizard.cancel.message")) == 4 && this.getCurrentStep().cancel();
    }

    public void init() {
        AuthWizardStep authWizardStep;
        try {
            this.authInfo = XParser.make((InputStream)this.getDaemonSession().getInputStream((DaemonMessage)new XmlResponseMessage(){

                public String getMessageString() {
                    return "auth";
                }
            }, "text/xml")).parse();
        }
        catch (Exception exception) {
            throw new BajaRuntimeException((Throwable)exception);
        }
        XElem xElem = this.authInfo.elem("auth");
        this.setCurrentAuthMethod(xElem.get("type"));
        this.setAuthMethod(xElem.get("type"));
        this.setStationIsAdmin(xElem.getb("stationIsAdmin", true));
        BOsPart bOsPart = this.getDaemonPlatform().getOsPart();
        boolean bl = bOsPart.getPartName().toLowerCase().startsWith("win");
        this.setNativeAuthSupported(xElem.getb("nativeAuthSupported", bl));
        XElem xElem2 = xElem.elem("usergroup");
        if (xElem2 != null) {
            this.setUserGroup(new WinNtAccount(xElem2.get("name"), xElem2.get("sid", null)));
        }
        if ((xElem2 = xElem.elem("admingroup")) != null) {
            this.setAdminGroup(new WinNtAccount(xElem2.get("name"), xElem2.get("sid", null)));
        }
        if ((xElem2 = xElem.elem("user")) != null) {
            this.setAdminUser(xElem2.get("name"));
            this.setUsingDefaultDigestCredentials(xElem2.getb("default", false));
        }
        this.initialAuthMessage = new UpdateAuthMessage();
        for (authWizardStep = new AuthMethodStep(); authWizardStep != null && ((AuthWizardStep)authWizardStep).isSkipped(); authWizardStep = authWizardStep.getNextStep()) {
        }
        this.update(authWizardStep);
        ((AuthWizardStep)authWizardStep).enter();
    }

    public void back() {
        AuthWizardStep authWizardStep = this.getCurrentStep().getPriorStep();
        if (authWizardStep != null && this.getCurrentStep().exit()) {
            this.update(authWizardStep);
            authWizardStep.enter();
        }
    }

    public void next() {
        AuthWizardStep authWizardStep = this.getCurrentStep().getNextStep();
        if (authWizardStep != null && this.getCurrentStep().exit()) {
            while (authWizardStep != null && authWizardStep.isSkipped()) {
                authWizardStep = authWizardStep.getNextStep();
            }
            authWizardStep.setPriorStep(this.getCurrentStep());
            this.update(authWizardStep);
            authWizardStep.enter();
        }
    }

    public boolean finish() {
        if (!this.getCurrentStep().exit()) {
            return false;
        }
        UpdateAuthMessage updateAuthMessage = new UpdateAuthMessage();
        if (this.initialAuthMessage.getMessageString().equals(updateAuthMessage.getMessageString())) {
            return true;
        }
        try {
            this.getDaemonSession().sendMessage((DaemonMessage)updateAuthMessage);
            Thread.sleep(3000L);
            if (this.getAuthMethod().equals("digest/file")) {
                DaemonCredentialsManager.setCredentials(this.getDaemonSession(), (BICredentials)new BUsernameAndPassword(this.getAdminUser(), this.getAdminPassword()));
            } else {
                DaemonCredentialsManager.setCredentials(this.getDaemonSession(), (BICredentials)new BUsernameAndPassword(this.queryUsername, this.queryPassword));
            }
        }
        catch (Exception exception) {
            BDialog.error((BWidget)this.getWizard(), (String)lex.get("AuthWizard.finish.error.title"), (Object)exception, (Throwable)exception);
            return false;
        }
        return true;
    }

    private AuthWizardStep getCurrentStep() {
        return this.currentStep;
    }

    public void update(AuthWizardStep authWizardStep) {
        this.currentStep = authWizardStep;
        this.update(authWizardStep.getWidget(), authWizardStep.getMode());
    }

    public Size getPreferredSizeOfSteps() {
        return new Size(650.0, 300.0);
    }

    public BDaemonPlatform getDaemonPlatform() {
        try {
            return BRemoteDaemonPlatform.make((BDaemonSession)this.session, null);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new BajaRuntimeException((Throwable)exception);
        }
    }

    public BDaemonSession getDaemonSession() {
        return this.session;
    }

    public String getAuthMethod() {
        return this.authMethod;
    }

    public void setAuthMethod(String string) {
        this.authMethod = string;
    }

    public void setCurrentAuthMethod(String string) {
        this.currentAuthMethod = string;
    }

    public String getCurrentAuthMethod() {
        return this.currentAuthMethod;
    }

    public WinNtAccount getUserGroup() {
        return this.userGroup;
    }

    public void setUserGroup(WinNtAccount winNtAccount) {
        this.userGroup = winNtAccount;
    }

    public WinNtAccount getAdminGroup() {
        return this.adminGroup;
    }

    public void setAdminGroup(WinNtAccount winNtAccount) {
        this.adminGroup = winNtAccount;
    }

    public String getAdminUser() {
        return this.adminUser;
    }

    public void setAdminUser(String string) {
        this.adminUser = string;
    }

    public boolean getUsingDefaultDigestCredentials() {
        return this.usingDefaultDigestCredentials;
    }

    public void setUsingDefaultDigestCredentials(boolean bl) {
        this.usingDefaultDigestCredentials = bl;
    }

    public BPassword getAdminPassword() {
        return this.adminPassword;
    }

    public void setAdminPassword(BPassword bPassword) {
        this.adminPassword = bPassword;
    }

    public boolean getStationIsAdmin() {
        return this.stationIsAdmin;
    }

    public void setStationIsAdmin(boolean bl) {
        this.stationIsAdmin = bl;
    }

    public boolean getNativeAuthSupported() {
        return this.nativeAuthSupported;
    }

    public void setNativeAuthSupported(boolean bl) {
        this.nativeAuthSupported = bl;
    }

    private XElem getAuthInfo() {
        return this.authInfo;
    }

    private String getPasswordFEText(BPasswordFE bPasswordFE) {
        return ((BTextField)bPasswordFE.getContent()).getText();
    }

    private static boolean passwordsMatch(String string, String string2) {
        if (string != null && string.length() > 0 && string2 != null && string2.length() > 0) {
            return string.equals(string2);
        }
        return false;
    }

    static /* synthetic */ BImage access$000() {
        return wizImage;
    }

    private class UpdateAuthMessage
    extends XmlResponseMessage {
        private StringBuffer buf = new StringBuffer("auth?update=true&authtype=");

        public UpdateAuthMessage() {
            this.buf.append(HttpUtil.encodeUrl((String)AuthenticationWizardModel.this.getAuthMethod()));
            if (AuthenticationWizardModel.this.getAuthMethod().equals("basic/native")) {
                if (AuthenticationWizardModel.this.getUserGroup().sid == null) {
                    this.buf.append("&usergroup=");
                    this.buf.append(HttpUtil.encodeUrl((String)AuthenticationWizardModel.this.getUserGroup().name));
                } else {
                    this.buf.append("&usergroupsid=");
                    this.buf.append(HttpUtil.encodeUrl((String)AuthenticationWizardModel.this.getUserGroup().sid));
                }
                if (AuthenticationWizardModel.this.getAdminGroup().sid == null) {
                    this.buf.append("&admingroup=");
                    this.buf.append(HttpUtil.encodeUrl((String)AuthenticationWizardModel.this.getAdminGroup().name));
                } else {
                    this.buf.append("&admingroupsid=");
                    this.buf.append(HttpUtil.encodeUrl((String)AuthenticationWizardModel.this.getAdminGroup().sid));
                }
                this.buf.append("&stationIsAdmin=");
                this.buf.append(String.valueOf(AuthenticationWizardModel.this.stationIsAdmin));
            } else {
                this.buf.append("&user=");
                this.buf.append(HttpUtil.encodeUrl((String)AuthenticationWizardModel.this.getAdminUser()));
                this.buf.append("&password=");
                try {
                    if (AuthenticationWizardModel.this.getAdminPassword() != null) {
                        this.buf.append(HttpUtil.encodeUrl((String)AuthenticationWizardModel.this.getAdminPassword().encodeToString()));
                    } else {
                        this.buf.append(HttpUtil.encodeUrl((String)BPassword.DEFAULT.encodeToString()));
                    }
                }
                catch (Exception exception) {
                    throw new BajaRuntimeException((Throwable)exception);
                }
            }
        }

        public String getMessageString() {
            return this.buf.toString();
        }

        public int getConnectionFlags() {
            return 16;
        }
    }

    private class GroupStep
    extends AuthWizardStep {
        private BListDropDown userList;
        private BListDropDown adminList;
        private BCheckBox stationIsAdminCheckBox;

        public GroupStep() {
            BGridPane bGridPane = new BGridPane(2);
            bGridPane.setValign(BValign.top);
            bGridPane.setHalign(BHalign.left);
            bGridPane.setStretchColumn(1);
            this.userList = new BListDropDown();
            if (!AuthenticationWizardModel.this.getDaemonPlatform().getIsNpsdk()) {
                LabelUtil.addLabelWidgetPair((BGridPane)bGridPane, (LexiconText)LexiconText.make((String)"platDaemon", (String)"AuthWizard.groupStep.userList.label"), (BWidget)this.userList);
                bGridPane.add(null, (BValue)new BNullWidget());
                bGridPane.add(null, (BValue)new BLabel(lex.getText("AuthWizard.groupStep.userList.desc"), BHalign.left));
            }
            this.adminList = new BListDropDown();
            LabelUtil.addLabelWidgetPair((BGridPane)bGridPane, (LexiconText)LexiconText.make((String)"platDaemon", (String)"AuthWizard.groupStep.adminList.label"), (BWidget)this.adminList);
            bGridPane.add(null, (BValue)new BNullWidget());
            bGridPane.add(null, (BValue)new BLabel(lex.getText("AuthWizard.groupStep.adminList.desc"), BHalign.left));
            this.stationIsAdminCheckBox = new BCheckBox(lex.getText("AuthWizard.groupStep.stationIsAdmin.checkBox"));
            LabelUtil.addLabelWidgetPair((BGridPane)bGridPane, (LexiconText)LexiconText.make((String)"platDaemon", (String)"AuthWizard.groupStep.stationIsAdmin.label"), (BWidget)this.stationIsAdminCheckBox);
            bGridPane.add(null, (BValue)new BNullWidget());
            bGridPane.add(null, (BValue)new BLabel(lex.getText("AuthWizard.groupStep.stationIsAdmin.desc"), BHalign.left));
            this.setContent((BWidget)new BEdgePane(null, null, null, null, (BWidget)bGridPane));
        }

        public String getStepName() {
            return "groupStep";
        }

        public void enter() {
            this.userList.getList().removeAllItems();
            this.adminList.getList().removeAllItems();
            XElem[] xElemArray = AuthenticationWizardModel.this.getAuthInfo().elems("domain");
            for (int i = 0; i < xElemArray.length; ++i) {
                XElem[] xElemArray2 = xElemArray[i].elems("group");
                for (int j = 0; j < xElemArray2.length; ++j) {
                    this.userList.getList().addItem((Object)new WinNtAccount(xElemArray2[j].get("name"), xElemArray2[j].get("sid", null)));
                    this.adminList.getList().addItem((Object)new WinNtAccount(xElemArray2[j].get("name"), xElemArray2[j].get("sid", null)));
                }
            }
            if (this.userList.getList().indexOfItem((Object)AuthenticationWizardModel.this.getUserGroup()) >= 0) {
                this.userList.getList().setSelectedItem((Object)AuthenticationWizardModel.this.getUserGroup());
            } else if (this.userList.getList().indexOfItem((Object)WinNtAccount.BUILTIN_USERS_GROUP) >= 0) {
                this.userList.getList().setSelectedItem((Object)WinNtAccount.BUILTIN_USERS_GROUP);
            } else {
                this.userList.getList().getSelection().deselectAll();
            }
            if (this.adminList.getList().indexOfItem((Object)AuthenticationWizardModel.this.getAdminGroup()) >= 0) {
                this.adminList.getList().setSelectedItem((Object)AuthenticationWizardModel.this.getAdminGroup());
            } else if (this.adminList.getList().indexOfItem((Object)WinNtAccount.BUILTIN_ADMINISTRATORS_GROUP) >= 0) {
                this.adminList.getList().setSelectedItem((Object)WinNtAccount.BUILTIN_ADMINISTRATORS_GROUP);
            } else {
                this.adminList.getList().getSelection().deselectAll();
            }
        }

        public boolean exit() {
            if (!AuthenticationWizardModel.this.getDaemonPlatform().getIsNpsdk()) {
                if (this.userList.getList().getSelectedIndex() < 0 || this.adminList.getList().getSelectedIndex() < 0) {
                    BDialog.error((BWidget)AuthenticationWizardModel.this.getWizard(), (Object)lex.getText("AuthWizard.groupStep.error.nullGroup"));
                    return false;
                }
            } else if (this.adminList.getList().getSelectedIndex() < 0) {
                BDialog.error((BWidget)AuthenticationWizardModel.this.getWizard(), (Object)lex.getText("AuthWizard.groupStep.error.nullAdminGroup"));
                return false;
            }
            if (!AuthenticationWizardModel.this.getDaemonPlatform().getIsNpsdk()) {
                AuthenticationWizardModel.this.setUserGroup((WinNtAccount)this.userList.getList().getSelectedItem());
            } else {
                AuthenticationWizardModel.this.setUserGroup((WinNtAccount)this.adminList.getList().getSelectedItem());
            }
            AuthenticationWizardModel.this.setAdminGroup((WinNtAccount)this.adminList.getList().getSelectedItem());
            AuthenticationWizardModel.this.setStationIsAdmin(this.stationIsAdminCheckBox.isSelected());
            return true;
        }

        public int getMode() {
            return 5;
        }
    }

    private class CredentialsStep
    extends AuthWizardStep
    implements ModeStep {
        private BTextField usernameTextField;
        private BPasswordFE passwordFE;

        public CredentialsStep() {
            GroupStep groupStep = new GroupStep();
            this.setNextStep(groupStep);
            groupStep.setPriorStep(this);
            BIndentPane bIndentPane = new BIndentPane();
            bIndentPane.add(LexiconText.make((String)"platDaemon", (String)"AuthWizard.credentialsStep.heading"));
            bIndentPane.add((BWidget)new BBox(0.0, 5.0));
            BGridPane bGridPane = new BGridPane(2);
            bGridPane.setValign(BValign.top);
            bGridPane.setHalign(BHalign.left);
            bGridPane.setStretchColumn(1);
            this.usernameTextField = new BTextField("", 8);
            LabelUtil.addLabelWidgetPair((BGridPane)bGridPane, (LexiconText)LexiconText.make((String)"platDaemon", (String)"AuthWizard.credentialsStep.user.label"), (BWidget)this.usernameTextField);
            this.passwordFE = new BPasswordFE();
            LabelUtil.addLabelWidgetPair((BGridPane)bGridPane, (LexiconText)LexiconText.make((String)"platDaemon", (String)"AuthWizard.credentialsStep.pw.label"), (BWidget)this.passwordFE);
            this.usernameTextField.setModel((TextModel)new ModeControlModel(this));
            ((BTextField)this.passwordFE.getContent()).setModel((TextModel)new ModeControlModel(this));
            bIndentPane.add((BWidget)bGridPane);
            this.setContent((BWidget)bIndentPane);
        }

        public String getStepName() {
            return "credentialsStep";
        }

        public int getMode() {
            int n = 0;
            n = this.getPriorStep() == null || this.getPriorStep().isSkipped() ? 0 : 1;
            if (this.usernameTextField.getText().trim().length() == 0 || AuthenticationWizardModel.this.getPasswordFEText(this.passwordFE).trim().length() == 0) {
                return n;
            }
            return n | 2;
        }

        public void enter() {
            this.usernameTextField.setText(AuthenticationWizardModel.this.queryUsername);
            this.passwordFE.loadValue((BObject)AuthenticationWizardModel.this.queryPassword);
        }

        public boolean exit() {
            try {
                if (this.usernameTextField.getText().equals(AuthenticationWizardModel.this.queryUsername) && this.passwordFE.saveValue().equals((Object)AuthenticationWizardModel.this.queryPassword)) {
                    return true;
                }
                XElem xElem = XParser.make((InputStream)AuthenticationWizardModel.this.getDaemonSession().getInputStream((DaemonMessage)new XmlResponseMessage(){

                    public String getMessageString() {
                        try {
                            return "auth?reqUsername=" + HttpUtil.encodeUrl((String)CredentialsStep.this.usernameTextField.getText()) + "&reqPassword=" + HttpUtil.encodeUrl((String)((BPassword)CredentialsStep.this.passwordFE.saveValue()).encodeToString());
                        }
                        catch (RuntimeException runtimeException) {
                            throw runtimeException;
                        }
                        catch (Exception exception) {
                            throw new BajaRuntimeException((Throwable)exception);
                        }
                    }
                }, "text/xml")).parse();
                if (xElem.elems("domain").length == 0) {
                    BDialog.error((BWidget)AuthenticationWizardModel.this.getWizard(), (Object)lex.getText("AuthWizard.credentials.error.badCredentials"));
                    return false;
                }
                AuthenticationWizardModel.this.queryUsername = this.usernameTextField.getText();
                AuthenticationWizardModel.this.queryPassword = (BPassword)this.passwordFE.saveValue();
                AuthenticationWizardModel.this.authInfo = xElem;
                return true;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new BajaRuntimeException((Throwable)exception);
            }
        }
    }

    private class ModeControlModel
    extends TextModel {
        private ModeStep step;

        public ModeControlModel(ModeStep modeStep) {
            this.step = modeStep;
        }

        protected void textModified() {
            AuthenticationWizardModel.this.update(this.step.getMode());
        }
    }

    private static interface ModeStep {
        public int getMode();
    }

    private class UserStep
    extends AuthWizardStep
    implements ModeStep {
        private BTextField userNameField;
        private BPasswordFE passwordFE1;
        private BPasswordFE passwordFE2;

        public UserStep() {
            BOsPart bOsPart = AuthenticationWizardModel.this.getDaemonPlatform().getOsPart();
            BGridPane bGridPane = new BGridPane(2);
            bGridPane.setValign(BValign.top);
            bGridPane.setHalign(BHalign.left);
            bGridPane.setStretchColumn(1);
            this.userNameField = new BTextField("", 8);
            LabelUtil.addLabelWidgetPair((BGridPane)bGridPane, (LexiconText)LexiconText.make((String)"platDaemon", (String)"AuthWizard.userStep.user.label"), (BWidget)this.userNameField);
            this.passwordFE1 = new BPasswordFE();
            LabelUtil.addLabelWidgetPair((BGridPane)bGridPane, (LexiconText)LexiconText.make((String)"platDaemon", (String)"AuthWizard.userStep.pw1.label"), (BWidget)this.passwordFE1);
            this.passwordFE2 = new BPasswordFE();
            LabelUtil.addLabelWidgetPair((BGridPane)bGridPane, (LexiconText)LexiconText.make((String)"platDaemon", (String)"AuthWizard.userStep.pw1.label"), (BWidget)this.passwordFE2);
            ((BTextField)this.passwordFE1.getContent()).setModel((TextModel)new ModeControlModel(this));
            ((BTextField)this.passwordFE2.getContent()).setModel((TextModel)new ModeControlModel(this));
            ((BTextField)this.passwordFE1.getContent()).setController((TextController)new DigestFilePasswordController());
            ((BTextField)this.passwordFE2.getContent()).setController((TextController)new DigestFilePasswordController());
            this.userNameField.setModel((TextModel)new ModeControlModel(this));
            if (TextUtil.toLowerCase((String)bOsPart.getPartName()).startsWith("qnx")) {
                this.userNameField.setController((TextController)new QnxUserNameController());
            }
            this.setContent((BWidget)new BEdgePane(null, null, null, null, (BWidget)bGridPane));
        }

        public String getStepName() {
            return "userStep";
        }

        public void enter() {
            this.userNameField.setText(AuthenticationWizardModel.this.getAdminUser());
            if (AuthenticationWizardModel.this.getAdminPassword() != null) {
                this.passwordFE1.loadValue((BObject)AuthenticationWizardModel.this.getAdminPassword());
                this.passwordFE2.loadValue((BObject)AuthenticationWizardModel.this.getAdminPassword());
            } else {
                this.passwordFE1.loadValue((BObject)BPassword.DEFAULT);
                this.passwordFE2.loadValue((BObject)BPassword.DEFAULT);
            }
        }

        public boolean exit() {
            try {
                BUsernameAndPassword bUsernameAndPassword;
                BPassword bPassword = (BPassword)this.passwordFE1.saveValue();
                BPassword bPassword2 = (BPassword)this.passwordFE2.saveValue();
                if (!SecurityUtil.equals((String)bPassword.getValue(), (String)bPassword2.getValue())) {
                    BDialog.error((BWidget)AuthenticationWizardModel.this.getWizard(), (Object)lex.getText("AuthWizard.userStep.error.passwordMismatch"));
                    return false;
                }
                char[] cArray = bPassword.getValue().toCharArray();
                for (int i = 0; i < cArray.length; ++i) {
                    if (cArray[i] < '!' || cArray[i] > '~') {
                        BDialog.error((BWidget)AuthenticationWizardModel.this.getWizard(), (Object)lex.getText("AuthWizard.userStep.error.invalidPasswordCharacter", new Object[]{String.valueOf(cArray[i])}));
                        return false;
                    }
                    if (i < 16) continue;
                    BDialog.error((BWidget)AuthenticationWizardModel.this.getWizard(), (Object)lex.getText("AuthWizard.userStep.error.passwordTooLong"));
                    return false;
                }
                if (AuthenticationWizardModel.this.getUsingDefaultDigestCredentials() && this.userNameField.getText().equalsIgnoreCase(AuthenticationWizardModel.this.getAdminUser()) && SecurityUtil.equals((String)(bUsernameAndPassword = (BUsernameAndPassword)AuthenticationWizardModel.this.session.getCredentials()).getPassword().getValue(), (String)bPassword.getValue())) {
                    BDialog.error((BWidget)AuthenticationWizardModel.this.getWizard(), (Object)lex.getText("AuthWizard.userStep.error.defaultCredentials"));
                    return false;
                }
                AuthenticationWizardModel.this.setAdminUser(this.userNameField.getText());
                AuthenticationWizardModel.this.setAdminPassword(bPassword);
                return true;
            }
            catch (Exception exception) {
                throw new BajaRuntimeException((Throwable)exception);
            }
        }

        public int getMode() {
            int n = 0;
            n = this.getPriorStep() == null || this.getPriorStep().isSkipped() ? 0 : 1;
            if (this.userNameField.getText().trim().length() > 0 && AuthenticationWizardModel.passwordsMatch(AuthenticationWizardModel.this.getPasswordFEText(this.passwordFE1).trim(), AuthenticationWizardModel.this.getPasswordFEText(this.passwordFE2).trim())) {
                return n | 4;
            }
            return n;
        }
    }

    private class NextStepCommand
    extends ToggleCommand {
        private AuthWizardStep fromStep;
        private AuthWizardStep toStep;

        public NextStepCommand(BWidget bWidget, AuthWizardStep authWizardStep, AuthWizardStep authWizardStep2, String string, Object[] objectArray) {
            super(bWidget, lex.getText(string, objectArray));
            this.fromStep = authWizardStep;
            this.toStep = authWizardStep2;
        }

        public CommandArtifact doInvoke() {
            if (this.isSelected()) {
                this.fromStep.setNextStep(this.toStep);
                this.toStep.setPriorStep(this.fromStep);
            }
            return null;
        }
    }

    private class AuthMethodStep
    extends AuthWizardStep {
        private UserStep userStep;
        private CredentialsStep credentialsStep;
        private BRadioButton digestFileButton = null;
        private BRadioButton basicNativeButton = null;

        public AuthMethodStep() {
            NextStepCommand nextStepCommand;
            BOsPart bOsPart = AuthenticationWizardModel.this.getDaemonPlatform().getOsPart();
            ToggleCommandGroup toggleCommandGroup = new ToggleCommandGroup();
            BGridPane bGridPane = new BGridPane(1);
            bGridPane.setValign(BValign.top);
            bGridPane.setHalign(BHalign.left);
            if (AuthenticationWizardModel.this.getNativeAuthSupported()) {
                this.credentialsStep = new CredentialsStep();
                nextStepCommand = new NextStepCommand((BWidget)AuthenticationWizardModel.this.getWizard(), this, this.credentialsStep, "AuthWizard.authMethodStep.basicNative.label", new Object[]{bOsPart.getPartName()});
                this.basicNativeButton = new BRadioButton((ToggleCommand)nextStepCommand, true, false);
                bGridPane.add(null, (BValue)this.basicNativeButton);
                this.credentialsStep.setPriorStep(this);
                toggleCommandGroup.add((ToggleCommand)nextStepCommand);
            }
            this.userStep = new UserStep();
            nextStepCommand = new NextStepCommand((BWidget)AuthenticationWizardModel.this.getWizard(), this, this.userStep, "AuthWizard.authMethodStep.digestFile.label", null);
            this.digestFileButton = new BRadioButton((ToggleCommand)nextStepCommand, true, false);
            bGridPane.add(null, (BValue)this.digestFileButton);
            this.userStep.setPriorStep(this);
            toggleCommandGroup.add((ToggleCommand)nextStepCommand);
            this.setContent((BWidget)new BEdgePane(null, null, null, null, (BWidget)bGridPane));
        }

        public String getStepName() {
            return "authMethodStep";
        }

        public boolean isSkipped() {
            return this.basicNativeButton == null;
        }

        public int getMode() {
            return 2;
        }

        public void enter() {
            if (AuthenticationWizardModel.this.getAuthMethod().equals("basic/native")) {
                this.basicNativeButton.setSelected(true);
                this.setNextStep(this.credentialsStep);
            } else {
                this.digestFileButton.setSelected(true);
                this.setNextStep(this.userStep);
            }
        }

        public boolean exit() {
            if (this.digestFileButton.isSelected()) {
                AuthenticationWizardModel.this.setAuthMethod("digest/file");
            } else {
                AuthenticationWizardModel.this.setAuthMethod("basic/native");
            }
            return true;
        }
    }

    public abstract class AuthWizardStep {
        private BEdgePane contentPane = new BEdgePane(null, null, null, null, null);
        private BEdgePane widget = new BEdgePane((BWidget)new BWizardHeader(AuthenticationWizardModel.access$000(), AuthenticationWizardModel.access$100().getText("AuthWizard.headerTitle"), AuthenticationWizardModel.access$100().getText("AuthWizard." + this.getStepName() + ".desc")), null, null, null, (BWidget)new BBorderPane((BWidget)this.contentPane, 5.0, 10.0, 4.0, 10.0));
        private AuthWizardStep priorStep = null;
        private AuthWizardStep nextStep = null;

        public abstract String getStepName();

        public BWidget getWidget() {
            return this.widget;
        }

        protected void setContent(BWidget bWidget) {
            this.contentPane.setCenter(bWidget);
        }

        public int getMode() {
            return 0;
        }

        public int getNavMode() {
            AuthWizardStep authWizardStep;
            AuthWizardStep authWizardStep2;
            int n = 0;
            for (authWizardStep2 = this.getPriorStep(); authWizardStep2 != null && authWizardStep2.isSkipped(); authWizardStep2 = authWizardStep2.getPriorStep()) {
            }
            if (authWizardStep2 != null) {
                n |= 1;
            }
            for (authWizardStep = this.getNextStep(); authWizardStep != null && authWizardStep.isSkipped(); authWizardStep = authWizardStep.getNextStep()) {
            }
            if (authWizardStep != null) {
                n |= 2;
            }
            return n;
        }

        public AuthWizardStep getPriorStep() {
            return this.priorStep;
        }

        public AuthWizardStep getNextStep() {
            return this.nextStep;
        }

        public void setNextStep(AuthWizardStep authWizardStep) {
            this.nextStep = authWizardStep;
        }

        public void enter() {
        }

        public boolean exit() {
            return true;
        }

        public void setPriorStep(AuthWizardStep authWizardStep) {
            this.priorStep = authWizardStep;
        }

        public boolean cancel() {
            return true;
        }

        public boolean isSkipped() {
            return false;
        }
    }
}

