/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.config;

import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.BHostProperties;
import com.tridium.platform.daemon.message.DaemonDebugMessage;
import com.tridium.platform.daemon.message.DaemonMessage;
import com.tridium.platform.daemon.message.QnxInetdMessage;
import com.tridium.platform.daemon.message.QnxSshdMessage;
import com.tridium.platform.daemon.message.UpdateInetMessage;
import com.tridium.platform.daemon.message.UpdateSshdMessage;
import com.tridium.platform.ui.util.PortConfigController;
import com.tridium.ui.BOptionDialog;
import java.io.InputStream;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BLabel;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.text.TextController;
import javax.baja.ui.text.TextModel;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

public class AdvancedOptionsPrompt {
    BOptionDialog dialog;
    boolean debugSupported;
    boolean sshdSupported;
    boolean inetdSupported;
    boolean usbBackupSupported;
    BCheckBox daemonDebugEnabledCheckBox = null;
    String originalDaemonDebugSettings;
    BCheckBox telnetEnabledCheckBox = null;
    BTextField telnetPortTextField = null;
    BCheckBox ftpEnabledCheckBox = null;
    BTextField ftpPortTextField = null;
    String originalInetdSettings;
    BCheckBox sshEnabledCheckBox = null;
    BTextField sshPortTextField = null;
    String originalSshSettings;
    OkCommand okCommand;
    static Lexicon lex = Lexicon.make((String)"platDaemon");

    public static boolean updateSettings(BWidget bWidget, BDaemonSession bDaemonSession) {
        try {
            BOptionDialog bOptionDialog = new BOptionDialog(bWidget, lex.getText("AdvancedOptionsPrompt.dlgTitle"), (BWidget)new BNullWidget(), 3, null, null);
            AdvancedOptionsPrompt advancedOptionsPrompt = new AdvancedOptionsPrompt(bOptionDialog, bDaemonSession);
            bOptionDialog.setBoundsCenteredOnOwner();
            bOptionDialog.open();
            boolean bl = false;
            if (bOptionDialog.getResult() == 1) {
                if (advancedOptionsPrompt.debugSupported && advancedOptionsPrompt.debugChanged()) {
                    bDaemonSession.sendMessage((DaemonMessage)new DaemonDebugMessage(advancedOptionsPrompt.daemonDebugEnabledCheckBox.isSelected()));
                    bl = true;
                }
                if (advancedOptionsPrompt.inetdSupported && advancedOptionsPrompt.inetdChanged()) {
                    bDaemonSession.sendMessage((DaemonMessage)new UpdateInetMessage(advancedOptionsPrompt.ftpEnabledCheckBox.isSelected(), Integer.valueOf(advancedOptionsPrompt.ftpPortTextField.getText()).intValue(), advancedOptionsPrompt.telnetEnabledCheckBox.isSelected(), Integer.valueOf(advancedOptionsPrompt.telnetPortTextField.getText()).intValue()));
                    bl = true;
                } else if (advancedOptionsPrompt.sshdSupported && advancedOptionsPrompt.sshdChanged()) {
                    bDaemonSession.sendMessage((DaemonMessage)new UpdateSshdMessage(advancedOptionsPrompt.sshEnabledCheckBox.isSelected(), Integer.valueOf(advancedOptionsPrompt.sshPortTextField.getText()).intValue()));
                    bl = true;
                }
                bDaemonSession.reloadHostProperties();
                return bl;
            }
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new BajaRuntimeException((Throwable)exception);
        }
        return false;
    }

    private AdvancedOptionsPrompt(BOptionDialog bOptionDialog, BDaemonSession bDaemonSession) {
        int n;
        BGridPane bGridPane;
        this.dialog = bOptionDialog;
        this.okCommand = new OkCommand(this);
        bOptionDialog.getOkButton().setCommand((Command)this.okCommand, true, false);
        BGridPane bGridPane2 = new BGridPane(1);
        BHostProperties bHostProperties = bDaemonSession.getHostProperties();
        this.debugSupported = bHostProperties.supportsServlet("debug");
        this.inetdSupported = bHostProperties.supportsServlet("qnxinetd");
        this.sshdSupported = bHostProperties.supportsServlet("qnxsshd");
        this.usbBackupSupported = bHostProperties.supportsServlet("usbbackup");
        if (this.inetdSupported) {
            bGridPane = new BGridPane(3);
            n = -1;
            int n2 = -1;
            try {
                XElem xElem = XParser.make((InputStream)bDaemonSession.getInputStream((DaemonMessage)QnxInetdMessage.getInstance(), 0)).parse();
                n2 = xElem.geti("fp", -1);
                n = xElem.geti("tp", -1);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.ftpPortTextField = new BTextField("", 4);
            this.telnetPortTextField = new BTextField("", 4);
            this.ftpEnabledCheckBox = new BCheckBox((ToggleCommand)new EnabledCommand(this, "QnxInetdPrompt.ftpEnabled", this.ftpPortTextField));
            bGridPane.add(null, (BValue)this.ftpEnabledCheckBox);
            bGridPane.add(null, (BValue)new BLabel(lex.getText("QnxInetdPrompt.port")));
            bGridPane.add(null, (BValue)this.ftpPortTextField);
            this.ftpPortTextField.setController((TextController)new PortConfigController());
            this.ftpPortTextField.setModel((TextModel)new NotNullModel(this.okCommand));
            this.telnetEnabledCheckBox = new BCheckBox((ToggleCommand)new EnabledCommand(this, "QnxInetdPrompt.telnetEnabled", this.telnetPortTextField));
            bGridPane.add(null, (BValue)this.telnetEnabledCheckBox);
            bGridPane.add(null, (BValue)new BLabel(lex.getText("QnxInetdPrompt.port")));
            bGridPane.add(null, (BValue)this.telnetPortTextField);
            this.telnetPortTextField.setController((TextController)new PortConfigController());
            this.telnetPortTextField.setModel((TextModel)new NotNullModel(this.okCommand));
            if (n2 < 0) {
                this.ftpEnabledCheckBox.setSelected(false);
                this.ftpPortTextField.setText("21");
                this.ftpPortTextField.setEnabled(false);
            } else {
                this.ftpEnabledCheckBox.setSelected(true);
                this.ftpPortTextField.setText(String.valueOf(n2));
            }
            if (n < 0) {
                this.telnetEnabledCheckBox.setSelected(false);
                this.telnetPortTextField.setText("23");
                this.telnetPortTextField.setEnabled(false);
            } else {
                this.telnetEnabledCheckBox.setSelected(true);
                this.telnetPortTextField.setText(String.valueOf(n));
            }
            this.originalInetdSettings = String.valueOf(this.telnetEnabledCheckBox.isSelected()) + String.valueOf(n) + String.valueOf(this.ftpEnabledCheckBox.isSelected()) + String.valueOf(n2);
            bGridPane2.add(null, (BValue)bGridPane);
        } else if (this.sshdSupported) {
            bGridPane = new BGridPane(3);
            n = -1;
            try {
                XElem xElem = XParser.make((InputStream)bDaemonSession.getInputStream((DaemonMessage)QnxSshdMessage.getInstance(), 0)).parse();
                n = xElem.geti("port", -1);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.sshPortTextField = new BTextField("", 4);
            this.sshEnabledCheckBox = new BCheckBox((ToggleCommand)new EnabledCommand(this, "QnxSshdPrompt.sshEnabled", this.sshPortTextField));
            bGridPane.add(null, (BValue)this.sshEnabledCheckBox);
            bGridPane.add(null, (BValue)new BLabel(lex.getText("QnxSshdPrompt.port")));
            bGridPane.add(null, (BValue)this.sshPortTextField);
            this.sshPortTextField.setController((TextController)new PortConfigController());
            this.sshPortTextField.setModel((TextModel)new NotNullModel(this.okCommand));
            if (n < 0) {
                this.sshEnabledCheckBox.setSelected(false);
                this.sshPortTextField.setText("22");
                this.sshPortTextField.setEnabled(false);
            } else {
                this.sshEnabledCheckBox.setSelected(true);
                this.sshPortTextField.setText(String.valueOf(n));
            }
            this.originalSshSettings = String.valueOf(this.sshEnabledCheckBox.isSelected()) + String.valueOf(n);
            bGridPane2.add(null, (BValue)bGridPane);
        }
        if (this.debugSupported) {
            bGridPane = new BGridPane(1);
            n = 0;
            try {
                XElem xElem = XParser.make((InputStream)bDaemonSession.getInputStream((DaemonMessage)new DaemonDebugMessage())).parse();
                n = xElem.getb("daemonDebug", false) ? 1 : 0;
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.daemonDebugEnabledCheckBox = new BCheckBox(lex.getText("AdvancedOptionsPrompt.debugEnabled"));
            bGridPane.add(null, (BValue)this.daemonDebugEnabledCheckBox);
            this.daemonDebugEnabledCheckBox.setSelected(n != 0);
            this.originalDaemonDebugSettings = String.valueOf(n != 0);
            bGridPane2.add(null, (BValue)bGridPane);
        }
        bOptionDialog.setContent((BWidget)new BBorderPane((BWidget)bGridPane2, 6.0, 6.0, 6.0, 6.0));
    }

    boolean debugChanged() {
        return !String.valueOf(this.daemonDebugEnabledCheckBox.isSelected()).equalsIgnoreCase(this.originalDaemonDebugSettings);
    }

    boolean inetdChanged() {
        return !(String.valueOf(this.telnetEnabledCheckBox.isSelected()) + this.telnetPortTextField.getText() + String.valueOf(this.ftpEnabledCheckBox.isSelected()) + this.ftpPortTextField.getText()).equalsIgnoreCase(this.originalInetdSettings);
    }

    boolean sshdChanged() {
        return !(String.valueOf(this.sshEnabledCheckBox.isSelected()) + this.sshPortTextField.getText()).equalsIgnoreCase(this.originalSshSettings);
    }

    private static class NotNullModel
    extends TextModel {
        private OkCommand command;

        public NotNullModel(OkCommand okCommand) {
            this.command = okCommand;
        }

        protected void textModified() {
            this.command.check();
        }
    }

    static class EnabledCommand
    extends ToggleCommand {
        private BTextField textField;

        public EnabledCommand(AdvancedOptionsPrompt advancedOptionsPrompt, String string, BTextField bTextField) {
            super((BWidget)advancedOptionsPrompt.dialog, lex.getText(string), null, null, null);
            this.textField = bTextField;
        }

        public CommandArtifact doInvoke() {
            this.textField.setEnabled(this.isSelected());
            return null;
        }
    }

    static class OkCommand
    extends Command {
        AdvancedOptionsPrompt prompt;

        public OkCommand(AdvancedOptionsPrompt advancedOptionsPrompt) {
            super((BWidget)advancedOptionsPrompt.dialog, UiLexicon.bajaui.getText("action.ok"), null, null, null);
            this.prompt = advancedOptionsPrompt;
        }

        public CommandArtifact doInvoke() {
            return null;
        }

        public void check() {
            if (this.prompt.inetdSupported) {
                this.setEnabled(this.prompt.telnetPortTextField.getText().length() > 0 && this.prompt.ftpPortTextField.getText().length() > 0);
            } else if (this.prompt.sshdSupported) {
                this.setEnabled(this.prompt.sshPortTextField.getText().length() > 0);
            }
        }
    }
}

