/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.commissioningwizard;

import com.tridium.nre.auth.SecurityUtil;
import com.tridium.platDaemon.ui.commissioningwizard.CommissioningWizardModel;
import com.tridium.platDaemon.ui.commissioningwizard.CommissioningWizardStep;
import com.tridium.platDaemon.ui.config.SystemPasswordPrompt;
import com.tridium.platform.daemon.message.SystemPasswordMessageAX;
import com.tridium.platform.daemon.message.XmlResponseMessage;
import com.tridium.platform.ui.util.LabelUtil;
import com.tridium.workbench.fieldeditors.BPasswordFE;
import javax.baja.gx.BColor;
import javax.baja.security.BPassword;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.text.TextModel;
import javax.baja.user.BPasswordStrength;
import javax.baja.util.Lexicon;

public class SystemPasswordStep
extends CommissioningWizardStep {
    BPasswordFE currentPasswordFE;
    BPasswordFE newPasswordFE1;
    BPasswordFE newPasswordFE2;
    static final Lexicon LEX = Lexicon.make((String)"platDaemon");

    public SystemPasswordStep(CommissioningWizardModel commissioningWizardModel) {
        super(commissioningWizardModel);
        BLabel bLabel;
        BGridPane bGridPane = new BGridPane(2);
        bGridPane.setValign(BValign.top);
        bGridPane.setHalign(BHalign.left);
        bGridPane.setStretchColumn(1);
        BGridPane bGridPane2 = new BGridPane(1);
        bGridPane2.setHalign(BHalign.left);
        bGridPane2.add(null, (BValue)new BLabel(LEX.getText("CommissioningWizard.systemPass.header"), BHalign.left));
        if (commissioningWizardModel.requireSystemPassword) {
            bLabel = new BLabel(LEX.getText("CommissioningWizard.systemPass.defaultNotice"), BHalign.left);
            bLabel.setForeground(BColor.red.toBrush());
            bGridPane2.add(null, (BValue)bLabel);
        }
        if (!commissioningWizardModel.daemonSession.isSecure()) {
            bLabel = new BLabel(LEX.getText("CommissioningWizard.systemPass.nonSecureNotice"), BHalign.left);
            bLabel.setForeground(BColor.red.toBrush());
            bGridPane2.add(null, (BValue)bLabel);
        }
        this.currentPasswordFE = new BPasswordFE();
        LabelUtil.addLabelWidgetPair((BGridPane)bGridPane, (String)LEX.getText("CommissioningWizard.systemPass.oldpassword.label"), (BWidget)this.currentPasswordFE);
        this.newPasswordFE1 = new BPasswordFE();
        LabelUtil.addLabelWidgetPair((BGridPane)bGridPane, (String)LEX.getText("CommissioningWizard.systemPass.newpassword.label"), (BWidget)this.newPasswordFE1);
        this.newPasswordFE2 = new BPasswordFE();
        LabelUtil.addLabelWidgetPair((BGridPane)bGridPane, (String)LEX.getText("CommissioningWizard.systemPass.newpassword2.label"), (BWidget)this.newPasswordFE2);
        ((BTextField)this.newPasswordFE1.getContent()).setModel((TextModel)new ModeControlModel(this));
        ((BTextField)this.newPasswordFE2.getContent()).setModel((TextModel)new ModeControlModel(this));
        this.setContent((BWidget)new BEdgePane((BWidget)new BBorderPane((BWidget)bGridPane2, 4.0, 0.0, 8.0, 0.0), null, null, null, (BWidget)bGridPane));
    }

    public String getStepName() {
        return "systemPass";
    }

    public String getSectionName() {
        return "systemPass";
    }

    public boolean exit(int n) {
        boolean bl;
        boolean bl2 = bl = n == 1;
        if (bl) {
            return true;
        }
        try {
            BPassword bPassword = (BPassword)this.currentPasswordFE.saveValue();
            BPassword bPassword2 = (BPassword)this.newPasswordFE1.saveValue();
            BPassword bPassword3 = (BPassword)this.newPasswordFE2.saveValue();
            if (bPassword == null || bPassword.getValue().trim().length() == 0 || bPassword2 == null || bPassword2.getValue().trim().length() == 0 || bPassword3 == null || bPassword3.getValue().trim().length() == 0) {
                BDialog.error((BWidget)this.wizardModel.getWizard(), (Object)LEX.getText("UserManager.error.fieldRequired"));
                return false;
            }
            if (!SystemPasswordPrompt.validatePassword((BWidget)this.wizardModel.getWizard(), bPassword2, BPasswordStrength.STRONG)) {
                return false;
            }
            if (!SystemPasswordPrompt.checkStatus(null, this.wizardModel.daemonSession, (XmlResponseMessage)new SystemPasswordMessageAX(null, bPassword, true))) {
                BDialog.error((BWidget)this.wizardModel.getWizard(), (Object)LEX.getText("SystemPassword.error.badPassword"));
                return false;
            }
            if (!SystemPasswordPrompt.checkStatus(null, this.wizardModel.daemonSession, (XmlResponseMessage)new SystemPasswordMessageAX(bPassword2, null, true))) {
                BDialog.error((BWidget)this.wizardModel.getWizard(), (Object)LEX.getText("UserManager.error.invalidPasswordDefault"));
                return false;
            }
            if (!SecurityUtil.equals((String)bPassword2.getValue(), (String)bPassword3.getValue())) {
                BDialog.error((BWidget)this.wizardModel.getWizard(), (Object)LEX.getText("UserManager.error.passwordMismatch"));
                return false;
            }
            this.wizardModel.newSystemPassword = bPassword2;
            this.wizardModel.oldSystemPassword = bPassword;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new BajaRuntimeException((Throwable)exception);
        }
        return true;
    }

    public int getMode() {
        int n = 1;
        if (((BTextField)this.newPasswordFE1.getContent()).getText().trim().length() == 0 || ((BTextField)this.newPasswordFE2.getContent()).getText().trim().length() == 0) {
            return n;
        }
        return n | 2;
    }

    public boolean isSkipped() {
        return this.wizardModel.skipSystemPassword;
    }

    private static class ModeControlModel
    extends TextModel {
        private CommissioningWizardStep step;

        public ModeControlModel(CommissioningWizardStep commissioningWizardStep) {
            this.step = commissioningWizardStep;
        }

        protected void textModified() {
            this.step.wizardModel.update(this.step.getMode());
        }
    }
}

