/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.commissioningwizard;

import com.tridium.install.BDaemonPlatform;
import com.tridium.install.BPartInstallStatus;
import com.tridium.install.BRemoteDaemonPlatform;
import com.tridium.install.DependencyUtil;
import com.tridium.install.InstallScenario;
import com.tridium.install.PartSpec;
import com.tridium.install.SolutionParameters;
import com.tridium.install.UnmeetableDependency;
import com.tridium.install.installable.BDistribution;
import com.tridium.install.installable.BInstallable;
import com.tridium.install.installable.BModuleInstallable;
import com.tridium.install.installable.InstallableRegistry;
import com.tridium.install.installable.LocalInstallableRegistry;
import com.tridium.install.part.BModulePart;
import com.tridium.install.part.BPart;
import com.tridium.platDaemon.ui.BDaemonSessionView;
import com.tridium.platDaemon.ui.commissioningwizard.BModuleTypeFilter;
import com.tridium.platDaemon.ui.commissioningwizard.CommissioningWizardModel;
import com.tridium.platDaemon.ui.commissioningwizard.CommissioningWizardStep;
import com.tridium.platDaemon.ui.commissioningwizard.LexiconSourceModel;
import com.tridium.platDaemon.ui.softwaremanager.BPartDetailsPane;
import com.tridium.platDaemon.ui.softwaremanager.CancelInstallCommand;
import com.tridium.platDaemon.ui.softwaremanager.InstallerCellRenderer;
import com.tridium.platDaemon.ui.softwaremanager.InstallerTableModel;
import com.tridium.platDaemon.ui.softwaremanager.InstallerTableRow;
import com.tridium.platDaemon.ui.softwaremanager.ResetCommand;
import com.tridium.platDaemon.ui.softwaremanager.UpgradeOutOfDateCommand;
import com.tridium.platform.daemon.BAppSurrogate;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.BModuleContent;
import com.tridium.platform.daemon.BStationSurrogate;
import com.tridium.platform.daemon.DaemonFileUtil;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import com.tridium.platform.ui.util.AsyncGroup;
import com.tridium.platform.ui.util.BBox;
import com.tridium.platform.ui.util.BButtonPane;
import com.tridium.platform.ui.util.BIndentPane;
import com.tridium.platform.ui.util.CommandUtil;
import com.tridium.platform.ui.util.LabelUtil;
import com.tridium.sys.registry.NModuleInfo;
import com.tridium.ui.theme.Theme;
import java.io.File;
import java.io.InputStream;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.baja.file.BDirectory;
import javax.baja.file.FilePath;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.gx.Graphics;
import javax.baja.log.Log;
import javax.baja.nre.util.Array;
import javax.baja.security.AuthenticationException;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.ModuleException;
import javax.baja.sys.ModuleNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.ui.BActionMenuItem;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BMenu;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BScrollBarPolicy;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BFlowPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableCellRenderer;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.util.LexiconText;
import javax.baja.workbench.BWbShell;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

public class ModuleStep
extends CommissioningWizardStep
implements AsyncGroup.AsyncGroupMember {
    private BDirectory lastStationDir = null;
    private BModuleContent lastModuleContent = null;
    private DependencyUtil.AnalysisResults analysisResults = null;
    private TreeSet lexiconModules;
    private BTable table;
    private ModuleTableModel tableModel = new ModuleTableModel();
    private UpgradeOutOfDateCommand upgradeOODCommand;
    private ResetCommand resetCommand;
    private long currentFreeSpace;
    private BLabel currentSpaceLabel;
    private BLabel spaceDeltaLabel;
    private BLabel afterSpaceLabel;
    private AsyncGroup asyncGroup;
    private boolean asyncGroupActive = false;
    public static final int MT_PART_NAME_COL = 0;
    public static final int MT_CURRENT_VER_COL = 1;
    public static final int MT_AVAIL_VER_COL = 2;
    public static final int MT_COMMENT_COL = 3;
    public static final int REQUIRED_PLATFORM = 3;
    public static final int REQUIRED_STATION = 2;
    public static final int REQUIRED_MODULECONTENT = 4;
    public static final int REQUIRED_LEXICON = 1;
    private static Log log = Log.getLog((String)"platDaemon");
    static /* synthetic */ Class class$javax$baja$file$BDirectory;

    public ModuleStep(CommissioningWizardModel commissioningWizardModel) {
        super(commissioningWizardModel);
        this.table = new BTable((TableModel)this.tableModel);
        this.table.setController((TableController)new ModuleTableController());
        this.table.setMultipleSelection(false);
        this.tableModel.setFilter(new BModuleTypeFilter());
        this.table.setCellRenderer((TableCellRenderer)new ModuleCellRenderer());
        BButtonPane bButtonPane = new BButtonPane();
        BInsets bInsets = BInsets.make((double)4.0, (double)3.0, (double)4.0, (double)3.0);
        this.asyncGroup = new AsyncGroup();
        this.asyncGroup.add((AsyncGroup.AsyncGroupMember)this);
        this.asyncGroup.add((AsyncGroup.AsyncGroupMember)this.tableModel);
        this.upgradeOODCommand = new UpgradeOutOfDateCommand(commissioningWizardModel.owner, this.tableModel);
        BButton bButton = new BButton((Command)this.upgradeOODCommand);
        bButtonPane.add((BWidget)bButton);
        bButton.setPadding(bInsets);
        this.resetCommand = new ResetCommand(commissioningWizardModel.owner, this.tableModel);
        bButton = new BButton((Command)this.resetCommand);
        bButtonPane.add((BWidget)bButton);
        bButton.setPadding(bInsets);
        this.asyncGroup.add((AsyncGroup.AsyncGroupMember)this.upgradeOODCommand);
        this.asyncGroup.add((AsyncGroup.AsyncGroupMember)this.resetCommand);
        BGridPane bGridPane = new BGridPane(6);
        BLabel bLabel = new BLabel(DaemonFileUtil.kbFormat.format(88888888L));
        bLabel.computePreferredSize();
        BLabel bLabel2 = new BLabel(DaemonFileUtil.kbFormat.format(88888L));
        bLabel2.computePreferredSize();
        bGridPane.add(null, (BValue)new BNullWidget());
        bGridPane.add(null, (BValue)new BBox((double)((int)bLabel.getPreferredWidth() + 5), 0.0));
        bGridPane.add(null, (BValue)new BNullWidget());
        bGridPane.add(null, (BValue)new BBox((double)((int)bLabel2.getPreferredWidth() + 5), 0.0));
        bGridPane.add(null, (BValue)new BNullWidget());
        bGridPane.add(null, (BValue)new BBox((double)((int)bLabel.getPreferredWidth() + 5), 0.0));
        bGridPane.setHalign(BHalign.left);
        this.currentSpaceLabel = new BLabel();
        LabelUtil.addLabelWidgetPair((BGridPane)bGridPane, (LexiconText)LexiconText.make((String)"platDaemon", (String)"SoftwareManager.currentSpaceLabel"), (BWidget)this.currentSpaceLabel);
        this.spaceDeltaLabel = new BLabel();
        LabelUtil.addLabelWidgetPair((BGridPane)bGridPane, (LexiconText)LexiconText.make((String)"platDaemon", (String)"SoftwareManager.spaceDeltaLabel"), (BWidget)this.spaceDeltaLabel);
        this.afterSpaceLabel = new BLabel();
        LabelUtil.addLabelWidgetPair((BGridPane)bGridPane, (LexiconText)LexiconText.make((String)"platDaemon", (String)"SoftwareManager.afterSpaceLabel"), (BWidget)this.afterSpaceLabel);
        BGridPane bGridPane2 = new BGridPane(1);
        bGridPane2.setHalign(BHalign.left);
        bGridPane2.setValign(BValign.top);
        bGridPane2.add(null, (BValue)new BLabel(lex.getText("CommissioningWizard.moduleUpgrades.header.standard"), BHalign.left));
        this.setContent((BWidget)new BEdgePane((BWidget)new BEdgePane(null, (BWidget)new BBorderPane((BWidget)bGridPane, 3.0, 0.0, 7.0, 0.0), null, null, (BWidget)new BBorderPane((BWidget)bGridPane2, BBorder.make((String)"bottom(groove)"), BInsets.make((double)4.0, (double)0.0, (double)8.0, (double)0.0))), (BWidget)new BBorderPane((BWidget)bButtonPane, 4.0, 0.0, 4.0, 0.0), null, null, (BWidget)new BBorderPane((BWidget)this.table, BBorder.inset, BInsets.DEFAULT)));
        this.nextStep = new UnavailableModuleStep(commissioningWizardModel);
        this.nextStep.priorStep = this;
        this.lastStep = this.nextStep;
        this.lexiconModules = new TreeSet();
    }

    public void enter() {
        this.initStep();
    }

    public boolean exit(int n) {
        if (this.tableModel == null || this.tableModel.getScenario() == null) {
            this.wizardModel.moduleScenario = null;
            this.wizardModel.moduleScenarioHasDists = false;
        } else {
            BInstallable[] bInstallableArray = this.tableModel.getScenario().getToInstall();
            this.wizardModel.moduleScenarioHasDists = false;
            for (int i = 0; i < bInstallableArray.length; ++i) {
                if (!(bInstallableArray[i] instanceof BDistribution)) continue;
                this.wizardModel.moduleScenarioHasDists = true;
                break;
            }
            this.wizardModel.moduleScenario = this.tableModel.getScenario();
        }
        this.wizardModel.distSolution = null;
        return true;
    }

    public boolean isSkipped() {
        this.initStep();
        return !this.wizardModel.initialScenario.canCommit();
    }

    public int getMode() {
        return this.asyncGroupActive ? 0 : 3;
    }

    public String getStepName() {
        return "moduleUpgrades";
    }

    public String getSectionName() {
        return "module";
    }

    public void startActive() {
        this.asyncGroupActive = true;
        this.wizardModel.update(0);
    }

    public void stopActive() {
        this.asyncGroupActive = false;
        this.wizardModel.update(3);
    }

    public void setAsyncGroup(AsyncGroup asyncGroup) {
        this.asyncGroup = asyncGroup;
    }

    public AsyncGroup getAsyncGroup() {
        return this.asyncGroup;
    }

    private void initStep() {
        try {
            AsyncGroup asyncGroup = this.tableModel.getAsyncGroup();
            if (asyncGroup != null) {
                asyncGroup.startActive();
            }
            this.currentFreeSpace = DaemonFileUtil.getFilesystemAttributes((BDaemonSession)this.wizardModel.daemonSession, (FilePath)new FilePath("!modules")).getFreeSpace();
            if (this.currentSpaceLabel != null) {
                this.currentSpaceLabel.setText(DaemonFileUtil.kbFormat.format(this.currentFreeSpace));
            }
            if (!this.initScenario() && this.wizardModel.initialScenario.canCommit()) {
                this.tableModel.init(this.wizardModel.daemonSession, this.wizardModel.sessionTaskHandler, false);
            }
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new BajaRuntimeException((Throwable)exception);
        }
        finally {
            AsyncGroup asyncGroup = this.tableModel.getAsyncGroup();
            if (asyncGroup != null) {
                asyncGroup.stopActive();
            }
        }
    }

    private boolean initScenario() throws Exception {
        if (this.wizardModel.initialScenario == null || this.analysisResults == null || this.lastModuleContent != this.wizardModel.moduleContent || this.lastStationDir != this.wizardModel.stationDir) {
            BStationSurrogate bStationSurrogate;
            int n;
            BRemoteDaemonPlatform bRemoteDaemonPlatform = this.wizardModel.getPlatform();
            Array array = new Array(class$javax$baja$file$BDirectory == null ? (class$javax$baja$file$BDirectory = ModuleStep.class$("javax.baja.file.BDirectory")) : class$javax$baja$file$BDirectory);
            if (this.wizardModel.stationDir != null) {
                array.add((Object)this.wizardModel.stationDir);
            }
            BAppSurrogate[] bAppSurrogateArray = this.wizardModel.getSurrogates();
            for (n = 0; n < bAppSurrogateArray.length; ++n) {
                if (!(bAppSurrogateArray[n] instanceof BStationSurrogate) || this.wizardModel.stationsToDelete.contains((Object)bAppSurrogateArray[n])) continue;
                bStationSurrogate = (BStationSurrogate)bAppSurrogateArray[n];
                array.add((Object)this.wizardModel.daemonSession.getFileSpace().findFile(new FilePath("!stations/" + bStationSurrogate.getStationName())));
            }
            this.analysisResults = DependencyUtil.analyzeAllDependencies((BDaemonPlatform)bRemoteDaemonPlatform, (BDirectory[])((BDirectory[])array.trim()), (BModuleContent)this.wizardModel.moduleContent, (SolutionParameters)this.wizardModel.solutionParms);
            this.wizardModel.initialScenario = this.analysisResults.getSolution();
            this.lexiconModules.clear();
            if (this.wizardModel.lexLocalesToInstall.size() > 0) {
                for (n = 0; n < this.wizardModel.lexLocalesToInstall.size(); ++n) {
                    bStationSurrogate = ((LexiconSourceModel)this.wizardModel.lexLocalesToInstall.get((int)n)).lexModules;
                    for (int i = 0; i < bStationSurrogate.size(); ++i) {
                        NModuleInfo nModuleInfo = (NModuleInfo)bStationSurrogate.get(i);
                        BModuleInstallable bModuleInstallable = BModuleInstallable.make((NModuleInfo)nModuleInfo);
                        if (bModuleInstallable == null) continue;
                        if (this.isExistingModuleValid(nModuleInfo.getModuleName())) {
                            this.lexiconModules.add(bModuleInstallable);
                            log.trace(" Request lexicon module: " + nModuleInfo.getModuleName());
                            continue;
                        }
                        log.trace(" Excluding invalid lexicon module: " + nModuleInfo.getModuleName());
                    }
                }
            }
            this.wizardModel.moduleScenario = this.wizardModel.initialScenario;
            this.wizardModel.moduleScenarioHasDists = false;
            this.wizardModel.distSolution = null;
            BInstallable[] bInstallableArray = this.wizardModel.initialScenario.getToInstall();
            for (int i = 0; i < bInstallableArray.length; ++i) {
                if (!(bInstallableArray[i] instanceof BDistribution)) continue;
                this.wizardModel.moduleScenarioHasDists = true;
                break;
            }
            this.lastStationDir = this.wizardModel.stationDir;
            this.lastModuleContent = this.wizardModel.moduleContent;
            if (this.wizardModel.initialScenario.canCommit()) {
                this.tableModel.resetScenario();
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean isExistingModuleValid(String string) {
        ZipFile zipFile = null;
        try {
            File file = new File(Sys.getBajaHome(), "modules/" + string + ".jar");
            zipFile = new ZipFile(file);
            ZipEntry zipEntry = zipFile.getEntry("META-INF/module.xml");
            if (zipEntry == null) {
                zipEntry = zipFile.getEntry("meta-inf/module.xml");
            }
            if (zipEntry == null) {
                throw new BajaRuntimeException("Module does not include manifest.");
            }
            XElem xElem = XParser.make((InputStream)zipFile.getInputStream(zipEntry)).parse();
            XElem xElem2 = xElem.elem("lexicons");
            boolean bl = false;
            if (xElem2 != null) {
                XElem[] xElemArray = xElem2.elems("lexicon");
                for (int i = 0; i < xElemArray.length; ++i) {
                    if (xElemArray[i].get("module", "").equals(string)) continue;
                    bl = true;
                    break;
                }
            }
            if (!bl) {
                log.trace(" ModuleStep - lexicon does not reference external module: " + string);
                throw new ModuleException("Lexicons in manifest do not reference external modules.");
            }
        }
        catch (ModuleNotFoundException moduleNotFoundException) {
            boolean bl = false;
            return bl;
        }
        catch (ModuleException moduleException) {
            boolean bl = false;
            return bl;
        }
        catch (Exception exception) {
            boolean bl = false;
            return bl;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (Exception exception) {}
            }
        }
        return true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class LicenseCommand
    extends Command {
        public LicenseCommand() {
            super(ModuleStep.this.wizardModel.owner, CommissioningWizardStep.lex.getText("CommissioningWizard.dist.goLicense"), null, null, null);
        }

        public CommandArtifact doInvoke() {
            if (ModuleStep.this.exit(1)) {
                ModuleStep.this.wizardModel.licenseStep.enter();
                ModuleStep.this.wizardModel.update(ModuleStep.this.wizardModel.licenseStep);
            }
            return null;
        }
    }

    private class ModuleTableController
    extends TableController {
        private ModuleTableController() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void cellPressed(BMouseEvent bMouseEvent, int n, int n2) {
            if (bMouseEvent.isPopupTrigger()) {
                super.cellPressed(bMouseEvent, n, n2);
                return;
            }
            if (n2 != 0 || bMouseEvent.getX() > 14.0) {
                if (bMouseEvent.getClickCount() > 1) {
                    new ModuleDetailCommand(n).invoke();
                } else {
                    super.cellPressed(bMouseEvent, n, n2);
                }
                return;
            }
            ModuleRow moduleRow = ModuleStep.this.tableModel.getModuleRow(n);
            if (moduleRow != null && moduleRow.isSelectEnabled() && ModuleStep.this.tableModel.isRowSelectEnabled()) {
                try {
                    AsyncGroup asyncGroup = ModuleStep.this.tableModel.getAsyncGroup();
                    if (asyncGroup != null) {
                        asyncGroup.startActive();
                    }
                    if (moduleRow.isSelected()) {
                        CancelInstallCommand.cancelInstall(ModuleStep.this.wizardModel.owner, ModuleStep.this.tableModel, new int[]{n});
                    } else {
                        BWbShell bWbShell = BWbShell.getWbShell((BWidget)ModuleStep.this.wizardModel.owner);
                        try {
                            InstallScenario installScenario;
                            if (bWbShell != null) {
                                bWbShell.enterBusy();
                            }
                            if ((installScenario = ModuleStep.this.tableModel.getScenario().solve(ModuleStep.this.tableModel.getTaskListener(), null, null, new BInstallable[]{ModuleStep.this.tableModel.getInstallableAt(n)}, (InstallableRegistry)LocalInstallableRegistry.getInstance())).canCommit()) {
                                ModuleStep.this.tableModel.setScenario(installScenario);
                            } else {
                                BInstallable[] bInstallableArray;
                                BScrollPane bScrollPane;
                                BIndentPane bIndentPane = new BIndentPane();
                                boolean bl = false;
                                boolean bl2 = false;
                                UnmeetableDependency[] unmeetableDependencyArray = installScenario.getUnmeetableDependencies();
                                for (int i = 0; i < unmeetableDependencyArray.length; ++i) {
                                    bScrollPane = unmeetableDependencyArray[i].toString();
                                    if (unmeetableDependencyArray[i].failedFilter != null) {
                                        bScrollPane = (String)bScrollPane + " *";
                                        bl2 = true;
                                    }
                                    if (!bl) {
                                        bIndentPane.add((BWidget)new BLabel(CommissioningWizardStep.lex.getText("CommissioningWizard.module.unmetDeps.message", new Object[]{ModuleStep.this.tableModel.getNameAt(n)})));
                                        bIndentPane.add((BWidget)new BBox(0.0, 3.0));
                                        bIndentPane.indent();
                                        bl = true;
                                    }
                                    bIndentPane.add((BWidget)new BLabel(unmeetableDependencyArray[i].getIcon(), (String)bScrollPane));
                                }
                                bIndentPane.unindent();
                                if (bl2) {
                                    bIndentPane.add((BWidget)new BBox(0.0, 3.0));
                                    bIndentPane.add(LexiconText.make((String)"platDaemon", (String)"CommissioningWizard.module.unlicensed.message"));
                                }
                                if ((bInstallableArray = installScenario.getExcludedInstallables()).length > 0) {
                                    if (bl) {
                                        bIndentPane.add((BWidget)new BBox(0.0, 3.0));
                                    }
                                    bIndentPane.add((BWidget)new BLabel(CommissioningWizardStep.lex.getText("CommissioningWizard.module.exclusions.message", new Object[]{ModuleStep.this.tableModel.getNameAt(n)})));
                                    bIndentPane.add((BWidget)new BBox(0.0, 3.0));
                                    bIndentPane.indent();
                                    bScrollPane = installScenario.getFailedExclusion(bInstallableArray[0]);
                                    bIndentPane.add((BWidget)new BLabel(BImage.make((BIcon)bScrollPane.getIcon()), bScrollPane.getPartName()));
                                } else if (!bl) {
                                    bScrollPane = installScenario.getInstallableCandidates().getDependencies();
                                    bIndentPane.add((BWidget)new BLabel(CommissioningWizardStep.lex.getText("CommissioningWizard.module.unmetDeps.message", new Object[]{ModuleStep.this.tableModel.getNameAt(n)})));
                                    bIndentPane.add((BWidget)new BBox(0.0, 3.0));
                                    bIndentPane.indent();
                                    for (int i = 0; i < ((BScrollPane)bScrollPane).length; ++i) {
                                        bIndentPane.add((BWidget)new BLabel(BImage.make((BIcon)bScrollPane[i].getIcon()), bScrollPane[i].toString()));
                                    }
                                }
                                bScrollPane = new BScrollPane((BWidget)new BBorderPane((BWidget)bIndentPane, 4.0, 4.0, 4.0, 4.0));
                                bScrollPane.setViewportBackground(Theme.scrollPane().getControlBackground());
                                bScrollPane.setBorderPolicy(BScrollBarPolicy.asNeeded);
                                BConstrainedPane bConstrainedPane = new BConstrainedPane((BWidget)bScrollPane);
                                bConstrainedPane.setMinHeight(200.0);
                                bConstrainedPane.setMaxHeight(200.0);
                                BDialog.warning((BWidget)ModuleStep.this.wizardModel.owner, (String)CommissioningWizardStep.lex.getText("CommissioningWizard.module.unmetDeps.title"), (Object)bConstrainedPane);
                            }
                        }
                        finally {
                            if (bWbShell != null) {
                                bWbShell.exitBusy();
                            }
                        }
                    }
                    if (asyncGroup != null) {
                        asyncGroup.stopActive();
                    }
                }
                catch (RuntimeException runtimeException) {
                    throw runtimeException;
                }
                catch (Exception exception) {
                    throw new BajaRuntimeException((Throwable)exception);
                }
                ModuleStep.this.tableModel.updateTable();
            } else {
                super.cellPressed(bMouseEvent, n, n2);
            }
        }

        protected void cellPopup(BMouseEvent bMouseEvent, int n, int n2) {
            BMenu bMenu = new BMenu();
            bMenu.add(null, (BValue)new BActionMenuItem((Command)new ModuleDetailCommand(n)), null);
            bMenu.open((BWidget)ModuleStep.this.table, bMouseEvent.getX(), bMouseEvent.getY());
        }
    }

    private class ModuleDetailCommand
    extends Command {
        private int row;

        public ModuleDetailCommand(int n) {
            super(ModuleStep.this.wizardModel.owner, CommissioningWizardStep.lex, "SoftwareManager.command.details");
            this.row = n;
        }

        public CommandArtifact doInvoke() {
            try {
                BPartDetailsPane bPartDetailsPane = new BPartDetailsPane();
                bPartDetailsPane.loadValue(ModuleStep.this.tableModel.getCurrentPartAt(this.row), ModuleStep.this.tableModel.getInstallablePartAt(this.row), ModuleStep.this.tableModel.getTypeAt(this.row), ModuleStep.this.tableModel.getForwardDependenciesAt(this.row), ModuleStep.this.tableModel.getDependentPartsAt(this.row));
                BScrollPane bScrollPane = new BScrollPane((BWidget)new BBorderPane((BWidget)bPartDetailsPane, 4.0, 4.0, 4.0, 4.0));
                bScrollPane.setViewportBackground(Theme.scrollPane().getControlBackground());
                bScrollPane.setBorderPolicy(BScrollBarPolicy.asNeeded);
                BConstrainedPane bConstrainedPane = new BConstrainedPane((BWidget)bScrollPane);
                bConstrainedPane.setFixedSize(600.0, 480.0);
                BDialog.message((BWidget)ModuleStep.this.wizardModel.owner, (String)CommissioningWizardStep.lex.getText("SoftwareManager.command.details.dlgTitle"), (Object)bConstrainedPane);
            }
            catch (Throwable throwable) {
                CommandUtil.error((Command)this, (Throwable)throwable);
            }
            return null;
        }
    }

    public class ModuleCellRenderer
    extends InstallerCellRenderer {
        public ModuleTableModel getModuleTableModel() {
            return (ModuleTableModel)this.getTable().getModel();
        }

        public BBrush getForeground(TableCellRenderer.Cell cell) {
            if (cell.column == 3) {
                switch (this.getModuleTableModel().getRequirementAt(cell.row)) {
                    case 2: 
                    case 3: {
                        return BColor.red.toBrush();
                    }
                    case 1: {
                        return BColor.chocolate.toBrush();
                    }
                }
            }
            return super.getForeground(this.getModuleTableModel().translateCell(cell));
        }

        public BBrush getSelectionForeground(TableCellRenderer.Cell cell) {
            if (cell.column == 3) {
                switch (this.getModuleTableModel().getRequirementAt(cell.row)) {
                    case 2: 
                    case 3: {
                        return BColor.red.toBrush();
                    }
                    case 1: {
                        return BColor.chocolate.toBrush();
                    }
                }
            }
            return super.getSelectionForeground(this.getModuleTableModel().translateCell(cell));
        }

        public double getPreferredCellWidth(TableCellRenderer.Cell cell) {
            if (cell.column == 0) {
                String string = this.getCellText(cell);
                return Theme.table().getCellFont().width(string) + 14.0;
            }
            return super.getPreferredCellWidth(this.getModuleTableModel().translateCell(cell));
        }

        public void paintCell(Graphics graphics, TableCellRenderer.Cell cell) {
            if (cell.column == 0) {
                ModuleTableModel moduleTableModel = this.getModuleTableModel();
                ModuleRow moduleRow = moduleTableModel.getModuleRow(cell.row);
                this.paintCellBackground(graphics, cell);
                double d = 2.0;
                double d2 = (cell.height - 16.0) / 2.0;
                double d3 = d;
                double d4 = d2 + cell.height / 2.0 - 5.0;
                double d5 = 10.0;
                double d6 = 10.0;
                if (moduleRow.isSelectEnabled() && moduleTableModel.isRowSelectEnabled()) {
                    graphics.setBrush(BColor.black.toBrush());
                } else {
                    graphics.setBrush(BColor.gray.toBrush());
                }
                graphics.strokeRect(d3, d4, d5, d6);
                if (moduleRow.isSelected()) {
                    graphics.strokeLine(d3, d4, d3 + d5, d4 + d6);
                    graphics.strokeLine(d3, d4 + d5, d3 + d5, d4);
                }
                if (cell.selected) {
                    graphics.setBrush(this.getSelectionForeground(cell));
                } else {
                    graphics.setBrush(this.getForeground(cell));
                }
                String string = this.getCellText(cell);
                BFont bFont = Theme.table().getCellFont();
                switch (moduleTableModel.getColumnAlignment(cell.column).getOrdinal()) {
                    case 2: {
                        d = cell.width - 2.0 - bFont.width(string);
                        break;
                    }
                    case 1: {
                        d = (cell.width - bFont.width(string)) / 2.0;
                    }
                }
                graphics.setFont(bFont);
                graphics.drawString(string, d + 14.0, bFont.getAscent() + 2.0);
            } else {
                super.paintCell(graphics, cell);
            }
        }
    }

    class ModuleTableModel
    extends InstallerTableModel
    implements AsyncGroup.AsyncGroupMember {
        private AsyncGroup asyncGroup;
        private boolean isRowSelectEnabled = true;

        ModuleTableModel() {
        }

        public void init(BDaemonSession bDaemonSession, DaemonSessionTaskListener daemonSessionTaskListener, boolean bl) throws AuthenticationException {
            this.scenario = ModuleStep.this.wizardModel.initialScenario;
            this.taskListener = daemonSessionTaskListener;
            try {
                this.oodScenario = InstallScenario.upgradeOutOfDate((InstallScenario)this.scenario, (InstallableRegistry)LocalInstallableRegistry.getInstance()).solve();
            }
            catch (AuthenticationException authenticationException) {
                throw authenticationException;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new BajaRuntimeException((Throwable)exception);
            }
            this.rebuild(bl);
        }

        public BModuleContent getTargetModuleContent() {
            return ModuleStep.this.wizardModel.moduleContent;
        }

        public void updateTable(boolean bl) {
            super.updateTable(bl);
            if (ModuleStep.this.upgradeOODCommand != null) {
                boolean bl2 = false;
                for (int i = 0; i < ModuleStep.this.tableModel.getRowCount(); ++i) {
                    int n = ModuleStep.this.tableModel.getStatusAt(i);
                    if (n != 3 && n != 4 && n != 12) continue;
                    bl2 = true;
                    break;
                }
                ModuleStep.this.upgradeOODCommand.setEnabled(bl2);
            }
            if (ModuleStep.this.spaceDeltaLabel != null) {
                long l = (int)(this.getSizeDeltaOnCommit() / 1024L);
                ModuleStep.this.spaceDeltaLabel.setText(DaemonFileUtil.kbFormat.format(l));
                if (ModuleStep.this.afterSpaceLabel != null) {
                    long l2 = ModuleStep.this.currentFreeSpace - l;
                    ModuleStep.this.afterSpaceLabel.setText(DaemonFileUtil.kbFormat.format(l2));
                }
            }
        }

        public void resetScenario() {
            this.scenario = ModuleStep.this.wizardModel.initialScenario;
            try {
                this.oodScenario = InstallScenario.upgradeOutOfDate((InstallScenario)this.scenario, (InstallableRegistry)LocalInstallableRegistry.getInstance()).solve();
            }
            catch (AuthenticationException authenticationException) {
                throw authenticationException;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new BajaRuntimeException((Throwable)exception);
            }
            this.rebuild(true);
        }

        protected void updateValues(boolean bl) {
            PartSpec partSpec;
            if (ModuleStep.this.wizardModel.initialScenario == null) {
                return;
            }
            BInstallable[] bInstallableArray = ModuleStep.this.wizardModel.initialScenario.getToInstall();
            for (int i = 0; i < bInstallableArray.length; ++i) {
                partSpec = bInstallableArray[i].getPartSpec();
                if (!partSpec.getPartType().equals((Object)BModulePart.TYPE.getTypeSpec())) continue;
                if (ModuleStep.this.analysisResults.isPlatformModule(partSpec.getPartName())) {
                    ((ModuleRow)this.getRow(partSpec)).requirement = 3;
                    continue;
                }
                if (ModuleStep.this.analysisResults.isStationModule(partSpec.getPartName())) {
                    ((ModuleRow)this.getRow(partSpec)).requirement = 2;
                    continue;
                }
                if (ModuleStep.this.analysisResults.isMissing(partSpec.getPartName())) {
                    ((ModuleRow)this.getRow(partSpec)).requirement = 4;
                    continue;
                }
                if (ModuleStep.this.lexiconModules.contains(bInstallableArray[i])) {
                    ModuleStep.this.lexiconModules.remove(bInstallableArray[i]);
                    continue;
                }
                throw new IllegalStateException(partSpec + " is installed in initial scenario, but reason is unknown");
            }
            Iterator iterator = ModuleStep.this.lexiconModules.iterator();
            while (iterator.hasNext()) {
                partSpec = (BInstallable)iterator.next();
                PartSpec partSpec2 = partSpec.getPartSpec();
                ((ModuleRow)this.getRow(partSpec2)).requirement = 1;
            }
            super.updateValues(bl);
        }

        public ModuleRow getModuleRow(int n) {
            return (ModuleRow)this.getRow(n);
        }

        public int getRequirementAt(int n) {
            return this.getModuleRow(n).getRequirement();
        }

        protected InstallerTableRow makeRow() {
            return new ModuleRow(this);
        }

        public int getColumnCount() {
            return 4;
        }

        public void sortByColumn(int n, boolean bl) {
            super.sortByColumn(this.translateColumn(n), bl);
        }

        public TableCellRenderer.Cell translateCell(TableCellRenderer.Cell cell) {
            TableCellRenderer.Cell cell2 = new TableCellRenderer.Cell();
            cell2.row = cell.row;
            cell2.column = this.translateColumn(cell.column);
            cell2.value = cell.value;
            cell2.width = cell.width;
            cell2.height = cell.height;
            cell2.selected = cell.selected;
            return cell2;
        }

        public int translateColumn(int n) {
            switch (n) {
                case 0: {
                    return 0;
                }
                case 1: {
                    return 1;
                }
                case 2: {
                    return 2;
                }
                case 3: {
                    return 3;
                }
            }
            throw new ArrayIndexOutOfBoundsException();
        }

        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return CommissioningWizardStep.lex.getText("CommissioningWizard.moduleTable.column.partName");
                }
                case 1: {
                    return CommissioningWizardStep.lex.getText("SoftwareManager.column.currentVersion");
                }
                case 2: {
                    return CommissioningWizardStep.lex.getText("SoftwareManager.column.availableVersion");
                }
                case 3: {
                    return "";
                }
            }
            throw new ArrayIndexOutOfBoundsException();
        }

        public Object getValueAt(int n, int n2) {
            return super.getValueAt(n, this.translateColumn(n2));
        }

        public BImage getCellIcon(int n, int n2) {
            return null;
        }

        public synchronized void startActive() {
            this.isRowSelectEnabled = false;
        }

        public synchronized void stopActive() {
            this.isRowSelectEnabled = true;
        }

        public synchronized boolean isRowSelectEnabled() {
            return this.isRowSelectEnabled;
        }

        public void setAsyncGroup(AsyncGroup asyncGroup) {
            this.asyncGroup = asyncGroup;
        }

        public AsyncGroup getAsyncGroup() {
            return this.asyncGroup;
        }
    }

    class ModuleRow
    extends InstallerTableRow {
        private int requirement = 0;

        public ModuleRow(ModuleTableModel moduleTableModel) {
            super(moduleTableModel);
        }

        public String getComment() {
            switch (this.getRequirement()) {
                case 2: {
                    return CommissioningWizardStep.lex.getText("CommissioningWizard.moduleTable.requiredStation", new Object[]{this.getInstallable().getVersion()});
                }
                case 3: {
                    return CommissioningWizardStep.lex.getText("CommissioningWizard.moduleTable.requiredPlatform", new Object[]{this.getInstallable().getVersion()});
                }
                case 4: {
                    return CommissioningWizardStep.lex.getText("CommissioningWizard.moduleTable.requiredModuleContent", new Object[]{this.getInstallable().getVersion()});
                }
                case 1: {
                    return CommissioningWizardStep.lex.getText("CommissioningWizard.moduleTable.requiredLexicon", new Object[]{this.getInstallable().getVersion()});
                }
            }
            if (!(this.getInstallStatus() != BPartInstallStatus.noChange && this.getInstallStatus() != BPartInstallStatus.notFound || this.getStatus() != 12 && this.getStatus() != 13)) {
                if (this.getStatus() == 12) {
                    return BDaemonSessionView.lexicon.getText("CommissioningWizard.moduleTable.coreRequiredOod");
                }
                if (this.getStatus() == 13) {
                    return BDaemonSessionView.lexicon.getText("CommissioningWizard.moduleTable.coreRequiredMissing");
                }
            }
            return super.getComment();
        }

        public void setInstallable(BInstallable bInstallable) {
            super.setInstallable(bInstallable);
        }

        public void setCurrentPart(BPart bPart) {
            super.setCurrentPart(bPart);
        }

        public int getRequirement() {
            return this.requirement;
        }

        public int compareComment(InstallerTableRow installerTableRow) {
            ModuleRow moduleRow = (ModuleRow)installerTableRow;
            if (this.getRequirement() < moduleRow.getRequirement()) {
                return 1;
            }
            if (this.getRequirement() > moduleRow.getRequirement()) {
                return -1;
            }
            return super.compareComment(moduleRow);
        }

        public boolean isSelectEnabled() {
            return this.getRequirement() <= 1;
        }

        public boolean isSelected() {
            return this.getInstallStatus() != BPartInstallStatus.noChange && this.getInstallStatus() != BPartInstallStatus.notFound;
        }
    }

    private class UnavailableModuleStep
    extends CommissioningWizardStep {
        public UnavailableModuleStep(CommissioningWizardModel commissioningWizardModel) {
            super(commissioningWizardModel);
        }

        public String getSectionName() {
            return "module";
        }

        public int getMode() {
            return 1;
        }

        public String getStepName() {
            return "unavailableModules";
        }

        public void enter() {
            this.initStep();
        }

        public boolean exit(int n) {
            return true;
        }

        public boolean isSkipped() {
            this.initStep();
            return this.wizardModel.initialScenario.canCommit();
        }

        private void initStep() {
            String string;
            if (!ModuleStep.this.analysisResults.anyUnvailable()) {
                return;
            }
            BIndentPane bIndentPane = new BIndentPane();
            bIndentPane.add(this.getLexiconText("CommissioningWizard.unavailableModules.header"));
            bIndentPane.indent();
            boolean bl = false;
            UnmeetableDependency[] unmeetableDependencyArray = ModuleStep.this.analysisResults.getSolution().getUnmeetableDependencies();
            for (int i = 0; i < unmeetableDependencyArray.length; ++i) {
                string = unmeetableDependencyArray[i].toString();
                if (unmeetableDependencyArray[i].failedFilter != null) {
                    string = string + " *";
                    bl = true;
                }
                bIndentPane.add((BWidget)new BLabel(unmeetableDependencyArray[i].getIcon(), string));
            }
            bIndentPane.unindent();
            if (bl) {
                bIndentPane.add((BWidget)new BBox(0.0, 3.0));
                bIndentPane.add(this.getLexiconText("CommissioningWizard.unavailableModules.unlicensed.part1"));
                BFlowPane bFlowPane = new BFlowPane(BHalign.left);
                bFlowPane.add(null, (BValue)new BLabel(lex.getText("CommissioningWizard.unavailableModules.unlicensed.part2")));
                string = new BButton((Command)new LicenseCommand(), true, false);
                string.setFont(Theme.widget().getTextFont());
                string.setPadding(BInsets.make((double)3.0, (double)6.0, (double)3.0, (double)6.0));
                bFlowPane.add(null, (BValue)string);
                bFlowPane.add(null, (BValue)new BLabel(lex.getText("CommissioningWizard.unavailableModules.unlicensed.part3")));
                bIndentPane.add((BWidget)bFlowPane);
            }
            BScrollPane bScrollPane = new BScrollPane((BWidget)new BBorderPane((BWidget)bIndentPane, 4.0, 4.0, 4.0, 4.0));
            bScrollPane.setViewportBackground(Theme.scrollPane().getControlBackground());
            bScrollPane.setBorderPolicy(BScrollBarPolicy.asNeeded);
            this.setContent((BWidget)bScrollPane);
        }
    }
}

