/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.commissioningwizard;

import com.tridium.net.HttpUtil;
import com.tridium.platDaemon.SessionSurrogates;
import com.tridium.platDaemon.ui.DaemonSessionTaskHandler;
import com.tridium.platDaemon.ui.commissioningwizard.CommissioningWizardModel;
import com.tridium.platDaemon.ui.widget.DaemonCredentialsManager;
import com.tridium.platDaemon.ui.widget.TaskDetailDialog;
import com.tridium.platDaemon.ui.widget.TaskDetailPane;
import com.tridium.platform.daemon.BAppSurrogate;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.BStationSurrogate;
import com.tridium.platform.daemon.DaemonFileUtil;
import com.tridium.platform.daemon.file.BDaemonFileSpace;
import com.tridium.platform.daemon.message.DaemonMessage;
import com.tridium.platform.daemon.message.DeleteFileTransferMessageElement;
import com.tridium.platform.daemon.message.DeleteStationMessage;
import com.tridium.platform.daemon.message.FileTransferMessage;
import com.tridium.platform.daemon.message.FileTransferMessageElement;
import com.tridium.platform.daemon.message.OSUpdateMessage;
import com.tridium.platform.daemon.message.RefreshDaemonBinariesMessage;
import com.tridium.platform.daemon.message.SystemPasswordMessageAX;
import com.tridium.platform.daemon.message.UpdateStationMessage;
import com.tridium.platform.daemon.message.UpdateTimeMessage;
import com.tridium.platform.daemon.message.XmlResponseMessage;
import com.tridium.platform.daemon.task.CancelableDaemonSessionTask;
import com.tridium.platform.daemon.task.DaemonSessionTask;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import com.tridium.platform.license.LicenseInfo;
import com.tridium.platform.license.LicenseSync;
import com.tridium.platform.tcpip.BTcpIpHostSettings;
import com.tridium.platform.tcpip.TcpUtil;
import com.tridium.platform.timezone.BDstSupportLevel;
import com.tridium.platform.timezone.TimeZoneUtil;
import com.tridium.platform.ui.util.AuditUtil;
import com.tridium.sys.license.dom.LicenseDatabase;
import java.net.SocketException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import javax.baja.file.FilePath;
import javax.baja.gx.BImage;
import javax.baja.job.BJobState;
import javax.baja.naming.BHost;
import javax.baja.nre.util.Array;
import javax.baja.platform.BStationStatus;
import javax.baja.platform.ICancelHint;
import javax.baja.security.BICredentials;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.ui.BWidget;
import javax.baja.util.Lexicon;

public class FinishPane
extends TaskDetailDialog
implements DaemonSessionTaskListener {
    private String lastText = null;
    private CommissioningWizardModel wizardModel;
    private TaskDetailPane.TaskItem stopAppsItem;
    private TaskDetailPane.TaskItem deleteStationsItem;
    private TaskDetailPane.TaskItem installItem;
    private TaskDetailPane.TaskItem tcpItem;
    private TaskDetailPane.TaskItem osInstallItem;
    private TaskDetailPane.TaskItem dateTimeItem;
    private TaskDetailPane.TaskItem systemPasswordItem;
    private TaskDetailPane.TaskItem authChangeItem;
    private TaskDetailPane.TaskItem rebootItem;
    private TaskDetailPane.TaskItem updateDaemonItem;
    private TaskDetailPane.TaskItem startAppItem;
    private TaskDetailPane.TaskItem moveStagedWin32BinariesItem;
    private TaskDetailPane.TaskItem reconnectItem;
    private Array items = null;
    private static Lexicon lex = Lexicon.make((String)"platDaemon");
    static /* synthetic */ Class class$com$tridium$platDaemon$ui$widget$TaskDetailPane$TaskItem;

    private FinishPane(CommissioningWizardModel commissioningWizardModel) {
        this.wizardModel = commissioningWizardModel;
        this.stopAppsItem = new TaskDetailPane.TaskItem(lex.getText("CommissioningWizard.finish.item.stopApps"));
        this.deleteStationsItem = new TaskDetailPane.TaskItem(lex.getText("CommissioningWizard.finish.item.deleteStations"));
        this.installItem = new TaskDetailPane.TaskItem(lex.getText("CommissioningWizard.finish.item.install"));
        this.tcpItem = new TaskDetailPane.TaskItem(lex.getText("CommissioningWizard.finish.item.updateTcp"));
        this.osInstallItem = new TaskDetailPane.TaskItem(lex.getText("CommissioningWizard.finish.item.osInstall"));
        this.authChangeItem = new TaskDetailPane.TaskItem(lex.getText("CommissioningWizard.finish.item.updateAuth"));
        this.systemPasswordItem = new TaskDetailPane.TaskItem(lex.getText("CommissioningWizard.finish.item.updateSystemPassword"));
        this.dateTimeItem = new TaskDetailPane.TaskItem(lex.getText("CommissioningWizard.finish.item.dateTime"));
        this.rebootItem = new TaskDetailPane.TaskItem(lex.getText("CommissioningWizard.finish.item.reboot"));
        this.updateDaemonItem = new TaskDetailPane.TaskItem(lex.getText("CommissioningWizard.finish.item.updateDaemon"));
        this.startAppItem = new TaskDetailPane.TaskItem(lex.getText("CommissioningWizard.finish.item.startApp"));
        this.moveStagedWin32BinariesItem = new TaskDetailPane.TaskItem(lex.getText("CommissioningWizard.finish.item.moveStagedWin32Binaries"));
        this.reconnectItem = new TaskDetailPane.TaskItem(lex.getText("CommissioningWizard.finish.item.reconnect"));
        this.init(commissioningWizardModel.owner);
    }

    public static void openDialog(CommissioningWizardModel commissioningWizardModel) {
        new FinishPane(commissioningWizardModel).open();
    }

    public String getDialogTitle() {
        return lex.getText("CommissioningWizard.title", new Object[]{this.wizardModel.daemonSession.getRemoteHost().getNavDisplayName(null)});
    }

    public String getHeadingTitle() {
        return lex.getText("CommissioningWizard.finish.mainHeading");
    }

    public BImage getHeadingIcon() {
        return BImage.make((String)lex.getText("CommissioningWizard.wizard.sectionIcon"));
    }

    public String getItemListHeading() {
        return lex.getText("CommissioningWizard.finish.itemHeading");
    }

    public TaskDetailPane.TaskItem[] makeTaskItems() {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        this.items = new Array(class$com$tridium$platDaemon$ui$widget$TaskDetailPane$TaskItem == null ? (class$com$tridium$platDaemon$ui$widget$TaskDetailPane$TaskItem = FinishPane.class$("com.tridium.platDaemon.ui.widget.TaskDetailPane$TaskItem")) : class$com$tridium$platDaemon$ui$widget$TaskDetailPane$TaskItem);
        if (this.wizardModel.stationsToDelete.size() > 0) {
            this.items.add((Object)this.deleteStationsItem);
        }
        if (this.wizardModel.solution.hasChanges()) {
            this.items.add((Object)this.installItem);
            if ((this.wizardModel.solution.getProcessingFlags() & 0x20000L) > 0L) {
                bl3 = true;
                bl = true;
            }
            if ((this.wizardModel.solution.getProcessingFlags() & 0x10000L) > 0L) {
                bl = true;
            } else if ((this.wizardModel.solution.getProcessingFlags() & 0x40000L) > 0L) {
                bl4 = true;
                if (this.wizardModel.updateTcpIpSettings && this.wizardModel.daemonSession.getHostProperties().getOsName().toLowerCase().startsWith("win")) {
                    this.items.add((Object)this.moveStagedWin32BinariesItem);
                    this.items.add((Object)this.reconnectItem);
                }
            }
            bl2 = true;
        }
        if (this.wizardModel.authChanged) {
            this.items.add((Object)this.authChangeItem);
        }
        if (!this.wizardModel.skipSystemPassword && this.wizardModel.newSystemPassword != null && this.wizardModel.oldSystemPassword != null) {
            this.items.add((Object)this.systemPasswordItem);
        }
        if (this.wizardModel.syncLocalTime) {
            this.items.add((Object)this.dateTimeItem);
        }
        if (this.wizardModel.updateTcpIpSettings) {
            this.items.add((Object)this.tcpItem);
            bl2 = true;
            bl = true;
        }
        if (!this.wizardModel.skipStation && this.wizardModel.stationDir != null && !this.wizardModel.restartEnabled) {
            bl = true;
        }
        if (bl3) {
            this.items.add((Object)this.osInstallItem);
        }
        if (bl) {
            this.items.add((Object)this.rebootItem);
        } else {
            boolean bl5 = false;
            if (bl2) {
                try {
                    BAppSurrogate[] bAppSurrogateArray = BAppSurrogate.makeAll(null, (BDaemonSession)this.wizardModel.daemonSession);
                    for (int i = 0; i < bAppSurrogateArray.length; ++i) {
                        if (bAppSurrogateArray[i].isAppStopped()) continue;
                        if (this.wizardModel.restartEnabled) {
                            if (!bl5) {
                                bl5 = true;
                                this.items.add((Object)this.startAppItem);
                            }
                        } else if (!bl) {
                            bl = true;
                            this.items.add((Object)this.rebootItem);
                        }
                        break;
                    }
                }
                catch (RuntimeException runtimeException) {
                    throw runtimeException;
                }
                catch (Exception exception) {
                    throw new BajaRuntimeException((Throwable)exception);
                }
            }
            if (!bl) {
                if (bl4) {
                    this.items.add((Object)this.updateDaemonItem);
                } else if (this.wizardModel.targetStationName != null && this.wizardModel.startStation && !bl5) {
                    bl5 = true;
                    this.items.add((Object)this.startAppItem);
                }
            }
        }
        if (bl2) {
            this.items.add(0, (Object)this.stopAppsItem);
        }
        return (TaskDetailPane.TaskItem[])this.items.trim();
    }

    public void taskStarted(DaemonSessionTask daemonSessionTask) {
        if (this.lastText == null || !daemonSessionTask.getMessage().equals(this.lastText)) {
            this.getLog().append(daemonSessionTask.getMessage() + "\n");
            this.lastText = daemonSessionTask.getMessage();
        }
    }

    public void taskUpdated(DaemonSessionTask daemonSessionTask) {
        if (this.lastText == null || !daemonSessionTask.getMessage().equals(this.lastText)) {
            this.getLog().append(daemonSessionTask.getMessage() + "\n");
            this.lastText = daemonSessionTask.getMessage();
        }
        if (daemonSessionTask instanceof CancelableDaemonSessionTask && !((CancelableDaemonSessionTask)daemonSessionTask).isCancelEnabled()) {
            this.setCancelEnabled(false);
        }
    }

    public void taskFinished(DaemonSessionTask daemonSessionTask) {
    }

    public void updateFileTransferStatus(FileTransferMessageElement fileTransferMessageElement, int n, int n2) {
        this.updateStatusMessage(fileTransferMessageElement.getProgressText());
    }

    public void updateStatusMessage(String string) {
        if (this.lastText == null || !string.equals(this.lastText)) {
            this.getLog().append(string + "\n");
            this.lastText = string;
        }
    }

    public void run() {
        try {
            HashSet hashSet;
            BStationSurrogate bStationSurrogate;
            int n;
            Object object;
            HashMap<Type, BStationSurrogate> hashMap = new HashMap<Type, BStationSurrogate>();
            if (this.items.contains((Object)this.stopAppsItem)) {
                this.setCurrentItem(this.stopAppsItem, BJobState.running);
                this.getLog().append(lex.getText("CommissioningWizard.finish.stopApps"));
                this.getLog().append("\n");
                object = BAppSurrogate.stopAllApps((BDaemonSession)this.wizardModel.daemonSession, null, null, (DaemonSessionTaskListener)new DaemonSessionTaskHandler((BWidget)this.getDialog()));
                if (((BAppSurrogate[])object).length == 0) {
                    this.getLog().append(lex.getText("CommissioningWizard.installDist.stopApps.noneRunning"));
                    this.getLog().append("\n");
                } else {
                    for (n = 0; n < ((FileTransferMessage)object).length; ++n) {
                        bStationSurrogate = (BStationSurrogate)hashMap.get(object[n].getType());
                        if (bStationSurrogate == null) {
                            bStationSurrogate = new HashSet();
                            hashMap.put(object[n].getType(), bStationSurrogate);
                        }
                        bStationSurrogate.add(object[n].getAppName());
                        this.getLog().append(lex.getText("CommissioningWizard.finish.item.stopApps", new Object[]{object[n].toString(null)}));
                        this.getLog().append("\n");
                    }
                }
                this.updateCurrentItemState(BJobState.success);
            }
            if (this.items.contains((Object)this.deleteStationsItem)) {
                this.setCurrentItem(this.deleteStationsItem, BJobState.running);
                this.checkCanceled();
                this.getLog().append(lex.getText("CommissioningWizard.finish.deleteStations"));
                this.getLog().append("\n");
                object = new FileTransferMessage((BDaemonFileSpace)this.wizardModel.daemonSession.getFileSpace());
                for (n = 0; n < this.wizardModel.stationsToDelete.size(); ++n) {
                    bStationSurrogate = (BStationSurrogate)this.wizardModel.stationsToDelete.get(n);
                    object.addElement((FileTransferMessageElement)new DeleteFileTransferMessageElement(new FilePath("!stations/" + bStationSurrogate.getStationName()), (BDaemonFileSpace)this.wizardModel.daemonSession.getFileSpace()));
                    hashSet = (HashSet)hashMap.get(bStationSurrogate.getType());
                    if (hashSet == null) continue;
                    hashSet.remove(bStationSurrogate.getAppName());
                }
                DaemonFileUtil.transfer((BDaemonSession)this.wizardModel.daemonSession, (FileTransferMessage)object, (ICancelHint)this, (DaemonSessionTaskListener)this);
                for (n = 0; n < this.wizardModel.stationsToDelete.size(); ++n) {
                    bStationSurrogate = (BStationSurrogate)this.wizardModel.stationsToDelete.get(n);
                    this.wizardModel.daemonSession.sendMessage((DaemonMessage)new DeleteStationMessage(bStationSurrogate.getStationName()));
                }
                this.updateCurrentItemState(BJobState.success);
            }
            if (this.items.contains((Object)this.installItem)) {
                this.setCurrentItem(this.installItem, BJobState.running);
                this.checkCanceled();
                this.wizardModel.solution.commit((DaemonSessionTaskListener)this, (ICancelHint)this);
                if (!this.wizardModel.skipLicense) {
                    object = null;
                    switch (this.wizardModel.getLicenseAction()) {
                        case 1: {
                            object = this.wizardModel.getFileLicenseSync();
                            break;
                        }
                        case 2: {
                            object = this.wizardModel.portalLicenseSync;
                        }
                    }
                    if (object != null) {
                        for (n = 0; n < ((LicenseSync)object).toAdd.size(); ++n) {
                            LicenseDatabase.LOCAL_INSTANCE.add(((LicenseInfo)((LicenseSync)object).toAdd.get((int)n)).vendorLicense);
                        }
                        for (n = 0; n < ((LicenseSync)object).toUpdate.size(); ++n) {
                            LicenseDatabase.LOCAL_INSTANCE.add(((LicenseInfo)((LicenseSync)object).toUpdate.get((int)n)).vendorLicense);
                        }
                    }
                }
                this.updateCurrentItemState(BJobState.success);
            }
            if (this.items.contains((Object)this.moveStagedWin32BinariesItem)) {
                this.setCurrentItem(this.moveStagedWin32BinariesItem, BJobState.running);
                this.getLog().append(lex.getText("CommissioningWizard.finish.moveStagedWin32Binaries"));
                this.getLog().append("\n");
                object = BAppSurrogate.makeAll(null, (BDaemonSession)this.wizardModel.daemonSession);
                boolean[] blArray = new boolean[((BAppSurrogate[])object).length];
                for (int i = 0; i < ((BAppSurrogate[])object).length; ++i) {
                    if (object[i].getIsAutoStart()) {
                        blArray[i] = true;
                        object[i].updateSettings(false, object[i].getIsAutoRestart());
                        continue;
                    }
                    blArray[i] = false;
                }
                try {
                    this.wizardModel.daemonSession.sendMessage((DaemonMessage)RefreshDaemonBinariesMessage.getInstance());
                }
                catch (SocketException socketException) {
                    // empty catch block
                }
                this.setCancelEnabled(true);
                this.reconnect();
                for (int i = 0; i < ((BTimeZone)object).length; ++i) {
                    if (!blArray[i]) continue;
                    object[i].updateSettings(true, object[i].getIsAutoRestart());
                }
                this.wizardModel.tcpIpSettings = TcpUtil.updateAdapterNames((BTcpIpHostSettings)this.wizardModel.originalTcpIpSettings, (BDaemonSession)this.wizardModel.daemonSession, (BTcpIpHostSettings)this.wizardModel.tcpIpSettings);
            } else {
                this.setCancelEnabled(true);
            }
            if (this.items.contains((Object)this.authChangeItem)) {
                this.setCurrentItem(this.authChangeItem, BJobState.running);
                this.checkCanceled();
                this.getLog().append(lex.getText("CommissioningWizard.finish.updateAuth"));
                this.getLog().append("\n");
                this.wizardModel.daemonSession.sendMessage((DaemonMessage)new UpdateAuthMessage());
                Thread.sleep(5000L);
                DaemonCredentialsManager.setCredentials(this.wizardModel.daemonSession, (BICredentials)this.wizardModel.newCredentials);
                this.updateCurrentItemState(BJobState.success);
            }
            if (this.wizardModel.targetStationName != null) {
                this.wizardModel.daemonSession.sendMessage((DaemonMessage)new UpdateStationMessage());
                this.wizardModel.daemonSession.sendMessage((DaemonMessage)new UpdateStationMessage(this.wizardModel.targetStationName, false, this.wizardModel.autoStart, this.wizardModel.autoRestart, true));
            }
            if (this.items.contains((Object)this.systemPasswordItem)) {
                this.setCurrentItem(this.systemPasswordItem, BJobState.running);
                this.checkCanceled();
                this.getLog().append(lex.getText("CommissioningWizard.finish.updateSystemPassword"));
                this.getLog().append("\n");
                this.wizardModel.daemonSession.sendMessage((DaemonMessage)new SystemPasswordMessageAX(this.wizardModel.newSystemPassword, this.wizardModel.oldSystemPassword, false));
                this.updateCurrentItemState(BJobState.success);
                this.setCancelEnabled(false);
            }
            if (this.items.contains((Object)this.dateTimeItem)) {
                this.setCurrentItem(this.dateTimeItem, BJobState.running);
                object = BTimeZone.getLocal();
                String string = object.getId();
                if (!TimeZoneUtil.isSupported((BTimeZone)object, (BDstSupportLevel)this.wizardModel.daemonSession.getHostProperties().getTimezoneDayModeSupport())) {
                    object = BTimeZone.UTC;
                }
                BDstSupportLevel bDstSupportLevel = this.wizardModel.daemonSession.getHostProperties().getTimezoneDayModeSupport();
                object = TimeZoneUtil.makeCompatible((BTimeZone)object, (BDstSupportLevel)bDstSupportLevel);
                this.wizardModel.daemonSession.sendMessage((DaemonMessage)new UpdateTimeMessage(BAbsTime.now(), string, (BTimeZone)object));
                this.updateCurrentItemState(BJobState.success);
            }
            if (this.items.contains((Object)this.tcpItem)) {
                this.setCurrentItem(this.tcpItem, BJobState.running);
                this.checkCanceled();
                this.getLog().append(lex.getText("CommissioningWizard.finish.updateTcp"));
                this.getLog().append("\n");
                TcpUtil.saveToSession((BTcpIpHostSettings)this.wizardModel.tcpIpSettings, (BDaemonSession)this.wizardModel.daemonSession, (boolean)this.wizardModel.hostFileDirty);
                AuditUtil.audit((String)"ipchanges", (BHost)this.wizardModel.daemonSession.getHost(), (String)"CommissioningWizard", (BComponent)this.wizardModel.originalTcpIpSettings, (BComponent)this.wizardModel.tcpIpSettings);
                this.updateCurrentItemState(BJobState.success);
                this.setCancelEnabled(false);
            }
            if (this.items.contains((Object)this.osInstallItem)) {
                this.setCurrentItem(this.osInstallItem, BJobState.running);
                this.getLog().append(lex.getText("CommissioningWizard.finish.osInstall"));
                this.getLog().append("\n");
                this.wizardModel.daemonSession.sendMessage((DaemonMessage)OSUpdateMessage.getInstance(), 60000);
                this.updateCurrentItemState(BJobState.success);
            }
            if (this.items.contains((Object)this.rebootItem)) {
                this.setCurrentItem(this.rebootItem, BJobState.running);
                this.getLog().append(lex.getText("CommissioningWizard.finish.reboot"));
                this.getLog().append("\n");
                this.wizardModel.daemonSession.sendRebootRequest();
                this.wizardModel.reconnectOnFinish = false;
                this.updateCurrentItemState(BJobState.success);
            } else if (this.items.contains((Object)this.updateDaemonItem)) {
                this.setCurrentItem(this.updateDaemonItem, BJobState.running);
                this.getLog().append(lex.getText("CommissioningWizard.finish.updateDaemon"));
                this.getLog().append("\n");
                try {
                    this.wizardModel.daemonSession.sendMessage((DaemonMessage)RefreshDaemonBinariesMessage.getInstance());
                }
                catch (SocketException socketException) {
                    // empty catch block
                }
                this.wizardModel.reconnectOnFinish = false;
                this.updateCurrentItemState(BJobState.success);
            } else {
                if (this.wizardModel.getLicenseAction() != 0) {
                    this.wizardModel.daemonSession.sendMessage((DaemonMessage)new ReloadLicenseMessage());
                }
                if (this.items.contains((Object)this.startAppItem)) {
                    this.setCurrentItem(this.startAppItem, BJobState.running);
                    this.checkCanceled();
                    this.getLog().append(lex.getText("CommissioningWizard.finish.startApp.header"));
                    this.getLog().append("\n");
                    object = new SessionSurrogates(this.wizardModel.daemonSession);
                    ((SessionSurrogates)object).getVector(true);
                    BStationSurrogate bStationSurrogate2 = hashMap.keySet().iterator();
                    while (bStationSurrogate2.hasNext()) {
                        Type type = (Type)bStationSurrogate2.next();
                        hashSet = (HashSet)hashMap.get(type);
                        Iterator iterator = hashSet.iterator();
                        while (iterator.hasNext()) {
                            BAppSurrogate bAppSurrogate = ((SessionSurrogates)object).get(type, (String)iterator.next(), false);
                            if (bAppSurrogate == null) continue;
                            bAppSurrogate.startAppAsync();
                            this.getLog().append(lex.getText("CommissioningWizard.finish.startApp.item", new Object[]{bAppSurrogate.toString(null)}));
                            this.getLog().append("\n");
                        }
                    }
                    if (this.wizardModel.targetStationName != null && this.wizardModel.startStation && (bStationSurrogate2 = (BStationSurrogate)((SessionSurrogates)object).get(BStationSurrogate.TYPE, this.wizardModel.targetStationName, false)) != null && bStationSurrogate2.getAppStatus() == BStationStatus.idle) {
                        bStationSurrogate2.startAppAsync();
                        this.getLog().append(lex.getText("CommissioningWizard.finish.startApp.item", new Object[]{bStationSurrogate2.toString(null)}));
                        this.getLog().append("\n");
                    }
                    this.updateCurrentItemState(BJobState.success);
                }
            }
            this.checkCanceled();
            this.getLog().append(lex.getText("CommissioningWizard.finish.done"));
            this.getLog().append("\n");
            this.setBottomLabelText(lex.getText("CommissioningWizard.finish.done"));
        }
        catch (ICancelHint.CanceledException canceledException) {
            this.updateCurrentItemState(BJobState.canceled);
            this.getLog().append(lex.getText("CommissioningWizard.finish.canceled"));
            this.getLog().append("\n");
            this.setBottomLabelText(lex.getText("CommissioningWizard.finish.canceled"));
        }
        catch (Throwable throwable) {
            this.setCancelEnabled(true);
            this.cancel(false);
            this.updateCurrentItemState(BJobState.failed);
            throwable.printStackTrace();
            this.getLog().append(throwable);
            this.setBottomLabelText(lex.getText("CommissioningWizard.finish.failed"));
        }
    }

    private void reconnect() throws Exception {
        this.updateCurrentItemState(BJobState.success);
        this.setCurrentItem(this.reconnectItem, BJobState.running);
        this.getLog().append(lex.getText("CommissioningWizard.finish.reconnect"));
        this.getLog().append("\n");
        String string = this.wizardModel.daemonSession.getHostProperties().getSessionTimestamp();
        Dots dots = new Dots();
        dots.start();
        while (!this.isCanceled()) {
            try {
                this.wizardModel.daemonSession.reloadHostProperties(15000);
                if (this.wizardModel.daemonSession.getHostProperties().getSessionTimestamp().equals(string)) continue;
                dots.cancel();
                this.getLog().append(lex.getText("CommissioningWizard.finish.reconnected"));
                this.getLog().append("\n");
                this.updateCurrentItemState(BJobState.success);
                Thread.sleep(5000L);
                break;
            }
            catch (SocketException socketException) {
            }
        }
        dots.cancel();
        this.updateCurrentItemState(BJobState.success);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class ReloadLicenseMessage
    extends XmlResponseMessage {
        private ReloadLicenseMessage() {
        }

        public String getMessageString() {
            return "updatedaemon?reloadLicenses=true";
        }
    }

    private class UpdateAuthMessage
    extends XmlResponseMessage {
        private StringBuffer buf = new StringBuffer("auth?update=true&authtype=");

        public UpdateAuthMessage() {
            this.buf.append(HttpUtil.encodeUrl((String)((FinishPane)FinishPane.this).wizardModel.authMethod));
            if (((FinishPane)FinishPane.this).wizardModel.authMethod.equals("basic/native")) {
                if (((FinishPane)FinishPane.this).wizardModel.userGroup.sid == null) {
                    this.buf.append("&usergroup=");
                    this.buf.append(HttpUtil.encodeUrl((String)((FinishPane)FinishPane.this).wizardModel.userGroup.name));
                } else {
                    this.buf.append("&usergroupsid=");
                    this.buf.append(HttpUtil.encodeUrl((String)((FinishPane)FinishPane.this).wizardModel.userGroup.sid));
                }
                if (((FinishPane)FinishPane.this).wizardModel.adminGroup.sid == null) {
                    this.buf.append("&admingroup=");
                    this.buf.append(HttpUtil.encodeUrl((String)((FinishPane)FinishPane.this).wizardModel.adminGroup.name));
                } else {
                    this.buf.append("&admingroupsid=");
                    this.buf.append(HttpUtil.encodeUrl((String)((FinishPane)FinishPane.this).wizardModel.adminGroup.sid));
                }
                this.buf.append("&stationIsAdmin=");
                this.buf.append(String.valueOf(((FinishPane)FinishPane.this).wizardModel.stationIsAdmin));
            } else {
                this.buf.append("&user=");
                this.buf.append(HttpUtil.encodeUrl((String)((FinishPane)FinishPane.this).wizardModel.adminUser));
                this.buf.append("&password=");
                try {
                    this.buf.append(HttpUtil.encodeUrl((String)((FinishPane)FinishPane.this).wizardModel.adminPassword.encodeToString()));
                }
                catch (Exception exception) {
                    throw new BajaRuntimeException((Throwable)exception);
                }
            }
        }

        public String getMessageString() {
            return this.buf.toString();
        }

        public int getConnectionFlags() {
            return 16;
        }
    }

    private class Dots
    extends Thread {
        private boolean dotCanceled = false;
        private boolean dotRunning = true;
        private int i = 0;

        private Dots() {
        }

        public void run() {
            while (!this.dotCanceled) {
                try {
                    Thread.sleep(1000L);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (this.i++ > 60) {
                    FinishPane.this.getLog().append("\n");
                    this.i = 0;
                }
                FinishPane.this.getLog().append(".");
            }
            FinishPane.this.getLog().append("\n");
            this.dotRunning = false;
        }

        public synchronized void cancel() {
            this.dotCanceled = true;
            while (this.dotRunning) {
                try {
                    Thread.sleep(300L);
                }
                catch (Throwable throwable) {}
            }
        }
    }
}

