/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.commissioningwizard;

import com.tridium.install.BDaemonPlatform;
import com.tridium.install.BDependency;
import com.tridium.install.DependencyUtil;
import com.tridium.install.InstallScenario;
import com.tridium.install.UnmeetableDependency;
import com.tridium.install.installable.BDistribution;
import com.tridium.install.installable.BInstallable;
import com.tridium.install.installable.BModuleInstallable;
import com.tridium.install.installable.InstallableRegistry;
import com.tridium.install.installable.LocalInstallableRegistry;
import com.tridium.install.part.BPart;
import com.tridium.platDaemon.ui.commissioningwizard.CommissioningWizardModel;
import com.tridium.platDaemon.ui.commissioningwizard.CommissioningWizardStep;
import com.tridium.platform.daemon.file.StoreCache;
import com.tridium.platform.daemon.task.CancelableDaemonSessionTask;
import com.tridium.platform.daemon.task.DaemonSessionTask;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import com.tridium.platform.ui.util.BBox;
import com.tridium.platform.ui.util.BIndentPane;
import com.tridium.ui.theme.Theme;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.IFilter;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.ui.BButton;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.pane.BFlowPane;

public class DistStep
extends CommissioningWizardStep
implements DaemonSessionTaskListener {
    private BLabel messageLabel;
    private BCheckBox reinstallCheckBox = null;
    private InstallScenario solution;
    private boolean hasCommitPrivileges;
    private static final BIcon WARN_ICON = BIcon.std((String)"warning.png");
    private int mode = 0;
    private CancelableDaemonSessionTask cancelable = null;
    static /* synthetic */ Class class$com$tridium$install$installable$BInstallable;
    static /* synthetic */ Class class$com$tridium$install$installable$BDistribution;

    public DistStep(CommissioningWizardModel commissioningWizardModel) {
        super(commissioningWizardModel);
    }

    public String getStepName() {
        return "dist";
    }

    public String getSectionName() {
        return "dist";
    }

    public void enter() {
        block27: {
            this.wizardModel.sessionTaskHandler.waitAllTasks();
            this.cancelable = null;
            this.solution = null;
            BDistribution bDistribution = null;
            try {
                if (this.wizardModel.moduleScenarioHasDists && this.wizardModel.skipDistInstall) {
                    this.solution = this.wizardModel.moduleScenario;
                } else {
                    Array array;
                    InstallScenario installScenario = this.wizardModel.moduleScenario;
                    if (this.wizardModel.moduleScenarioHasDists) {
                        array = new Array(class$com$tridium$install$installable$BInstallable == null ? (class$com$tridium$install$installable$BInstallable = DistStep.class$("com.tridium.install.installable.BInstallable")) : class$com$tridium$install$installable$BInstallable);
                        array.addAll((Object[])installScenario.getToInstall());
                        array = array.filter(new IFilter(){

                            public boolean accept(Object object) {
                                return object instanceof BModuleInstallable;
                            }
                        });
                        installScenario = new InstallScenario(installScenario.getTargetPlatform(), null, installScenario.getUnmetDependencies(), (BInstallable[])array.trim(), null, null, installScenario.getNewModuleContent(), installScenario.getSolutionParameters(), (InstallableRegistry)LocalInstallableRegistry.getInstance());
                        if (installScenario.getExcludedInstallables().length > 0) {
                            this.solution = this.wizardModel.moduleScenario;
                        }
                    }
                    if (installScenario.getExcludedInstallables().length == 0) {
                        array = LocalInstallableRegistry.getInstance().getInstallables(true, (DaemonSessionTaskListener)this.wizardModel.sessionTaskHandler, this.wizardModel.getPlatform().getConfigDistFileName());
                        while (array.next(class$com$tridium$install$installable$BDistribution == null ? DistStep.class$("com.tridium.install.installable.BDistribution") : class$com$tridium$install$installable$BDistribution)) {
                            BDistribution bDistribution2 = (BDistribution)array.get();
                            boolean bl = this.wizardModel.acceptInstallable((BInstallable)bDistribution2);
                            InstallScenario installScenario2 = installScenario.solve((DaemonSessionTaskListener)this.wizardModel.sessionTaskHandler, null, null, new BInstallable[]{bDistribution2}, (InstallableRegistry)LocalInstallableRegistry.getInstance());
                            if (installScenario2.canCommit()) {
                                installScenario2 = installScenario2.solve((DaemonSessionTaskListener)this.wizardModel.sessionTaskHandler, null, DependencyUtil.getPlatformModuleDependencies((BDaemonPlatform)this.wizardModel.getPlatform(), (BDistribution)bDistribution2), null, (InstallableRegistry)LocalInstallableRegistry.getInstance());
                            }
                            if (installScenario2.canCommit()) {
                                this.solution = installScenario2;
                                break;
                            }
                            if (installScenario2.getExcludedInstallables().length != 0 || this.solution != null && installScenario2.getUnmeetableDependencies().length >= this.solution.getUnmeetableDependencies().length) continue;
                            boolean bl2 = false;
                            BDependency[] bDependencyArray = installScenario2.getUnmetDependencies();
                            for (int i = 0; i < bDependencyArray.length; ++i) {
                                BPart bPart;
                                BDependency bDependency = bDependencyArray[i];
                                if (!bDependency.isPlatformDependency() || (bPart = this.wizardModel.getPlatform().getPart(bDependency)) != null && bPart.isInstallable()) continue;
                                bl2 = true;
                                break;
                            }
                            if (bl2) continue;
                            if (bl) {
                                this.solution = installScenario2;
                                continue;
                            }
                            if (bDistribution != null) continue;
                            bDistribution = bDistribution2;
                        }
                    }
                }
                if (this.solution == null) {
                    this.setContent(this.getNoDistsContent(bDistribution));
                    if (!this.wizardModel.requireDistStep) {
                        this.setMode(3);
                    } else {
                        this.setMode(1);
                    }
                    break block27;
                }
                try {
                    if (this.solution.canCommit()) {
                        long l = this.solution.getProcessingFlags();
                        if (!(this.wizardModel.isAdmin || (l & 0x10000L) <= 0L && (l & 0x80000L) <= 0L && (l & 0x20000L) <= 0L)) {
                            this.setContent(this.getInsufficientPrivilegesContent());
                            this.hasCommitPrivileges = false;
                            if (this.wizardModel.requireDistStep) {
                                this.setMode(1);
                            } else {
                                this.setMode(3);
                            }
                        } else {
                            this.setContent(this.getSummaryContent(bDistribution));
                            this.hasCommitPrivileges = true;
                            this.setMode(3);
                        }
                    } else {
                        this.setContent(this.getUnmetDependenciesContent(bDistribution));
                        if (this.wizardModel.requireDistStep) {
                            this.setMode(1);
                        } else {
                            this.setMode(3);
                        }
                    }
                }
                catch (RuntimeException runtimeException) {
                    throw runtimeException;
                }
                catch (Exception exception) {
                    throw exception;
                }
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new BajaRuntimeException((Throwable)exception);
            }
        }
    }

    private BWidget getSummaryContent(BDistribution bDistribution) throws Exception {
        int n;
        BIndentPane bIndentPane = new BIndentPane();
        BInstallable[] bInstallableArray = this.solution.getToInstall();
        boolean bl = false;
        for (n = 0; n < bInstallableArray.length; ++n) {
            if (!(bInstallableArray[n] instanceof BDistribution) || !((BDistribution)bInstallableArray[n]).hasFileUpdates((BDaemonPlatform)this.wizardModel.getPlatform(), new StoreCache(), null, (DaemonSessionTaskListener)this)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            bIndentPane.add(this.getLexiconText("CommissioningWizard.dist.summary.reinstall.head"));
        } else {
            bIndentPane.add(this.getLexiconText("CommissioningWizard.dist.summary.head"));
        }
        bIndentPane.add((BWidget)new BBox(0.0, 3.0));
        bIndentPane.indent();
        for (n = 0; n < bInstallableArray.length; ++n) {
            if (!(bInstallableArray[n] instanceof BDistribution)) continue;
            bIndentPane.add((BWidget)new BLabel(BImage.make((BIcon)bInstallableArray[n].getIcon()), bInstallableArray[n].toString()));
        }
        bIndentPane.unindent();
        bIndentPane.add((BWidget)new BBox(0.0, 6.0));
        if (!bl) {
            this.reinstallCheckBox = new BCheckBox(lex.getText("CommissioningWizard.dist.summary.reinstall.checkbox"));
            bIndentPane.add((BWidget)this.reinstallCheckBox);
            if (bDistribution != null) {
                bIndentPane.add((BWidget)new BBox(0.0, 6.0));
                BLabel bLabel = new BLabel(BImage.make((BIcon)WARN_ICON), lex.getText("CommissioningWizard.dist.summary.reinstall.unlicensed", new Object[]{bDistribution.getVersion().getVendorVersionString(), this.wizardModel.getNewLicenseVersion()}));
                bLabel.setHalign(BHalign.left);
                bIndentPane.add((BWidget)bLabel);
                bIndentPane.add((BWidget)new BBox(0.0, 6.0));
                BFlowPane bFlowPane = new BFlowPane(BHalign.left);
                bFlowPane.add(null, (BValue)new BLabel(lex.getText("CommissioningWizard.dist.summary.reinstall.unlicensed.foot.part1")));
                BButton bButton = new BButton((Command)new LicenseCommand(), true, false);
                bButton.setFont(Theme.widget().getTextFont());
                bButton.setPadding(BInsets.make((double)3.0, (double)6.0, (double)3.0, (double)6.0));
                bFlowPane.add(null, (BValue)bButton);
                bFlowPane.add(null, (BValue)new BLabel(lex.getText("CommissioningWizard.dist.summary.reinstall.unlicensed.foot.part2")));
                bIndentPane.add((BWidget)bFlowPane);
            }
        } else {
            this.reinstallCheckBox = null;
            if (bDistribution == null) {
                bIndentPane.add(this.getLexiconText("CommissioningWizard.dist.summary.foot"));
            } else {
                BLabel bLabel = new BLabel(BImage.make((BIcon)WARN_ICON), lex.getText("CommissioningWizard.dist.summary.unlicensed", new Object[]{bDistribution.getVersion().getVendorVersionString(), this.wizardModel.getNewLicenseVersion()}));
                bLabel.setHalign(BHalign.left);
                bIndentPane.add((BWidget)bLabel);
                bIndentPane.add((BWidget)new BBox(0.0, 6.0));
                BFlowPane bFlowPane = new BFlowPane(BHalign.left);
                bFlowPane.add(null, (BValue)new BLabel(lex.getText("CommissioningWizard.dist.summary.unlicensed.foot.part1")));
                BButton bButton = new BButton((Command)new LicenseCommand(), true, false);
                bButton.setFont(Theme.widget().getTextFont());
                bButton.setPadding(BInsets.make((double)3.0, (double)6.0, (double)3.0, (double)6.0));
                bFlowPane.add(null, (BValue)bButton);
                bFlowPane.add(null, (BValue)new BLabel(lex.getText("CommissioningWizard.dist.summary.unlicensed.foot.part2")));
                bIndentPane.add((BWidget)bFlowPane);
            }
        }
        return bIndentPane;
    }

    private BWidget getInsufficientPrivilegesContent() throws Exception {
        BIndentPane bIndentPane = new BIndentPane();
        BInstallable[] bInstallableArray = this.solution.getToInstall();
        bIndentPane.add((BWidget)new BLabel(BImage.make((BIcon)BIcon.std((String)"warning.png")), lex.getText("CommissioningWizard.dist.noPrivs.head")));
        bIndentPane.add((BWidget)new BBox(0.0, 3.0));
        bIndentPane.indent();
        for (int i = 0; i < bInstallableArray.length; ++i) {
            bIndentPane.add((BWidget)new BLabel(BImage.make((BIcon)bInstallableArray[i].getIcon()), bInstallableArray[i].toString()));
        }
        bIndentPane.unindent();
        bIndentPane.add((BWidget)new BBox(0.0, 6.0));
        if (this.wizardModel.requireDistStep) {
            bIndentPane.add(this.getLexiconText("CommissioningWizard.dist.noPrivs.foot.required"));
        } else {
            bIndentPane.add(this.getLexiconText("CommissioningWizard.dist.noPrivs.foot"));
        }
        return bIndentPane;
    }

    private BWidget getNoDistsContent(BDistribution bDistribution) throws Exception {
        String string;
        String string2;
        BIndentPane bIndentPane = new BIndentPane();
        String string3 = null;
        if (bDistribution == null) {
            if (this.wizardModel.requireDistStep) {
                string2 = lex.getText("CommissioningWizard.dist.noDists.head.required");
                string = lex.getText("CommissioningWizard.dist.noDists.foot.required");
            } else {
                string2 = lex.getText("CommissioningWizard.dist.noDists.head");
                string = lex.getText("CommissioningWizard.dist.noDists.foot");
            }
        } else if (this.wizardModel.requireDistStep) {
            string2 = lex.getText("CommissioningWizard.dist.noLicensedDists.head.required", new Object[]{bDistribution.getVersion().getVendorVersionString(), this.wizardModel.getNewLicenseVersion()});
            string = lex.getText("CommissioningWizard.dist.noLicensedDists.foot.required.part1");
            string3 = lex.getText("CommissioningWizard.dist.noLicensedDists.foot.required.part2");
        } else {
            string2 = lex.getText("CommissioningWizard.dist.noLicensedDists.head", new Object[]{bDistribution.getVersion().getVendorVersionString(), this.wizardModel.getNewLicenseVersion()});
            string = lex.getText("CommissioningWizard.dist.noLicensedDists.foot.part1");
            string3 = lex.getText("CommissioningWizard.dist.noLicensedDists.foot.part2");
        }
        BLabel bLabel = new BLabel(BImage.make((BIcon)WARN_ICON), string2);
        bLabel.setHalign(BHalign.left);
        bIndentPane.add((BWidget)bLabel);
        bIndentPane.add((BWidget)new BBox(0.0, 3.0));
        if (string3 == null) {
            bIndentPane.add(string);
        } else {
            BFlowPane bFlowPane = new BFlowPane(BHalign.left);
            bFlowPane.add(null, (BValue)new BLabel(string));
            BButton bButton = new BButton((Command)new LicenseCommand(), true, false);
            bButton.setFont(Theme.widget().getTextFont());
            bButton.setPadding(BInsets.make((double)3.0, (double)6.0, (double)3.0, (double)6.0));
            bFlowPane.add(null, (BValue)bButton);
            bFlowPane.add(null, (BValue)new BLabel(string3));
            bIndentPane.add((BWidget)bFlowPane);
        }
        return bIndentPane;
    }

    private BWidget getUnmetDependenciesContent(BDistribution bDistribution) throws Exception {
        BIndentPane bIndentPane = new BIndentPane();
        bIndentPane.add((BWidget)new BLabel(BImage.make((BIcon)BIcon.std((String)"warning.png")), lex.getText("CommissioningWizard.dist.unmetDeps.head")));
        bIndentPane.add((BWidget)new BBox(0.0, 3.0));
        bIndentPane.indent();
        UnmeetableDependency[] unmeetableDependencyArray = this.solution.getUnmeetableDependencies();
        if (unmeetableDependencyArray != null && unmeetableDependencyArray.length > 0) {
            for (int i = 0; i < unmeetableDependencyArray.length; ++i) {
                bIndentPane.add((BWidget)new BLabel(unmeetableDependencyArray[i].getIcon(), unmeetableDependencyArray[i].toString(null)));
            }
        }
        if (unmeetableDependencyArray == null || unmeetableDependencyArray.length == 0) {
            BDependency[] bDependencyArray = this.solution.getUnmetDependencies();
            for (int i = 0; i < bDependencyArray.length; ++i) {
                bIndentPane.add((BWidget)new BLabel(BImage.make((BIcon)bDependencyArray[i].getIcon()), bDependencyArray[i].toString(null)));
            }
        }
        bIndentPane.unindent();
        bIndentPane.add((BWidget)new BBox(0.0, 6.0));
        if (this.wizardModel.requireDistStep) {
            if (bDistribution == null) {
                bIndentPane.add(this.getLexiconText("CommissioningWizard.dist.unmetDeps.foot.required"));
            } else {
                BLabel bLabel = new BLabel(BImage.make((BIcon)WARN_ICON), lex.getText("CommissioningWizard.dist.unmetDeps.requiredUnlicensed", new Object[]{bDistribution.getVersion().getVendorVersionString(), this.wizardModel.getNewLicenseVersion()}));
                bLabel.setHalign(BHalign.left);
                bIndentPane.add((BWidget)bLabel);
                bIndentPane.add((BWidget)new BBox(0.0, 6.0));
                BFlowPane bFlowPane = new BFlowPane(BHalign.left);
                bFlowPane.add(null, (BValue)new BLabel(lex.getText("CommissioningWizard.dist.unmetDeps.requiredUnlicensed.foot.part1")));
                BButton bButton = new BButton((Command)new LicenseCommand(), true, false);
                bButton.setFont(Theme.widget().getTextFont());
                bButton.setPadding(BInsets.make((double)3.0, (double)6.0, (double)3.0, (double)6.0));
                bFlowPane.add(null, (BValue)bButton);
                bFlowPane.add(null, (BValue)new BLabel(lex.getText("CommissioningWizard.dist.unmetDeps.requiredUnlicensed.foot.part2")));
                bIndentPane.add((BWidget)bFlowPane);
            }
        } else if (bDistribution == null) {
            bIndentPane.add(this.getLexiconText("CommissioningWizard.dist.unmetDeps.foot"));
        } else {
            BLabel bLabel = new BLabel(BImage.make((BIcon)WARN_ICON), lex.getText("CommissioningWizard.dist.unmetDeps.unlicensed", new Object[]{bDistribution.getVersion().getVendorVersionString(), this.wizardModel.getNewLicenseVersion()}));
            bLabel.setHalign(BHalign.left);
            bIndentPane.add((BWidget)bLabel);
            bIndentPane.add((BWidget)new BBox(0.0, 6.0));
            bIndentPane.add(this.getLexiconText("CommissioningWizard.dist.unmetDeps.unlicensed.foot"));
            BButton bButton = new BButton((Command)new LicenseCommand(), true, false);
            bButton.setFont(Theme.widget().getTextFont());
            bButton.setPadding(BInsets.make((double)3.0, (double)6.0, (double)3.0, (double)6.0));
            bIndentPane.add((BWidget)bButton);
        }
        return bIndentPane;
    }

    public boolean exit(int n) {
        if (this.cancelable != null) {
            this.cancelable.cancel();
        }
        this.wizardModel.distSolution = (this.reinstallCheckBox == null || this.reinstallCheckBox.isSelected()) && this.hasCommitPrivileges ? this.solution : null;
        return true;
    }

    public int getMode() {
        return this.mode;
    }

    public boolean isSkipped() {
        return this.wizardModel.skipDistInstall && !this.wizardModel.moduleScenarioHasDists;
    }

    public boolean cancel() {
        if (this.cancelable != null) {
            this.cancelable.cancel();
        }
        return true;
    }

    public void abort() {
        this.messageLabel.setText(lex.getText("CommissioningWizard.dist.abort"));
        this.setMode(1);
    }

    public void setStepAfterSection(CommissioningWizardStep commissioningWizardStep) {
        this.stepAfterSection = commissioningWizardStep;
        this.lastStep.nextStep = commissioningWizardStep;
        if (commissioningWizardStep != null) {
            commissioningWizardStep.priorStep = this;
        }
    }

    private void setMode(int n) {
        if (this.mode != n) {
            this.mode = n;
            if (this.wizardModel.getCurrentStep() == this) {
                this.wizardModel.update(this.mode);
            }
        }
    }

    public void taskStarted(DaemonSessionTask daemonSessionTask) {
        if (daemonSessionTask instanceof CancelableDaemonSessionTask) {
            this.cancelable = (CancelableDaemonSessionTask)daemonSessionTask;
        }
    }

    public void taskUpdated(DaemonSessionTask daemonSessionTask) {
    }

    public void taskFinished(DaemonSessionTask daemonSessionTask) {
        if (daemonSessionTask == this.cancelable) {
            this.cancelable = null;
        }
    }

    public boolean isCancelEnabled() {
        return true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class LicenseCommand
    extends Command {
        public LicenseCommand() {
            super(DistStep.this.wizardModel.owner, CommissioningWizardStep.lex.getText("CommissioningWizard.dist.goLicense"), null, null, null);
        }

        public CommandArtifact doInvoke() {
            if (DistStep.this.exit(1)) {
                DistStep.this.wizardModel.licenseStep.enter();
                DistStep.this.wizardModel.update(DistStep.this.wizardModel.licenseStep);
            }
            return null;
        }
    }
}

