/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.commissioningwizard;

import com.tridium.install.part.BOsPart;
import com.tridium.net.HttpUtil;
import com.tridium.nre.auth.SecurityUtil;
import com.tridium.platDaemon.ui.acctmgt.WinNtAccount;
import com.tridium.platDaemon.ui.commissioningwizard.CommissioningWizardModel;
import com.tridium.platDaemon.ui.commissioningwizard.CommissioningWizardStep;
import com.tridium.platDaemon.ui.config.DigestFilePasswordController;
import com.tridium.platDaemon.ui.config.QnxUserNameController;
import com.tridium.platform.daemon.message.DaemonMessage;
import com.tridium.platform.daemon.message.XmlResponseMessage;
import com.tridium.platform.ui.util.LabelUtil;
import com.tridium.workbench.fieldeditors.BPasswordFE;
import java.io.InputStream;
import javax.baja.nre.util.TextUtil;
import javax.baja.security.BPassword;
import javax.baja.security.BUsernameAndPassword;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BRadioButton;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.ToggleCommandGroup;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.text.TextController;
import javax.baja.ui.text.TextModel;
import javax.baja.util.LexiconText;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

public class AuthStep
extends CommissioningWizardStep {
    private UserStep userStep = null;
    private CredentialsStep credentialsStep = null;
    private BRadioButton digestFileButton = null;
    private BRadioButton basicNativeButton = null;
    private boolean stepInitialized = false;

    public AuthStep(CommissioningWizardModel commissioningWizardModel) {
        super(commissioningWizardModel);
    }

    public String getStepName() {
        return "authMethod";
    }

    public String getSectionName() {
        return "auth";
    }

    public void enter() {
        this.initStep();
        if (this.wizardModel.authMethod.equals("basic/native")) {
            this.basicNativeButton.setSelected(true);
            this.nextStep = this.credentialsStep;
            this.lastStep = this.credentialsStep.lastStep;
        } else {
            this.digestFileButton.setSelected(true);
            this.nextStep = this.userStep;
            this.lastStep = this.userStep.lastStep;
        }
        this.setStepAfterSection(this.stepAfterSection);
    }

    public boolean exit(int n) {
        if (this.digestFileButton.isSelected()) {
            if (!this.wizardModel.authMethod.equals("digest/file")) {
                this.wizardModel.authMethod = "digest/file";
                this.wizardModel.authChanged = true;
            }
        } else if (!this.wizardModel.authMethod.equals("basic/native")) {
            this.wizardModel.authMethod = "basic/native";
            this.wizardModel.authChanged = true;
        }
        return true;
    }

    public int getMode() {
        return 3;
    }

    public boolean isSkipped() {
        this.initStep();
        return this.basicNativeButton == null || this.wizardModel.skipAuth;
    }

    private void initStep() {
        try {
            if (!this.stepInitialized) {
                NextStepCommand nextStepCommand;
                BOsPart bOsPart;
                this.stepInitialized = true;
                if (this.wizardModel.authMethod.equals("digest/file") && (bOsPart = (BUsernameAndPassword)this.wizardModel.daemonSession.getCredentials()) != null) {
                    this.wizardModel.adminPassword = bOsPart.getPassword();
                }
                bOsPart = this.wizardModel.getPlatform().getOsPart();
                ToggleCommandGroup toggleCommandGroup = new ToggleCommandGroup();
                BGridPane bGridPane = new BGridPane(1);
                bGridPane.setValign(BValign.top);
                bGridPane.setHalign(BHalign.left);
                if (this.wizardModel.nativeAuthSupported) {
                    this.credentialsStep = new CredentialsStep(this.wizardModel);
                    nextStepCommand = new NextStepCommand(this.wizardModel.owner, this, this.credentialsStep, "AuthWizard.authMethodStep.basicNative.label", new Object[]{bOsPart.getPartName()});
                    this.basicNativeButton = new BRadioButton((ToggleCommand)nextStepCommand, true, false);
                    bGridPane.add(null, (BValue)this.basicNativeButton);
                    this.credentialsStep.priorStep = this;
                    this.credentialsStep.lastStep.nextStep = this.stepAfterSection;
                    toggleCommandGroup.add((ToggleCommand)nextStepCommand);
                }
                this.userStep = new UserStep(this.wizardModel);
                nextStepCommand = new NextStepCommand(this.wizardModel.owner, this, this.userStep, "AuthWizard.authMethodStep.digestFile.label", null);
                this.digestFileButton = new BRadioButton((ToggleCommand)nextStepCommand, true, false);
                bGridPane.add(null, (BValue)this.digestFileButton);
                this.userStep.priorStep = this;
                this.userStep.lastStep.nextStep = this.stepAfterSection;
                toggleCommandGroup.add((ToggleCommand)nextStepCommand);
                this.setContent((BWidget)new BEdgePane((BWidget)new BBorderPane((BWidget)LabelUtil.makeLabel((LexiconText)this.getLexiconText("CommissioningWizard.authMethod.header")), 0.0, 0.0, 4.0, 0.0), null, null, null, (BWidget)bGridPane));
            }
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new BajaRuntimeException((Throwable)exception);
        }
    }

    private static class GroupStep
    extends CommissioningWizardStep {
        private BListDropDown userList;
        private BListDropDown adminList;
        private BCheckBox stationIsAdminCheckBox;

        public GroupStep(CommissioningWizardModel commissioningWizardModel) throws Exception {
            super(commissioningWizardModel);
            BGridPane bGridPane = new BGridPane(2);
            bGridPane.setValign(BValign.top);
            bGridPane.setHalign(BHalign.left);
            bGridPane.setStretchColumn(1);
            this.userList = new BListDropDown();
            if (!commissioningWizardModel.isNpsdk) {
                LabelUtil.addLabelWidgetPair((BGridPane)bGridPane, (LexiconText)LexiconText.make((String)"platDaemon", (String)"AuthWizard.groupStep.userList.label"), (BWidget)this.userList);
                bGridPane.add(null, (BValue)new BNullWidget());
                bGridPane.add(null, (BValue)new BLabel(lex.getText("AuthWizard.groupStep.userList.desc"), BHalign.left));
            }
            this.adminList = new BListDropDown();
            LabelUtil.addLabelWidgetPair((BGridPane)bGridPane, (LexiconText)LexiconText.make((String)"platDaemon", (String)"AuthWizard.groupStep.adminList.label"), (BWidget)this.adminList);
            bGridPane.add(null, (BValue)new BNullWidget());
            bGridPane.add(null, (BValue)new BLabel(lex.getText("AuthWizard.groupStep.adminList.desc"), BHalign.left));
            this.stationIsAdminCheckBox = new BCheckBox(lex.getText("AuthWizard.groupStep.stationIsAdmin.checkBox"));
            LabelUtil.addLabelWidgetPair((BGridPane)bGridPane, (LexiconText)LexiconText.make((String)"platDaemon", (String)"AuthWizard.groupStep.stationIsAdmin.label"), (BWidget)this.stationIsAdminCheckBox);
            bGridPane.add(null, (BValue)new BNullWidget());
            bGridPane.add(null, (BValue)new BLabel(lex.getText("AuthWizard.groupStep.stationIsAdmin.desc"), BHalign.left));
            this.setContent((BWidget)new BEdgePane((BWidget)new BLabel(lex.getText("CommissioningWizard.authGroups.header"), BHalign.left), null, null, null, (BWidget)new BBorderPane((BWidget)bGridPane, 4.0, 0.0, 0.0, 0.0)));
        }

        public String getStepName() {
            return "authGroups";
        }

        public String getSectionName() {
            return "auth";
        }

        public void enter() {
            this.userList.getList().removeAllItems();
            this.adminList.getList().removeAllItems();
            XElem[] xElemArray = this.wizardModel.authInfo.elems("domain");
            for (int i = 0; i < xElemArray.length; ++i) {
                XElem[] xElemArray2 = xElemArray[i].elems("group");
                for (int j = 0; j < xElemArray2.length; ++j) {
                    this.userList.getList().addItem((Object)new WinNtAccount(xElemArray2[j].get("name"), xElemArray2[j].get("sid", null)));
                    this.adminList.getList().addItem((Object)new WinNtAccount(xElemArray2[j].get("name"), xElemArray2[j].get("sid", null)));
                }
            }
            if (this.userList.getList().indexOfItem((Object)this.wizardModel.userGroup) >= 0) {
                this.userList.getList().setSelectedItem((Object)this.wizardModel.userGroup);
            } else if (this.userList.getList().indexOfItem((Object)"BUILTIN\\Users") >= 0) {
                this.userList.getList().setSelectedItem((Object)"BUILTIN\\Users");
            } else {
                this.userList.getList().getSelection().deselectAll();
            }
            if (this.adminList.getList().indexOfItem((Object)this.wizardModel.adminGroup) >= 0) {
                this.adminList.getList().setSelectedItem((Object)this.wizardModel.adminGroup);
            } else if (this.adminList.getList().indexOfItem((Object)"BUILTIN\\Administrators") >= 0) {
                this.adminList.getList().setSelectedItem((Object)"BUILTIN\\Administrators");
            } else {
                this.adminList.getList().getSelection().deselectAll();
            }
        }

        public boolean exit(int n) {
            boolean bl = n == 1;
            boolean bl2 = false;
            boolean bl3 = false;
            if (!this.wizardModel.isNpsdk) {
                if (this.userList.getList().getSelectedIndex() < 0 || this.adminList.getList().getSelectedIndex() < 0) {
                    if (!bl) {
                        BDialog.error((BWidget)this.wizardModel.getWizard(), (Object)lex.getText("AuthWizard.groupStep.error.nullGroup"));
                        return false;
                    }
                } else {
                    bl2 = true;
                    bl3 = true;
                }
            } else {
                if (this.adminList.getList().getSelectedIndex() < 0) {
                    if (!bl) {
                        BDialog.error((BWidget)this.wizardModel.getWizard(), (Object)lex.getText("AuthWizard.groupStep.error.nullAdminGroup"));
                        return false;
                    }
                } else {
                    bl3 = true;
                }
                bl2 = false;
            }
            if (!this.wizardModel.isNpsdk) {
                if (bl2 && (this.wizardModel.userGroup == null || !this.wizardModel.userGroup.equals(this.userList.getList().getSelectedItem().toString()))) {
                    this.wizardModel.userGroup = (WinNtAccount)this.userList.getList().getSelectedItem();
                    this.wizardModel.authChanged = true;
                }
            } else if (bl3 && (this.wizardModel.userGroup == null || !this.wizardModel.userGroup.equals(this.adminList.getList().getSelectedItem().toString()))) {
                this.wizardModel.userGroup = (WinNtAccount)this.adminList.getList().getSelectedItem();
                this.wizardModel.authChanged = true;
            }
            if (bl3 && (this.wizardModel.adminGroup == null || !this.wizardModel.adminGroup.equals(this.adminList.getList().getSelectedItem().toString()))) {
                this.wizardModel.adminGroup = (WinNtAccount)this.adminList.getList().getSelectedItem();
                this.wizardModel.authChanged = true;
            }
            this.wizardModel.stationIsAdmin = this.stationIsAdminCheckBox.isSelected();
            return true;
        }

        public int getMode() {
            return 3;
        }

        public boolean isSkipped() {
            return this.wizardModel.skipAuth;
        }
    }

    private static class ModeControlModel
    extends TextModel {
        private CommissioningWizardStep step;

        public ModeControlModel(CommissioningWizardStep commissioningWizardStep) {
            this.step = commissioningWizardStep;
        }

        protected void textModified() {
            this.step.wizardModel.update(this.step.getMode());
        }
    }

    private static class CredentialsStep
    extends CommissioningWizardStep {
        private BPasswordFE passwordFE;
        private BTextField userNameField;

        public CredentialsStep(CommissioningWizardModel commissioningWizardModel) throws Exception {
            super(commissioningWizardModel);
            BGridPane bGridPane = new BGridPane(2);
            bGridPane.setValign(BValign.top);
            bGridPane.setHalign(BHalign.left);
            bGridPane.setStretchColumn(1);
            this.userNameField = new BTextField("", 8);
            LabelUtil.addLabelWidgetPair((BGridPane)bGridPane, (LexiconText)LexiconText.make((String)"platDaemon", (String)"AuthWizard.userStep.user.label"), (BWidget)this.userNameField);
            this.passwordFE = new BPasswordFE();
            LabelUtil.addLabelWidgetPair((BGridPane)bGridPane, (LexiconText)LexiconText.make((String)"platDaemon", (String)"AuthWizard.userStep.pw1.label"), (BWidget)this.passwordFE);
            this.userNameField.setModel((TextModel)new ModeControlModel(this));
            ((BTextField)this.passwordFE.getContent()).setModel((TextModel)new ModeControlModel(this));
            BLabel bLabel = LabelUtil.makeLabel((LexiconText)this.getLexiconText("CommissioningWizard.newCreds.header"));
            this.lastStep = this.nextStep = new GroupStep(commissioningWizardModel);
            this.nextStep.priorStep = this;
            this.setContent((BWidget)new BEdgePane((BWidget)new BBorderPane((BWidget)bLabel, 0.0, 0.0, 10.0, 0.0), null, null, null, (BWidget)bGridPane));
        }

        public String getStepName() {
            return "newCreds";
        }

        public String getSectionName() {
            return "auth";
        }

        public void enter() {
            if (this.nextStep != null) {
                this.nextStep.priorStep = this;
            }
            if (this.wizardModel.newCredentials == null) {
                this.passwordFE.loadValue((BObject)BPassword.DEFAULT);
            } else {
                this.userNameField.setText(this.wizardModel.newCredentials.getUsername());
                this.passwordFE.loadValue((BObject)this.wizardModel.newCredentials.getPassword());
            }
        }

        public boolean exit(int n) {
            try {
                boolean bl;
                boolean bl2 = bl = n == 1;
                if (bl) {
                    return true;
                }
                XElem xElem = XParser.make((InputStream)this.wizardModel.daemonSession.getInputStream((DaemonMessage)new XmlResponseMessage(){

                    public String getMessageString() {
                        try {
                            return "auth?reqUsername=" + HttpUtil.encodeUrl((String)CredentialsStep.this.userNameField.getText()) + "&reqPassword=" + HttpUtil.encodeUrl((String)((BPassword)CredentialsStep.this.passwordFE.saveValue()).encodeToString());
                        }
                        catch (RuntimeException runtimeException) {
                            throw runtimeException;
                        }
                        catch (Exception exception) {
                            throw new BajaRuntimeException((Throwable)exception);
                        }
                    }
                }, "text/xml")).parse();
                if (xElem.elems("domain").length == 0) {
                    BDialog.error((BWidget)this.wizardModel.getWizard(), (Object)lex.getText("AuthWizard.credentials.error.badCredentials"));
                    return false;
                }
                if (this.userNameField.getText().length() > 0 && ((BTextField)this.passwordFE.getContent()).getText().length() > 0) {
                    this.wizardModel.newCredentials = new BUsernameAndPassword(this.userNameField.getText(), (BPassword)this.passwordFE.saveValue());
                }
                this.wizardModel.authInfo = xElem;
                return true;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new BajaRuntimeException((Throwable)exception);
            }
        }

        public boolean isSkipped() {
            return this.wizardModel.skipAuth;
        }

        public int getMode() {
            int n = 1;
            if (this.userNameField.getText().length() > 0 && ((BTextField)this.passwordFE.getContent()).getText().length() > 0) {
                n |= 2;
            }
            return n;
        }
    }

    private static class UserStep
    extends CommissioningWizardStep {
        private BTextField userNameField;
        private BPasswordFE passwordFE1;
        private BPasswordFE passwordFE2;

        public UserStep(CommissioningWizardModel commissioningWizardModel) throws Exception {
            super(commissioningWizardModel);
            BOsPart bOsPart = commissioningWizardModel.getPlatform().getOsPart();
            BGridPane bGridPane = new BGridPane(2);
            bGridPane.setValign(BValign.top);
            bGridPane.setHalign(BHalign.left);
            bGridPane.setStretchColumn(1);
            this.userNameField = new BTextField("", 32);
            LabelUtil.addLabelWidgetPair((BGridPane)bGridPane, (LexiconText)LexiconText.make((String)"platDaemon", (String)"AuthWizard.userStep.user.label"), (BWidget)this.userNameField);
            this.passwordFE1 = new BPasswordFE();
            LabelUtil.addLabelWidgetPair((BGridPane)bGridPane, (LexiconText)LexiconText.make((String)"platDaemon", (String)"AuthWizard.userStep.pw1.label"), (BWidget)this.passwordFE1);
            this.passwordFE2 = new BPasswordFE();
            LabelUtil.addLabelWidgetPair((BGridPane)bGridPane, (LexiconText)LexiconText.make((String)"platDaemon", (String)"AuthWizard.userStep.pw1.label"), (BWidget)this.passwordFE2);
            if (commissioningWizardModel.adminPassword != null) {
                this.passwordFE1.loadValue((BObject)commissioningWizardModel.adminPassword);
                this.passwordFE2.loadValue((BObject)commissioningWizardModel.adminPassword);
            }
            ((BTextField)this.passwordFE1.getContent()).setModel((TextModel)new ModeControlModel(this));
            ((BTextField)this.passwordFE2.getContent()).setModel((TextModel)new ModeControlModel(this));
            ((BTextField)this.passwordFE1.getContent()).setController((TextController)new DigestFilePasswordController());
            ((BTextField)this.passwordFE2.getContent()).setController((TextController)new DigestFilePasswordController());
            this.userNameField.setModel((TextModel)new ModeControlModel(this));
            if (TextUtil.toLowerCase((String)bOsPart.getPartName()).startsWith("qnx")) {
                this.userNameField.setController((TextController)new QnxUserNameController());
            }
            this.setContent((BWidget)new BEdgePane((BWidget)new BBorderPane((BWidget)new BLabel(lex.getText("CommissioningWizard.authUsers.header"), BHalign.left), 4.0, 0.0, 4.0, 0.0), null, null, null, (BWidget)bGridPane));
        }

        public String getStepName() {
            return "authUsers";
        }

        public String getSectionName() {
            return "auth";
        }

        public void enter() {
            if (this.nextStep != null) {
                this.nextStep.priorStep = this;
            }
            this.userNameField.setText(this.wizardModel.adminUser);
            if (this.wizardModel.adminPassword != null) {
                this.passwordFE1.loadValue((BObject)this.wizardModel.adminPassword);
                this.passwordFE2.loadValue((BObject)this.wizardModel.adminPassword);
            } else {
                this.passwordFE1.loadValue((BObject)BPassword.DEFAULT);
                this.passwordFE2.loadValue((BObject)BPassword.DEFAULT);
            }
        }

        public boolean exit(int n) {
            boolean bl = n == 1;
            try {
                int n2;
                BPassword bPassword = (BPassword)this.passwordFE1.saveValue();
                BPassword bPassword2 = (BPassword)this.passwordFE2.saveValue();
                if (!SecurityUtil.equals((String)bPassword.getValue(), (String)bPassword2.getValue()) && !bl) {
                    BDialog.error((BWidget)this.wizardModel.getWizard(), (Object)lex.getText("AuthWizard.userStep.error.passwordMismatch"));
                    return false;
                }
                char[] cArray = bPassword.getValue().toCharArray();
                for (n2 = 0; n2 < cArray.length; ++n2) {
                    if (cArray[n2] < '!' || cArray[n2] > '~') {
                        BDialog.error((BWidget)this.wizardModel.getWizard(), (Object)lex.getText("AuthWizard.userStep.error.invalidPasswordCharacter", new Object[]{String.valueOf(cArray[n2])}));
                        return false;
                    }
                    if (n2 < 16) continue;
                    BDialog.error((BWidget)this.wizardModel.getWizard(), (Object)lex.getText("AuthWizard.userStep.error.passwordTooLong"));
                    return false;
                }
                n2 = 0;
                if (!this.wizardModel.adminUser.equals(this.userNameField.getText())) {
                    this.wizardModel.adminUser = this.userNameField.getText();
                    n2 = 1;
                }
                if (this.wizardModel.adminPassword == null || !SecurityUtil.equals((String)this.wizardModel.adminPassword.getValue(), (String)bPassword.getValue())) {
                    this.wizardModel.adminPassword = bPassword;
                    n2 = 1;
                }
                if (n2 != 0) {
                    this.wizardModel.newCredentials = new BUsernameAndPassword(this.wizardModel.adminUser, this.wizardModel.adminPassword);
                    this.wizardModel.authChanged = true;
                } else if (this.wizardModel.usingDefaultDigestCredentials && !bl) {
                    BDialog.error((BWidget)this.wizardModel.getWizard(), (Object)lex.getText("AuthWizard.userStep.error.defaultCredentials"));
                    return false;
                }
                return true;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new BajaRuntimeException((Throwable)exception);
            }
        }

        public int getMode() {
            int n = 1;
            if (this.userNameField.getText().trim().length() == 0 || this.getPasswordFEText(this.passwordFE1).trim().length() == 0 || this.getPasswordFEText(this.passwordFE2).trim().length() == 0) {
                return n;
            }
            return n | 2;
        }

        public boolean isSkipped() {
            return this.wizardModel.skipAuth;
        }

        private String getPasswordFEText(BPasswordFE bPasswordFE) {
            return ((BTextField)bPasswordFE.getContent()).getText();
        }
    }

    private class NextStepCommand
    extends ToggleCommand {
        private CommissioningWizardStep fromStep;
        private CommissioningWizardStep toStep;

        public NextStepCommand(BWidget bWidget, CommissioningWizardStep commissioningWizardStep, CommissioningWizardStep commissioningWizardStep2, String string, Object[] objectArray) {
            super(bWidget, CommissioningWizardStep.lex.getText(string, objectArray));
            this.fromStep = commissioningWizardStep;
            this.toStep = commissioningWizardStep2;
        }

        public CommandArtifact doInvoke() {
            if (this.isSelected()) {
                this.fromStep.nextStep = this.toStep;
                this.toStep.priorStep = this.fromStep;
            }
            return null;
        }
    }
}

