/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.appsurrogate;

import com.tridium.install.BDaemonPlatform;
import com.tridium.install.BDependency;
import com.tridium.install.BRemoteDaemonPlatform;
import com.tridium.install.DependencyUtil;
import com.tridium.install.InstallScenario;
import com.tridium.install.installable.BInstallable;
import com.tridium.install.installable.LocalInstallableRegistry;
import com.tridium.platDaemon.ui.BDaemonSessionView;
import com.tridium.platDaemon.ui.commissioningwizard.CommissioningWizardModel;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.BStationSurrogate;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import com.tridium.platform.ui.util.AsyncCommand;
import com.tridium.platform.ui.util.BBox;
import com.tridium.platform.ui.util.BIndentPane;
import com.tridium.platform.ui.util.CommandUtil;
import com.tridium.ui.theme.Theme;
import javax.baja.file.BFileSpace;
import javax.baja.file.FilePath;
import javax.baja.gx.BImage;
import javax.baja.platform.ICancelHint;
import javax.baja.sys.ActionInvokeException;
import javax.baja.sys.BIcon;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BScrollBarPolicy;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.wizard.BWizard;
import javax.baja.ui.wizard.WizardModel;
import javax.baja.util.Lexicon;
import javax.baja.util.LexiconText;

public class VerifyCommand
extends AsyncCommand {
    private FilePath stationDirPath = null;
    private BDaemonSession session = null;
    private BStationSurrogate station = null;
    private DaemonSessionTaskListener taskListener;
    private static final BIcon iconRef = BIcon.std((String)"module.png");

    public VerifyCommand(BWidget bWidget, DaemonSessionTaskListener daemonSessionTaskListener) {
        super(bWidget, BDaemonSessionView.TYPE.getModule(), "StationCopier.verify");
        this.taskListener = daemonSessionTaskListener;
    }

    public void doInvokeAsync() {
        block33: {
            try {
                if (this.session == null) {
                    return;
                }
                try {
                    String string;
                    BRemoteDaemonPlatform bRemoteDaemonPlatform = BRemoteDaemonPlatform.make((BDaemonSession)this.session, (DaemonSessionTaskListener)this.taskListener);
                    DependencyUtil.AnalysisResults analysisResults = DependencyUtil.analyzeAllDependencies((BDaemonPlatform)bRemoteDaemonPlatform, (BFileSpace)bRemoteDaemonPlatform.getDaemonSession().getFileSpace(), (FilePath)this.stationDirPath, null, (DaemonSessionTaskListener)this.taskListener);
                    InstallScenario installScenario = analysisResults.getSolution();
                    BIndentPane bIndentPane = new BIndentPane();
                    boolean bl = false;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    if (installScenario.canCommit()) {
                        if (installScenario.getToInstall().length > 0) {
                            if (this.session.usesLocalNiagaraEnvironment()) {
                                string = this.getLexicon().getText("StationCopier.verify.missing.title");
                                this.addStationOrPlatformMessage(bIndentPane, "StationCopier.verify.missing.top", "StationCopier.verifyPlatform.missing.top");
                            } else {
                                string = this.getLexicon().getText("StationCopier.verify.promptInstall.title");
                                this.addStationOrPlatformMessage(bIndentPane, "StationCopier.verify.promptInstall.message", "StationCopier.verifyPlatform.promptInstall.message");
                                bl = true;
                            }
                        } else {
                            string = this.getLexicon().getText("StationCopier.verifyPlatform.success.title");
                            this.addStationOrPlatformMessage(bIndentPane, "StationCopier.verify.success.message", "StationCopier.verifyPlatform.success.message");
                            bl2 = true;
                        }
                    } else {
                        string = this.getLexicon().getText("StationCopier.verify.missing.title");
                        if (analysisResults.anyUnsolvable()) {
                            string = this.getLexicon().getText("StationCopier.verify.mustCommission.title");
                            if (this.session.usesLocalNiagaraEnvironment()) {
                                bIndentPane.add(LexiconText.make((String)"platDaemon", (String)"StationCopier.verify.mustCommission.message"));
                            } else {
                                bIndentPane.add(LexiconText.make((String)"platDaemon", (String)"StationCopier.verify.mustCommission.prompt"));
                                bl3 = true;
                            }
                        } else {
                            string = this.getLexicon().getText("StationCopier.verify.missing.title");
                            this.addStationOrPlatformMessage(bIndentPane, "StationCopier.verify.missing.top", "StationCopier.verifyPlatform.missing.top");
                        }
                    }
                    if (bl2) {
                        BDialog.message((BWidget)this.getOwner(), (String)string, (Object)bIndentPane);
                        break block33;
                    }
                    if (bl3) {
                        if (4 == BDialog.confirm((BWidget)this.getOwner(), (String)string, (Object)bIndentPane, (int)12)) {
                            BWizard.open((BWidget)this.getOwner(), (WizardModel)new CommissioningWizardModel(this.getOwner(), this.session, true));
                        }
                        break block33;
                    }
                    if (bl) {
                        bIndentPane.indent();
                        boolean bl4 = false;
                        for (int i = 0; i < installScenario.getToInstall().length; ++i) {
                            BInstallable bInstallable = installScenario.getToInstall()[i];
                            if (!bl4) {
                                try {
                                    BInstallable bInstallable2 = LocalInstallableRegistry.getInstance().findInstallable(BDependency.forModule((String)bInstallable.getInstallableName()), null);
                                    if (bInstallable2.getVersion().getVendorVersion().compareTo((Object)bInstallable.getVersion().getVendorVersion()) > 0) {
                                        bl4 = true;
                                    }
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            bIndentPane.add((BWidget)new BLabel(BImage.make((BIcon)bInstallable.getIcon()), bInstallable.toString()));
                        }
                        bIndentPane.unindent();
                        if (bl4) {
                            bIndentPane.add((BWidget)new BBox(0.0, 5.0));
                            BLabel bLabel = new BLabel(BImage.make((BIcon)BIcon.std((String)"warning.png")), this.getLexicon().getText("StationCopier.verifyPlatform.laterVersionAvail"));
                            bLabel.setHalign(BHalign.left);
                            bIndentPane.add((BWidget)bLabel);
                        }
                        if (4 == BDialog.confirm((BWidget)this.getOwner(), (String)string, (Object)this.makeScrollPane((BWidget)bIndentPane), (int)12)) {
                            installScenario.commit(this.taskListener, null);
                        }
                        break block33;
                    }
                    if (analysisResults.anyUnsolvable()) {
                        BDialog.warning((BWidget)this.getOwner(), (String)string, (Object)bIndentPane);
                    } else {
                        String[] stringArray = analysisResults.getPartNames();
                        for (int i = 0; i < stringArray.length; ++i) {
                            if (analysisResults.isUnavailable(stringArray[i])) {
                                bIndentPane.add((BWidget)new BLabel(BImage.make((BIcon)iconRef), stringArray[i] + "*"));
                                continue;
                            }
                            bIndentPane.add((BWidget)new BLabel(BImage.make((BIcon)iconRef), stringArray[i]));
                        }
                        bIndentPane.unindent();
                        if (analysisResults.anyUnvailable()) {
                            bIndentPane.add(LexiconText.make((String)"platDaemon", (String)"StationCopier.verify.missing.bottom"));
                        }
                        BDialog.warning((BWidget)this.getOwner(), (String)string, (Object)this.makeScrollPane((BWidget)bIndentPane));
                    }
                }
                catch (ICancelHint.CanceledException canceledException) {
                }
                catch (ActionInvokeException actionInvokeException) {
                    if (!(actionInvokeException.getCause() instanceof ICancelHint.CanceledException)) {
                        actionInvokeException.printStackTrace();
                        throw actionInvokeException;
                    }
                }
            }
            catch (Throwable throwable) {
                CommandUtil.error((Command)this, (Throwable)throwable);
            }
        }
    }

    public void setStationDirectory(FilePath filePath) {
        this.stationDirPath = filePath;
    }

    public void loadStation(BStationSurrogate bStationSurrogate) {
        this.station = bStationSurrogate;
        this.setStationDirectory(new FilePath("!stations/" + this.station.getStationName()));
    }

    public void setDaemonSession(BDaemonSession bDaemonSession) {
        this.session = bDaemonSession;
    }

    private Lexicon getLexicon() {
        return this.getOwner().getLexicon();
    }

    private void addStationOrPlatformMessage(BIndentPane bIndentPane, String string, String string2) {
        if (this.stationDirPath == null) {
            bIndentPane.add(LexiconText.make((String)"platDaemon", (String)string2));
        } else {
            bIndentPane.add(LexiconText.make((String)"platDaemon", (String)string), new Object[]{this.stationDirPath.getName()});
        }
    }

    private BWidget makeScrollPane(BWidget bWidget) {
        BScrollPane bScrollPane = new BScrollPane((BWidget)new BBorderPane(bWidget, 4.0, 4.0, 4.0, 4.0));
        bScrollPane.setViewportBackground(Theme.scrollPane().getControlBackground());
        bScrollPane.setBorderPolicy(BScrollBarPolicy.asNeeded);
        BConstrainedPane bConstrainedPane = new BConstrainedPane((BWidget)bScrollPane);
        bConstrainedPane.setFixedSize(275.0, 260.0);
        return bConstrainedPane;
    }
}

