/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.acctmgt;

import com.tridium.net.HttpUtil;
import com.tridium.platDaemon.ui.BDaemonSessionView;
import com.tridium.platDaemon.ui.acctmgt.BNativeGroupTable;
import com.tridium.platDaemon.ui.acctmgt.BNativeUserTable;
import com.tridium.platDaemon.ui.acctmgt.WinNtAccount;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.message.DaemonMessage;
import com.tridium.platform.daemon.message.XmlResponseMessage;
import com.tridium.platform.ui.util.CommandUtil;
import com.tridium.platform.ui.util.LabelUtil;
import com.tridium.ui.theme.Theme;
import java.io.InputStream;
import java.net.ConnectException;
import javax.baja.gx.BInsets;
import javax.baja.nre.util.Array;
import javax.baja.security.AuthenticationException;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BDialog;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BOrientation;
import javax.baja.ui.enums.BScrollBarPolicy;
import javax.baja.ui.list.BCheckList;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BFlowPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.pane.BSplitPane;
import javax.baja.util.Lexicon;
import javax.baja.util.LexiconText;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

public class BUserManager
extends BDaemonSessionView {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$platDaemon$ui$acctmgt$BUserManager == null ? (class$com$tridium$platDaemon$ui$acctmgt$BUserManager = BUserManager.class$("com.tridium.platDaemon.ui.acctmgt.BUserManager")) : class$com$tridium$platDaemon$ui$acctmgt$BUserManager));
    private BNativeUserTable uTable;
    private BNativeGroupTable gTable;
    private static Lexicon lex = Lexicon.make((String)"platDaemon");
    static /* synthetic */ Class class$com$tridium$platDaemon$ui$acctmgt$BUserManager;
    static /* synthetic */ Class class$com$tridium$platDaemon$ui$acctmgt$BUserManager$MemberSelectionItem;

    public Type getType() {
        return TYPE;
    }

    public BUserManager() {
        BSplitPane bSplitPane = new BSplitPane(BOrientation.horizontal, 60.0);
        BFlowPane bFlowPane = new BFlowPane(BHalign.left);
        bFlowPane.add(null, (BValue)LabelUtil.makeLabel((LexiconText)LexiconText.make((Type)TYPE, (String)"UserManager.label.users"), (boolean)true));
        this.uTable = new BNativeUserTable();
        bSplitPane.setWidget1((BWidget)new BEdgePane((BWidget)new BBorderPane((BWidget)bFlowPane, 4.0, 0.0, 0.0, 4.0), (BWidget)new BBorderPane((BWidget)this.uTable.getButtonPane(), 4.0, 0.0, 0.0, 0.0), null, null, (BWidget)new BBorderPane((BWidget)this.uTable, BBorder.inset, BInsets.DEFAULT)));
        this.gTable = new BNativeGroupTable(this);
        bSplitPane.setWidget2((BWidget)this.gTable.getSplitPane());
        this.setContent((BWidget)bSplitPane);
    }

    static boolean checkStatus(BWidget bWidget, BDaemonSession bDaemonSession, XmlResponseMessage xmlResponseMessage) throws Exception {
        String string = bDaemonSession.getErrorText(xmlResponseMessage);
        if (string == null) {
            return true;
        }
        BDialog.error((BWidget)bWidget, (Object)string);
        return false;
    }

    MemberSelection makeMemberSelection(boolean bl) throws Exception {
        return new MemberSelection(bl);
    }

    protected final void doLoadSession(BDaemonSession bDaemonSession, Context context) throws AuthenticationException {
        try {
            this.uTable.loadSession(bDaemonSession);
            this.gTable.loadSession(bDaemonSession);
        }
        catch (ConnectException connectException) {
        }
        catch (AuthenticationException authenticationException) {
            throw authenticationException;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new BajaRuntimeException((Throwable)exception);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class MemberSelectionItem
    implements Comparable {
        public WinNtAccount account;
        public boolean isUser;

        public MemberSelectionItem(String string, String string2, boolean bl) {
            this.account = new WinNtAccount(string, string2);
            this.isUser = bl;
        }

        public String toString() {
            if (this.isUser) {
                return this.account.name + " " + lex.getText("UserManager.MemberSelectionItem.user");
            }
            return this.account.name + " " + lex.getText("UserManager.MemberSelectionItem.group");
        }

        public int compareTo(Object object) {
            return this.account.name.compareTo(((MemberSelectionItem)object).account.name);
        }
    }

    private class MemberSelectionToggleCommand
    extends ToggleCommand {
        private MemberSelection selection;

        public MemberSelectionToggleCommand(MemberSelection memberSelection, String string) {
            super((BWidget)BUserManager.this, lex, string);
            this.selection = memberSelection;
            this.setSelected(true);
        }

        public CommandArtifact doInvoke() {
            try {
                this.selection.load();
            }
            catch (Throwable throwable) {
                CommandUtil.error((Command)this, (Throwable)throwable);
            }
            return null;
        }
    }

    class MemberSelection {
        private BTextField groupNameTextField = null;
        private ToggleCommand localOnlyCommand;
        private ToggleCommand userOnlyCommand;
        private BCheckList membersList;
        private BWidget content;

        public MemberSelection(boolean bl) throws Exception {
            BFlowPane bFlowPane = null;
            if (bl) {
                bFlowPane = new BFlowPane(BHalign.left);
                bFlowPane.add(null, (BValue)LabelUtil.makeLabel((LexiconText)LexiconText.make((Type)TYPE, (String)"UserManager.MemberSelection.label.group"), (boolean)true));
                this.groupNameTextField = new BTextField("", 20);
                bFlowPane.add(null, (BValue)this.groupNameTextField);
            }
            BFlowPane bFlowPane2 = new BFlowPane(BHalign.left);
            this.localOnlyCommand = new MemberSelectionToggleCommand(this, "UserManager.MemberSelection.LocalOnlyCommand");
            bFlowPane2.add(null, (BValue)new BCheckBox(this.localOnlyCommand));
            this.userOnlyCommand = new MemberSelectionToggleCommand(this, "UserManager.MemberSelection.UserOnlyCommand");
            bFlowPane2.add(null, (BValue)new BCheckBox(this.userOnlyCommand));
            this.membersList = new BCheckList();
            BScrollPane bScrollPane = new BScrollPane((BWidget)this.membersList);
            bScrollPane.setViewportBackground(Theme.scrollPane().getControlBackground());
            bScrollPane.setBorderPolicy(BScrollBarPolicy.asNeeded);
            BConstrainedPane bConstrainedPane = new BConstrainedPane((BWidget)bScrollPane);
            bConstrainedPane.setMaxWidth(300.0);
            bConstrainedPane.setMinWidth(300.0);
            bConstrainedPane.setMaxHeight(200.0);
            bConstrainedPane.setMinHeight(200.0);
            this.content = bl ? new BEdgePane((BWidget)bFlowPane, null, null, null, (BWidget)new BBorderPane((BWidget)new BEdgePane((BWidget)bFlowPane2, null, null, null, (BWidget)bConstrainedPane), lex.getText("UserManager.MemberSelection.label.members"))) : new BEdgePane((BWidget)bFlowPane2, null, null, null, (BWidget)bConstrainedPane);
            this.load();
        }

        public void load() throws Exception {
            int n;
            Array array = new Array(class$com$tridium$platDaemon$ui$acctmgt$BUserManager$MemberSelectionItem == null ? (class$com$tridium$platDaemon$ui$acctmgt$BUserManager$MemberSelectionItem = BUserManager.class$("com.tridium.platDaemon.ui.acctmgt.BUserManager$MemberSelectionItem")) : class$com$tridium$platDaemon$ui$acctmgt$BUserManager$MemberSelectionItem);
            XElem xElem = XParser.make((InputStream)BUserManager.this.getDaemonSession().getInputStream((DaemonMessage)new XmlResponseMessage(){

                public String getMessageString() {
                    return "acctmgt?users=true";
                }
            })).parse();
            XElem[] xElemArray = xElem.elems("user");
            for (n = 0; n < xElemArray.length; ++n) {
                if (this.localOnlyCommand.isSelected() && !xElemArray[n].get("type").equals("local")) continue;
                WinNtAccount winNtAccount = new WinNtAccount(xElemArray[n].get("name"), xElemArray[n].get("sid", null));
                if (this.groupNameTextField == null && BUserManager.this.gTable.getMemberTable().hasMember(winNtAccount)) continue;
                array.add((Object)new MemberSelectionItem(winNtAccount.name, winNtAccount.sid, true));
            }
            if (!this.userOnlyCommand.isSelected()) {
                if (this.localOnlyCommand.isSelected()) {
                    for (n = 0; n < BUserManager.this.gTable.getModel().getRowCount(); ++n) {
                        if (this.groupNameTextField == null && (BUserManager.this.gTable.getMemberTable().hasMember(BUserManager.this.gTable.getGroup(n)) || BUserManager.this.gTable.getMemberTable().getGroup().equals(BUserManager.this.gTable.getGroup(n)))) continue;
                        array.add((Object)new MemberSelectionItem(((BUserManager)BUserManager.this).gTable.getGroup((int)n).name, ((BUserManager)BUserManager.this).gTable.getGroup((int)n).sid, false));
                    }
                } else {
                    xElem = XParser.make((InputStream)BUserManager.this.getDaemonSession().getInputStream((DaemonMessage)new XmlResponseMessage(){

                        public String getMessageString() {
                            return "acctmgt?allgroups=true";
                        }
                    })).parse();
                    XElem[] xElemArray2 = xElem.elems("domain");
                    for (int i = 0; i < xElemArray2.length; ++i) {
                        XElem[] xElemArray3 = xElemArray2[i].elems("group");
                        for (int j = 0; j < xElemArray3.length; ++j) {
                            WinNtAccount winNtAccount = new WinNtAccount(xElemArray3[j].get("name"), xElemArray3[j].get("sid", null));
                            if (this.groupNameTextField == null && (BUserManager.this.gTable.getMemberTable().hasMember(winNtAccount) || BUserManager.this.gTable.getMemberTable().getGroup().equals(winNtAccount))) continue;
                            array.add((Object)new MemberSelectionItem(winNtAccount.name, winNtAccount.sid, false));
                        }
                    }
                }
            }
            array = array.sort();
            this.membersList.removeAllItems();
            for (int i = 0; i < array.size(); ++i) {
                this.membersList.addItem(array.get(i));
            }
        }

        public String getGroupName() {
            return this.groupNameTextField == null ? null : this.groupNameTextField.getText().trim();
        }

        public WinNtAccount[] getMemberAccounts() {
            Object[] objectArray = this.membersList.getSelectedItems();
            WinNtAccount[] winNtAccountArray = new WinNtAccount[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                winNtAccountArray[i] = ((MemberSelectionItem)objectArray[i]).account;
            }
            return winNtAccountArray;
        }

        public BWidget getContent() {
            return this.content;
        }
    }

    static class AddMemberMessage
    extends XmlResponseMessage {
        StringBuffer buf = new StringBuffer("acctmgt?update=addgrpmbr&");

        public AddMemberMessage(WinNtAccount winNtAccount, WinNtAccount winNtAccount2) {
            if (winNtAccount.sid == null) {
                this.buf.append("group=");
                this.buf.append(HttpUtil.encodeUrl((String)winNtAccount.name));
            } else {
                this.buf.append("groupsid=");
                this.buf.append(HttpUtil.encodeUrl((String)winNtAccount.sid));
            }
            if (winNtAccount2.sid == null) {
                this.buf.append("&member=");
                this.buf.append(HttpUtil.encodeUrl((String)winNtAccount2.name));
            } else {
                this.buf.append("&membersid=");
                this.buf.append(HttpUtil.encodeUrl((String)winNtAccount2.sid));
            }
        }

        public String getMessageString() {
            return this.buf.toString();
        }
    }
}

