/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.acctmgt;

import com.tridium.net.HttpUtil;
import com.tridium.platDaemon.ui.acctmgt.BNativeGroupTable;
import com.tridium.platDaemon.ui.acctmgt.BUserManager;
import com.tridium.platDaemon.ui.acctmgt.WinNtAccount;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.message.DaemonMessage;
import com.tridium.platform.daemon.message.XmlResponseMessage;
import com.tridium.platform.ui.util.BButtonPane;
import com.tridium.platform.ui.util.CommandUtil;
import java.io.InputStream;
import javax.baja.nre.util.Array;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.transfer.TransferContext;
import javax.baja.ui.transfer.TransferFormat;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

public class BNativeGroupMemberTable
extends BTable {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$platDaemon$ui$acctmgt$BNativeGroupMemberTable == null ? (class$com$tridium$platDaemon$ui$acctmgt$BNativeGroupMemberTable = BNativeGroupMemberTable.class$("com.tridium.platDaemon.ui.acctmgt.BNativeGroupMemberTable")) : class$com$tridium$platDaemon$ui$acctmgt$BNativeGroupMemberTable));
    private BButtonPane buttons;
    private Command addMemberCommand;
    private Command delMemberCommand;
    private boolean admin = false;
    private boolean canModify;
    private BDaemonSession session;
    private BNativeGroupTable groupTable;
    static /* synthetic */ Class class$com$tridium$platDaemon$ui$acctmgt$BNativeGroupMemberTable;
    static /* synthetic */ Class class$com$tridium$platDaemon$ui$acctmgt$BNativeGroupMemberTable$MemberRow;

    public Type getType() {
        return TYPE;
    }

    public BNativeGroupMemberTable() {
        throw new UnsupportedOperationException();
    }

    public BNativeGroupMemberTable(BNativeGroupTable bNativeGroupTable) {
        this.groupTable = bNativeGroupTable;
        this.setModel(new MembersModel());
        this.setController(new MembersController());
        this.buttons = new BButtonPane();
        this.addMemberCommand = new AddMemberCommand();
        this.buttons.add(this.addMemberCommand);
        this.delMemberCommand = new DelMemberCommand();
        this.buttons.add(this.delMemberCommand);
    }

    public BNativeGroupTable getGroupTable() {
        return this.groupTable;
    }

    public BUserManager getUserManager() {
        return this.getGroupTable().getUserManager();
    }

    public BButtonPane getButtonPane() {
        return this.buttons;
    }

    public void loadGroup(BDaemonSession bDaemonSession, WinNtAccount winNtAccount, boolean bl) {
        this.session = bDaemonSession;
        this.admin = this.session.getHostProperties().hasFullAccess();
        this.canModify = bl;
        this.getMembersModel().loadGroup(winNtAccount);
    }

    public void clear() {
        this.getMembersModel().clear();
    }

    public boolean hasMember(WinNtAccount winNtAccount) {
        return this.getMembersModel().hasMember(winNtAccount);
    }

    public WinNtAccount getGroup() {
        return this.getMembersModel().getGroup();
    }

    public int dragOver(TransferContext transferContext) {
        WinNtAccount winNtAccount;
        if (this.admin && this.canModify && transferContext.isCopy() && transferContext.getEnvelope().supports(TransferFormat.string) && this.getGroup() != null && !this.hasMember(winNtAccount = WinNtAccount.decode((String)transferContext.getEnvelope().getData(TransferFormat.string))) && !this.getGroup().equals(winNtAccount)) {
            return 16;
        }
        return 0;
    }

    public CommandArtifact drop(TransferContext transferContext) throws Exception {
        WinNtAccount winNtAccount;
        if (this.admin && transferContext.isCopy() && transferContext.getEnvelope().supports(TransferFormat.string) && this.getGroup() != null && !this.hasMember(winNtAccount = WinNtAccount.decode((String)transferContext.getEnvelope().getData(TransferFormat.string))) && BUserManager.checkStatus((BWidget)this, this.getDaemonSession(), new BUserManager.AddMemberMessage(this.getGroup(), winNtAccount))) {
            this.getMembersModel().reload();
        }
        return null;
    }

    private MembersModel getMembersModel() {
        return (MembersModel)this.getModel();
    }

    private BDaemonSession getDaemonSession() {
        return this.session;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class DelMemberMessage
    extends XmlResponseMessage {
        StringBuffer buf = new StringBuffer("acctmgt?update=delgrpmbr&");

        public DelMemberMessage(WinNtAccount winNtAccount, WinNtAccount winNtAccount2) {
            if (winNtAccount.sid == null) {
                this.buf.append("group=");
                this.buf.append(HttpUtil.encodeUrl((String)winNtAccount.name));
            } else {
                this.buf.append("groupsid=");
                this.buf.append(HttpUtil.encodeUrl((String)winNtAccount.sid));
            }
            if (winNtAccount2.sid == null) {
                this.buf.append("&member=");
                this.buf.append(HttpUtil.encodeUrl((String)winNtAccount2.name));
            } else {
                this.buf.append("&membersid=");
                this.buf.append(HttpUtil.encodeUrl((String)winNtAccount2.sid));
            }
        }

        public String getMessageString() {
            return this.buf.toString();
        }
    }

    private class DelMemberCommand
    extends Command {
        public DelMemberCommand() {
            super((BWidget)BNativeGroupMemberTable.this, BNativeGroupMemberTable.this.getLexicon(), "UserManager.DelMemberCommand");
            this.setEnabled(false);
        }

        public CommandArtifact doInvoke() throws Exception {
            try {
                if (4 == BDialog.confirm((BWidget)BNativeGroupMemberTable.this, (String)BNativeGroupMemberTable.this.getLexicon().getText("UserManager.DelMemberCommand.confirmTitle"), (Object)BNativeGroupMemberTable.this.getLexicon().getText("UserManager.DelMemberCommand.confirmMessage"))) {
                    int[] nArray = BNativeGroupMemberTable.this.getSelection().getRows();
                    for (int i = 0; i < nArray.length; ++i) {
                        WinNtAccount winNtAccount = BNativeGroupMemberTable.this.getMembersModel().getGroup();
                        WinNtAccount winNtAccount2 = ((BNativeGroupMemberTable)BNativeGroupMemberTable.this).getMembersModel().getRow((int)nArray[i]).acct;
                        if (!BUserManager.checkStatus((BWidget)BNativeGroupMemberTable.this, BNativeGroupMemberTable.this.getDaemonSession(), new DelMemberMessage(winNtAccount, winNtAccount2))) break;
                    }
                    BNativeGroupMemberTable.this.getMembersModel().reload();
                }
            }
            catch (Throwable throwable) {
                CommandUtil.error((Command)this, (Throwable)throwable);
            }
            return null;
        }
    }

    private class AddMemberCommand
    extends Command {
        public AddMemberCommand() {
            super((BWidget)BNativeGroupMemberTable.this, BNativeGroupMemberTable.this.getLexicon(), "UserManager.AddMemberCommand");
            this.setEnabled(false);
        }

        public CommandArtifact doInvoke() throws Exception {
            try {
                BUserManager.MemberSelection memberSelection = BNativeGroupMemberTable.this.getUserManager().makeMemberSelection(false);
                if (1 == BDialog.open((BWidget)BNativeGroupMemberTable.this, (String)BNativeGroupMemberTable.this.getLexicon().getText("UserManager.AddMemberCommand.dlgTitle"), (Object)memberSelection.getContent(), (int)3, null)) {
                    WinNtAccount winNtAccount = BNativeGroupMemberTable.this.getMembersModel().getGroup();
                    WinNtAccount[] winNtAccountArray = memberSelection.getMemberAccounts();
                    for (int i = 0; i < winNtAccountArray.length && BUserManager.checkStatus((BWidget)BNativeGroupMemberTable.this, BNativeGroupMemberTable.this.getDaemonSession(), new BUserManager.AddMemberMessage(winNtAccount, winNtAccountArray[i])); ++i) {
                    }
                    BNativeGroupMemberTable.this.getMembersModel().reload();
                }
            }
            catch (Throwable throwable) {
                CommandUtil.error((Command)this, (Throwable)throwable);
            }
            return null;
        }
    }

    private class MembersController
    extends TableController {
        private MembersController() {
        }

        protected final void backgroundPressed(BMouseEvent bMouseEvent) {
            super.backgroundPressed(bMouseEvent);
            BNativeGroupMemberTable.this.delMemberCommand.setEnabled(false);
        }

        protected void checkSelection(BMouseEvent bMouseEvent, int n) {
            super.checkSelection(bMouseEvent, n);
            BNativeGroupMemberTable.this.delMemberCommand.setEnabled(BNativeGroupMemberTable.this.admin && BNativeGroupMemberTable.this.canModify && !this.getTable().getSelection().isEmpty());
        }
    }

    private class MemberRow
    implements Comparable {
        public String type;
        public WinNtAccount acct;

        public MemberRow(String string, String string2, String string3) {
            this.type = string;
            this.acct = new WinNtAccount(string2, string3);
        }

        public int compareTo(Object object) {
            return this.acct.name.compareTo(((MemberRow)object).acct.name);
        }
    }

    private class GetGroupMembersMessage
    extends XmlResponseMessage {
        StringBuffer buf = new StringBuffer("acctmgt?");

        public GetGroupMembersMessage(WinNtAccount winNtAccount) {
            if (winNtAccount.sid == null) {
                this.buf.append("group=");
                this.buf.append(HttpUtil.encodeUrl((String)winNtAccount.name));
            } else {
                this.buf.append("groupsid=");
                this.buf.append(HttpUtil.encodeUrl((String)winNtAccount.sid));
            }
        }

        public String getMessageString() {
            return this.buf.toString();
        }
    }

    private class MembersModel
    extends TableModel {
        private Array rows = new Array(class$com$tridium$platDaemon$ui$acctmgt$BNativeGroupMemberTable$MemberRow == null ? (class$com$tridium$platDaemon$ui$acctmgt$BNativeGroupMemberTable$MemberRow = BNativeGroupMemberTable.class$("com.tridium.platDaemon.ui.acctmgt.BNativeGroupMemberTable$MemberRow")) : class$com$tridium$platDaemon$ui$acctmgt$BNativeGroupMemberTable$MemberRow);
        private WinNtAccount group = null;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            Array array = this.rows;
            synchronized (array) {
                this.rows.clear();
            }
            BNativeGroupMemberTable.this.addMemberCommand.setEnabled(false);
            BNativeGroupMemberTable.this.delMemberCommand.setEnabled(false);
            this.group = null;
            this.updateTable(true);
        }

        public WinNtAccount getGroup() {
            return this.group;
        }

        public void reload() {
            this.loadGroup(this.getGroup());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void loadGroup(WinNtAccount winNtAccount) {
            this.group = winNtAccount;
            if (this.group == null) {
                this.clear();
                return;
            }
            try {
                XElem xElem = XParser.make((InputStream)BNativeGroupMemberTable.this.getDaemonSession().getInputStream((DaemonMessage)new GetGroupMembersMessage(this.group))).parse();
                XElem[] xElemArray = xElem.elems();
                Array array = this.rows;
                synchronized (array) {
                    this.rows.clear();
                    for (int i = 0; i < xElemArray.length; ++i) {
                        if (xElemArray[i].get("name", null) == null) {
                            System.out.println(xElem);
                            continue;
                        }
                        this.rows.add((Object)new MemberRow(xElemArray[i].name(), xElemArray[i].get("name"), xElemArray[i].get("sid", null)));
                    }
                    this.rows.sort();
                }
                BNativeGroupMemberTable.this.addMemberCommand.setEnabled(BNativeGroupMemberTable.this.admin && BNativeGroupMemberTable.this.canModify);
                BNativeGroupMemberTable.this.delMemberCommand.setEnabled(false);
                this.updateTable(true);
                this.getTable().getSelection().deselectAll();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new BajaRuntimeException((Throwable)exception);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getRowCount() {
            Array array = this.rows;
            synchronized (array) {
                return this.rows.size();
            }
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return BNativeGroupMemberTable.this.getLexicon().getText("UserManager.membersTable.col.type");
                }
                case 1: {
                    return BNativeGroupMemberTable.this.getLexicon().getText("UserManager.membersTable.col.name");
                }
            }
            throw new ArrayIndexOutOfBoundsException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public MemberRow getRow(int n) {
            Array array = this.rows;
            synchronized (array) {
                return (MemberRow)this.rows.get(n);
            }
        }

        public boolean hasMember(WinNtAccount winNtAccount) {
            for (int i = 0; i < this.getRowCount(); ++i) {
                if (!this.getRow((int)i).acct.equals(winNtAccount)) continue;
                return true;
            }
            return false;
        }

        public Object getValueAt(int n, int n2) {
            switch (n2) {
                case 0: {
                    return this.getRow((int)n).type;
                }
                case 1: {
                    return this.getRow((int)n).acct.name;
                }
            }
            throw new ArrayIndexOutOfBoundsException();
        }
    }
}

