/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui;

import com.tridium.platform.daemon.task.CancelableDaemonSessionTask;
import com.tridium.platform.daemon.task.DaemonSessionTask;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.log.Log;
import javax.baja.nre.util.Array;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BProgressBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BFlowPane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;

public class DaemonSessionTaskHandler
implements DaemonSessionTaskListener {
    private BWidget owner;
    private long elapsed = 0L;
    private DelayedDialogThread dlgThread = null;
    private Array taskList = new Array();
    private boolean cancelEnabled = true;
    public static final Log log = Log.getLog((String)"platDaemon.task");
    public static final Lexicon lexicon = Lexicon.make((String)"platDaemon");
    private static final BImage clockIcon = BImage.make((String)"module://icons/x32/clock.png");

    public DaemonSessionTaskHandler(BWidget bWidget) {
        this.setOwner(bWidget);
    }

    public void taskStarted(DaemonSessionTask daemonSessionTask) {
        log.trace("task started: " + daemonSessionTask.getMessage() + " - " + this.getElapsed());
        if (this.getOwner() == null || this.getOwner().widgetSupport(null) == null) {
            log.trace("task started - no window peer: " + daemonSessionTask.getMessage());
            return;
        }
        this.taskList.add((Object)daemonSessionTask);
        this.showNextActiveTask(750L);
    }

    public void taskUpdated(DaemonSessionTask daemonSessionTask) {
        if (this.dlgThread != null && daemonSessionTask == this.dlgThread.getTask()) {
            this.dlgThread.refresh();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void taskFinished(DaemonSessionTask daemonSessionTask) {
        log.trace("task finished: " + daemonSessionTask.getMessage() + " - " + this.getElapsed());
        if (this.dlgThread != null && daemonSessionTask == this.dlgThread.getTask()) {
            log.trace("interrupting dialog thread: " + daemonSessionTask.getMessage() + " - " + this.getElapsed());
            this.dlgThread.interrupt();
            this.dlgThread = null;
        }
        Array array = this.taskList;
        synchronized (array) {
            int n = this.taskList.lastIndexOf((Object)daemonSessionTask);
            if (n >= 0) {
                this.taskList.remove(n);
            }
        }
        this.showNextActiveTask(0L);
    }

    public boolean isCancelEnabled() {
        return this.cancelEnabled;
    }

    public void setCancelEnabled(boolean bl) {
        this.cancelEnabled = bl;
    }

    public void setOwner(BWidget bWidget) {
        this.owner = bWidget;
        if (this.dlgThread != null) {
            this.dlgThread.setOwner(bWidget);
        }
    }

    public BWidget getOwner() {
        return this.owner;
    }

    public void waitAllTasks() {
        while (this.taskList.size() > 0) {
            try {
                Thread.sleep(500L);
            }
            catch (Throwable throwable) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelAllTasks() {
        if (this.isCancelEnabled()) {
            Array array = this.taskList;
            synchronized (array) {
                for (int i = 0; i < this.taskList.size(); ++i) {
                    if (!(this.taskList.get(i) instanceof CancelableDaemonSessionTask)) continue;
                    CancelableDaemonSessionTask cancelableDaemonSessionTask = (CancelableDaemonSessionTask)this.taskList.get(i);
                    cancelableDaemonSessionTask.cancel();
                }
            }
        }
        this.waitAllTasks();
    }

    private String getElapsed() {
        long l = this.elapsed;
        this.elapsed = Clock.ticks();
        return l == 0L ? "" : this.elapsed - l + " ms";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showNextActiveTask(long l) {
        if (this.dlgThread != null) {
            log.trace("showNextActiveTask - thread still active");
            return;
        }
        Array array = this.taskList;
        synchronized (array) {
            DaemonSessionTask daemonSessionTask;
            if (this.taskList.size() == 0) {
                log.trace("showNextActiveTask - no active tasks");
                return;
            }
            this.dlgThread = this.makeDelayedDialogThread(daemonSessionTask, (daemonSessionTask = (DaemonSessionTask)this.taskList.remove(0)).isImmediate() ? 0L : l);
            this.dlgThread.start();
        }
    }

    private DelayedDialogThread makeDelayedDialogThread(DaemonSessionTask daemonSessionTask, long l) {
        return new DelayedDialogThread(daemonSessionTask, l, this.getOwner());
    }

    private static boolean hasAnyModalDialogOwners(BWidget bWidget) {
        while (bWidget != null) {
            if (bWidget instanceof BDialog && ((BDialog)bWidget).isModal()) {
                return true;
            }
            bWidget = bWidget.getParentWidget();
        }
        return false;
    }

    private class DelayedDialogThread
    extends Thread {
        private BDialog dialog = null;
        private Command cancelCommand = null;
        private long delay;
        private DaemonSessionTask task;
        private BWidget owner;
        private BProgressBar progressBar = null;
        private BLabel messageLabel = null;

        public DelayedDialogThread(DaemonSessionTask daemonSessionTask, BWidget bWidget) {
            this(daemonSessionTask, 1000L, bWidget);
        }

        public DelayedDialogThread(DaemonSessionTask daemonSessionTask, long l, BWidget bWidget) {
            super("Ui:DelayedDialogThread");
            this.delay = l;
            this.task = daemonSessionTask;
            this.owner = bWidget;
        }

        public DaemonSessionTask getTask() {
            return this.task;
        }

        public BWidget getOwner() {
            return this.owner;
        }

        public void setOwner(BWidget bWidget) {
            this.owner = bWidget;
        }

        public void refresh() {
            if (this.dialog != null && this.messageLabel != null) {
                this.messageLabel.setText(this.task.getMessage());
                this.messageLabel.computePreferredSize();
                if (this.messageLabel.getPreferredWidth() > this.dialog.getWidth() || this.messageLabel.getPreferredHeight() > this.dialog.getHeight()) {
                    this.dialog.setBoundsCenteredOnOwner();
                }
            }
            if (this.progressBar != null) {
                this.progressBar.setValue((double)this.task.getProgress());
            }
            if (this.cancelCommand != null && this.task instanceof CancelableDaemonSessionTask) {
                this.cancelCommand.setEnabled(((CancelableDaemonSessionTask)this.task).isCancelEnabled());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                DelayedDialogThread.sleep(this.delay);
            }
            catch (InterruptedException interruptedException) {
                log.trace("DelayedDialogThread.run interrupted before dialog raised");
                return;
            }
            try {
                this.messageLabel = new BLabel(this.task.getMessage(), BHalign.left);
                BEdgePane bEdgePane = new BEdgePane((BWidget)new BBorderPane((BWidget)this.messageLabel, 10.0, 10.0, 10.0, 10.0), null, null, null, null);
                this.messageLabel.setImage(clockIcon);
                if (this.task.getTotal() > 0) {
                    this.progressBar = new BProgressBar(0.0, (double)this.task.getTotal());
                    bEdgePane.setCenter((BWidget)new BBorderPane((BWidget)this.progressBar, 0.0, 10.0, 10.0, 10.0));
                    this.progressBar.setValue((double)this.task.getProgress());
                } else {
                    this.progressBar = new BProgressBar();
                    this.progressBar.setIndeterminate(true);
                    bEdgePane.setCenter((BWidget)new BBorderPane((BWidget)this.progressBar, 0.0, 10.0, 10.0, 10.0));
                }
                if (DaemonSessionTaskHandler.this.isCancelEnabled() && this.task instanceof CancelableDaemonSessionTask && ((CancelableDaemonSessionTask)this.task).isCancelEnabled()) {
                    BFlowPane bFlowPane = new BFlowPane(BHalign.center);
                    this.cancelCommand = new TaskCancelCommand(this.getOwner(), (CancelableDaemonSessionTask)this.task);
                    BButton bButton = new BButton(this.cancelCommand);
                    bButton.setPadding(BInsets.make((double)4.0, (double)4.0, (double)4.0, (double)4.0));
                    bFlowPane.add(null, (BValue)bButton);
                    bEdgePane.setBottom((BWidget)new BBorderPane((BWidget)bFlowPane, 0.0, 10.0, 4.0, 10.0));
                }
                this.dialog = new BDialog(this.owner, this.task.getTitle(), DaemonSessionTaskHandler.hasAnyModalDialogOwners(this.owner), (BWidget)bEdgePane);
                this.dialog.setBoundsCenteredOnOwner();
                log.trace("task dialog: " + this.task.getMessage());
                this.dialog.open();
                while (this.dialog != null && this.dialog.isShowing() && this.ownerActive()) {
                    DelayedDialogThread.sleep(1000L);
                }
            }
            catch (InterruptedException interruptedException) {
                log.trace("DelayedDialogThread.run interrupted after dialog raised");
            }
            finally {
                this.closeDialog();
            }
        }

        private boolean ownerActive() {
            for (BWidget bWidget = this.getOwner(); bWidget != null; bWidget = bWidget.getParent()) {
                if (!(bWidget instanceof BDialog)) continue;
                return ((BDialog)bWidget).isShowing();
            }
            return this.getOwner().getShell() != null;
        }

        public void interrupt() {
            this.closeDialog();
            log.trace("DelayedDialogThread interrupt called");
            super.interrupt();
        }

        private synchronized void closeDialog() {
            if (this.dialog != null) {
                try {
                    this.dialog.close();
                }
                catch (Exception exception) {
                }
                finally {
                    this.dialog = null;
                }
            }
        }
    }

    private static class TaskCancelCommand
    extends Command {
        private CancelableDaemonSessionTask task;

        public TaskCancelCommand(BWidget bWidget, CancelableDaemonSessionTask cancelableDaemonSessionTask) {
            super(bWidget, cancelableDaemonSessionTask.getCancelLabel(UiLexicon.bajaui.getText("dialog.cancel")), null, null, null);
            this.task = cancelableDaemonSessionTask;
        }

        public CommandArtifact doInvoke() {
            this.task.cancel();
            return null;
        }
    }
}

