/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui;

import com.tridium.platDaemon.BDaemonSurrogate;
import com.tridium.platform.daemon.BAppSurrogate;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.ui.util.BInputStreamPane;
import java.io.BufferedWriter;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.baja.file.BFileSystem;
import javax.baja.file.FilePath;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BOutputPane
extends BInputStreamPane {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$platDaemon$ui$BOutputPane == null ? (class$com$tridium$platDaemon$ui$BOutputPane = BOutputPane.class$("com.tridium.platDaemon.ui.BOutputPane")) : class$com$tridium$platDaemon$ui$BOutputPane));
    private BAppSurrogate app = null;
    private BDaemonSurrogate daemon = null;
    private boolean updatesOnly = false;
    private FilePath capturePath = null;
    private Writer captureWriter = null;
    static /* synthetic */ Class class$com$tridium$platDaemon$ui$BOutputPane;

    public Type getType() {
        return TYPE;
    }

    public BOutputPane() {
    }

    public BOutputPane(int n, int n2) {
        super(n, n2);
    }

    public BOutputPane(int n, int n2, boolean bl) {
        super(n, n2);
        this.updatesOnly = bl;
    }

    protected InputStream getInputStream() {
        try {
            if (this.daemon == null) {
                return null;
            }
            if (this.app == null) {
                return this.daemon.getDaemonOutput(true, this.updatesOnly);
            }
            return this.app.getAppOutput(true, this.updatesOnly);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new BajaRuntimeException((Throwable)exception);
        }
    }

    public void loadDaemon() {
        BAppSurrogate bAppSurrogate = this.app;
        this.app = null;
        if (bAppSurrogate != null || this.watcher == null) {
            this.load();
        }
    }

    public void loadApp(BAppSurrogate bAppSurrogate) {
        BAppSurrogate bAppSurrogate2 = this.app;
        this.app = bAppSurrogate;
        if (bAppSurrogate2 != this.app) {
            this.setSession(this.app.getDaemonSession());
            this.setOutputBufferSize(this.app.getLogBufferSize());
            this.load();
        }
    }

    public void setSession(BDaemonSession bDaemonSession) {
        this.daemon = new BDaemonSurrogate(bDaemonSession);
    }

    public void setCapturePath(FilePath filePath) {
        this.capturePath = filePath;
    }

    protected synchronized void startUpdates(BInputStreamPane.OutputWatcher outputWatcher) {
        if (this.capturePath != null) {
            try {
                this.captureWriter = new BufferedWriter(new OutputStreamWriter(BFileSystem.INSTANCE.makeFile(this.capturePath).getOutputStream()));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        super.startUpdates(outputWatcher);
    }

    public void append(String string) {
        super.append(string);
        if (this.captureWriter != null) {
            try {
                this.captureWriter.write(string);
                this.captureWriter.flush();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                try {
                    this.captureWriter.close();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                this.captureWriter = null;
            }
        }
    }

    public synchronized void stopUpdates() {
        super.stopUpdates();
        try {
            Thread.sleep(600L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.captureWriter != null) {
            try {
                this.captureWriter.flush();
                this.captureWriter.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.captureWriter = null;
        }
    }

    public void clearValue() {
        this.app = null;
        super.clearValue();
    }

    public void clearText() throws Exception {
        if (this.daemon == null) {
            this.setText("");
        } else {
            super.clearText();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

