/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.command;

import com.tridium.net.HttpUtil;
import com.tridium.platform.command.BDaemonSessionCommand;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.message.DaemonMessage;
import com.tridium.platform.daemon.message.XmlResponseMessage;
import com.tridium.util.CommandLineArguments;
import javax.baja.log.Log;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BTellStationCommand
extends BDaemonSessionCommand {
    public static final BTellStationCommand INSTANCE = new BTellStationCommand();
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$platDaemon$command$BTellStationCommand == null ? (class$com$tridium$platDaemon$command$BTellStationCommand = BTellStationCommand.class$("com.tridium.platDaemon.command.BTellStationCommand")) : class$com$tridium$platDaemon$command$BTellStationCommand));
    private static Log log = Log.getLog((String)"stopstation");
    static /* synthetic */ Class class$com$tridium$platDaemon$command$BTellStationCommand;

    public Type getType() {
        return TYPE;
    }

    protected BTellStationCommand() {
    }

    public String getCommandName() {
        return "tellstation";
    }

    public String getCommandDescription() {
        return "send text to the console of a running Niagara Station";
    }

    public String getLicenseVendor() {
        return "tridium";
    }

    public String getLicenseFeature() {
        return "workbench";
    }

    public void usage() {
        BTellStationCommand.println((String)"");
        BTellStationCommand.println((String)"usage:");
        BTellStationCommand.println((String)"  plat tellstation <flags> <stationname> <message>");
        BTellStationCommand.println((String)"parameters:");
        BTellStationCommand.println((String)"  stationname        name of the station which gets the message");
        BTellStationCommand.println((String)"  message            text to send to the station's console.  If");
        BTellStationCommand.println((String)"                       the text has whitespace, it should be quoted");
        BTellStationCommand.println((String)"required flags:");
        BTellStationCommand.println((String)"  -h:<hostord>       host's ORD");
        BTellStationCommand.println((String)"optional flags:");
        BTellStationCommand.println((String)"  -usr:<userName>    user name for the host's platform daemon");
        BTellStationCommand.println((String)"  -pwd:<password>    password for the host's platform daemon");
        BTellStationCommand.println((String)"  -noinput           if given, command will fail when username");
        BTellStationCommand.println((String)"                       and password are missing or incorrect,");
        BTellStationCommand.println((String)"                       instead of prompting and reading them");
        BTellStationCommand.println((String)"                       from stdin");
        BTellStationCommand.println((String)"  -p:<port>          port for the host's platform daemon");
        BTellStationCommand.println((String)"                       if omitted, default port 3011 is used");
        BTellStationCommand.println((String)"");
    }

    public int invoke(CommandLineArguments commandLineArguments) throws Exception {
        if (commandLineArguments.hasHelpOption() || commandLineArguments.parameters.length < 2) {
            this.usage();
            return 2;
        }
        BDaemonSession bDaemonSession = this.getSession(commandLineArguments);
        if (bDaemonSession == null) {
            this.usage();
            return 2;
        }
        String string = commandLineArguments.parameters[0];
        String string2 = commandLineArguments.parameters[1];
        bDaemonSession.sendMessage((DaemonMessage)new TellStationMessage(string, string2));
        log.message("message sent to " + string);
        return 0;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class TellStationMessage
    extends XmlResponseMessage {
        private StringBuffer path = new StringBuffer("station?action=tell&station=");

        public TellStationMessage(String string, String string2) {
            this.path.append(string);
            this.path.append("&message=");
            this.path.append(HttpUtil.encodeUrl((String)string2));
        }

        public String getMessageString() {
            return this.path.toString();
        }
    }
}

