/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.command;

import com.tridium.platform.command.BDaemonSessionCommand;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.util.CommandLineArguments;
import javax.baja.log.Log;
import javax.baja.naming.BLocalHost;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BRebootHostCommand
extends BDaemonSessionCommand {
    public static final BRebootHostCommand INSTANCE = new BRebootHostCommand();
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$platDaemon$command$BRebootHostCommand == null ? (class$com$tridium$platDaemon$command$BRebootHostCommand = BRebootHostCommand.class$("com.tridium.platDaemon.command.BRebootHostCommand")) : class$com$tridium$platDaemon$command$BRebootHostCommand));
    private static Log log = Log.getLog((String)"reboothost");
    static /* synthetic */ Class class$com$tridium$platDaemon$command$BRebootHostCommand;

    public Type getType() {
        return TYPE;
    }

    protected BRebootHostCommand() {
    }

    public String getCommandName() {
        return "reboothost";
    }

    public String getCommandDescription() {
        return "request that a remote Niagara Platform Daemon reboot its host";
    }

    public String getLicenseVendor() {
        return "tridium";
    }

    public String getLicenseFeature() {
        return "workbench";
    }

    public void usage() {
        BRebootHostCommand.println((String)"");
        BRebootHostCommand.println((String)"usage:");
        BRebootHostCommand.println((String)"  plat reboothost <flags>");
        BRebootHostCommand.println((String)"required flags:");
        BRebootHostCommand.println((String)"  -h:<hostord>       ORD for the remote host  ");
        BRebootHostCommand.println((String)"optional flags:");
        BRebootHostCommand.println((String)"  -usr:<userName>    user name for the host's platform daemon");
        BRebootHostCommand.println((String)"  -pwd:<password>    password for the host's platform daemon");
        BRebootHostCommand.println((String)"  -noinput           if given, command will fail when username");
        BRebootHostCommand.println((String)"                       and password are missing or incorrect,");
        BRebootHostCommand.println((String)"                       instead of prompting and reading them");
        BRebootHostCommand.println((String)"                       from stdin");
        BRebootHostCommand.println((String)"  -p:<port>          port for the remote host's platform daemon");
        BRebootHostCommand.println((String)"                       if omitted, default port 3011 is used");
        BRebootHostCommand.println((String)"  -locale:<x>        set the default locale (en_US)");
        BRebootHostCommand.println((String)"  -@<option>         pass option to Java VM");
        BRebootHostCommand.println((String)"  -buildreg          force rebuild of the registry");
        BRebootHostCommand.println((String)"");
    }

    public int invoke(CommandLineArguments commandLineArguments) throws Exception {
        if (commandLineArguments.hasHelpOption()) {
            this.usage();
            return 2;
        }
        BDaemonSession bDaemonSession = this.getSession(commandLineArguments);
        if (bDaemonSession == null) {
            this.usage();
            return 2;
        }
        if (bDaemonSession.getHost() == BLocalHost.INSTANCE) {
            log.error("Cannot reboot the local host");
            return 1;
        }
        bDaemonSession.sendRebootRequest();
        log.message("Host " + bDaemonSession.getHost().getNavDisplayName(null) + " rebooting");
        return 0;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

