/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.command;

import com.tridium.install.BDependency;
import com.tridium.install.installable.BModuleInstallable;
import com.tridium.install.installable.LocalInstallableRegistry;
import com.tridium.install.part.BModuleStatus;
import com.tridium.platform.command.BAbstractPlatformCommand;
import com.tridium.platform.daemon.BModuleContent;
import com.tridium.util.CommandLineArguments;
import java.io.File;
import java.io.FileOutputStream;
import java.util.zip.ZipOutputStream;
import javax.baja.log.Log;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BJaceJarCommand
extends BAbstractPlatformCommand {
    public static final BJaceJarCommand INSTANCE = new BJaceJarCommand();
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$platDaemon$command$BJaceJarCommand == null ? (class$com$tridium$platDaemon$command$BJaceJarCommand = BJaceJarCommand.class$("com.tridium.platDaemon.command.BJaceJarCommand")) : class$com$tridium$platDaemon$command$BJaceJarCommand));
    private static Log log = Log.getLog((String)"jacejar");
    static /* synthetic */ Class class$com$tridium$platDaemon$command$BJaceJarCommand;

    public Type getType() {
        return TYPE;
    }

    protected BJaceJarCommand() {
    }

    public String getCommandName() {
        return "jacejar";
    }

    public String getCommandDescription() {
        return "create Niagara module files that can be run on embedded hosts";
    }

    public String getLicenseVendor() {
        return "tridium";
    }

    public String getLicenseFeature() {
        return "workbench";
    }

    public void usage() {
        BJaceJarCommand.println((String)"");
        BJaceJarCommand.println((String)"usage:");
        BJaceJarCommand.println((String)"  plat jacejar <flags> [modulename]");
        BJaceJarCommand.println((String)"parameters:");
        BJaceJarCommand.println((String)"  modulename         name of a Niagara module for which a Jace-ready");
        BJaceJarCommand.println((String)"                       file is to be created (UI entries are stripped)");
        BJaceJarCommand.println((String)"required flags:");
        BJaceJarCommand.println((String)"  -dest:<destPath>   path of a local directory where the new file(s)");
        BJaceJarCommand.println((String)"                       are to be created.   If \"\\\" char is used,");
        BJaceJarCommand.println((String)"                       it must be escaped, e.g. -d:d:\\\\niagara\\\\forjace");
        BJaceJarCommand.println((String)"");
    }

    public int invoke(CommandLineArguments commandLineArguments) throws Exception {
        if (commandLineArguments.hasHelpOption()) {
            this.usage();
            return 2;
        }
        String string = commandLineArguments.getOption("dest");
        if (string == null) {
            this.usage();
            return 2;
        }
        if (commandLineArguments.parameters.length == 0) {
            log.error("no modules specified");
            this.usage();
            return 2;
        }
        BModuleContent bModuleContent = BModuleContent.make((String)commandLineArguments.getOption("moduleContent", "runtime"));
        int n = 0;
        File file = new File(string);
        for (int i = 0; i < commandLineArguments.parameters.length; ++i) {
            BModuleInstallable bModuleInstallable = (BModuleInstallable)LocalInstallableRegistry.getInstance().findInstallable(BDependency.forModule((String)commandLineArguments.parameters[i]), null);
            if (bModuleInstallable != null && bModuleInstallable.getModulePart().getStatus() == BModuleStatus.ok) {
                ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(new File(file, commandLineArguments.parameters[i] + ".jar")));
                bModuleInstallable.getModulePart().writePackageArchive(bModuleContent, true, zipOutputStream);
                zipOutputStream.closeEntry();
                zipOutputStream.flush();
                zipOutputStream.close();
                log.message("created module archive for " + commandLineArguments.parameters[i]);
                continue;
            }
            log.error(commandLineArguments.parameters[i] + " is not a valid module JAR");
            n = 3;
        }
        return n;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

