/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.command;

import com.tridium.platform.command.BDaemonSessionCommand;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.DaemonFileUtil;
import com.tridium.platform.daemon.file.BDefaultDaemonFileSpace;
import com.tridium.util.CommandLineArguments;
import java.text.DecimalFormat;
import java.util.ArrayList;
import javax.baja.file.BDirectory;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

public class BFileListCommand
extends BDaemonSessionCommand {
    public static final BFileListCommand INSTANCE = new BFileListCommand();
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$platDaemon$command$BFileListCommand == null ? (class$com$tridium$platDaemon$command$BFileListCommand = BFileListCommand.class$("com.tridium.platDaemon.command.BFileListCommand")) : class$com$tridium$platDaemon$command$BFileListCommand));
    private DecimalFormat numFormat = new DecimalFormat(Lexicon.make((String)"platDaemon").getText("Formats.num"));
    private static final int NAME_WIDTH = 32;
    private static final int SIZE_WIDTH = 10;
    private static final int LAST_MODIFIED_WIDTH = 21;
    private static final int CRC_WIDTH = 13;
    static /* synthetic */ Class class$com$tridium$platDaemon$command$BFileListCommand;

    public Type getType() {
        return TYPE;
    }

    protected BFileListCommand() {
    }

    public String getCommandName() {
        return "flist";
    }

    public String getCommandDescription() {
        return "provide file details for a single file, or for all files in a directory";
    }

    public String getLicenseVendor() {
        return "tridium";
    }

    public String getLicenseFeature() {
        return "workbench";
    }

    public void usage() {
        BFileListCommand.println((String)"");
        BFileListCommand.println((String)"usage:");
        BFileListCommand.println((String)"  plat flist <flags> <path>");
        BFileListCommand.println((String)"parameters:");
        BFileListCommand.println((String)"  path               path of an existing file or directory");
        BFileListCommand.println((String)"required flags:");
        BFileListCommand.println((String)"  -h:<hostord>       ORD for the remote host");
        BFileListCommand.println((String)"optional flags:");
        BFileListCommand.println((String)"  -usr:<userName>    user name for the host's platform daemon");
        BFileListCommand.println((String)"  -pwd:<password>    password for the host's platform daemon");
        BFileListCommand.println((String)"  -noinput           if given, command will fail when username");
        BFileListCommand.println((String)"                       and password are missing or incorrect,");
        BFileListCommand.println((String)"                       instead of prompting and reading them");
        BFileListCommand.println((String)"                       from stdin");
        BFileListCommand.println((String)"  -recurse           list info for directory descendents recursively");
        BFileListCommand.println((String)"  -r                 same as -recurse");
        BFileListCommand.println((String)"  -p:<port>          port for the remote host's platform daemon");
        BFileListCommand.println((String)"                       if omitted, default port 3011 is used");
        BFileListCommand.println((String)"  -locale:<x>        set the default locale (en_US)");
        BFileListCommand.println((String)"  -@<option>         pass option to Java VM");
        BFileListCommand.println((String)"  -buildreg          force rebuild of the registry");
        BFileListCommand.println((String)"");
    }

    public int invoke(CommandLineArguments commandLineArguments) throws Exception {
        boolean bl;
        if (commandLineArguments.hasHelpOption()) {
            this.usage();
            return 2;
        }
        BDaemonSession bDaemonSession = this.getSession(commandLineArguments);
        if (bDaemonSession == null) {
            this.usage();
            return 2;
        }
        boolean bl2 = bl = commandLineArguments.hasOption("r") || commandLineArguments.hasOption("recurse");
        if (commandLineArguments.parameters.length < 1) {
            this.usage();
            return 2;
        }
        BDefaultDaemonFileSpace bDefaultDaemonFileSpace = bDaemonSession.getFileSpace();
        this.printHeaders();
        for (int i = 0; i < commandLineArguments.parameters.length; ++i) {
            FilePath filePath = new FilePath(commandLineArguments.parameters[i]);
            BIFile bIFile = bDefaultDaemonFileSpace.findFile(filePath);
            if (bIFile == null) {
                System.out.println(filePath.getBody() + " does not exist");
                continue;
            }
            if (bIFile.isDirectory()) {
                this.listDirectory((BDirectory)bIFile, bl);
                continue;
            }
            this.listFile(bIFile);
        }
        return 0;
    }

    private void listFile(BIFile bIFile) {
        System.out.print(TextUtil.padRight((String)bIFile.getFileName(), (int)32));
        System.out.print(" ");
        if (bIFile.getSize() < 0L) {
            System.out.print(TextUtil.padLeft((String)"", (int)10));
        } else {
            System.out.print(TextUtil.padLeft((String)DaemonFileUtil.fileSize((long)bIFile.getSize()), (int)10));
        }
        System.out.print(" ");
        System.out.print(TextUtil.padRight((String)bIFile.getLastModified().toString(), (int)21));
        System.out.print(" ");
        System.out.print(TextUtil.padLeft((String)this.numFormat.format(DaemonFileUtil.getCrc((BIFile)bIFile)), (int)13));
        System.out.println();
    }

    private void listDirectory(BDirectory bDirectory, boolean bl) {
        int n;
        if (bl) {
            System.out.println("Contents of directory " + bDirectory.getFilePath().getBody());
            this.printDashes(bDirectory.getFilePath().getBody().length() + 22);
            System.out.println();
        }
        ArrayList<BIFile> arrayList = new ArrayList<BIFile>();
        BIFile[] bIFileArray = bDirectory.listFiles();
        for (n = 0; n < bIFileArray.length; ++n) {
            if (bIFileArray[n].isDirectory()) {
                arrayList.add(bIFileArray[n]);
                continue;
            }
            this.listFile(bIFileArray[n]);
        }
        for (n = 0; n < arrayList.size(); ++n) {
            BDirectory bDirectory2 = (BDirectory)arrayList.get(n);
            if (bl) {
                this.listDirectory(bDirectory2, bl);
                continue;
            }
            System.out.print(TextUtil.padRight((String)bDirectory2.getFileName(), (int)32));
            System.out.println(" (directory)");
        }
    }

    private void printHeaders() {
        System.out.print(TextUtil.padRight((String)"Name", (int)32));
        System.out.print(" ");
        System.out.print(TextUtil.padRight((String)"Size", (int)10));
        System.out.print(" ");
        System.out.print(TextUtil.padRight((String)"Last modified", (int)21));
        System.out.print(" ");
        System.out.print(TextUtil.padRight((String)"CRC", (int)13));
        System.out.println();
        this.printDashes(32);
        System.out.print(" ");
        this.printDashes(10);
        System.out.print(" ");
        this.printDashes(21);
        System.out.print(" ");
        this.printDashes(13);
        System.out.println();
    }

    private void printDashes(int n) {
        for (int i = 0; i < n; ++i) {
            System.out.print('-');
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

