/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.command;

import com.tridium.platDaemon.util.DaemonGlob;
import com.tridium.platform.command.BDaemonSessionCommand;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.DaemonFileUtil;
import com.tridium.platform.daemon.file.FileCache;
import com.tridium.util.CommandLineArguments;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSpace;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.log.Log;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BFileGetCommand
extends BDaemonSessionCommand {
    public static final BFileGetCommand INSTANCE = new BFileGetCommand();
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$platDaemon$command$BFileGetCommand == null ? (class$com$tridium$platDaemon$command$BFileGetCommand = BFileGetCommand.class$("com.tridium.platDaemon.command.BFileGetCommand")) : class$com$tridium$platDaemon$command$BFileGetCommand));
    private static Log log = Log.getLog((String)"fget");
    static /* synthetic */ Class class$com$tridium$platDaemon$command$BFileGetCommand;

    public Type getType() {
        return TYPE;
    }

    protected BFileGetCommand() {
    }

    public String getCommandName() {
        return "fget";
    }

    public String getCommandDescription() {
        return "get one or more files from a remote host";
    }

    public String getLicenseVendor() {
        return "tridium";
    }

    public String getLicenseFeature() {
        return "workbench";
    }

    public void usage() {
        BFileGetCommand.println((String)"");
        BFileGetCommand.println((String)"usage:");
        BFileGetCommand.println((String)"  plat fget <flags> <srcPath>* <destPath>");
        BFileGetCommand.println((String)"parameters:");
        BFileGetCommand.println((String)"  srcPath            path of a file on the remote host to be");
        BFileGetCommand.println((String)"                       copied");
        BFileGetCommand.println((String)"  destPath           path of an existing directory on the local computer");
        BFileGetCommand.println((String)"                       to which files are to be copied");
        BFileGetCommand.println((String)"required flags:");
        BFileGetCommand.println((String)"  -h:<hostord>       ORD for the remote host");
        BFileGetCommand.println((String)"optional flags:");
        BFileGetCommand.println((String)"  -usr:<userName>    user name for the host's platform daemon");
        BFileGetCommand.println((String)"  -pwd:<password>    password for the host's platform daemon");
        BFileGetCommand.println((String)"  -noinput           if given, command will fail when username");
        BFileGetCommand.println((String)"                       and password are missing or incorrect,");
        BFileGetCommand.println((String)"                       instead of prompting and reading them");
        BFileGetCommand.println((String)"                       from stdin");
        BFileGetCommand.println((String)"  -recurse           copy children of the directories identified by");
        BFileGetCommand.println((String)"                       <srcPath> recursively");
        BFileGetCommand.println((String)"  -r                 same as -recurse");
        BFileGetCommand.println((String)"  -overwrite:<opt>   overwrite option, default is 'prompt', values are:");
        BFileGetCommand.println((String)"                       'all'    unconditionally overwrite");
        BFileGetCommand.println((String)"                       'prompt' prompt for each overwrite");
        BFileGetCommand.println((String)"                       'none'   never overwrite");
        BFileGetCommand.println((String)"                       'crc'    overwrite only if crc is different");
        BFileGetCommand.println((String)"  -o:<opt>           same as -overwrite");
        BFileGetCommand.println((String)"  -p:<port>          port for the remote host's platform daemon");
        BFileGetCommand.println((String)"                       if omitted, default port 3011 is used");
        BFileGetCommand.println((String)"  -locale:<x>        set the default locale (en_US)");
        BFileGetCommand.println((String)"  -@<option>         pass option to Java VM");
        BFileGetCommand.println((String)"  -buildreg          force rebuild of the registry");
        BFileGetCommand.println((String)"");
    }

    public int invoke(CommandLineArguments commandLineArguments) throws Exception {
        boolean bl;
        if (commandLineArguments.hasHelpOption()) {
            this.usage();
            return 2;
        }
        BDaemonSession bDaemonSession = this.getSession(commandLineArguments);
        if (bDaemonSession == null) {
            this.usage();
            return 2;
        }
        String string = "prompt";
        if (commandLineArguments.hasOption("o")) {
            string = commandLineArguments.getOption("o", "prompt");
        } else if (commandLineArguments.hasOption("overwrite")) {
            string = commandLineArguments.getOption("overwrite", "prompt");
        }
        if (!(string.equals("all") || string.equals("prompt") || string.equals("crc") || string.equals("none"))) {
            this.usage();
            return 2;
        }
        if (commandLineArguments.hasOption("noinput") && string.equals("prompt")) {
            log.error("Error: cannot use overwrite=prompt and noinput options together");
            return 2;
        }
        boolean bl2 = bl = commandLineArguments.hasOption("r") || commandLineArguments.hasOption("recurse");
        if (commandLineArguments.parameters.length < 2) {
            this.usage();
            return 2;
        }
        FileCache fileCache = new FileCache((BFileSpace)bDaemonSession.getFileSpace());
        FilePath filePath = new FilePath(DaemonGlob.makeFilePathString(commandLineArguments.parameters[commandLineArguments.parameters.length - 1]));
        BIFile bIFile = BFileSystem.INSTANCE.findFile(filePath);
        if (bIFile != null && !bIFile.isDirectory()) {
            if (commandLineArguments.parameters.length > 2) {
                log.error("Multiple file sources with one file target");
                return 2;
            }
            filePath = filePath.getParent();
        }
        for (int i = 0; i < commandLineArguments.parameters.length - 1; ++i) {
            FilePath[] filePathArray = DaemonGlob.expandPathString((BFileSpace)bDaemonSession.getFileSpace(), commandLineArguments.parameters[i], fileCache);
            for (int j = 0; j < filePathArray.length; ++j) {
                BIFile bIFile2 = DaemonFileUtil.findFile((BFileSpace)bDaemonSession.getFileSpace(), (FilePath)filePathArray[j], (FileCache)fileCache);
                if (bIFile2.isDirectory()) {
                    this.getDirectory((BDirectory)bIFile2, filePath, bl, string, fileCache);
                    continue;
                }
                this.getFile(bIFile2, filePath, string, fileCache);
            }
        }
        return 0;
    }

    private void getDirectory(BDirectory bDirectory, FilePath filePath, boolean bl, String string, FileCache fileCache) throws Exception {
        BIFile[] bIFileArray = DaemonFileUtil.listFiles((BDirectory)bDirectory, (FileCache)fileCache);
        for (int i = 0; i < bIFileArray.length; ++i) {
            if (bIFileArray[i].isDirectory()) {
                if (!bl) continue;
                this.getDirectory((BDirectory)bIFileArray[i], filePath.merge(bIFileArray[i].getFileName()), bl, string, fileCache);
                continue;
            }
            this.getFile(bIFileArray[i], filePath, string, fileCache);
        }
    }

    private void getFile(BIFile bIFile, FilePath filePath, String string, FileCache fileCache) throws Exception {
        BFileSystem.INSTANCE.makeDir(filePath);
        FilePath filePath2 = filePath.merge(bIFile.getFileName());
        BIFile bIFile2 = BFileSystem.INSTANCE.findFile(filePath2);
        String string2 = "created ";
        if (bIFile2 == null) {
            bIFile2 = BFileSystem.INSTANCE.makeFile(filePath2);
        } else {
            if (string.equals("crc") && DaemonFileUtil.getCrc((BIFile)bIFile) == DaemonFileUtil.getCrc((BIFile)bIFile2)) {
                log.message(filePath2.getBody() + " not overwritten");
                return;
            }
            if (string.equals("prompt")) {
                if (!this.promptBoolean("Replace " + filePath2.getBody() + " (y/n)? ")) {
                    return;
                }
                string2 = "replaced ";
            } else {
                if (string.equals("none")) {
                    log.message(filePath2.getBody() + " not overwritten");
                    return;
                }
                string2 = "replaced ";
            }
        }
        OutputStream outputStream = bIFile2.getOutputStream();
        InputStream inputStream = bIFile.getInputStream();
        byte[] byArray = new byte[8192];
        try {
            int n;
            while ((n = inputStream.read(byArray, 0, 8192)) > 0) {
                outputStream.write(byArray, 0, n);
            }
        }
        catch (IOException iOException) {
            try {
                inputStream.close();
            }
            catch (IOException iOException2) {
                // empty catch block
            }
            try {
                outputStream.close();
            }
            catch (IOException iOException3) {
                // empty catch block
            }
            throw iOException;
        }
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            outputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        log.message(string2 + filePath2.getBody());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

