/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.command;

import com.tridium.platDaemon.util.DaemonGlob;
import com.tridium.platform.command.BDaemonSessionCommand;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.DaemonFileUtil;
import com.tridium.platform.daemon.file.BDaemonFileSpace;
import com.tridium.platform.daemon.file.BDefaultDaemonFileSpace;
import com.tridium.platform.daemon.message.DeleteFileTransferMessageElement;
import com.tridium.platform.daemon.message.FileTransferMessage;
import com.tridium.platform.daemon.message.FileTransferMessageElement;
import com.tridium.platform.daemon.task.DaemonSessionTask;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import com.tridium.util.CommandLineArguments;
import javax.baja.file.BFileSpace;
import javax.baja.file.FilePath;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BFileDeleteCommand
extends BDaemonSessionCommand {
    public static final BFileDeleteCommand INSTANCE = new BFileDeleteCommand();
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$platDaemon$command$BFileDeleteCommand == null ? (class$com$tridium$platDaemon$command$BFileDeleteCommand = BFileDeleteCommand.class$("com.tridium.platDaemon.command.BFileDeleteCommand")) : class$com$tridium$platDaemon$command$BFileDeleteCommand));
    static /* synthetic */ Class class$com$tridium$platDaemon$command$BFileDeleteCommand;

    public Type getType() {
        return TYPE;
    }

    protected BFileDeleteCommand() {
    }

    public String getCommandName() {
        return "fdelete";
    }

    public String getLicenseVendor() {
        return "tridium";
    }

    public String getLicenseFeature() {
        return "workbench";
    }

    public boolean includeInCommandListing() {
        return false;
    }

    public String getCommandDescription() {
        return "delete files or directories from the remote host";
    }

    public void usage() {
        BFileDeleteCommand.println((String)"");
        BFileDeleteCommand.println((String)"usage:");
        BFileDeleteCommand.println((String)"  plat fdelete <flags> <path>*");
        BFileDeleteCommand.println((String)"parameters:");
        BFileDeleteCommand.println((String)"  path               path to be deleted");
        BFileDeleteCommand.println((String)"required flags:");
        BFileDeleteCommand.println((String)"  -h:<hostord>       ORD for the remote host");
        BFileDeleteCommand.println((String)"optional flags:");
        BFileDeleteCommand.println((String)"  -usr:<userName>    user name for the host's platform daemon");
        BFileDeleteCommand.println((String)"  -pwd:<password>    password for the host's platform daemon");
        BFileDeleteCommand.println((String)"  -noinput           if given, command will fail when username");
        BFileDeleteCommand.println((String)"                       and password are missing or incorrect,");
        BFileDeleteCommand.println((String)"                       instead of prompting and reading them");
        BFileDeleteCommand.println((String)"                       from stdin");
        BFileDeleteCommand.println((String)"  -prompt            prompt before each delete, default");
        BFileDeleteCommand.println((String)"  -noprompt          do not prompt before each delete");
        BFileDeleteCommand.println((String)"  -p:<port>          port for the remote host's platform daemon");
        BFileDeleteCommand.println((String)"                       if omitted, default port 3011 is used");
        BFileDeleteCommand.println((String)"  -locale:<x>        set the default locale (en_US)");
        BFileDeleteCommand.println((String)"  -@<option>         pass option to Java VM");
        BFileDeleteCommand.println((String)"  -buildreg          force rebuild of the registry");
        BFileDeleteCommand.println((String)"");
    }

    public int invoke(CommandLineArguments commandLineArguments) throws Exception {
        if (commandLineArguments.hasHelpOption() || commandLineArguments.parameters.length < 1) {
            this.usage();
            return 2;
        }
        BDaemonSession bDaemonSession = this.getSession(commandLineArguments);
        if (bDaemonSession == null) {
            this.usage();
            return 2;
        }
        boolean bl = !commandLineArguments.hasOption("noprompt");
        BDefaultDaemonFileSpace bDefaultDaemonFileSpace = bDaemonSession.getFileSpace();
        FileTransferMessage fileTransferMessage = new FileTransferMessage((BDaemonFileSpace)bDefaultDaemonFileSpace);
        for (int i = 0; i < commandLineArguments.parameters.length; ++i) {
            FilePath[] filePathArray = DaemonGlob.expandPathString((BFileSpace)bDefaultDaemonFileSpace, commandLineArguments.parameters[i]);
            for (int j = 0; j < filePathArray.length; ++j) {
                if (bl && !this.promptDelete(filePathArray[j])) continue;
                fileTransferMessage.addElement((FileTransferMessageElement)new DeleteFileTransferMessageElement(filePathArray[j], (BDaemonFileSpace)bDefaultDaemonFileSpace));
            }
        }
        DaemonFileUtil.transfer((BDaemonSession)bDaemonSession, (FileTransferMessage)fileTransferMessage, null, (DaemonSessionTaskListener)new Listener());
        return 0;
    }

    private boolean promptDelete(FilePath filePath) throws Exception {
        return this.promptBoolean("Delete " + filePath.getBody() + " (y/n)? ");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class Listener
    implements DaemonSessionTaskListener {
        String lastText = null;

        private Listener() {
        }

        public void taskStarted(DaemonSessionTask daemonSessionTask) {
            if (!daemonSessionTask.getMessage().equals(this.lastText)) {
                System.out.println(daemonSessionTask.getMessage());
                this.lastText = daemonSessionTask.getMessage();
            }
        }

        public void taskUpdated(DaemonSessionTask daemonSessionTask) {
            this.taskStarted(daemonSessionTask);
        }

        public void taskFinished(DaemonSessionTask daemonSessionTask) {
        }

        public boolean isCancelEnabled() {
            return false;
        }
    }
}

