/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.command;

import com.tridium.install.BDaemonPlatform;
import com.tridium.install.BDependency;
import com.tridium.install.BRemoteDaemonPlatform;
import com.tridium.install.DaemonPlatformUtil;
import com.tridium.install.InstallScenario;
import com.tridium.install.installable.BDistribution;
import com.tridium.install.installable.BInstallable;
import com.tridium.install.installable.ClosableCursor;
import com.tridium.install.installable.DistributionManifest;
import com.tridium.install.installable.InstallableRegistry;
import com.tridium.install.installable.LocalInstallableRegistry;
import com.tridium.install.part.BNrePart;
import com.tridium.install.part.BPart;
import com.tridium.platform.command.BDaemonSessionCommand;
import com.tridium.platform.daemon.BAppSurrogate;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.BModuleContent;
import com.tridium.platform.daemon.BStationSurrogate;
import com.tridium.platform.daemon.DaemonFileUtil;
import com.tridium.platform.daemon.file.BCachedDaemonFileSpace;
import com.tridium.platform.daemon.file.BDaemonFileSpace;
import com.tridium.platform.daemon.message.ByteArrayFileTransferElement;
import com.tridium.platform.daemon.message.DaemonMessage;
import com.tridium.platform.daemon.message.FileTransferMessage;
import com.tridium.platform.daemon.message.FileTransferMessageElement;
import com.tridium.platform.daemon.message.OSUpdateMessage;
import com.tridium.platform.daemon.message.RefreshDaemonBinariesMessage;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import com.tridium.platform.license.LicenseInfo;
import com.tridium.platform.tcpip.BTcpIpHostSettings;
import com.tridium.platform.tcpip.TcpUtil;
import com.tridium.platform.timezone.BDstSupportLevel;
import com.tridium.platform.timezone.TimeZoneUtil;
import com.tridium.util.CommandLineArguments;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.BLocalFileStore;
import javax.baja.file.FilePath;
import javax.baja.log.Log;
import javax.baja.nre.util.Array;
import javax.baja.platform.BStationStatus;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.xml.XContent;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;
import javax.baja.xml.XWriter;

public class BBackupInstallCommand
extends BDaemonSessionCommand {
    public static final BBackupInstallCommand INSTANCE = new BBackupInstallCommand();
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$platDaemon$command$BBackupInstallCommand == null ? (class$com$tridium$platDaemon$command$BBackupInstallCommand = BBackupInstallCommand.class$("com.tridium.platDaemon.command.BBackupInstallCommand")) : class$com$tridium$platDaemon$command$BBackupInstallCommand));
    private static Log log = Log.getLog((String)"backupinstall");
    static /* synthetic */ Class class$com$tridium$platDaemon$command$BBackupInstallCommand;
    static /* synthetic */ Class class$com$tridium$install$BDependency;
    static /* synthetic */ Class class$java$lang$String;

    public Type getType() {
        return TYPE;
    }

    protected BBackupInstallCommand() {
    }

    public String getCommandName() {
        return "backupinstall";
    }

    public String getCommandDescription() {
        return "install backup distribution file to a remote host";
    }

    public String getLicenseVendor() {
        return "tridium";
    }

    public String getLicenseFeature() {
        return "workbench";
    }

    public boolean includeInCommandListing() {
        return false;
    }

    public void usage() {
        BBackupInstallCommand.println((String)"");
        BBackupInstallCommand.println((String)"usage:");
        BBackupInstallCommand.println((String)"  plat backupinstall <flags> <distfilepath>");
        BBackupInstallCommand.println((String)"parameters:");
        BBackupInstallCommand.println((String)"  distfilepath        FilePath for the distribution file to install");
        BBackupInstallCommand.println((String)"required flags:");
        BBackupInstallCommand.println((String)"  -h:<hostord>        ORD for the remote host");
        BBackupInstallCommand.println((String)"optional flags:");
        BBackupInstallCommand.println((String)"  -usr:<userName>     user name for the host's platform daemon");
        BBackupInstallCommand.println((String)"  -pwd:<password>     password for the host's platform daemon");
        BBackupInstallCommand.println((String)"  -notcp              if present, the install will not change the");
        BBackupInstallCommand.println((String)"                        remote host's TCP/IP settings");
        BBackupInstallCommand.println((String)"  -allowupgrades      if present, the install will attempt to");
        BBackupInstallCommand.println((String)"                        use different software than what's specified");
        BBackupInstallCommand.println((String)"                        in the backup dist if the backup dist's");
        BBackupInstallCommand.println((String)"                        dependencies can't be met exactly");
        BBackupInstallCommand.println((String)"  -noinput            if given, command will fail when username");
        BBackupInstallCommand.println((String)"                        and password are missing or incorrect,");
        BBackupInstallCommand.println((String)"                        instead of prompting and reading them");
        BBackupInstallCommand.println((String)"                        from stdin");
        BBackupInstallCommand.println((String)"  -p:<port>           port for the remote host's platform daemon");
        BBackupInstallCommand.println((String)"                        if omitted, default port 3011 is used");
        BBackupInstallCommand.println((String)"  -locale:<x>         set the default locale (en_US)");
        BBackupInstallCommand.println((String)"  -@<option>          pass option to Java VM");
        BBackupInstallCommand.println((String)"  -buildreg           force rebuild of the registry");
        BBackupInstallCommand.println((String)"");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int invoke(CommandLineArguments commandLineArguments) throws Exception {
        int n;
        BPart bPart;
        BPart bPart2;
        DistributionManifest distributionManifest;
        Object object;
        boolean bl = commandLineArguments.hasOption("notcp");
        boolean bl2 = commandLineArguments.hasOption("allowupgrades");
        if (commandLineArguments.hasHelpOption() || commandLineArguments.parameters.length != 1) {
            this.usage();
            return 2;
        }
        String string = commandLineArguments.parameters[0];
        BDaemonSession bDaemonSession = this.getSession(commandLineArguments);
        if (bDaemonSession == null) {
            this.usage();
            return 2;
        }
        BIFile bIFile = BFileSystem.INSTANCE.findFile(new FilePath(string));
        if (bIFile == null) {
            log.error(string + " not found");
            return 1;
        }
        BDistribution bDistribution = new BDistribution(bIFile);
        if (!bDistribution.getInstallableName().equals("backupdist")) {
            log.error(string + " is not a backup distribution file");
            return 1;
        }
        int n2 = 0;
        BRemoteDaemonPlatform bRemoteDaemonPlatform = BRemoteDaemonPlatform.make((BDaemonSession)bDaemonSession, (DaemonSessionTaskListener)this);
        bRemoteDaemonPlatform.checkSession();
        bRemoteDaemonPlatform.getModuleList().init();
        InstallScenario installScenario = InstallScenario.solve((BDaemonPlatform)bRemoteDaemonPlatform, null, (String[])new String[0], (BDependency[])new BDependency[0], (BInstallable[])new BInstallable[]{bDistribution}, (InstallableRegistry)LocalInstallableRegistry.getInstance());
        BCachedDaemonFileSpace bCachedDaemonFileSpace = new BCachedDaemonFileSpace(bDaemonSession, true, true, false, null, (DaemonSessionTaskListener)this);
        FileTransferMessage fileTransferMessage = new FileTransferMessage((BDaemonFileSpace)bCachedDaemonFileSpace);
        ZipFile zipFile = null;
        if (installScenario.getUnmetDependencies().length > 0) {
            BModuleContent bModuleContent;
            Object object2;
            String string2;
            InstallScenario installScenario2;
            if (!bl2) {
                for (int i = 0; i < installScenario.getUnmetDependencies().length; ++i) {
                    log.error("Unmet dependency: " + installScenario.getUnmetDependencies()[i]);
                }
                log.message("Use the -allowupgrades option to install this backup with upgraded software");
                return 1;
            }
            zipFile = new ZipFile(((BLocalFileStore)bIFile.getStore()).getLocalFile());
            object = zipFile.getEntry("META-INF/dist.xml");
            if (object == null) {
                object = zipFile.getEntry("meta-inf/dist.xml");
            }
            distributionManifest = DistributionManifest.make((InputStream)zipFile.getInputStream((ZipEntry)object));
            Array array = new Array(class$com$tridium$install$BDependency == null ? (class$com$tridium$install$BDependency = BBackupInstallCommand.class$("com.tridium.install.BDependency")) : class$com$tridium$install$BDependency);
            bPart2 = null;
            ClosableCursor closableCursor = LocalInstallableRegistry.getInstance().getInstallables(true, null, bRemoteDaemonPlatform.getConfigDistFileName());
            while (closableCursor.next()) {
                bPart = (BDistribution)closableCursor.get();
                installScenario2 = InstallScenario.solve((BDaemonPlatform)bRemoteDaemonPlatform, null, null, null, (BInstallable[])new BInstallable[]{bPart}, (InstallableRegistry)LocalInstallableRegistry.getInstance());
                if (installScenario2.getUnmetDependencies().length != 0) continue;
                bPart2 = bPart;
                break;
            }
            if (bPart2 == null) {
                log.error("Can't find a nre-config-*.dist version suitable for the remote host's platform");
                try {
                    zipFile.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return 1;
            }
            bPart = distributionManifest.getPlatformXml();
            installScenario2 = new HashMap();
            XElem[] xElemArray = bPart.elems("p");
            for (int i = 0; i < xElemArray.length; ++i) {
                string2 = xElemArray[i].get("t");
                string2 = string2.substring(string2.indexOf(58) + 1);
                installScenario2.put(string2, xElemArray[i]);
            }
            ZipFile zipFile2 = new ZipFile(bPart2.getLocalInstallableFile());
            object = zipFile2.getEntry("META-INF/dist.xml");
            if (object == null) {
                object = zipFile2.getEntry("meta-inf/dist.xml");
            }
            string2 = DistributionManifest.make((InputStream)zipFile2.getInputStream((ZipEntry)object));
            XElem xElem = string2.getPlatformXml();
            HashSet<String> hashSet = new HashSet<String>();
            String string3 = xElem.get("m", null);
            if (string3 != null) {
                int n3 = string3.indexOf(61);
                if (n3 < 0) {
                    hashSet.add(string3);
                } else {
                    hashSet.add(string3.substring(n3 + 1));
                }
            }
            XElem xElem2 = new XElem("bajaObjectGraph");
            xElem2.addAttr("version", "1.0");
            XElem xElem3 = new XElem("p");
            xElem3.addAttr("n", "platform");
            xElem3.addAttr("m", "platform=platform");
            xElem3.addAttr("t", "platform:PlatformServiceContainer");
            xElem2.addContent((XContent)xElem3);
            XElem[] xElemArray2 = xElem.elems();
            for (int i = 0; i < xElemArray2.length; ++i) {
                if (!xElemArray2[i].name().equals("p")) continue;
                string3 = xElemArray2[i].get("m", null);
                if (string3 != null) {
                    int n4 = string3.indexOf(61);
                    if (n4 < 0) {
                        hashSet.add(string3);
                    } else {
                        hashSet.add(string3.substring(n4 + 1));
                    }
                }
                object2 = xElemArray2[i].get("t");
                bModuleContent = (XElem)installScenario2.get(object2 = ((String)object2).substring(((String)object2).indexOf(58) + 1));
                if (bModuleContent != null) {
                    xElem3.addContent((XContent)bModuleContent.copy());
                    continue;
                }
                xElem3.addContent((XContent)xElemArray2[i].copy());
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            object2 = new XWriter((OutputStream)byteArrayOutputStream);
            object2.prolog();
            xElem2.write((XWriter)object2);
            object2.close();
            bModuleContent = distributionManifest.getUpdateModuleContent();
            if (bModuleContent != null && bModuleContent != BModuleContent.runtime) {
                hashSet.add("web");
                hashSet.add("icons");
                hashSet.add("converters");
                hashSet.add("html");
                hashSet.add("fonts");
                hashSet.add("chart");
                hashSet.add("wiresheet");
                hashSet.add("workbench");
                hashSet.add("pdf");
                hashSet.add("kitPx");
            }
            Array array2 = new Array(class$java$lang$String == null ? (class$java$lang$String = BBackupInstallCommand.class$("java.lang.String")) : class$java$lang$String);
            array2.add((Object)distributionManifest.getEntryPath(new FilePath("!lib/platform.bog")));
            array2.add((Object)distributionManifest.getEntryPath(new FilePath("!lib/system.properties")));
            array2.add((Object)distributionManifest.getEntryPath(new FilePath("!lib/nre.properties")));
            array2.add((Object)distributionManifest.getEntryPath(new FilePath("!daemon/daemon.properties")));
            fileTransferMessage.addElement((FileTransferMessageElement)new ByteArrayFileTransferElement(new FilePath("!lib/platform.bog"), byteArrayOutputStream.toByteArray(), (BDaemonFileSpace)bCachedDaemonFileSpace));
            String string4 = distributionManifest.getEntryPath(new FilePath("!stations"));
            Object object3 = zipFile.entries();
            while (object3.hasMoreElements()) {
                XElem xElem4;
                ZipEntry zipEntry = object3.nextElement();
                boolean bl3 = zipEntry.getName().toLowerCase().startsWith("meta-inf");
                FilePath filePath = this.getEntryDestPath(distributionManifest.useAbsoluteElementPaths(), zipEntry.getName());
                if (filePath.getName().endsWith(".license")) {
                    InputStream inputStream = zipFile.getInputStream(zipEntry);
                    try {
                        xElem4 = XParser.make((InputStream)inputStream).parse();
                        LicenseInfo licenseInfo = new LicenseInfo(xElem4);
                        if (!bDaemonSession.getHostProperties().getHostId().equals(licenseInfo.vendorLicense.getHostId())) {
                            bl3 = true;
                        }
                    }
                    catch (Exception exception) {
                        bl3 = true;
                    }
                    inputStream.close();
                }
                for (int i = 0; !bl3 && i < array2.size(); ++i) {
                    if (!zipEntry.getName().equals(array2.get(i))) continue;
                    bl3 = true;
                }
                if (bl3) continue;
                if (string2.useAbsoluteElementPaths() || filePath.isSysHomeAbsolute()) {
                    fileTransferMessage.addElement((FileTransferMessageElement)new ZipTransferElement(filePath, (BDaemonFileSpace)bCachedDaemonFileSpace, zipFile, zipEntry));
                }
                if (!zipEntry.getName().startsWith(string4) || !zipEntry.getName().endsWith("/config.bog")) continue;
                InputStream inputStream = zipFile.getInputStream(zipEntry);
                try {
                    xElem4 = XParser.make((InputStream)inputStream).parse();
                    this.accumBogModuleDeps(hashSet, xElem4);
                }
                finally {
                    try {
                        inputStream.close();
                    }
                    catch (Exception exception) {}
                }
            }
            object3 = hashSet.iterator();
            while (object3.hasNext()) {
                array.add((Object)BDependency.forModule((String)((String)object3.next())));
            }
            object3 = bDistribution.getNewOsTimeZone();
            if (!TimeZoneUtil.isSupported((BTimeZone)object3, (BDstSupportLevel)bDaemonSession.getHostProperties().getTimezoneDayModeSupport())) {
                object3 = BTimeZone.NULL;
            }
            installScenario = new InstallScenario((BDaemonPlatform)bRemoteDaemonPlatform, null, new String[]{}, (BDependency[])array.trim(), new BInstallable[]{bPart2}, (BTimeZone)object3, bDistribution.getTcpIpChanges(), bDistribution.getUpdateModuleContent() ? bDistribution.getNewModuleContent() : null, (InstallableRegistry)LocalInstallableRegistry.getInstance()).solve();
            if ((installScenario = InstallScenario.upgradeOutOfDate((InstallScenario)installScenario, (InstallableRegistry)LocalInstallableRegistry.getInstance())).getUnmetDependencies().length > 0) {
                for (int i = 0; i < installScenario.getUnmetDependencies().length; ++i) {
                    log.error("Unmet dependency: " + installScenario.getUnmetDependencies()[i]);
                }
                return 1;
            }
        }
        object = BAppSurrogate.stopAllApps((BDaemonSession)bDaemonSession, null, null, (DaemonSessionTaskListener)this);
        distributionManifest = BStationSurrogate.makeAll((BDaemonSession)bDaemonSession);
        block19: for (n = 0; n < ((BStationSurrogate[])distributionManifest).length; ++n) {
            if (distributionManifest[n].getStationStatus() == BStationStatus.idle) continue;
            bPart2 = installScenario.getToInstall();
            for (int i = 0; i < ((BInstallable[])bPart2).length; ++i) {
                bPart = bPart2[i].getPart();
                if (bPart == null || !(bPart instanceof BNrePart)) continue;
                DaemonPlatformUtil.doExtraStationShutdownTasks((BDaemonPlatform)bRemoteDaemonPlatform, (DaemonSessionTaskListener)this, null);
                break block19;
            }
            break;
        }
        installScenario.commit((DaemonSessionTaskListener)this, bCachedDaemonFileSpace.getCache(), null, false);
        DaemonFileUtil.transfer((BDaemonSession)bDaemonSession, (FileTransferMessage)fileTransferMessage, null, (DaemonSessionTaskListener)this);
        if (zipFile != null) {
            zipFile.close();
        }
        if (installScenario.getTcpIpChanges() != null && !bl && !installScenario.getTcpIpChanges().getIsReadonly()) {
            log.message("Applying changes to TCP/IP settings");
            TcpUtil.saveToSession((BTcpIpHostSettings)installScenario.getTcpIpChanges(), (BDaemonSession)bDaemonSession, (boolean)false);
        }
        if ((installScenario.getProcessingFlags() & 0x20000L) > 0L) {
            log.message("Updating OS Image");
            bDaemonSession.sendMessage((DaemonMessage)OSUpdateMessage.getInstance(), 60000);
        }
        n = (installScenario.getProcessingFlags() & 0x10000L) > 0L ? 1 : 0;
        boolean bl4 = false;
        if (((BAppSurrogate[])object).length > 0) {
            if (!bDaemonSession.getHostProperties().getAllowStationRestart()) {
                bl4 = true;
            } else {
                n = 1;
            }
        }
        if (n != 0) {
            log.message("Rebooting the remote host");
            bDaemonSession.sendRebootRequest();
        } else if ((installScenario.getProcessingFlags() & 0x40000L) > 0L) {
            log.message("Restarting the platform daemon");
            bDaemonSession.sendMessage((DaemonMessage)RefreshDaemonBinariesMessage.getInstance());
        } else if (bl4) {
            for (int i = 0; i < ((BAppSurrogate[])object).length; ++i) {
                log.message("Starting  " + object[i].toString(null));
                object[i].startAppAsync();
            }
        }
        log.message("Installation complete");
        return n2;
    }

    private void accumBogModuleDeps(Set set, XElem xElem) throws Exception {
        int n;
        Object object;
        if (xElem.name().equals("p") && (object = xElem.get("m", null)) != null) {
            n = ((String)object).indexOf(61);
            if (n < 0) {
                set.add(object);
            } else {
                set.add(((String)object).substring(n + 1));
            }
        }
        object = xElem.elems();
        for (n = 0; n < ((XElem[])object).length; ++n) {
            this.accumBogModuleDeps(set, (XElem)object[n]);
        }
    }

    private FilePath getEntryDestPath(boolean bl, String string) {
        if (bl) {
            FilePath filePath = string.charAt(0) == '/' ? new FilePath(string) : new FilePath("/" + string);
            if (filePath.nameAt(0).equals("niagara")) {
                FilePath filePath2 = filePath;
                filePath = new FilePath("!");
                for (int i = 1; i < filePath2.depth(); ++i) {
                    filePath = filePath.merge(filePath2.nameAt(i));
                }
            }
            return filePath;
        }
        if (string.charAt(0) == '/') {
            return new FilePath("!" + string.substring(1));
        }
        return new FilePath("!" + string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class ZipTransferElement
    extends FileTransferMessageElement {
        private ZipFile zipFile;
        private ZipEntry zipEntry;

        public ZipTransferElement(FilePath filePath, BDaemonFileSpace bDaemonFileSpace, ZipFile zipFile, ZipEntry zipEntry) {
            super(filePath, bDaemonFileSpace);
            this.zipFile = zipFile;
            this.zipEntry = zipEntry;
        }

        public InputStream getStream() throws IOException {
            return this.zipFile.getInputStream(this.zipEntry);
        }

        public long getSize() {
            return this.zipEntry.getSize();
        }
    }
}

