/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon;

import com.tridium.file.types.text.BCertificateFile;
import com.tridium.file.types.text.BLicenseFile;
import com.tridium.install.BDaemonPlatform;
import com.tridium.install.BVersion;
import com.tridium.install.installable.BModuleInstallable;
import com.tridium.install.part.BGenericPart;
import com.tridium.install.part.BNrePart;
import com.tridium.install.part.BOsPart;
import com.tridium.install.part.BPart;
import com.tridium.install.part.BVmPart;
import com.tridium.platform.BFilesystemAttributes;
import com.tridium.platform.BPlatformSSLSettings;
import com.tridium.platform.daemon.BAppSurrogate;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.BStationSurrogate;
import com.tridium.platform.daemon.DaemonFileUtil;
import com.tridium.platform.daemon.file.BCacheAccessPolicy;
import com.tridium.platform.daemon.file.BDaemonDirectoryStore;
import com.tridium.platform.daemon.file.BDaemonFileSpace;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import com.tridium.platform.license.CertificateInfo;
import com.tridium.platform.license.LicenseInfo;
import java.io.PrintWriter;
import javax.baja.file.BIFile;
import javax.baja.file.BIFileStore;
import javax.baja.file.FilePath;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.Property;
import javax.baja.util.Lexicon;

public class ConfigDetails {
    private static Lexicon lex = Lexicon.make((String)"platDaemon");

    public static void printDetails(BDaemonPlatform bDaemonPlatform, BAppSurrogate[] bAppSurrogateArray, PrintWriter printWriter) throws Exception {
        ConfigDetails.printDetails(bDaemonPlatform, bAppSurrogateArray, printWriter, null);
    }

    public static void printDetails(BDaemonPlatform bDaemonPlatform, BAppSurrogate[] bAppSurrogateArray, PrintWriter printWriter, DaemonSessionTaskListener daemonSessionTaskListener) throws Exception {
        String string;
        BFilesystemAttributes bFilesystemAttributes;
        int n;
        String string2;
        String string3;
        Property[] propertyArray;
        BPlatformSSLSettings bPlatformSSLSettings;
        BDaemonSession bDaemonSession = bDaemonPlatform.getDaemonSession();
        bDaemonSession.updateHostProperties();
        ConfigDetails.printlnLex(printWriter, "summaryHeader", new Object[]{bDaemonSession.getRemoteHost().getHostname()}, true);
        printWriter.println();
        printWriter.println(TextUtil.pad((String)(lex.getText("PlatformAdministration.daemonPort") + ": "), (int)22) + bDaemonPlatform.getPort());
        printWriter.println(TextUtil.pad((String)(lex.getText("PlatformAdministration.hostId") + ": "), (int)22) + bDaemonPlatform.getHostId());
        BNrePart bNrePart = bDaemonPlatform.getNrePart();
        if (!bNrePart.isNull()) {
            printWriter.println(TextUtil.pad((String)(lex.getText("PlatformAdministration.nre") + ": "), (int)22) + BVersion.formatNameVersion((String)bNrePart.getPartName(), (BVersion)bNrePart.getVersion(), null));
        }
        printWriter.println(TextUtil.pad((String)(lex.getText("PlatformAdministration.arch") + ": "), (int)22) + bDaemonPlatform.getArchPart().getPartName());
        printWriter.println(TextUtil.pad((String)(lex.getText("PlatformAdministration.numCpus") + ": "), (int)22) + bDaemonSession.getHostProperties().getNumCpus());
        printWriter.println(TextUtil.pad((String)(lex.getText("PlatformAdministration.model") + ": "), (int)22) + bDaemonPlatform.getModelPart().getPartName());
        printWriter.println(TextUtil.pad((String)(lex.getText("PlatformAdministration.moduleContent") + ": "), (int)22) + lex.getText("ModuleContent." + bDaemonPlatform.getModuleContent().getTag()));
        printWriter.println(TextUtil.pad((String)(lex.getText("PlatformAdministration.stripLineNumbers") + ": "), (int)22) + String.valueOf(bDaemonPlatform.getStripLineNumbers()));
        BOsPart bOsPart = bDaemonPlatform.getOsPart();
        String string4 = bOsPart.getDescription();
        if (string4 == null || string4.trim().length() == 0) {
            string4 = bOsPart.getPartName();
        }
        printWriter.println(TextUtil.pad((String)(lex.getText("PlatformAdministration.os") + ": "), (int)22) + BVersion.formatNameVersion((String)string4, (BVersion)bOsPart.getVersion(), null));
        BVmPart bVmPart = bDaemonPlatform.getVmPart();
        if (bVmPart == null || bVmPart.isNull()) {
            printWriter.println(TextUtil.pad((String)(lex.getText("PlatformAdministration.vm") + ": "), (int)22) + lex.getText("PlatformAdministration.noneValue"));
        } else if (bVmPart.getUnspecified()) {
            printWriter.println(TextUtil.pad((String)(lex.getText("PlatformAdministration.vm") + ": "), (int)22) + Lexicon.make((String)"platform").getText("unspecifiedVm.label"));
        } else {
            printWriter.println(TextUtil.pad((String)(lex.getText("PlatformAdministration.vm") + ": "), (int)22) + BVersion.formatNameVersion((BPart)bVmPart, null));
        }
        printWriter.println(TextUtil.pad((String)(lex.getText("PlatformAdministration.niagaraStationsEnabled") + ": "), (int)22) + (bDaemonPlatform.getNiagaraStationsEnabled() ? lex.getText("PlatformAdministration.niagaraStationsEnabled.enabled") : lex.getText("PlatformAdministration.niagaraStationsEnabled.disabled")));
        if (bDaemonPlatform.getSedonaSupported()) {
            printWriter.println(TextUtil.pad((String)(lex.getText("PlatformAdministration.sedonaSupport") + ": "), (int)22) + (bDaemonPlatform.getSedonaEnabled() ? lex.getText("PlatformAdministration.sedonaSupport.enabled") : lex.getText("PlatformAdministration.sedonaSupport.disabled")));
        } else {
            printWriter.println(TextUtil.pad((String)(lex.getText("PlatformAdministration.sedonaSupport") + ": "), (int)22) + lex.getText("PlatformAdministration.sedonaSupport.unsupported"));
        }
        if (bDaemonPlatform.getNiagaraR2Supported()) {
            printWriter.println(TextUtil.pad((String)(lex.getText("PlatformAdministration.niagaraR2Support") + ": "), (int)22) + (bDaemonPlatform.getNiagaraR2Enabled() ? lex.getText("PlatformAdministration.niagaraR2Support.enabled") : lex.getText("PlatformAdministration.niagaraR2Support.disabled")));
        } else {
            printWriter.println(TextUtil.pad((String)(lex.getText("PlatformAdministration.niagaraR2Support") + ": "), (int)22) + lex.getText("PlatformAdministration.niagaraR2Support.unsupported"));
        }
        if (bDaemonPlatform.getPlatformSSLSupported()) {
            bPlatformSSLSettings = bDaemonPlatform.getPlatformSSLSettings();
            if (bPlatformSSLSettings.getSslEnabled()) {
                if (bPlatformSSLSettings.getSslOnly()) {
                    printWriter.println(TextUtil.pad((String)(lex.getText("PlatformAdministration.sslSupport") + ": "), (int)22) + TextUtil.toLowerCase((String)lex.getText("PlatformAdministration.command.sslSettings.status.sslOnly")));
                } else {
                    printWriter.println(TextUtil.pad((String)(lex.getText("PlatformAdministration.sslSupport") + ": "), (int)22) + TextUtil.toLowerCase((String)lex.getText("PlatformAdministration.command.sslSettings.status.sslEnabled")));
                }
            } else {
                printWriter.println(TextUtil.pad((String)(lex.getText("PlatformAdministration.sslSupport") + ": "), (int)22) + TextUtil.toLowerCase((String)lex.getText("PlatformAdministration.command.sslSettings.status.sslDisabled")));
            }
            printWriter.println(TextUtil.pad((String)(lex.getText("PlatformAdministration.command.sslSettings.sslPort") + ": "), (int)22) + bPlatformSSLSettings.getSslPort());
            printWriter.println(TextUtil.pad((String)(lex.getText("PlatformAdministration.command.sslSettings.sslKeyAlias") + ": "), (int)22) + bPlatformSSLSettings.getKeyAlias());
            printWriter.println(TextUtil.pad((String)(lex.getText("PlatformAdministration.command.sslSettings.sslAlgType") + ": "), (int)22) + bPlatformSSLSettings.getSslAlgType());
        } else {
            printWriter.println(TextUtil.pad((String)(lex.getText("PlatformAdministration.sslSupport") + ": "), (int)22) + TextUtil.toLowerCase((String)lex.getText("PlatformAdministration.sslNotSupported")));
        }
        bPlatformSSLSettings = BDaemonDirectoryStore.make((BDaemonFileSpace)bDaemonSession.getFileSpace(), (FilePath)new FilePath("!"), (boolean)false, (boolean)false, (boolean)true, null);
        printWriter.println(TextUtil.pad((String)(lex.getText("PlatformAdministration.homeDir") + ": "), (int)22) + bPlatformSSLSettings.getLocalPath());
        int n2 = bDaemonSession.getHostProperties().getTotalPhysicalMemory();
        if (n2 > 0) {
            int n3 = bDaemonSession.getHostProperties().getFreePhysicalMemory();
            printWriter.println();
            printWriter.println(TextUtil.pad((String)lex.getText("PlatformAdministration.physicalMemory"), (int)14) + TextUtil.pad((String)lex.getText("PlatformAdministration.freeKb"), (int)14) + "  " + TextUtil.pad((String)lex.getText("PlatformAdministration.totalKb"), (int)14));
            printWriter.println(TextUtil.pad((String)"", (int)14) + TextUtil.padLeft((String)DaemonFileUtil.kbFormat.format(n3), (int)14) + "  " + TextUtil.padLeft((String)DaemonFileUtil.kbFormat.format(n2), (int)14));
        }
        if ((propertyArray = bDaemonSession.getHostProperties().getFilesystemAttributes().getPropertiesArray()).length > 0) {
            printWriter.println();
            boolean bl = bDaemonSession.getHostProperties().getOsName().toLowerCase().startsWith("qnx");
            string3 = "";
            string2 = "";
            if (bl) {
                string3 = "  " + TextUtil.pad((String)lex.getText("PlatformAdministration.currentFileCount"), (int)12) + "  " + TextUtil.pad((String)lex.getText("PlatformAdministration.maxFileCount"), (int)12);
            }
            printWriter.println(TextUtil.pad((String)lex.getText("PlatformAdministration.filesystem"), (int)14) + TextUtil.pad((String)lex.getText("PlatformAdministration.freeKb"), (int)14) + "  " + TextUtil.pad((String)lex.getText("PlatformAdministration.totalKb"), (int)14) + "  " + TextUtil.pad((String)lex.getText("PlatformAdministration.blockSize"), (int)12) + string3);
            for (n = 0; n < propertyArray.length; ++n) {
                bFilesystemAttributes = (BFilesystemAttributes)bDaemonSession.getHostProperties().getFilesystemAttributes().get(propertyArray[n]);
                string2 = "";
                if (bl) {
                    string = bFilesystemAttributes.getCurrentFileCount() < 0L ? lex.getText("PlatformAdministration.unavailable") : String.valueOf(bFilesystemAttributes.getCurrentFileCount());
                    String string5 = bFilesystemAttributes.getMaxFileCount() < 0L ? lex.getText("PlatformAdministration.unavailable") : String.valueOf(bFilesystemAttributes.getMaxFileCount());
                    string2 = "  " + TextUtil.padLeft((String)string, (int)12) + "  " + TextUtil.padLeft((String)string5, (int)12);
                }
                printWriter.println("  " + TextUtil.pad((String)SlotPath.unescape((String)propertyArray[n].getName()), (int)12) + TextUtil.padLeft((String)DaemonFileUtil.kbFormat.format(bFilesystemAttributes.getFreeSpace()), (int)14) + "  " + TextUtil.padLeft((String)DaemonFileUtil.kbFormat.format(bFilesystemAttributes.getTotalSpace()), (int)14) + "  " + TextUtil.padLeft((String)DaemonFileUtil.byteFormat.format(bFilesystemAttributes.getBlockSize()), (int)12) + string2);
            }
        }
        printWriter.println();
        ConfigDetails.printlnLex(printWriter, "modules");
        bDaemonPlatform.getModuleList().doInit(daemonSessionTaskListener);
        Property[] propertyArray2 = bDaemonPlatform.getModuleList().getModules().getProperties();
        while (propertyArray2.next()) {
            string3 = ((BModuleInstallable)propertyArray2.get()).getModulePart();
            printWriter.println("  " + BVersion.formatNameVersion((BPart)string3, null));
        }
        printWriter.println();
        ConfigDetails.printlnLex(printWriter, "other");
        propertyArray2 = bDaemonPlatform.getOtherParts().getPropertiesArray();
        if (propertyArray2.length == 0) {
            printWriter.println("  " + lex.getText("PlatformAdministration.noneValue"));
        } else {
            for (int i = 0; i < propertyArray2.length; ++i) {
                string2 = (BGenericPart)bDaemonPlatform.getOtherParts().get(propertyArray2[i]);
                printWriter.println("  " + BVersion.formatNameVersion((BPart)string2, null));
            }
        }
        printWriter.println();
        ConfigDetails.printlnLex(printWriter, "apps");
        for (int i = 0; i < bAppSurrogateArray.length; ++i) {
            printWriter.print("  " + bAppSurrogateArray[i].toString(null) + ' ');
            ConfigDetails.printLex(printWriter, "isAutoStart");
            printWriter.print('=' + String.valueOf(bAppSurrogateArray[i].getIsAutoStart()) + ", ");
            ConfigDetails.printLex(printWriter, "isAutoRestart");
            printWriter.print('=' + String.valueOf(bAppSurrogateArray[i].getIsAutoRestart()) + ", ");
            if (bAppSurrogateArray[i] instanceof BStationSurrogate) {
                string2 = (BStationSurrogate)bAppSurrogateArray[i];
                if (string2.getFoxPort() != -1) {
                    printWriter.print("fox=" + String.valueOf(string2.getFoxPort()) + ", ");
                }
                if (string2.getFoxsPort() != -1) {
                    printWriter.print("foxs=" + String.valueOf(string2.getFoxsPort()) + ", ");
                }
                if (string2.getHttpPort() != -1) {
                    printWriter.print("http=" + String.valueOf(string2.getHttpPort()) + ", ");
                }
                if (string2.getHttpsPort() != -1) {
                    printWriter.print("https=" + String.valueOf(string2.getHttpsPort()) + ", ");
                }
            }
            ConfigDetails.printLex(printWriter, "appStatus");
            printWriter.println('=' + bAppSurrogateArray[i].getAppStatus().toString());
        }
        printWriter.println();
        ConfigDetails.printlnLex(printWriter, "lexicons");
        BDaemonDirectoryStore bDaemonDirectoryStore = BDaemonDirectoryStore.make((BDaemonFileSpace)bDaemonSession.getFileSpace(), (FilePath)new FilePath("!lexicon"), (boolean)true, (boolean)false, (boolean)false, null);
        if (bDaemonDirectoryStore != null) {
            string2 = bDaemonDirectoryStore.getChildren(BCacheAccessPolicy.lazyFetch);
            for (n = 0; n < string2.size(); ++n) {
                if (!((BIFileStore)string2.get(n)).isDirectory()) continue;
                printWriter.println("  " + ((BIFileStore)string2.get(n)).getFileName());
            }
        }
        printWriter.println();
        ConfigDetails.printlnLex(printWriter, "licenses");
        bDaemonDirectoryStore = BDaemonDirectoryStore.make((BDaemonFileSpace)bDaemonSession.getFileSpace(), (FilePath)new FilePath("!licenses"), (boolean)true, (boolean)false, (boolean)false, null);
        if (bDaemonDirectoryStore != null) {
            string2 = bDaemonDirectoryStore.getChildren(BCacheAccessPolicy.lazyFetch);
            for (n = 0; n < string2.size(); ++n) {
                bFilesystemAttributes = (BIFileStore)string2.get(n);
                if (!"license".equals(bFilesystemAttributes.getExtension())) continue;
                string = new LicenseInfo((BIFile)new BLicenseFile((BIFileStore)bFilesystemAttributes));
                printWriter.println("  " + string.toString(null));
            }
        }
        printWriter.println();
        ConfigDetails.printlnLex(printWriter, "certificates");
        bDaemonDirectoryStore = BDaemonDirectoryStore.make((BDaemonFileSpace)bDaemonSession.getFileSpace(), (FilePath)new FilePath("!certificates"), (boolean)true, (boolean)false, (boolean)false, null);
        if (bDaemonDirectoryStore != null) {
            string2 = bDaemonDirectoryStore.getChildren(BCacheAccessPolicy.lazyFetch);
            for (n = 0; n < string2.size(); ++n) {
                bFilesystemAttributes = (BIFileStore)string2.get(n);
                if (!"certificate".equals(bFilesystemAttributes.getExtension())) continue;
                string = new CertificateInfo((BIFile)new BCertificateFile((BIFileStore)bFilesystemAttributes));
                printWriter.println("  " + string.toString(null));
            }
        }
    }

    public static String getDashes(String string) {
        if (string == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            stringBuffer.append('-');
        }
        return stringBuffer.toString();
    }

    private static void printlnLex(PrintWriter printWriter, String string) {
        ConfigDetails.printlnLex(printWriter, string, false);
    }

    private static void printlnLex(PrintWriter printWriter, String string, boolean bl) {
        ConfigDetails.printLex(printWriter, string);
        printWriter.println();
        if (bl) {
            printWriter.println(ConfigDetails.getDashes(lex.getText("PlatformAdministration." + string)));
        }
    }

    private static void printLex(PrintWriter printWriter, String string) {
        ConfigDetails.printLex(printWriter, string, new Object[0]);
    }

    private static void printlnLex(PrintWriter printWriter, String string, Object[] objectArray, boolean bl) {
        ConfigDetails.printLex(printWriter, string, objectArray);
        printWriter.println();
        if (bl) {
            printWriter.println(ConfigDetails.getDashes(lex.getText("PlatformAdministration." + string, objectArray)));
        }
    }

    private static void printLex(PrintWriter printWriter, String string, Object[] objectArray) {
        printWriter.print(lex.getText("PlatformAdministration." + string, objectArray));
    }
}

