/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.kitControl.util;

import com.tridium.kitControl.util.BRampWaveform;
import javax.baja.control.BNumericPoint;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BRamp
extends BNumericPoint {
    public static final Property enabled = BRamp.newProperty((int)0, (boolean)true, null);
    public static final Property period = BRamp.newProperty((int)0, (BValue)BRelTime.make((long)30000L), null);
    public static final Property amplitude = BRamp.newProperty((int)0, (int)50, null);
    public static final Property offset = BRamp.newProperty((int)0, (int)50, null);
    public static final Property updateInterval = BRamp.newProperty((int)0, (BValue)BRelTime.make((long)1000L), null);
    public static final Property waveform = BRamp.newProperty((int)0, (BValue)BRampWaveform.triangle, null);
    public static final Type TYPE;
    private static final BIcon icon;
    private long start;
    private Clock.Ticket ticket;
    static /* synthetic */ Class class$com$tridium$kitControl$util$BRamp;

    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public void setEnabled(boolean bl) {
        this.setBoolean(enabled, bl, null);
    }

    public BRelTime getPeriod() {
        return (BRelTime)this.get(period);
    }

    public void setPeriod(BRelTime bRelTime) {
        this.set(period, (BValue)bRelTime, null);
    }

    public double getAmplitude() {
        return this.getDouble(amplitude);
    }

    public void setAmplitude(double d) {
        this.setDouble(amplitude, d, null);
    }

    public double getOffset() {
        return this.getDouble(offset);
    }

    public void setOffset(double d) {
        this.setDouble(offset, d, null);
    }

    public BRelTime getUpdateInterval() {
        return (BRelTime)this.get(updateInterval);
    }

    public void setUpdateInterval(BRelTime bRelTime) {
        this.set(updateInterval, (BValue)bRelTime, null);
    }

    public BRampWaveform getWaveform() {
        return (BRampWaveform)this.get(waveform);
    }

    public void setWaveform(BRampWaveform bRampWaveform) {
        this.set(waveform, (BValue)bRampWaveform, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        this.execute();
        this.initTimer();
    }

    public void stopped() throws Exception {
        if (this.ticket != null) {
            this.ticket.cancel();
        }
        super.stopped();
    }

    private final void initTimer() {
        if (this.ticket != null) {
            this.ticket.cancel();
        }
        this.start = Clock.ticks();
        if (this.getEnabled()) {
            this.ticket = Clock.schedulePeriodically((BComponent)this, (BRelTime)this.getUpdateInterval(), (Action)execute, null);
        }
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (property == updateInterval || property == enabled) {
            if (this.getUpdateInterval().getMillis() < 1000L) {
                this.setUpdateInterval(BRelTime.make((long)1000L));
            }
            if (this.isRunning()) {
                this.initTimer();
            }
        }
    }

    public void onExecute(BStatusValue bStatusValue, Context context) {
        if (this.getEnabled()) {
            double d;
            bStatusValue.setStatus(BStatus.makeDisabled((BStatus)bStatusValue.getStatus(), (boolean)false));
            long l = this.getPeriod().getMillis();
            long l2 = Clock.ticks() - this.start;
            long l3 = l2 % l;
            double d2 = (double)l3 / (double)l;
            double d3 = this.getAmplitude();
            double d4 = this.getOffset();
            switch (this.getWaveform().getOrdinal()) {
                case 0: {
                    d = d4 - d3 + (d2 < 0.5 ? d3 * d2 : d3 * (1.0 - d2)) * (double)4;
                    break;
                }
                case 1: {
                    d = d4 - d3 + d3 * d2 * (double)2;
                    break;
                }
                case 2: {
                    d = d4 - d3 + d3 * (1.0 - d2) * (double)2;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            BStatusNumeric bStatusNumeric = (BStatusNumeric)bStatusValue;
            bStatusNumeric.setValue(d);
        } else {
            bStatusValue.setStatus(BStatus.makeDisabled((BStatus)bStatusValue.getStatus(), (boolean)true));
        }
    }

    public BIcon getIcon() {
        return icon;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$kitControl$util$BRamp;
        if (clazz == null) {
            clazz = class$com$tridium$kitControl$util$BRamp = BRamp.class("[Lcom.tridium.kitControl.util.BRamp;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.std((String)"control/util/sine.png");
    }
}

