/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.kitControl.timer;

import javax.baja.data.BIDataValue;
import javax.baja.status.BIStatus;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusNumeric;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BINumeric;
import javax.baja.sys.BIcon;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BNumericDelay
extends BComponent
implements BIStatus,
BINumeric {
    public static final Property facets = BNumericDelay.newProperty((int)0, (BValue)BFacets.makeNumeric(), null);
    public static final Property in = BNumericDelay.newProperty((int)8, (BValue)new BStatusNumeric(), null);
    public static final Property updateTime = BNumericDelay.newProperty((int)0, (BValue)BRelTime.make((long)1000L), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.makeSeconds((int)0)));
    public static final Property maxStepSize = BNumericDelay.newProperty((int)0, (double)0.5, null);
    public static final Property out = BNumericDelay.newProperty((int)10, (BValue)new BStatusNumeric(), null);
    public static final Action timerExpired = BNumericDelay.newAction((int)4, null);
    public static final Type TYPE;
    private static final BIcon icon;
    Clock.Ticket ticket;
    static /* synthetic */ Class class$com$tridium$kitControl$timer$BNumericDelay;

    public BFacets getFacets() {
        return (BFacets)this.get(facets);
    }

    public void setFacets(BFacets bFacets) {
        this.set(facets, (BValue)bFacets, null);
    }

    public BStatusNumeric getIn() {
        return (BStatusNumeric)this.get(in);
    }

    public void setIn(BStatusNumeric bStatusNumeric) {
        this.set(in, (BValue)bStatusNumeric, null);
    }

    public BRelTime getUpdateTime() {
        return (BRelTime)this.get(updateTime);
    }

    public void setUpdateTime(BRelTime bRelTime) {
        this.set(updateTime, (BValue)bRelTime, null);
    }

    public double getMaxStepSize() {
        return this.getDouble(maxStepSize);
    }

    public void setMaxStepSize(double d) {
        this.setDouble(maxStepSize, d, null);
    }

    public BStatusNumeric getOut() {
        return (BStatusNumeric)this.get(out);
    }

    public void setOut(BStatusNumeric bStatusNumeric) {
        this.set(out, (BValue)bStatusNumeric, null);
    }

    public void timerExpired() {
        this.invoke(timerExpired, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() {
        this.startTimer();
    }

    public void changed(Property property, Context context) {
        if (!this.isRunning()) {
            return;
        }
        if (property == updateTime) {
            this.startTimer();
        } else if (property == in && this.ticket == null) {
            this.calculate();
        }
    }

    public void calculate() {
        if (!this.getIn().getStatus().isValid()) {
            return;
        }
        double d = this.getIn().getValue();
        double d2 = this.getOut().getValue();
        double d3 = d - d2;
        if (d != d2) {
            if (this.getUpdateTime().getMillis() == 0L) {
                if (this.ticket != null) {
                    this.ticket.cancel();
                }
                this.setOutput(d);
            } else if ((double)((float)Math.abs(d3)) > this.getMaxStepSize()) {
                if (d > d2) {
                    this.setOutput(d2 + this.getMaxStepSize());
                } else {
                    this.setOutput(d2 - this.getMaxStepSize());
                }
            } else {
                this.setOutput(d);
            }
        }
    }

    private final void setOutput(double d) {
        this.getOut().setValue(d);
    }

    public void doTimerExpired() {
        this.calculate();
    }

    void startTimer() {
        BRelTime bRelTime;
        if (this.ticket != null) {
            this.ticket.cancel();
        }
        if ((bRelTime = this.getUpdateTime()).getMillis() != 0L) {
            this.ticket = Clock.schedulePeriodically((BComponent)this, (BRelTime)bRelTime, (Action)timerExpired, null);
        }
    }

    public String toString(Context context) {
        return this.getOut().toString(context);
    }

    public BFacets getSlotFacets(Slot slot) {
        if (slot == out) {
            return this.getFacets();
        }
        return super.getSlotFacets(slot);
    }

    public BStatus getStatus() {
        return this.getOut().getStatus();
    }

    public double getNumeric() {
        return this.getOut().getValue();
    }

    public final BFacets getNumericFacets() {
        return this.getFacets();
    }

    public BIcon getIcon() {
        return icon;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$kitControl$timer$BNumericDelay;
        if (clazz == null) {
            clazz = class$com$tridium$kitControl$timer$BNumericDelay = BNumericDelay.class("[Lcom.tridium.kitControl.timer.BNumericDelay;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.std((String)"control/control.png");
    }
}

