/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.kitControl.hvac;

import com.tridium.kitControl.BKitNumeric;
import com.tridium.kitControl.enums.BRaiseLowerFunction;
import javax.baja.data.BIDataValue;
import javax.baja.log.Log;
import javax.baja.status.BIStatus;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusNumeric;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BINumeric;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BRaiseLower
extends BKitNumeric
implements BIStatus,
BINumeric {
    public static final Property out = BRaiseLower.newProperty((int)267, (BValue)new BStatusNumeric(), null);
    public static final Property in = BRaiseLower.newProperty((int)10, (BValue)new BStatusNumeric(), (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)0), (String)"max", (BIDataValue)BInteger.make((int)100)));
    public static final Property cancelSynchronizationOfflimits = BRaiseLower.newProperty((int)0, (boolean)false, null);
    public static final Property lastValidIn = BRaiseLower.newProperty((int)7, (BValue)new BStatusNumeric(), (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)0), (String)"max", (BIDataValue)BInteger.make((int)100)));
    public static final Property virtualPosition = BRaiseLower.newProperty((int)3, (double)0.0, (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)0), (String)"max", (BIDataValue)BInteger.make((int)100)));
    public static final Property raise = BRaiseLower.newProperty((int)259, (BValue)new BStatusBoolean(), null);
    public static final Property lower = BRaiseLower.newProperty((int)259, (BValue)new BStatusBoolean(), null);
    public static final Property function = BRaiseLower.newProperty((int)259, (BValue)BRaiseLowerFunction.offState, null);
    public static final Property deadBand = BRaiseLower.newProperty((int)0, (double)0.5, (BFacets)BFacets.make((String)"min", (BIDataValue)BDouble.make((double)0.0), (String)"max", (BIDataValue)BDouble.make((double)5)));
    public static final Property driveTime = BRaiseLower.newProperty((int)0, (BValue)BRelTime.make((long)60000L), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.make((long)1000L)));
    public static final Property midnightResetEnabled = BRaiseLower.newProperty((int)0, (boolean)true, null);
    public static final Property midnightResetTime = BRaiseLower.newProperty((int)4, (BValue)BAbsTime.DEFAULT.timeOfDay(23, 55, 0, 0), (BFacets)BFacets.make((String)"showDate", (BIDataValue)BBoolean.FALSE, (String)"showTime", (BIDataValue)BBoolean.TRUE));
    public static final Action finishMoving = BRaiseLower.newAction((int)20, null);
    public static final Action update = BRaiseLower.newAction((int)20, null);
    public static final Action reset = BRaiseLower.newAction((int)16, null);
    public static final Type TYPE;
    private static final Log log;
    private static final BIcon icon;
    private Clock.Ticket driveTimeTicket;
    private BRelTime driveTimePeriod;
    private double newVirtualPosition;
    private BRelTime lastVirtualPositionTime;
    private Clock.Ticket resetTicket;
    static /* synthetic */ Class class$com$tridium$kitControl$hvac$BRaiseLower;

    public final BStatusNumeric getOut() {
        return (BStatusNumeric)this.get(out);
    }

    public final void setOut(BStatusNumeric bStatusNumeric) {
        this.set(out, (BValue)bStatusNumeric, null);
    }

    public final BStatusNumeric getIn() {
        return (BStatusNumeric)this.get(in);
    }

    public final void setIn(BStatusNumeric bStatusNumeric) {
        this.set(in, (BValue)bStatusNumeric, null);
    }

    public final boolean getCancelSynchronizationOfflimits() {
        return this.getBoolean(cancelSynchronizationOfflimits);
    }

    public final void setCancelSynchronizationOfflimits(boolean bl) {
        this.setBoolean(cancelSynchronizationOfflimits, bl, null);
    }

    public final BStatusNumeric getLastValidIn() {
        return (BStatusNumeric)this.get(lastValidIn);
    }

    public final void setLastValidIn(BStatusNumeric bStatusNumeric) {
        this.set(lastValidIn, (BValue)bStatusNumeric, null);
    }

    public final double getVirtualPosition() {
        return this.getDouble(virtualPosition);
    }

    public final void setVirtualPosition(double d) {
        this.setDouble(virtualPosition, d, null);
    }

    public final BStatusBoolean getRaise() {
        return (BStatusBoolean)this.get(raise);
    }

    public final void setRaise(BStatusBoolean bStatusBoolean) {
        this.set(raise, (BValue)bStatusBoolean, null);
    }

    public final BStatusBoolean getLower() {
        return (BStatusBoolean)this.get(lower);
    }

    public final void setLower(BStatusBoolean bStatusBoolean) {
        this.set(lower, (BValue)bStatusBoolean, null);
    }

    public final BRaiseLowerFunction getFunction() {
        return (BRaiseLowerFunction)this.get(function);
    }

    public final void setFunction(BRaiseLowerFunction bRaiseLowerFunction) {
        this.set(function, (BValue)bRaiseLowerFunction, null);
    }

    public final double getDeadBand() {
        return this.getDouble(deadBand);
    }

    public final void setDeadBand(double d) {
        this.setDouble(deadBand, d, null);
    }

    public final BRelTime getDriveTime() {
        return (BRelTime)this.get(driveTime);
    }

    public final void setDriveTime(BRelTime bRelTime) {
        this.set(driveTime, (BValue)bRelTime, null);
    }

    public final boolean getMidnightResetEnabled() {
        return this.getBoolean(midnightResetEnabled);
    }

    public final void setMidnightResetEnabled(boolean bl) {
        this.setBoolean(midnightResetEnabled, bl, null);
    }

    public final BAbsTime getMidnightResetTime() {
        return (BAbsTime)this.get(midnightResetTime);
    }

    public final void setMidnightResetTime(BAbsTime bAbsTime) {
        this.set(midnightResetTime, (BValue)bAbsTime, null);
    }

    public final void finishMoving() {
        this.invoke(finishMoving, null, null);
    }

    public final void update() {
        this.invoke(update, null, null);
    }

    public final void reset() {
        this.invoke(reset, null, null);
    }

    public final Type getType() {
        return TYPE;
    }

    public final void started() throws Exception {
        if (this.getMidnightResetEnabled()) {
            this.startResetTimer(BAbsTime.now());
        }
        this.update();
    }

    public final void stopped() throws Exception {
        this.stopResetTimer();
        this.stopAndUpdateVirtualPosition();
    }

    public final void changed(Property property, Context context) {
        if (this.isRunning()) {
            if (property.equals((Object)BKitNumeric.propagateFlags)) {
                BStatus bStatus = this.propagate(this.getLastValidIn().getStatus());
                this.getOut().setStatus(bStatus);
                this.getRaise().setStatus(bStatus);
                this.getLower().setStatus(bStatus);
            } else if (property.equals((Object)midnightResetEnabled) || property.equals((Object)midnightResetTime)) {
                if (this.getMidnightResetEnabled()) {
                    this.startResetTimer(BAbsTime.now());
                } else {
                    this.stopResetTimer();
                }
            } else if (property.equals((Object)in)) {
                double d = this.getDeadBand();
                double d2 = this.getIn().getValue();
                double d3 = this.getLastValidIn().getValue();
                if (d2 > 100.0) {
                    d2 = 100.0;
                } else if (d2 < 0.0) {
                    d2 = 0.0;
                }
                if (Math.abs(d3 - d2) > d / (double)2) {
                    this.getLastValidIn().setValue(this.getIn().getValue());
                    this.getLastValidIn().setStatus(this.getIn().getStatus());
                }
            } else if (property.equals((Object)lastValidIn) && !this.getFunction().equals((Object)BRaiseLowerFunction.resetLowerState) && !this.getFunction().equals((Object)BRaiseLowerFunction.resetRaiseState)) {
                BStatus bStatus = this.propagate(this.getLastValidIn().getStatus());
                this.getOut().setStatus(bStatus);
                this.getRaise().setStatus(bStatus);
                this.getLower().setStatus(bStatus);
                this.update();
            }
        }
    }

    public final BFacets getSlotFacets(Slot slot) {
        if (slot.equals((Object)out)) {
            return this.getFacets();
        }
        return super.getSlotFacets(slot);
    }

    public final BIcon getIcon() {
        return icon;
    }

    public final void doUpdate() {
        if (log.isTraceOn()) {
            log.trace("Update in progress");
        }
        this.stopAndUpdateVirtualPosition();
        double d = 0.0;
        BRaiseLowerFunction bRaiseLowerFunction = BRaiseLowerFunction.staticState;
        if (!this.getFunction().equals((Object)BRaiseLowerFunction.resetLowerState) && !this.getFunction().equals((Object)BRaiseLowerFunction.resetRaiseState)) {
            if (log.isTraceOn()) {
                log.trace("Input: " + this.getLastValidIn().getValue() + " Virtual: " + this.getVirtualPosition());
            }
            if (this.getLastValidIn().getValue() >= 100.0) {
                bRaiseLowerFunction = BRaiseLowerFunction.resetRaiseState;
            } else if (this.getLastValidIn().getValue() <= 0.0) {
                bRaiseLowerFunction = BRaiseLowerFunction.resetLowerState;
            } else {
                d = this.getLastValidIn().getValue() - this.getVirtualPosition();
                if (d > 0.0) {
                    bRaiseLowerFunction = BRaiseLowerFunction.raiseState;
                } else if (d < 0.0) {
                    bRaiseLowerFunction = BRaiseLowerFunction.lowerState;
                }
            }
            this.changeFunctionState(bRaiseLowerFunction);
        } else {
            bRaiseLowerFunction = this.getFunction();
        }
        if (!this.getFunction().equals((Object)BRaiseLowerFunction.staticState)) {
            BRelTime bRelTime = bRaiseLowerFunction.equals((Object)BRaiseLowerFunction.resetLowerState) || bRaiseLowerFunction.equals((Object)BRaiseLowerFunction.resetRaiseState) ? BRelTime.make((long)(this.getCancelSynchronizationOfflimits() ? this.getDriveTime().getMillis() : this.getDriveTime().getMillis() * (long)2)) : BRelTime.make((long)((long)((double)this.getDriveTime().getMillis() / 100.0 * Math.abs(d))));
            this.lastVirtualPositionTime = BRelTime.make((long)Clock.ticks());
            this.newVirtualPosition = this.getLastValidIn().getValue();
            if (log.isTraceOn()) {
                log.trace("Activating timer for drive time: " + bRelTime);
            }
            this.driveTimePeriod = bRelTime;
            this.driveTimeTicket = Clock.schedule((BComponent)this, (BRelTime)bRelTime, (Action)finishMoving, null);
        }
    }

    private final void stopAndUpdateVirtualPosition() {
        if (this.driveTimeTicket != null && !this.lastVirtualPositionTime.equals((Object)BRelTime.DEFAULT)) {
            BRelTime bRelTime = this.driveTimePeriod;
            this.driveTimeTicket.cancel();
            this.driveTimeTicket = null;
            long l = Clock.ticks() - this.lastVirtualPositionTime.getMillis();
            double d = this.getVirtualPosition();
            double d2 = this.newVirtualPosition - d;
            double d3 = d + (double)l / (double)bRelTime.getMillis() * d2;
            if (d3 < 0.0) {
                d3 = 0.0;
            } else if (d3 > 100.0) {
                d3 = 100.0;
            }
            this.setVirtualPosition(d3);
            if (log.isTraceOn()) {
                log.trace("After stop and update on raise vp = " + this.getVirtualPosition());
            }
            this.lastVirtualPositionTime = BRelTime.DEFAULT;
            this.newVirtualPosition = 0.0;
        }
    }

    private final void changeFunctionState(BRaiseLowerFunction bRaiseLowerFunction) {
        this.setFunction(bRaiseLowerFunction);
        BStatus bStatus = this.propagate(this.getLastValidIn().getStatus());
        this.getRaise().setStatus(bStatus);
        this.getLower().setStatus(bStatus);
        this.getOut().setStatus(bStatus);
        if (bRaiseLowerFunction.equals((Object)BRaiseLowerFunction.lowerState) || bRaiseLowerFunction.equals((Object)BRaiseLowerFunction.resetLowerState)) {
            this.getRaise().setValue(false);
            this.getLower().setValue(true);
            this.getOut().setValue((double)4);
        } else if (bRaiseLowerFunction.equals((Object)BRaiseLowerFunction.raiseState) || bRaiseLowerFunction.equals((Object)BRaiseLowerFunction.resetRaiseState)) {
            this.getRaise().setValue(true);
            this.getLower().setValue(false);
            this.getOut().setValue(10.0);
        } else {
            this.getRaise().setValue(false);
            this.getLower().setValue(false);
            if (bRaiseLowerFunction.equals((Object)BRaiseLowerFunction.offState)) {
                this.getOut().setValue(0.0);
            } else {
                this.getOut().setValue(7.0);
            }
        }
    }

    public final void doFinishMoving() {
        if (log.isTraceOn()) {
            log.trace("Finish moving called");
        }
        boolean bl = false;
        if (this.getFunction().equals((Object)BRaiseLowerFunction.resetLowerState)) {
            this.setVirtualPosition(0.0);
            boolean bl2 = false;
            if (this.getLastValidIn().getValue() > 0.0) {
                bl2 = true;
            }
            bl = bl2;
        } else if (this.getFunction().equals((Object)BRaiseLowerFunction.resetRaiseState)) {
            this.setVirtualPosition(100.0);
            boolean bl3 = false;
            if (this.getLastValidIn().getValue() < 100.0) {
                bl3 = true;
            }
            bl = bl3;
        } else {
            this.setVirtualPosition(this.newVirtualPosition);
        }
        this.changeFunctionState(BRaiseLowerFunction.staticState);
        this.lastVirtualPositionTime = BRelTime.DEFAULT;
        this.newVirtualPosition = 0.0;
        this.driveTimeTicket = null;
        if (bl) {
            this.doUpdate();
        }
    }

    private final void startResetTimer(BAbsTime bAbsTime) {
        if (this.resetTicket != null) {
            this.resetTicket.cancel();
        }
        BAbsTime bAbsTime2 = this.getMidnightResetTime();
        if (log.isTraceOn()) {
            log.trace("Next reset time: " + bAbsTime2);
        }
        BAbsTime bAbsTime3 = bAbsTime.timeOfDay(bAbsTime2.getHour(), bAbsTime2.getMinute(), bAbsTime2.getSecond(), 0);
        if (log.isTraceOn()) {
            log.trace("Next reset event: " + bAbsTime3);
        }
        this.resetTicket = Clock.schedule((BComponent)this, (BAbsTime)bAbsTime3, (Action)reset, null);
    }

    private final void stopResetTimer() {
        if (this.resetTicket != null) {
            this.resetTicket.cancel();
            this.resetTicket = null;
        }
    }

    public final void doReset() {
        this.startResetTimer(BAbsTime.now().nextDay());
        this.changeFunctionState(BRaiseLowerFunction.resetLowerState);
        this.update();
    }

    public final BStatus getStatus() {
        return this.getOut().getStatus();
    }

    public final double getNumeric() {
        return this.getOut().getValue();
    }

    public final BFacets getNumericFacets() {
        return this.getFacets();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.driveTimeTicket = null;
        this.driveTimePeriod = BRelTime.DEFAULT;
        this.newVirtualPosition = 0.0;
        this.lastVirtualPositionTime = BRelTime.DEFAULT;
        this.resetTicket = null;
    }

    public BRaiseLower() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$kitControl$hvac$BRaiseLower;
        if (clazz == null) {
            clazz = class$com$tridium$kitControl$hvac$BRaiseLower = BRaiseLower.class("[Lcom.tridium.kitControl.hvac.BRaiseLower;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        log = Log.getLog((String)"kitControl.raiseLower");
        icon = BIcon.std((String)"control/control.png");
    }
}

