/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.kitControl.hvac;

import javax.baja.status.BStatusBoolean;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BLink;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BLeadLagCycles
extends BComponent {
    public static final Property facets = BLeadLagCycles.newProperty((int)0, (BValue)BFacets.makeBoolean(), null);
    public static final Property in = BLeadLagCycles.newProperty((int)8, (BValue)new BStatusBoolean(), null);
    public static final Property numberOutputs = BLeadLagCycles.newProperty((int)0, (int)2, (BFacets)BFacets.makeInt(null, (int)2, (int)10));
    public static final Property maxRuntime = BLeadLagCycles.newProperty((int)0, (BValue)BRelTime.make((long)360000L), null);
    public static final Property feedback = BLeadLagCycles.newProperty((int)10, (BValue)new BStatusBoolean(), null);
    public static final Property feedbackDelay = BLeadLagCycles.newProperty((int)0, (BValue)BRelTime.make((long)5000L), null);
    public static final Property clearAlarmTime = BLeadLagCycles.newProperty((int)0, (BValue)BRelTime.makeHours((int)1), null);
    public static final Property outA = BLeadLagCycles.newProperty((int)10, (BValue)new BStatusBoolean(), null);
    public static final Property outB = BLeadLagCycles.newProperty((int)10, (BValue)new BStatusBoolean(), null);
    public static final Property outC = BLeadLagCycles.newProperty((int)2, (BValue)new BStatusBoolean(), null);
    public static final Property outD = BLeadLagCycles.newProperty((int)2, (BValue)new BStatusBoolean(), null);
    public static final Property outE = BLeadLagCycles.newProperty((int)2, (BValue)new BStatusBoolean(), null);
    public static final Property outF = BLeadLagCycles.newProperty((int)2, (BValue)new BStatusBoolean(), null);
    public static final Property outG = BLeadLagCycles.newProperty((int)2, (BValue)new BStatusBoolean(), null);
    public static final Property outH = BLeadLagCycles.newProperty((int)2, (BValue)new BStatusBoolean(), null);
    public static final Property outI = BLeadLagCycles.newProperty((int)2, (BValue)new BStatusBoolean(), null);
    public static final Property outJ = BLeadLagCycles.newProperty((int)2, (BValue)new BStatusBoolean(), null);
    public static final Property cycleCountA = BLeadLagCycles.newProperty((int)10, (int)0, null);
    public static final Property cycleCountB = BLeadLagCycles.newProperty((int)10, (int)0, null);
    public static final Property cycleCountC = BLeadLagCycles.newProperty((int)2, (int)0, null);
    public static final Property cycleCountD = BLeadLagCycles.newProperty((int)2, (int)0, null);
    public static final Property cycleCountE = BLeadLagCycles.newProperty((int)2, (int)0, null);
    public static final Property cycleCountF = BLeadLagCycles.newProperty((int)2, (int)0, null);
    public static final Property cycleCountG = BLeadLagCycles.newProperty((int)2, (int)0, null);
    public static final Property cycleCountH = BLeadLagCycles.newProperty((int)2, (int)0, null);
    public static final Property cycleCountI = BLeadLagCycles.newProperty((int)2, (int)0, null);
    public static final Property cycleCountJ = BLeadLagCycles.newProperty((int)2, (int)0, null);
    public static final Action rotateTimerExpired = BLeadLagCycles.newAction((int)4, null);
    public static final Action feedbackTimerExpired = BLeadLagCycles.newAction((int)4, null);
    public static final Action clearAlarmState = BLeadLagCycles.newAction((int)0, null);
    public static final Type TYPE;
    private static final BIcon icon;
    int numOutputs;
    int lastNumberOutputs;
    boolean feedbackTimerActive;
    boolean currentIn;
    boolean wasOn;
    int[] cycleCounts;
    Clock.Ticket rotateTicket;
    Clock.Ticket feedbackTicket;
    Clock.Ticket alarmClearTicket;
    static /* synthetic */ Class class$com$tridium$kitControl$hvac$BLeadLagCycles;

    public BFacets getFacets() {
        return (BFacets)this.get(facets);
    }

    public void setFacets(BFacets bFacets) {
        this.set(facets, (BValue)bFacets, null);
    }

    public BStatusBoolean getIn() {
        return (BStatusBoolean)this.get(in);
    }

    public void setIn(BStatusBoolean bStatusBoolean) {
        this.set(in, (BValue)bStatusBoolean, null);
    }

    public int getNumberOutputs() {
        return this.getInt(numberOutputs);
    }

    public void setNumberOutputs(int n) {
        this.setInt(numberOutputs, n, null);
    }

    public BRelTime getMaxRuntime() {
        return (BRelTime)this.get(maxRuntime);
    }

    public void setMaxRuntime(BRelTime bRelTime) {
        this.set(maxRuntime, (BValue)bRelTime, null);
    }

    public BStatusBoolean getFeedback() {
        return (BStatusBoolean)this.get(feedback);
    }

    public void setFeedback(BStatusBoolean bStatusBoolean) {
        this.set(feedback, (BValue)bStatusBoolean, null);
    }

    public BRelTime getFeedbackDelay() {
        return (BRelTime)this.get(feedbackDelay);
    }

    public void setFeedbackDelay(BRelTime bRelTime) {
        this.set(feedbackDelay, (BValue)bRelTime, null);
    }

    public BRelTime getClearAlarmTime() {
        return (BRelTime)this.get(clearAlarmTime);
    }

    public void setClearAlarmTime(BRelTime bRelTime) {
        this.set(clearAlarmTime, (BValue)bRelTime, null);
    }

    public BStatusBoolean getOutA() {
        return (BStatusBoolean)this.get(outA);
    }

    public void setOutA(BStatusBoolean bStatusBoolean) {
        this.set(outA, (BValue)bStatusBoolean, null);
    }

    public BStatusBoolean getOutB() {
        return (BStatusBoolean)this.get(outB);
    }

    public void setOutB(BStatusBoolean bStatusBoolean) {
        this.set(outB, (BValue)bStatusBoolean, null);
    }

    public BStatusBoolean getOutC() {
        return (BStatusBoolean)this.get(outC);
    }

    public void setOutC(BStatusBoolean bStatusBoolean) {
        this.set(outC, (BValue)bStatusBoolean, null);
    }

    public BStatusBoolean getOutD() {
        return (BStatusBoolean)this.get(outD);
    }

    public void setOutD(BStatusBoolean bStatusBoolean) {
        this.set(outD, (BValue)bStatusBoolean, null);
    }

    public BStatusBoolean getOutE() {
        return (BStatusBoolean)this.get(outE);
    }

    public void setOutE(BStatusBoolean bStatusBoolean) {
        this.set(outE, (BValue)bStatusBoolean, null);
    }

    public BStatusBoolean getOutF() {
        return (BStatusBoolean)this.get(outF);
    }

    public void setOutF(BStatusBoolean bStatusBoolean) {
        this.set(outF, (BValue)bStatusBoolean, null);
    }

    public BStatusBoolean getOutG() {
        return (BStatusBoolean)this.get(outG);
    }

    public void setOutG(BStatusBoolean bStatusBoolean) {
        this.set(outG, (BValue)bStatusBoolean, null);
    }

    public BStatusBoolean getOutH() {
        return (BStatusBoolean)this.get(outH);
    }

    public void setOutH(BStatusBoolean bStatusBoolean) {
        this.set(outH, (BValue)bStatusBoolean, null);
    }

    public BStatusBoolean getOutI() {
        return (BStatusBoolean)this.get(outI);
    }

    public void setOutI(BStatusBoolean bStatusBoolean) {
        this.set(outI, (BValue)bStatusBoolean, null);
    }

    public BStatusBoolean getOutJ() {
        return (BStatusBoolean)this.get(outJ);
    }

    public void setOutJ(BStatusBoolean bStatusBoolean) {
        this.set(outJ, (BValue)bStatusBoolean, null);
    }

    public int getCycleCountA() {
        return this.getInt(cycleCountA);
    }

    public void setCycleCountA(int n) {
        this.setInt(cycleCountA, n, null);
    }

    public int getCycleCountB() {
        return this.getInt(cycleCountB);
    }

    public void setCycleCountB(int n) {
        this.setInt(cycleCountB, n, null);
    }

    public int getCycleCountC() {
        return this.getInt(cycleCountC);
    }

    public void setCycleCountC(int n) {
        this.setInt(cycleCountC, n, null);
    }

    public int getCycleCountD() {
        return this.getInt(cycleCountD);
    }

    public void setCycleCountD(int n) {
        this.setInt(cycleCountD, n, null);
    }

    public int getCycleCountE() {
        return this.getInt(cycleCountE);
    }

    public void setCycleCountE(int n) {
        this.setInt(cycleCountE, n, null);
    }

    public int getCycleCountF() {
        return this.getInt(cycleCountF);
    }

    public void setCycleCountF(int n) {
        this.setInt(cycleCountF, n, null);
    }

    public int getCycleCountG() {
        return this.getInt(cycleCountG);
    }

    public void setCycleCountG(int n) {
        this.setInt(cycleCountG, n, null);
    }

    public int getCycleCountH() {
        return this.getInt(cycleCountH);
    }

    public void setCycleCountH(int n) {
        this.setInt(cycleCountH, n, null);
    }

    public int getCycleCountI() {
        return this.getInt(cycleCountI);
    }

    public void setCycleCountI(int n) {
        this.setInt(cycleCountI, n, null);
    }

    public int getCycleCountJ() {
        return this.getInt(cycleCountJ);
    }

    public void setCycleCountJ(int n) {
        this.setInt(cycleCountJ, n, null);
    }

    public void rotateTimerExpired() {
        this.invoke(rotateTimerExpired, null, null);
    }

    public void feedbackTimerExpired() {
        this.invoke(feedbackTimerExpired, null, null);
    }

    public void clearAlarmState() {
        this.invoke(clearAlarmState, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() {
        this.initNumberOutputs();
    }

    public void atSteadyState() {
        this.currentIn = this.getIn().getValue();
        this.calculate();
    }

    public void changed(Property property, Context context) {
        if (property == numberOutputs) {
            this.initNumberOutputs();
        }
        if (!this.isRunning()) {
            return;
        }
        if (property == in) {
            this.currentIn = this.getIn().getValue();
            this.calculate();
        } else if (property == feedback) {
            if (!this.currentIn) {
                return;
            }
            if (this.getFeedback().getValue()) {
                return;
            }
            if (this.feedbackTimerActive) {
                return;
            }
            this.setCurrentOutputAlarm(true);
            this.getCycleCounts();
            this.startOutput();
        }
    }

    public void initNumberOutputs() {
        this.numOutputs = this.getNumberOutputs();
        int n = 0;
        while (n < 10) {
            int n2 = n >= this.numOutputs ? 6 : 10;
            switch (n) {
                case 0: {
                    this.initSlot("outA", n2 | 1);
                    this.initSlot("cycleCountA", n2);
                    break;
                }
                case 1: {
                    this.initSlot("outB", n2 | 1);
                    this.initSlot("cycleCountB", n2);
                    break;
                }
                case 2: {
                    this.initSlot("outC", n2 | 1);
                    this.initSlot("cycleCountC", n2);
                    break;
                }
                case 3: {
                    this.initSlot("outD", n2 | 1);
                    this.initSlot("cycleCountD", n2);
                    break;
                }
                case 4: {
                    this.initSlot("outE", n2 | 1);
                    this.initSlot("cycleCountE", n2);
                    break;
                }
                case 5: {
                    this.initSlot("outF", n2 | 1);
                    this.initSlot("cycleCountF", n2);
                    break;
                }
                case 6: {
                    this.initSlot("outG", n2 | 1);
                    this.initSlot("cycleCountG", n2);
                    break;
                }
                case 7: {
                    this.initSlot("outH", n2 | 1);
                    this.initSlot("cycleCountH", n2);
                    break;
                }
                case 8: {
                    this.initSlot("outI", n2 | 1);
                    this.initSlot("cycleCountI", n2);
                    break;
                }
                case 9: {
                    this.initSlot("outJ", n2 | 1);
                    this.initSlot("cycleCountJ", n2);
                    break;
                }
            }
            ++n;
        }
    }

    void initSlot(String string, int n) {
        try {
            this.setFlags(this.getSlot(string), n, null);
        }
        catch (Exception exception) {}
    }

    public void doClearAlarmState() {
        if (this.alarmClearTicket != null) {
            this.alarmClearTicket.cancel();
            this.alarmClearTicket = null;
        }
        int n = 0;
        while (n < this.numOutputs) {
            this.getStatusOutput(n).setStatusInAlarm(false);
            ++n;
        }
    }

    public void doRotateTimerExpired() {
        if (!this.currentIn) {
            return;
        }
        this.getCycleCounts();
        this.startOutput();
    }

    public void doFeedbackTimerExpired() {
        this.feedbackTimerActive = false;
        if (!this.currentIn) {
            return;
        }
        if (this.getFeedback().getValue()) {
            return;
        }
        this.setCurrentOutputAlarm(true);
        this.getCycleCounts();
        this.startOutput();
    }

    void calculate() {
        this.getCycleCounts();
        if (this.currentIn) {
            if (!this.wasOn) {
                this.startOutput();
                this.wasOn = true;
            }
        } else {
            if (this.wasOn) {
                if (this.rotateTicket != null) {
                    this.rotateTicket.cancel();
                }
                if (this.feedbackTicket != null) {
                    this.feedbackTicket.cancel();
                }
                this.wasOn = false;
            }
            this.stopOutput();
        }
    }

    void getCycleCounts() {
        int n = 0;
        while (n < this.numOutputs) {
            this.cycleCounts[n] = this.isCycleCountLinked(n) && !this.getOutValue(n) ? this.getCycleCount(n) : Integer.MAX_VALUE;
            ++n;
        }
    }

    int getCycleCount(int n) {
        switch (n) {
            case 0: {
                return this.getCycleCountA();
            }
            case 1: {
                return this.getCycleCountB();
            }
            case 2: {
                return this.getCycleCountC();
            }
            case 3: {
                return this.getCycleCountD();
            }
            case 4: {
                return this.getCycleCountE();
            }
            case 5: {
                return this.getCycleCountF();
            }
            case 6: {
                return this.getCycleCountG();
            }
            case 7: {
                return this.getCycleCountH();
            }
            case 8: {
                return this.getCycleCountI();
            }
            case 9: {
                return this.getCycleCountJ();
            }
        }
        return Integer.MAX_VALUE;
    }

    boolean getOutValue(int n) {
        switch (n) {
            case 0: {
                return this.getOutA().getValue();
            }
            case 1: {
                return this.getOutB().getValue();
            }
            case 2: {
                return this.getOutC().getValue();
            }
            case 3: {
                return this.getOutD().getValue();
            }
            case 4: {
                return this.getOutE().getValue();
            }
            case 5: {
                return this.getOutF().getValue();
            }
            case 6: {
                return this.getOutG().getValue();
            }
            case 7: {
                return this.getOutH().getValue();
            }
            case 8: {
                return this.getOutI().getValue();
            }
            case 9: {
                return this.getOutJ().getValue();
            }
        }
        return false;
    }

    boolean isCycleCountLinked(int n) {
        BLink[] bLinkArray = null;
        switch (n) {
            case 0: {
                bLinkArray = this.getLinks(this.getSlot("cycleCountA"));
                break;
            }
            case 1: {
                bLinkArray = this.getLinks(this.getSlot("cycleCountB"));
                break;
            }
            case 2: {
                bLinkArray = this.getLinks(this.getSlot("cycleCountC"));
                break;
            }
            case 3: {
                bLinkArray = this.getLinks(this.getSlot("cycleCountD"));
                break;
            }
            case 4: {
                bLinkArray = this.getLinks(this.getSlot("cycleCountE"));
                break;
            }
            case 5: {
                bLinkArray = this.getLinks(this.getSlot("cycleCountF"));
                break;
            }
            case 6: {
                bLinkArray = this.getLinks(this.getSlot("cycleCountG"));
                break;
            }
            case 7: {
                bLinkArray = this.getLinks(this.getSlot("cycleCountH"));
                break;
            }
            case 8: {
                bLinkArray = this.getLinks(this.getSlot("cycleCountI"));
                break;
            }
            case 9: {
                bLinkArray = this.getLinks(this.getSlot("cycleCountJ"));
                break;
            }
        }
        if (bLinkArray == null) {
            return false;
        }
        boolean bl = false;
        if (bLinkArray.length != 0) {
            bl = true;
        }
        return bl;
    }

    void startOutput() {
        int n = Integer.MAX_VALUE;
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.numOutputs) {
            if (!this.getStatusOutput(n3).getStatus().isAlarm() && this.cycleCounts[n3] < n) {
                n = this.cycleCounts[n3];
                n2 = n3;
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < this.numOutputs) {
            BStatusBoolean bStatusBoolean = this.getStatusOutput(n3);
            boolean bl = false;
            if (n2 == n3) {
                bl = true;
            }
            bStatusBoolean.setValue(bl);
            ++n3;
        }
        this.startRotateTimer();
        this.startFeedbackTimer();
    }

    BStatusBoolean getStatusOutput(int n) {
        switch (n) {
            case 0: {
                return this.getOutA();
            }
            case 1: {
                return this.getOutB();
            }
            case 2: {
                return this.getOutC();
            }
            case 3: {
                return this.getOutD();
            }
            case 4: {
                return this.getOutE();
            }
            case 5: {
                return this.getOutF();
            }
            case 6: {
                return this.getOutG();
            }
            case 7: {
                return this.getOutH();
            }
            case 8: {
                return this.getOutI();
            }
            case 9: {
                return this.getOutJ();
            }
        }
        if (n < 0) {
            return this.getOutA();
        }
        return this.getOutJ();
    }

    void setCurrentOutputAlarm(boolean bl) {
        if (bl) {
            this.startAlarmClearTimer();
        }
        int n = 0;
        while (n < this.numOutputs) {
            BStatusBoolean bStatusBoolean = this.getStatusOutput(n);
            if (bStatusBoolean.getValue()) {
                bStatusBoolean.setStatusInAlarm(bl);
            }
            ++n;
        }
    }

    void stopOutput() {
        int n = 0;
        while (n < this.numOutputs) {
            this.getStatusOutput(n).setValue(false);
            ++n;
        }
    }

    void startAlarmClearTimer() {
        BRelTime bRelTime = this.getClearAlarmTime();
        if (bRelTime.getMillis() == 0L || this.alarmClearTicket != null) {
            return;
        }
        this.alarmClearTicket = Clock.schedule((BComponent)this, (BRelTime)bRelTime, (Action)clearAlarmState, null);
    }

    void startRotateTimer() {
        if (this.rotateTicket != null) {
            this.rotateTicket.cancel();
        }
        this.rotateTicket = Clock.schedule((BComponent)this, (BRelTime)this.getMaxRuntime(), (Action)rotateTimerExpired, null);
    }

    void startFeedbackTimer() {
        if (this.feedbackTicket != null) {
            this.feedbackTicket.cancel();
        }
        this.feedbackTimerActive = true;
        this.feedbackTicket = Clock.schedule((BComponent)this, (BRelTime)this.getFeedbackDelay(), (Action)feedbackTimerExpired, null);
    }

    public BFacets getSlotFacets(Slot slot) {
        if (slot.getName().startsWith("out")) {
            return this.getFacets();
        }
        return super.getSlotFacets(slot);
    }

    public BIcon getIcon() {
        return icon;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.feedbackTimerActive = false;
        this.wasOn = false;
        this.cycleCounts = new int[10];
    }

    public BLeadLagCycles() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$kitControl$hvac$BLeadLagCycles;
        if (clazz == null) {
            clazz = class$com$tridium$kitControl$hvac$BLeadLagCycles = BLeadLagCycles.class("[Lcom.tridium.kitControl.hvac.BLeadLagCycles;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.std((String)"control/control.png");
    }
}

