/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.kitControl.energy;

import javax.baja.status.BStatusNumeric;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BTime;
import javax.baja.sys.BValue;
import javax.baja.sys.BWeekday;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.units.UnitDatabase;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BSlidingWindowDemandCalc
extends BComponent {
    public static final Property consumptionFacets = BSlidingWindowDemandCalc.newProperty((int)0, (BValue)BFacets.makeNumeric((BUnit)UnitDatabase.getUnit((String)"kilowatt hour"), (int)1), null);
    public static final Property demandFacets = BSlidingWindowDemandCalc.newProperty((int)0, (BValue)BFacets.makeNumeric((BUnit)UnitDatabase.getUnit((String)"kilowatt"), (int)1), null);
    public static final Property kwhPerPulseFacets = BSlidingWindowDemandCalc.newProperty((int)0, (BValue)BFacets.makeNumeric((BUnit)UnitDatabase.getUnit((String)"kilowatt hour"), (int)3), null);
    public static final Property currentPulseCount = BSlidingWindowDemandCalc.newProperty((int)2, (BValue)new BStatusNumeric(), null);
    public static final Property timeOfReset = BSlidingWindowDemandCalc.newProperty((int)1, (BValue)BAbsTime.NULL, null);
    public static final Property demand5 = BSlidingWindowDemandCalc.newProperty((int)1, (BValue)new BStatusNumeric(), null);
    public static final Property demand15 = BSlidingWindowDemandCalc.newProperty((int)1, (BValue)new BStatusNumeric(), null);
    public static final Property demand30 = BSlidingWindowDemandCalc.newProperty((int)1, (BValue)new BStatusNumeric(), null);
    public static final Property kwh = BSlidingWindowDemandCalc.newProperty((int)1, (BValue)new BStatusNumeric(), null);
    public static final Property kwhHourly = BSlidingWindowDemandCalc.newProperty((int)1, (BValue)new BStatusNumeric(), null);
    public static final Property kwhLastHour = BSlidingWindowDemandCalc.newProperty((int)1, (BValue)new BStatusNumeric(), null);
    public static final Property kwhDaily = BSlidingWindowDemandCalc.newProperty((int)1, (BValue)new BStatusNumeric(), null);
    public static final Property kwhLastDay = BSlidingWindowDemandCalc.newProperty((int)1, (BValue)new BStatusNumeric(), null);
    public static final Property kwhPerPulse = BSlidingWindowDemandCalc.newProperty((int)0, (double)1.0, null);
    public static final Property enableReset = BSlidingWindowDemandCalc.newProperty((int)0, (boolean)true, null);
    public static final Property resetDayOfMonth = BSlidingWindowDemandCalc.newProperty((int)0, (int)1, (BFacets)BFacets.makeInt((int)1, (int)31));
    public static final Property resetDayOfWeek = BSlidingWindowDemandCalc.newProperty((int)0, (BValue)BWeekday.sunday, null);
    public static final Property resetTime = BSlidingWindowDemandCalc.newProperty((int)0, (BValue)BTime.make((int)0, (int)0, (int)0), null);
    public static final Property meterRollover = BSlidingWindowDemandCalc.newProperty((int)0, (long)65535L, null);
    public static final Action calculate = BSlidingWindowDemandCalc.newAction((int)4, null);
    public static final Action hourUpdate = BSlidingWindowDemandCalc.newAction((int)4, null);
    public static final Action dayUpdate = BSlidingWindowDemandCalc.newAction((int)4, null);
    public static final Action resetMonthly = BSlidingWindowDemandCalc.newAction((int)0, null);
    public static final Action resetData = BSlidingWindowDemandCalc.newAction((int)0, null);
    public static final Type TYPE;
    private static int FIFTY_SECONDS;
    Clock.Ticket ticket;
    BAbsTime now;
    BAbsTime previousTime;
    boolean reset;
    boolean resetFlag;
    double diffSec;
    double kwhNew;
    int lastHour;
    int lastDay;
    boolean firstTime;
    int maxPulseDiff;
    double lastPulseCount;
    double pulseCountDiff;
    long lastCountChangeTicks;
    long countChangePeriod;
    boolean isSlowRate;
    static /* synthetic */ Class class$com$tridium$kitControl$energy$BSlidingWindowDemandCalc;

    public BFacets getConsumptionFacets() {
        return (BFacets)this.get(consumptionFacets);
    }

    public void setConsumptionFacets(BFacets bFacets) {
        this.set(consumptionFacets, (BValue)bFacets, null);
    }

    public BFacets getDemandFacets() {
        return (BFacets)this.get(demandFacets);
    }

    public void setDemandFacets(BFacets bFacets) {
        this.set(demandFacets, (BValue)bFacets, null);
    }

    public BFacets getKwhPerPulseFacets() {
        return (BFacets)this.get(kwhPerPulseFacets);
    }

    public void setKwhPerPulseFacets(BFacets bFacets) {
        this.set(kwhPerPulseFacets, (BValue)bFacets, null);
    }

    public BStatusNumeric getCurrentPulseCount() {
        return (BStatusNumeric)this.get(currentPulseCount);
    }

    public void setCurrentPulseCount(BStatusNumeric bStatusNumeric) {
        this.set(currentPulseCount, (BValue)bStatusNumeric, null);
    }

    public BAbsTime getTimeOfReset() {
        return (BAbsTime)this.get(timeOfReset);
    }

    public void setTimeOfReset(BAbsTime bAbsTime) {
        this.set(timeOfReset, (BValue)bAbsTime, null);
    }

    public BStatusNumeric getDemand5() {
        return (BStatusNumeric)this.get(demand5);
    }

    public void setDemand5(BStatusNumeric bStatusNumeric) {
        this.set(demand5, (BValue)bStatusNumeric, null);
    }

    public BStatusNumeric getDemand15() {
        return (BStatusNumeric)this.get(demand15);
    }

    public void setDemand15(BStatusNumeric bStatusNumeric) {
        this.set(demand15, (BValue)bStatusNumeric, null);
    }

    public BStatusNumeric getDemand30() {
        return (BStatusNumeric)this.get(demand30);
    }

    public void setDemand30(BStatusNumeric bStatusNumeric) {
        this.set(demand30, (BValue)bStatusNumeric, null);
    }

    public BStatusNumeric getKwh() {
        return (BStatusNumeric)this.get(kwh);
    }

    public void setKwh(BStatusNumeric bStatusNumeric) {
        this.set(kwh, (BValue)bStatusNumeric, null);
    }

    public BStatusNumeric getKwhHourly() {
        return (BStatusNumeric)this.get(kwhHourly);
    }

    public void setKwhHourly(BStatusNumeric bStatusNumeric) {
        this.set(kwhHourly, (BValue)bStatusNumeric, null);
    }

    public BStatusNumeric getKwhLastHour() {
        return (BStatusNumeric)this.get(kwhLastHour);
    }

    public void setKwhLastHour(BStatusNumeric bStatusNumeric) {
        this.set(kwhLastHour, (BValue)bStatusNumeric, null);
    }

    public BStatusNumeric getKwhDaily() {
        return (BStatusNumeric)this.get(kwhDaily);
    }

    public void setKwhDaily(BStatusNumeric bStatusNumeric) {
        this.set(kwhDaily, (BValue)bStatusNumeric, null);
    }

    public BStatusNumeric getKwhLastDay() {
        return (BStatusNumeric)this.get(kwhLastDay);
    }

    public void setKwhLastDay(BStatusNumeric bStatusNumeric) {
        this.set(kwhLastDay, (BValue)bStatusNumeric, null);
    }

    public double getKwhPerPulse() {
        return this.getDouble(kwhPerPulse);
    }

    public void setKwhPerPulse(double d) {
        this.setDouble(kwhPerPulse, d, null);
    }

    public boolean getEnableReset() {
        return this.getBoolean(enableReset);
    }

    public void setEnableReset(boolean bl) {
        this.setBoolean(enableReset, bl, null);
    }

    public int getResetDayOfMonth() {
        return this.getInt(resetDayOfMonth);
    }

    public void setResetDayOfMonth(int n) {
        this.setInt(resetDayOfMonth, n, null);
    }

    public BWeekday getResetDayOfWeek() {
        return (BWeekday)this.get(resetDayOfWeek);
    }

    public void setResetDayOfWeek(BWeekday bWeekday) {
        this.set(resetDayOfWeek, (BValue)bWeekday, null);
    }

    public BTime getResetTime() {
        return (BTime)this.get(resetTime);
    }

    public void setResetTime(BTime bTime) {
        this.set(resetTime, (BValue)bTime, null);
    }

    public long getMeterRollover() {
        return this.getLong(meterRollover);
    }

    public void setMeterRollover(long l) {
        this.setLong(meterRollover, l, null);
    }

    public void calculate() {
        this.invoke(calculate, null, null);
    }

    public void hourUpdate() {
        this.invoke(hourUpdate, null, null);
    }

    public void dayUpdate() {
        this.invoke(dayUpdate, null, null);
    }

    public void resetMonthly() {
        this.invoke(resetMonthly, null, null);
    }

    public void resetData() {
        this.invoke(resetData, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        if (this.ticket != null) {
            this.ticket.cancel();
        }
        this.ticket = Clock.schedulePeriodically((BComponent)this, (BRelTime)BRelTime.makeMinutes((int)1), (Action)calculate, null);
        super.started();
    }

    public void stopped() throws Exception {
        if (this.ticket != null) {
            this.ticket.cancel();
        }
        super.stopped();
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
    }

    public BFacets getSlotFacets(Slot slot) {
        if (slot.equals((Object)kwh) || slot.equals((Object)kwhDaily) || slot.equals((Object)kwhHourly) || slot.equals((Object)kwhLastDay) || slot.equals((Object)kwhLastHour)) {
            return this.getConsumptionFacets();
        }
        if (slot.equals((Object)demand5) || slot.equals((Object)demand15) || slot.equals((Object)demand30)) {
            return this.getDemandFacets();
        }
        if (slot.equals((Object)kwhPerPulse)) {
            return this.getKwhPerPulseFacets();
        }
        return super.getSlotFacets(slot);
    }

    public void doHourUpdate() {
    }

    public void doDayUpdate() {
    }

    public void doResetData() {
        if (this.now == null) {
            return;
        }
        this.getKwh().setValue(0.0);
        this.getKwhHourly().setValue(0.0);
        this.getKwhLastHour().setValue(0.0);
        this.getKwhDaily().setValue(0.0);
        this.getKwhLastDay().setValue(0.0);
        this.getDemand5().setValue(0.0);
        this.getDemand15().setValue(0.0);
        this.getDemand30().setValue(0.0);
        this.previousTime = this.now;
        this.lastHour = this.now.getHour();
        this.lastDay = this.now.getDay();
        this.resetFlag = true;
        this.setTimeOfReset(Clock.time());
    }

    public void setDataFaultStatus(boolean bl) {
        this.getKwh().setStatusFault(bl);
        this.getKwhHourly().setStatusFault(bl);
        this.getKwhLastHour().setStatusFault(bl);
        this.getKwhDaily().setStatusFault(bl);
        this.getKwhLastDay().setStatusFault(bl);
        this.getDemand5().setStatusFault(bl);
        this.getDemand15().setStatusFault(bl);
        this.getDemand30().setStatusFault(bl);
    }

    public void doResetMonthly() {
        if (this.now == null) {
            return;
        }
        this.getKwh().setValue(0.0);
        this.getKwhHourly().setValue(0.0);
        this.getKwhLastHour().setValue(0.0);
        this.getKwhDaily().setValue(0.0);
        this.getKwhLastDay().setValue(0.0);
        this.previousTime = this.now;
        this.lastHour = this.now.getHour();
        this.lastDay = this.now.getDay();
        this.resetFlag = true;
        this.setTimeOfReset(Clock.time());
    }

    public void doPulseCalculate() {
        if (this.getCurrentPulseCount().getValue() == this.lastPulseCount) {
            return;
        }
        if (!this.getCurrentPulseCount().getStatus().isValid() || Double.isNaN(this.getCurrentPulseCount().getValue())) {
            return;
        }
        long l = Clock.millis();
        this.countChangePeriod = l - this.lastCountChangeTicks;
        if (this.countChangePeriod < (long)FIFTY_SECONDS) {
            this.isSlowRate = false;
            this.lastCountChangeTicks = l;
            this.doCalculate();
        } else {
            this.isSlowRate = true;
            this.lastCountChangeTicks = l;
        }
    }

    public void doCalculate() {
        int n;
        int n2;
        this.now = Clock.time();
        if (this.firstTime) {
            this.lastPulseCount = this.getCurrentPulseCount().getValue();
            if (!this.getCurrentPulseCount().getStatus().isValid() || Double.isNaN(this.getCurrentPulseCount().getValue())) {
                this.setDataFaultStatus(true);
                return;
            }
            this.setDataFaultStatus(false);
            this.lastCountChangeTicks = this.now.getMillis();
            this.previousTime = this.now;
            this.setTimeOfReset(this.now);
            this.lastHour = this.now.getHour();
            this.lastDay = this.now.getDay();
            this.firstTime = false;
            return;
        }
        if (!this.reset && (n2 = this.now.getDay()) >= (n = this.getResetDayOfMonth()) && n < n + 7 && this.now.getWeekday().equals((Object)this.getResetDayOfWeek()) && this.now.getTimeOfDayMillis() >= this.getResetTime().getTimeOfDayMillis()) {
            this.reset = true;
            this.setTimeOfReset(Clock.time());
        }
        if (this.reset && !this.now.getWeekday().equals((Object)this.getResetDayOfWeek())) {
            this.reset = false;
        }
        if (this.getEnableReset() && this.reset && !this.resetFlag) {
            this.getKwh().setValue(0.0);
            this.getKwhHourly().setValue(0.0);
            this.getKwhLastHour().setValue(0.0);
            this.getKwhDaily().setValue(0.0);
            this.getKwhLastDay().setValue(0.0);
            this.previousTime = this.now;
            this.lastHour = this.now.getHour();
            this.lastDay = this.now.getDay();
            this.resetFlag = true;
        }
        if (!this.reset) {
            this.resetFlag = false;
        }
        this.diffSec = (double)this.previousTime.delta(this.now).getMillis() / 1000.0;
        this.previousTime = this.now;
        this.maxPulseDiff = (int)(this.diffSec * 10.0);
        double d = this.getCurrentPulseCount().getValue();
        if (!this.getCurrentPulseCount().getStatus().isValid() || Double.isNaN(this.getCurrentPulseCount().getValue())) {
            this.setDataFaultStatus(true);
            return;
        }
        this.setDataFaultStatus(false);
        this.pulseCountDiff = d >= this.lastPulseCount ? d - this.lastPulseCount : (double)this.getMeterRollover() + 1.0 + d - this.lastPulseCount;
        if (this.pulseCountDiff > (double)this.maxPulseDiff || this.pulseCountDiff < 0.0) {
            this.lastPulseCount = d;
            return;
        }
        if (this.pulseCountDiff > 0.0 && this.isSlowRate) {
            this.diffSec = (double)this.countChangePeriod / 1000.0;
        }
        this.kwhNew = this.pulseCountDiff * this.getKwhPerPulse();
        this.getKwh().setValue(this.getKwh().getValue() + this.kwhNew);
        this.lastPulseCount = d;
        if (this.lastHour != this.now.getHour()) {
            this.lastHour = this.now.getHour();
            this.getKwhLastHour().setValue(this.getKwhHourly().getValue());
            this.hourUpdate();
            this.getKwhHourly().setValue(this.kwhNew);
        } else {
            this.getKwhHourly().setValue(this.getKwhHourly().getValue() + this.kwhNew);
        }
        if (this.lastDay != this.now.getDay()) {
            this.lastDay = this.now.getDay();
            this.getKwhLastDay().setValue(this.getKwhDaily().getValue());
            this.dayUpdate();
            this.getKwhDaily().setValue(this.kwhNew);
        } else {
            this.getKwhDaily().setValue(this.getKwhDaily().getValue() + this.kwhNew);
        }
        double d2 = (1.0 - this.diffSec * 0.00751) * this.getDemand5().getValue();
        this.getDemand5().setValue(this.pulseCountDiff * this.getKwhPerPulse() * 0.00751 * 3600.0 + d2);
        d2 = (1.0 - this.diffSec * 0.002535) * this.getDemand15().getValue();
        this.getDemand15().setValue(this.pulseCountDiff * this.getKwhPerPulse() * 0.002535 * 3600.0 + d2);
        d2 = (1.0 - this.diffSec * 0.001278) * this.getDemand30().getValue();
        this.getDemand30().setValue(this.pulseCountDiff * this.getKwhPerPulse() * 0.001278 * 3600.0 + d2);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.ticket = null;
        this.reset = false;
        this.resetFlag = false;
        this.firstTime = true;
        this.lastCountChangeTicks = 0L;
        this.countChangePeriod = 0L;
        this.isSlowRate = false;
    }

    public BSlidingWindowDemandCalc() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$kitControl$energy$BSlidingWindowDemandCalc;
        if (clazz == null) {
            clazz = class$com$tridium$kitControl$energy$BSlidingWindowDemandCalc = BSlidingWindowDemandCalc.class("[Lcom.tridium.kitControl.energy.BSlidingWindowDemandCalc;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        FIFTY_SECONDS = 50000;
    }
}

