/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.kitControl.energy;

import com.tridium.kitControl.enums.BOutsideAirOptimizationMode;
import com.tridium.kitControl.hvac.Psychrometric;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.units.UnitDatabase;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BOutsideAirOptimization
extends BComponent {
    public static final Property temperatureFacets = BOutsideAirOptimization.newProperty((int)0, (BValue)BFacets.makeNumeric((BUnit)UnitDatabase.getUnit((String)"fahrenheit"), (int)1), null);
    public static final Property humidityFacets = BOutsideAirOptimization.newProperty((int)0, (BValue)BFacets.makeNumeric((BUnit)UnitDatabase.getUnit((String)"percent relative humidity"), (int)1), null);
    public static final Property outsideTemp = BOutsideAirOptimization.newProperty((int)8, (BValue)new BStatusNumeric(), null);
    public static final Property outsideHumidity = BOutsideAirOptimization.newProperty((int)8, (BValue)new BStatusNumeric(), null);
    public static final Property insideTemp = BOutsideAirOptimization.newProperty((int)8, (BValue)new BStatusNumeric(), null);
    public static final Property insideHumidity = BOutsideAirOptimization.newProperty((int)8, (BValue)new BStatusNumeric(), null);
    public static final Property lowTemperatureLimit = BOutsideAirOptimization.newProperty((int)8, (BValue)new BStatusNumeric(), null);
    public static final Property outsideEnthalpy = BOutsideAirOptimization.newProperty((int)10, (BValue)new BStatusNumeric(), null);
    public static final Property outsideEnthalpyString = BOutsideAirOptimization.newProperty((int)10, (BValue)new BStatusString(""), null);
    public static final Property insideEnthalpy = BOutsideAirOptimization.newProperty((int)10, (BValue)new BStatusNumeric(), null);
    public static final Property insideEnthalpyString = BOutsideAirOptimization.newProperty((int)10, (BValue)new BStatusString(""), null);
    public static final Property freeCooling = BOutsideAirOptimization.newProperty((int)10, (BValue)new BStatusBoolean(), null);
    public static final Property currentMode = BOutsideAirOptimization.newProperty((int)11, (BValue)new BStatusEnum((BEnum)BOutsideAirOptimizationMode.noFreeCooling), null);
    public static final Property thresholdSpan = BOutsideAirOptimization.newProperty((int)0, (float)1.0f, null);
    public static final Property useEnthalpy = BOutsideAirOptimization.newProperty((int)0, (boolean)true, null);
    public static final Property freeCoolingCommand = BOutsideAirOptimization.newProperty((int)0, (boolean)true, null);
    public static final Property useNullOutput = BOutsideAirOptimization.newProperty((int)0, (boolean)true, null);
    public static final Action calculate = BOutsideAirOptimization.newAction((int)0, null);
    public static final Type TYPE;
    static String engUnits;
    static String OUT_OF_RANGE;
    static String UNUSED;
    boolean lowTemp;
    static /* synthetic */ Class class$com$tridium$kitControl$energy$BOutsideAirOptimization;

    public BFacets getTemperatureFacets() {
        return (BFacets)this.get(temperatureFacets);
    }

    public void setTemperatureFacets(BFacets bFacets) {
        this.set(temperatureFacets, (BValue)bFacets, null);
    }

    public BFacets getHumidityFacets() {
        return (BFacets)this.get(humidityFacets);
    }

    public void setHumidityFacets(BFacets bFacets) {
        this.set(humidityFacets, (BValue)bFacets, null);
    }

    public BStatusNumeric getOutsideTemp() {
        return (BStatusNumeric)this.get(outsideTemp);
    }

    public void setOutsideTemp(BStatusNumeric bStatusNumeric) {
        this.set(outsideTemp, (BValue)bStatusNumeric, null);
    }

    public BStatusNumeric getOutsideHumidity() {
        return (BStatusNumeric)this.get(outsideHumidity);
    }

    public void setOutsideHumidity(BStatusNumeric bStatusNumeric) {
        this.set(outsideHumidity, (BValue)bStatusNumeric, null);
    }

    public BStatusNumeric getInsideTemp() {
        return (BStatusNumeric)this.get(insideTemp);
    }

    public void setInsideTemp(BStatusNumeric bStatusNumeric) {
        this.set(insideTemp, (BValue)bStatusNumeric, null);
    }

    public BStatusNumeric getInsideHumidity() {
        return (BStatusNumeric)this.get(insideHumidity);
    }

    public void setInsideHumidity(BStatusNumeric bStatusNumeric) {
        this.set(insideHumidity, (BValue)bStatusNumeric, null);
    }

    public BStatusNumeric getLowTemperatureLimit() {
        return (BStatusNumeric)this.get(lowTemperatureLimit);
    }

    public void setLowTemperatureLimit(BStatusNumeric bStatusNumeric) {
        this.set(lowTemperatureLimit, (BValue)bStatusNumeric, null);
    }

    public BStatusNumeric getOutsideEnthalpy() {
        return (BStatusNumeric)this.get(outsideEnthalpy);
    }

    public void setOutsideEnthalpy(BStatusNumeric bStatusNumeric) {
        this.set(outsideEnthalpy, (BValue)bStatusNumeric, null);
    }

    public BStatusString getOutsideEnthalpyString() {
        return (BStatusString)this.get(outsideEnthalpyString);
    }

    public void setOutsideEnthalpyString(BStatusString bStatusString) {
        this.set(outsideEnthalpyString, (BValue)bStatusString, null);
    }

    public BStatusNumeric getInsideEnthalpy() {
        return (BStatusNumeric)this.get(insideEnthalpy);
    }

    public void setInsideEnthalpy(BStatusNumeric bStatusNumeric) {
        this.set(insideEnthalpy, (BValue)bStatusNumeric, null);
    }

    public BStatusString getInsideEnthalpyString() {
        return (BStatusString)this.get(insideEnthalpyString);
    }

    public void setInsideEnthalpyString(BStatusString bStatusString) {
        this.set(insideEnthalpyString, (BValue)bStatusString, null);
    }

    public BStatusBoolean getFreeCooling() {
        return (BStatusBoolean)this.get(freeCooling);
    }

    public void setFreeCooling(BStatusBoolean bStatusBoolean) {
        this.set(freeCooling, (BValue)bStatusBoolean, null);
    }

    public BStatusEnum getCurrentMode() {
        return (BStatusEnum)this.get(currentMode);
    }

    public void setCurrentMode(BStatusEnum bStatusEnum) {
        this.set(currentMode, (BValue)bStatusEnum, null);
    }

    public float getThresholdSpan() {
        return this.getFloat(thresholdSpan);
    }

    public void setThresholdSpan(float f) {
        this.setFloat(thresholdSpan, f, null);
    }

    public boolean getUseEnthalpy() {
        return this.getBoolean(useEnthalpy);
    }

    public void setUseEnthalpy(boolean bl) {
        this.setBoolean(useEnthalpy, bl, null);
    }

    public boolean getFreeCoolingCommand() {
        return this.getBoolean(freeCoolingCommand);
    }

    public void setFreeCoolingCommand(boolean bl) {
        this.setBoolean(freeCoolingCommand, bl, null);
    }

    public boolean getUseNullOutput() {
        return this.getBoolean(useNullOutput);
    }

    public void setUseNullOutput(boolean bl) {
        this.setBoolean(useNullOutput, bl, null);
    }

    public void calculate() {
        this.invoke(calculate, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
    }

    public void stopped() throws Exception {
        super.stopped();
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!Sys.atSteadyState() || !this.isRunning()) {
            return;
        }
        if (property.equals((Object)outsideTemp) || property.equals((Object)outsideHumidity) || property.equals((Object)insideTemp) || property.equals((Object)insideHumidity) || property.equals((Object)thresholdSpan) || property.equals((Object)freeCoolingCommand) || property.equals((Object)useEnthalpy)) {
            this.doCalculate();
        }
    }

    public BFacets getSlotFacets(Slot slot) {
        if (slot.equals((Object)insideTemp) || slot.equals((Object)outsideTemp) || slot.equals((Object)lowTemperatureLimit)) {
            return this.getTemperatureFacets();
        }
        if (slot.equals((Object)insideHumidity) || slot.equals((Object)outsideHumidity)) {
            return this.getHumidityFacets();
        }
        return super.getSlotFacets(slot);
    }

    public void atSteadyState() {
        this.doCalculate();
    }

    public void doCalculate() {
        if (!(this.getOutsideTemp().getStatus().isValid() && this.getOutsideHumidity().getStatus().isValid() && this.getInsideTemp().getStatus().isValid() && this.getInsideHumidity().getStatus().isValid())) {
            this.getCurrentMode().setValue((BEnum)BOutsideAirOptimizationMode.inputError);
            return;
        }
        if (this.getOutsideTemp().getValue() < this.getLowTemperatureLimit().getValue()) {
            this.setOutput(false);
            this.getCurrentMode().setValue((BEnum)BOutsideAirOptimizationMode.lowTemperature);
            this.lowTemp = true;
            return;
        }
        if (this.getUseEnthalpy()) {
            this.getOutsideEnthalpy().setValue((double)Psychrometric.enthalpy((float)this.getOutsideTemp().getValue(), (float)this.getOutsideHumidity().getValue()));
            this.getInsideEnthalpy().setValue((double)Psychrometric.enthalpy((float)this.getInsideTemp().getValue(), (float)this.getInsideHumidity().getValue()));
            if (this.getOutsideEnthalpy().getValue() > 0.0) {
                this.getOutsideEnthalpyString().setValue((int)this.getOutsideEnthalpy().getValue() + engUnits);
            } else {
                this.getOutsideEnthalpyString().setValue(OUT_OF_RANGE);
            }
            if (this.getInsideEnthalpy().getValue() > 0.0) {
                this.getInsideEnthalpyString().setValue((int)this.getInsideEnthalpy().getValue() + engUnits);
            } else {
                this.getInsideEnthalpyString().setValue(OUT_OF_RANGE);
            }
            if (this.getOutsideEnthalpy().getValue() >= this.getInsideEnthalpy().getValue()) {
                this.setOutput(false);
                this.getCurrentMode().setValue((BEnum)BOutsideAirOptimizationMode.noFreeCooling);
            } else if (this.getOutsideEnthalpy().getValue() <= this.getInsideEnthalpy().getValue() - Math.abs((double)this.getThresholdSpan())) {
                this.setOutput(true);
                this.getCurrentMode().setValue((BEnum)BOutsideAirOptimizationMode.freeCooling);
            }
        } else {
            this.getOutsideEnthalpy().setValue(0.0);
            this.getInsideEnthalpy().setValue(0.0);
            this.getOutsideEnthalpyString().setValue(UNUSED);
            this.getInsideEnthalpyString().setValue(UNUSED);
            if (this.getOutsideTemp().getValue() >= this.getInsideTemp().getValue()) {
                this.setOutput(false);
                this.getCurrentMode().setValue((BEnum)BOutsideAirOptimizationMode.noFreeCooling);
            } else if (this.getOutsideTemp().getValue() <= this.getInsideTemp().getValue() - Math.abs((double)this.getThresholdSpan())) {
                this.setOutput(true);
                this.getCurrentMode().setValue((BEnum)BOutsideAirOptimizationMode.freeCooling);
            }
        }
    }

    private final void setOutput(boolean bl) {
        if (bl) {
            this.setFreeCooling(new BStatusBoolean(this.getFreeCoolingCommand(), BStatus.ok));
        } else if (this.getUseNullOutput()) {
            this.setFreeCooling(new BStatusBoolean(this.getFreeCoolingCommand() ^ true, BStatus.nullStatus));
        } else {
            this.setFreeCooling(new BStatusBoolean(this.getFreeCoolingCommand() ^ true, BStatus.ok));
        }
    }

    private final BStatus getNoFreeCoolingStatus() {
        if (this.getUseNullOutput()) {
            return BStatus.nullStatus;
        }
        return BStatus.ok;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.lowTemp = false;
    }

    public BOutsideAirOptimization() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$kitControl$energy$BOutsideAirOptimization;
        if (clazz == null) {
            clazz = class$com$tridium$kitControl$energy$BOutsideAirOptimization = BOutsideAirOptimization.class("[Lcom.tridium.kitControl.energy.BOutsideAirOptimization;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        engUnits = " BTU/lb";
        OUT_OF_RANGE = "Input out of range";
        UNUSED = "Unused";
    }
}

