/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.kitControl.energy;

import java.text.DecimalFormat;
import javax.baja.log.Log;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BOptimizedStartStop
extends BComponent {
    public static final Property heatCoolMode = BOptimizedStartStop.newProperty((int)10, (BValue)new BStatusBoolean(false), (BFacets)BFacets.makeBoolean((String)"coolMode", (String)"heatMode"));
    public static final Property parameterResetTime = BOptimizedStartStop.newProperty((int)10, (BValue)BAbsTime.NULL, null);
    public static final Property startEnable = BOptimizedStartStop.newProperty((int)8, (BValue)new BStatusBoolean(false), null);
    public static final Property stopEnable = BOptimizedStartStop.newProperty((int)8, (BValue)new BStatusBoolean(false), null);
    public static final Property scheduleStatus = BOptimizedStartStop.newProperty((int)10, (BValue)new BStatusBoolean(false), null);
    public static final Property nextEventTime = BOptimizedStartStop.newProperty((int)10, (BValue)BAbsTime.NULL, null);
    public static final Property nextEventValue = BOptimizedStartStop.newProperty((int)10, (BValue)new BStatusBoolean(false), null);
    public static final Property outsideTemp = BOptimizedStartStop.newProperty((int)10, (BValue)new BStatusNumeric(), null);
    public static final Property spaceTemp = BOptimizedStartStop.newProperty((int)10, (BValue)new BStatusNumeric(), null);
    public static final Property startTimeCommand = BOptimizedStartStop.newProperty((int)74, (BValue)new BStatusBoolean(false, BStatus.nullStatus), null);
    public static final Property stopTimeCommand = BOptimizedStartStop.newProperty((int)74, (BValue)new BStatusBoolean(false, BStatus.nullStatus), null);
    public static final Property message = BOptimizedStartStop.newProperty((int)10, (BValue)new BStatusString(""), null);
    public static final Property upperComfortLimit = BOptimizedStartStop.newProperty((int)0, (float)77.0f, null);
    public static final Property lowerComfortLimit = BOptimizedStartStop.newProperty((int)0, (float)68.0f, null);
    public static final Property dynamicParameterAdjust = BOptimizedStartStop.newProperty((int)0, (boolean)true, null);
    public static final Property oldParameterMultiplier = BOptimizedStartStop.newProperty((int)0, (int)2, null);
    public static final Property earliestStartTime = BOptimizedStartStop.newProperty((int)0, (BValue)BTime.make((int)0, (int)0, (int)10), null);
    public static final Property earliestStopTime = BOptimizedStartStop.newProperty((int)0, (BValue)BTime.make((int)16, (int)0, (int)0), null);
    public static final Property drifttimePerDegreeCoolingUserDefined = BOptimizedStartStop.newProperty((int)0, (float)0.0f, null);
    public static final Property drifttimePerDegreeHeatingUserDefined = BOptimizedStartStop.newProperty((int)0, (float)0.0f, null);
    public static final Property runtimePerDegreeCoolingUserDefined = BOptimizedStartStop.newProperty((int)0, (float)0.0f, null);
    public static final Property runtimePerDegreeHeatingUserDefined = BOptimizedStartStop.newProperty((int)0, (float)0.0f, null);
    public static final Property drifttimePerDegreeCooling = BOptimizedStartStop.newProperty((int)0, (float)10.0f, null);
    public static final Property drifttimePerDegreeHeating = BOptimizedStartStop.newProperty((int)0, (float)10.0f, null);
    public static final Property runtimePerDegreeCooling = BOptimizedStartStop.newProperty((int)0, (float)10.0f, null);
    public static final Property runtimePerDegreeHeating = BOptimizedStartStop.newProperty((int)0, (float)10.0f, null);
    public static final Property lastStartTime = BOptimizedStartStop.newProperty((int)2, (BValue)BAbsTime.NULL, null);
    public static final Property lastStopTime = BOptimizedStartStop.newProperty((int)2, (BValue)BAbsTime.NULL, null);
    public static final Property outsideTempAtBeginning = BOptimizedStartStop.newProperty((int)2, (BValue)new BStatusNumeric(), null);
    public static final Property spaceTempAtBeginning = BOptimizedStartStop.newProperty((int)2, (BValue)new BStatusNumeric(), null);
    public static final Property calculatedCommandTime = BOptimizedStartStop.newProperty((int)66, (BValue)BTime.DEFAULT, null);
    public static final Property programMode = BOptimizedStartStop.newProperty((int)66, (int)0, null);
    public static final Action startTimeTrigger = BOptimizedStartStop.newAction((int)4, null);
    public static final Action stopTimeTrigger = BOptimizedStartStop.newAction((int)4, null);
    public static final Action calculate = BOptimizedStartStop.newAction((int)4, null);
    public static final Type TYPE;
    private static boolean ACTIVE;
    private static boolean INACTIVE;
    private static boolean START;
    private static boolean STOP;
    private static boolean DISABLED;
    private static boolean ENABLED;
    private static boolean COOLING;
    private static boolean HEATING;
    private static long TIME_00_01;
    private static int NO_CALCULATION;
    private static int START_CALCULATION;
    private static int START_IN_PROCESS;
    private static int STOP_CALCULATION;
    private static int STOP_IN_PROCESS;
    public static final Log ossLog;
    boolean controlModeAtBeginning;
    boolean startDone;
    boolean analysisComplete;
    float observedMinutesPerDegree;
    float spaceTempChange;
    int leadTime;
    int optimizedRuntimeMinutes;
    int lastProgramMode;
    BAbsTime now;
    BAbsTime lastResetTime;
    int lastMinute;
    Clock.Ticket ticket;
    static /* synthetic */ Class class$com$tridium$kitControl$energy$BOptimizedStartStop;

    public BStatusBoolean getHeatCoolMode() {
        return (BStatusBoolean)this.get(heatCoolMode);
    }

    public void setHeatCoolMode(BStatusBoolean bStatusBoolean) {
        this.set(heatCoolMode, (BValue)bStatusBoolean, null);
    }

    public BAbsTime getParameterResetTime() {
        return (BAbsTime)this.get(parameterResetTime);
    }

    public void setParameterResetTime(BAbsTime bAbsTime) {
        this.set(parameterResetTime, (BValue)bAbsTime, null);
    }

    public BStatusBoolean getStartEnable() {
        return (BStatusBoolean)this.get(startEnable);
    }

    public void setStartEnable(BStatusBoolean bStatusBoolean) {
        this.set(startEnable, (BValue)bStatusBoolean, null);
    }

    public BStatusBoolean getStopEnable() {
        return (BStatusBoolean)this.get(stopEnable);
    }

    public void setStopEnable(BStatusBoolean bStatusBoolean) {
        this.set(stopEnable, (BValue)bStatusBoolean, null);
    }

    public BStatusBoolean getScheduleStatus() {
        return (BStatusBoolean)this.get(scheduleStatus);
    }

    public void setScheduleStatus(BStatusBoolean bStatusBoolean) {
        this.set(scheduleStatus, (BValue)bStatusBoolean, null);
    }

    public BAbsTime getNextEventTime() {
        return (BAbsTime)this.get(nextEventTime);
    }

    public void setNextEventTime(BAbsTime bAbsTime) {
        this.set(nextEventTime, (BValue)bAbsTime, null);
    }

    public BStatusBoolean getNextEventValue() {
        return (BStatusBoolean)this.get(nextEventValue);
    }

    public void setNextEventValue(BStatusBoolean bStatusBoolean) {
        this.set(nextEventValue, (BValue)bStatusBoolean, null);
    }

    public BStatusNumeric getOutsideTemp() {
        return (BStatusNumeric)this.get(outsideTemp);
    }

    public void setOutsideTemp(BStatusNumeric bStatusNumeric) {
        this.set(outsideTemp, (BValue)bStatusNumeric, null);
    }

    public BStatusNumeric getSpaceTemp() {
        return (BStatusNumeric)this.get(spaceTemp);
    }

    public void setSpaceTemp(BStatusNumeric bStatusNumeric) {
        this.set(spaceTemp, (BValue)bStatusNumeric, null);
    }

    public BStatusBoolean getStartTimeCommand() {
        return (BStatusBoolean)this.get(startTimeCommand);
    }

    public void setStartTimeCommand(BStatusBoolean bStatusBoolean) {
        this.set(startTimeCommand, (BValue)bStatusBoolean, null);
    }

    public BStatusBoolean getStopTimeCommand() {
        return (BStatusBoolean)this.get(stopTimeCommand);
    }

    public void setStopTimeCommand(BStatusBoolean bStatusBoolean) {
        this.set(stopTimeCommand, (BValue)bStatusBoolean, null);
    }

    public BStatusString getMessage() {
        return (BStatusString)this.get(message);
    }

    public void setMessage(BStatusString bStatusString) {
        this.set(message, (BValue)bStatusString, null);
    }

    public float getUpperComfortLimit() {
        return this.getFloat(upperComfortLimit);
    }

    public void setUpperComfortLimit(float f) {
        this.setFloat(upperComfortLimit, f, null);
    }

    public float getLowerComfortLimit() {
        return this.getFloat(lowerComfortLimit);
    }

    public void setLowerComfortLimit(float f) {
        this.setFloat(lowerComfortLimit, f, null);
    }

    public boolean getDynamicParameterAdjust() {
        return this.getBoolean(dynamicParameterAdjust);
    }

    public void setDynamicParameterAdjust(boolean bl) {
        this.setBoolean(dynamicParameterAdjust, bl, null);
    }

    public int getOldParameterMultiplier() {
        return this.getInt(oldParameterMultiplier);
    }

    public void setOldParameterMultiplier(int n) {
        this.setInt(oldParameterMultiplier, n, null);
    }

    public BTime getEarliestStartTime() {
        return (BTime)this.get(earliestStartTime);
    }

    public void setEarliestStartTime(BTime bTime) {
        this.set(earliestStartTime, (BValue)bTime, null);
    }

    public BTime getEarliestStopTime() {
        return (BTime)this.get(earliestStopTime);
    }

    public void setEarliestStopTime(BTime bTime) {
        this.set(earliestStopTime, (BValue)bTime, null);
    }

    public float getDrifttimePerDegreeCoolingUserDefined() {
        return this.getFloat(drifttimePerDegreeCoolingUserDefined);
    }

    public void setDrifttimePerDegreeCoolingUserDefined(float f) {
        this.setFloat(drifttimePerDegreeCoolingUserDefined, f, null);
    }

    public float getDrifttimePerDegreeHeatingUserDefined() {
        return this.getFloat(drifttimePerDegreeHeatingUserDefined);
    }

    public void setDrifttimePerDegreeHeatingUserDefined(float f) {
        this.setFloat(drifttimePerDegreeHeatingUserDefined, f, null);
    }

    public float getRuntimePerDegreeCoolingUserDefined() {
        return this.getFloat(runtimePerDegreeCoolingUserDefined);
    }

    public void setRuntimePerDegreeCoolingUserDefined(float f) {
        this.setFloat(runtimePerDegreeCoolingUserDefined, f, null);
    }

    public float getRuntimePerDegreeHeatingUserDefined() {
        return this.getFloat(runtimePerDegreeHeatingUserDefined);
    }

    public void setRuntimePerDegreeHeatingUserDefined(float f) {
        this.setFloat(runtimePerDegreeHeatingUserDefined, f, null);
    }

    public float getDrifttimePerDegreeCooling() {
        return this.getFloat(drifttimePerDegreeCooling);
    }

    public void setDrifttimePerDegreeCooling(float f) {
        this.setFloat(drifttimePerDegreeCooling, f, null);
    }

    public float getDrifttimePerDegreeHeating() {
        return this.getFloat(drifttimePerDegreeHeating);
    }

    public void setDrifttimePerDegreeHeating(float f) {
        this.setFloat(drifttimePerDegreeHeating, f, null);
    }

    public float getRuntimePerDegreeCooling() {
        return this.getFloat(runtimePerDegreeCooling);
    }

    public void setRuntimePerDegreeCooling(float f) {
        this.setFloat(runtimePerDegreeCooling, f, null);
    }

    public float getRuntimePerDegreeHeating() {
        return this.getFloat(runtimePerDegreeHeating);
    }

    public void setRuntimePerDegreeHeating(float f) {
        this.setFloat(runtimePerDegreeHeating, f, null);
    }

    public BAbsTime getLastStartTime() {
        return (BAbsTime)this.get(lastStartTime);
    }

    public void setLastStartTime(BAbsTime bAbsTime) {
        this.set(lastStartTime, (BValue)bAbsTime, null);
    }

    public BAbsTime getLastStopTime() {
        return (BAbsTime)this.get(lastStopTime);
    }

    public void setLastStopTime(BAbsTime bAbsTime) {
        this.set(lastStopTime, (BValue)bAbsTime, null);
    }

    public BStatusNumeric getOutsideTempAtBeginning() {
        return (BStatusNumeric)this.get(outsideTempAtBeginning);
    }

    public void setOutsideTempAtBeginning(BStatusNumeric bStatusNumeric) {
        this.set(outsideTempAtBeginning, (BValue)bStatusNumeric, null);
    }

    public BStatusNumeric getSpaceTempAtBeginning() {
        return (BStatusNumeric)this.get(spaceTempAtBeginning);
    }

    public void setSpaceTempAtBeginning(BStatusNumeric bStatusNumeric) {
        this.set(spaceTempAtBeginning, (BValue)bStatusNumeric, null);
    }

    public BTime getCalculatedCommandTime() {
        return (BTime)this.get(calculatedCommandTime);
    }

    public void setCalculatedCommandTime(BTime bTime) {
        this.set(calculatedCommandTime, (BValue)bTime, null);
    }

    public int getProgramMode() {
        return this.getInt(programMode);
    }

    public void setProgramMode(int n) {
        this.setInt(programMode, n, null);
    }

    public void startTimeTrigger() {
        this.invoke(startTimeTrigger, null, null);
    }

    public void stopTimeTrigger() {
        this.invoke(stopTimeTrigger, null, null);
    }

    public void calculate() {
        this.invoke(calculate, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        this.initClockTicket();
        super.started();
        if (!Sys.atSteadyState()) {
            return;
        }
    }

    public void stopped() throws Exception {
        if (this.ticket != null) {
            this.ticket.cancel();
        }
        super.stopped();
    }

    public void clockChanged(BRelTime bRelTime) {
        this.initClockTicket();
    }

    private final void initClockTicket() {
        if (this.ticket != null) {
            this.ticket.cancel();
        }
        BAbsTime bAbsTime = Clock.nextTopOfMinute().add(BRelTime.makeSeconds((int)15));
        this.ticket = Clock.schedulePeriodically((BComponent)this, (BAbsTime)bAbsTime, (BRelTime)BRelTime.makeMinutes((int)1), (Action)calculate, null);
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!Sys.atSteadyState() || !this.isRunning()) {
            return;
        }
        boolean bl = false;
        if (property.equals((Object)drifttimePerDegreeCoolingUserDefined)) {
            this.setDrifttimePerDegreeCooling(this.getDrifttimePerDegreeCoolingUserDefined());
            bl = true;
        } else if (property.equals((Object)drifttimePerDegreeHeatingUserDefined)) {
            this.setDrifttimePerDegreeHeating(this.getDrifttimePerDegreeHeatingUserDefined());
            bl = true;
        } else if (property.equals((Object)runtimePerDegreeCoolingUserDefined)) {
            this.setRuntimePerDegreeCooling(this.getRuntimePerDegreeCoolingUserDefined());
            bl = true;
        } else if (property.equals((Object)runtimePerDegreeHeatingUserDefined)) {
            this.setRuntimePerDegreeHeating(this.getRuntimePerDegreeHeatingUserDefined());
            bl = true;
        }
        if (bl) {
            this.setParameterResetTime(Clock.time());
        }
    }

    public BFacets getSlotFacets(Slot slot) {
        return super.getSlotFacets(slot);
    }

    public void doStopTimeTrigger() {
    }

    public void doStartTimeTrigger() {
    }

    private final String formatNumeric(double d, String string) {
        DecimalFormat decimalFormat = new DecimalFormat(string);
        return decimalFormat.format(d);
    }

    public void doCalculate() {
        this.now = Clock.time();
        if (this.getStartEnable().getValue() == DISABLED || this.now.getTimeOfDayMillis() < TIME_00_01) {
            this.startDone = false;
        }
        this.performStartStopAnalysis();
        this.performStartStopCalculation();
        this.performStartStopControl();
        this.updateControlOutput();
        this.lastProgramMode = this.getProgramMode();
    }

    private final void performStartStopCalculation() {
        if (this.getNextEventTime().getDayOfYear() != this.now.getDayOfYear()) {
            this.setProgramMode(NO_CALCULATION);
            return;
        }
        if (this.getNextEventValue().getValue() == ACTIVE) {
            this.performStartCalculation();
        } else {
            this.performStopCalculation();
        }
    }

    private final void performStartCalculation() {
        if (this.getStartEnable().getValue() != ENABLED || this.getScheduleStatus().getValue() == ACTIVE) {
            this.setProgramMode(NO_CALCULATION);
            return;
        }
        if (!this.startDone && this.getSpaceTemp().getStatus().isValid()) {
            if (this.getProgramMode() != START_IN_PROCESS) {
                this.setProgramMode(START_CALCULATION);
                this.leadTime = this.getSpaceTemp().getValue() > (double)this.getUpperComfortLimit() ? 1 + (int)((this.getSpaceTemp().getValue() - (double)this.getUpperComfortLimit()) * (double)this.getRuntimePerDegreeCooling()) : (this.getSpaceTemp().getValue() < (double)this.getLowerComfortLimit() ? 1 + (int)(((double)this.getLowerComfortLimit() - this.getSpaceTemp().getValue()) * (double)this.getRuntimePerDegreeHeating()) : 0);
            }
        } else {
            this.leadTime = 0;
        }
        ossLog.trace(this.getParent().getName() + '.' + this.getName() + "::oss start lead time = " + this.leadTime);
    }

    private final void performStopCalculation() {
        if (this.getStopEnable().getValue() != ENABLED || this.getScheduleStatus().getValue() == INACTIVE) {
            this.setProgramMode(NO_CALCULATION);
            return;
        }
        if (!this.getSpaceTemp().getStatus().isValid() || this.getProgramMode() == STOP_IN_PROCESS) {
            this.leadTime = 0;
            return;
        }
        this.setProgramMode(STOP_CALCULATION);
        if (this.getSpaceTemp().getValue() > (double)this.getLowerComfortLimit()) {
            this.controlModeAtBeginning = this.getHeatCoolMode().getValue();
            this.leadTime = this.getHeatCoolMode().getValue() == HEATING ? (int)((this.getSpaceTemp().getValue() - (double)this.getLowerComfortLimit()) * (double)this.getDrifttimePerDegreeHeating()) : (int)(((double)this.getUpperComfortLimit() - this.getSpaceTemp().getValue()) * (double)this.getDrifttimePerDegreeCooling());
        }
        ossLog.trace(this.getName() + "::oss stop lead time = " + this.leadTime);
    }

    private final void performStartStopControl() {
        BTime bTime;
        if (this.getProgramMode() != START_CALCULATION && this.getProgramMode() != STOP_CALCULATION) {
            this.setCalculatedCommandTime(BTime.make((BAbsTime)this.getNextEventTime()));
            return;
        }
        long l = this.getNextEventTime().getTimeOfDayMillis() - (long)this.leadTime * TIME_00_01;
        if (l < this.getEarliestStartTime().getTimeOfDayMillis()) {
            l = this.getEarliestStartTime().getTimeOfDayMillis();
        }
        this.setCalculatedCommandTime(BTime.make((BRelTime)BRelTime.make((long)l)));
        if (this.getProgramMode() == STOP_CALCULATION && this.getCalculatedCommandTime().isBefore(this.getEarliestStopTime())) {
            this.setCalculatedCommandTime(this.getEarliestStopTime());
        }
        if ((bTime = BTime.make((BAbsTime)Clock.time())).isAfter(this.getCalculatedCommandTime()) || bTime.isAfter(BTime.make((BAbsTime)this.getNextEventTime()))) {
            if (this.getProgramMode() == START_CALCULATION) {
                this.startDone = true;
                this.setProgramMode(START_IN_PROCESS);
                this.setLastStartTime(Clock.time());
                this.getSpaceTempAtBeginning().setValue(this.getSpaceTemp().getValue());
                this.getOutsideTempAtBeginning().setValue(this.getOutsideTemp().getValue());
                this.startTimeTrigger();
                this.getMessage().setValue("Optimized start for " + this.getNextEventTime() + " schedule time.  Space temp is " + this.formatNumeric(this.getSpaceTemp().getValue(), "#0.0") + '.');
            } else {
                this.setProgramMode(STOP_IN_PROCESS);
                this.setLastStopTime(Clock.time());
                this.getSpaceTempAtBeginning().setValue(this.getSpaceTemp().getValue());
                this.getOutsideTempAtBeginning().setValue(this.getOutsideTemp().getValue());
                this.controlModeAtBeginning = this.getHeatCoolMode().getValue();
                this.stopTimeTrigger();
                this.getMessage().setValue("Optimized stop for " + this.getNextEventTime() + " schedule time.  Space temp is " + this.formatNumeric(this.getSpaceTemp().getValue(), "#0.0") + '.');
            }
        }
    }

    private final void updateControlOutput() {
        if (this.getProgramMode() == START_IN_PROCESS) {
            this.getStartTimeCommand().setValue(START);
            this.getStartTimeCommand().setStatusNull(false);
            this.getStopTimeCommand().setValue(STOP);
            this.getStopTimeCommand().setStatusNull(true);
        } else if (this.getProgramMode() == STOP_IN_PROCESS) {
            this.getStopTimeCommand().setValue(STOP);
            this.getStopTimeCommand().setStatusNull(false);
            this.getStartTimeCommand().setValue(STOP);
            this.getStartTimeCommand().setStatusNull(true);
        } else {
            this.getStopTimeCommand().setValue(STOP);
            this.getStopTimeCommand().setStatusNull(true);
            this.getStartTimeCommand().setValue(STOP);
            this.getStartTimeCommand().setStatusNull(true);
            this.analysisComplete = false;
        }
    }

    private final void performStartStopAnalysis() {
        if (!this.getDynamicParameterAdjust() || this.analysisComplete || !this.getSpaceTemp().getStatus().isValid()) {
            return;
        }
        if (this.lastProgramMode == START_IN_PROCESS) {
            this.handleStartAnalysis();
        } else if (this.lastProgramMode == STOP_IN_PROCESS) {
            this.handleStopAnalysis();
        }
    }

    private final void handleStartAnalysis() {
        if (this.isCoolingAnalysis()) {
            if (this.getSpaceTemp().getValue() < this.getSpaceTempAtBeginning().getValue() && (this.getSpaceTemp().getValue() <= (double)this.getUpperComfortLimit() || this.getScheduleStatus().getValue() == ACTIVE)) {
                this.spaceTempChange = (float)(this.getSpaceTempAtBeginning().getValue() - this.getSpaceTemp().getValue());
                this.optimizedRuntimeMinutes = this.getLastStartTime().delta(this.now).getMinutes();
                this.observedMinutesPerDegree = (float)this.optimizedRuntimeMinutes / this.spaceTempChange;
                this.setRuntimePerDegreeCooling((this.getRuntimePerDegreeCooling() * (float)this.getOldParameterMultiplier() + this.observedMinutesPerDegree) / (float)(this.getOldParameterMultiplier() + 1));
                this.analysisComplete = true;
                this.getMessage().setValue("Optimized start analysis done at " + this.now + ".  Space temp is " + this.formatNumeric(this.getSpaceTemp().getValue(), "#0.0") + '.');
            }
        } else if (this.getSpaceTemp().getValue() > this.getSpaceTempAtBeginning().getValue() && (this.getSpaceTemp().getValue() >= (double)this.getLowerComfortLimit() || this.getScheduleStatus().getValue() == ACTIVE)) {
            this.spaceTempChange = (float)(this.getSpaceTemp().getValue() - this.getSpaceTempAtBeginning().getValue());
            this.optimizedRuntimeMinutes = this.getLastStartTime().delta(this.now).getMinutes();
            this.observedMinutesPerDegree = (float)this.optimizedRuntimeMinutes / this.spaceTempChange;
            this.setRuntimePerDegreeHeating((this.getRuntimePerDegreeHeating() * (float)this.getOldParameterMultiplier() + this.observedMinutesPerDegree) / (float)(this.getOldParameterMultiplier() + 1));
            this.analysisComplete = true;
            this.getMessage().setValue("Optimized start analysis done at " + this.now + ".  Space temp is " + this.formatNumeric(this.getSpaceTemp().getValue(), "#0.0") + '.');
        }
    }

    private final boolean isCoolingAnalysis() {
        boolean bl = false;
        if (this.getSpaceTempAtBeginning().getValue() > (double)this.getUpperComfortLimit()) {
            bl = true;
        }
        return bl;
    }

    private final void handleStopAnalysis() {
        if (this.controlModeAtBeginning == HEATING) {
            if (this.getSpaceTemp().getValue() < this.getSpaceTempAtBeginning().getValue() && (this.getSpaceTemp().getValue() <= (double)this.getLowerComfortLimit() || this.getScheduleStatus().getValue() == INACTIVE)) {
                this.spaceTempChange = (float)this.getSpaceTempAtBeginning().getValue() - (float)this.getSpaceTemp().getValue();
                this.optimizedRuntimeMinutes = this.getLastStopTime().delta(this.now).getMinutes();
                this.observedMinutesPerDegree = (float)this.optimizedRuntimeMinutes / this.spaceTempChange;
                this.setDrifttimePerDegreeHeating((this.getDrifttimePerDegreeHeating() * (float)this.getOldParameterMultiplier() + this.observedMinutesPerDegree) / (float)(this.getOldParameterMultiplier() + 1));
                this.getMessage().setValue("Optimized stop analysis done at " + this.now + ".  Space temp is " + this.formatNumeric(this.getSpaceTemp().getValue(), "#0.0") + '.');
                this.analysisComplete = true;
            }
        } else if (this.getSpaceTemp().getValue() > this.getSpaceTempAtBeginning().getValue() && (this.getSpaceTemp().getValue() >= (double)this.getUpperComfortLimit() || this.getScheduleStatus().getValue() == INACTIVE)) {
            this.spaceTempChange = (float)this.getSpaceTemp().getValue() - (float)this.getSpaceTempAtBeginning().getValue();
            this.optimizedRuntimeMinutes = this.getLastStopTime().delta(this.now).getMinutes();
            this.observedMinutesPerDegree = (float)this.optimizedRuntimeMinutes / this.spaceTempChange;
            this.setDrifttimePerDegreeCooling((this.getDrifttimePerDegreeCooling() * (float)this.getOldParameterMultiplier() + this.observedMinutesPerDegree) / (float)(this.getOldParameterMultiplier() + 1));
            this.getMessage().setValue("Optimized stop analysis done at " + this.now + ".  Space temp is " + this.formatNumeric(this.getSpaceTemp().getValue(), "#0.0") + '.');
            this.analysisComplete = true;
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.analysisComplete = false;
        this.observedMinutesPerDegree = 0.0f;
        this.spaceTempChange = 0.0f;
        this.leadTime = 0;
        this.optimizedRuntimeMinutes = 0;
        this.lastProgramMode = 0;
        this.now = BAbsTime.NULL;
        this.lastResetTime = BAbsTime.NULL;
        this.lastMinute = 0;
        this.ticket = null;
    }

    public BOptimizedStartStop() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$kitControl$energy$BOptimizedStartStop;
        if (clazz == null) {
            clazz = class$com$tridium$kitControl$energy$BOptimizedStartStop = BOptimizedStartStop.class("[Lcom.tridium.kitControl.energy.BOptimizedStartStop;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        ACTIVE = true;
        INACTIVE = false;
        START = true;
        STOP = false;
        DISABLED = false;
        ENABLED = true;
        COOLING = true;
        HEATING = false;
        TIME_00_01 = 60000L;
        NO_CALCULATION = 0;
        START_CALCULATION = 1;
        START_IN_PROCESS = 2;
        STOP_CALCULATION = 3;
        STOP_IN_PROCESS = 4;
        ossLog = Log.getLog((String)"kitControl.oss");
    }
}

