/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.kitControl;

import com.tridium.kitControl.enums.BDisableAction;
import com.tridium.kitControl.enums.BLoopAction;
import javax.baja.control.BNumericPoint;
import javax.baja.data.BIDataValue;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BLoopPoint
extends BNumericPoint {
    public static final Property loopEnable = BLoopPoint.newProperty((int)0, (BValue)new BStatusBoolean(true), null);
    public static final Property inputFacets = BLoopPoint.newProperty((int)0, (BValue)BFacets.makeNumeric(), null);
    public static final Property controlledVariable = BLoopPoint.newProperty((int)0, (BValue)new BStatusNumeric(), (BFacets)BFacets.makeNumeric());
    public static final Property setpoint = BLoopPoint.newProperty((int)0, (BValue)new BStatusNumeric(), (BFacets)BFacets.makeNumeric());
    public static final Property executeTime = BLoopPoint.newProperty((int)0, (BValue)BRelTime.make((long)500L), (BFacets)BFacets.make((String)"showMilliseconds", (BIDataValue)BBoolean.TRUE));
    public static final Property actualTime = BLoopPoint.newProperty((int)259, (int)0, null);
    public static final Property loopAction = BLoopPoint.newProperty((int)0, (BValue)BLoopAction.direct, null);
    public static final Property disableAction = BLoopPoint.newProperty((int)0, (BValue)BDisableAction.zero, null);
    public static final Property tuningFacets = BLoopPoint.newProperty((int)0, (BValue)BFacets.makeNumeric((int)3), null);
    public static final Property proportionalConstant = BLoopPoint.newProperty((int)0, (int)0, null);
    public static final Property integralConstant = BLoopPoint.newProperty((int)0, (int)0, null);
    public static final Property derivativeConstant = BLoopPoint.newProperty((int)0, (int)0, null);
    public static final Property bias = BLoopPoint.newProperty((int)0, (int)0, null);
    public static final Property maximumOutput = BLoopPoint.newProperty((int)0, (int)100, null);
    public static final Property minimumOutput = BLoopPoint.newProperty((int)0, (int)0, null);
    public static final Property rampTime = BLoopPoint.newProperty((int)0, (BValue)BRelTime.make((long)0L), null);
    public static final Action resetIntegral = BLoopPoint.newAction((int)0, null);
    public static final Action timerExpired = BLoopPoint.newAction((int)4, null);
    public static final Type TYPE;
    public static long LOOP_MAX_EXECUTE_TIME;
    public static long LOOP_MIN_EXECUTE_TIME;
    public static long LOOP_DEFAULT_EXECUTE_TIME;
    private Clock.Ticket ticket;
    private double lastUpdateValue;
    private boolean loopEnabled;
    private boolean lastStatusInhibit;
    private double kPkIconst;
    private double errorSum;
    private double lastError;
    private boolean debug;
    private long lastExecuteTime;
    private double kPortionalCurrent;
    private double kIntegralCurrent;
    private long rampStartTicks;
    private long rampEndTicks;
    private double rampConst;
    private BStatusNumeric pidOutput;
    static /* synthetic */ Class class$com$tridium$kitControl$BLoopPoint;

    public BStatusBoolean getLoopEnable() {
        return (BStatusBoolean)this.get(loopEnable);
    }

    public void setLoopEnable(BStatusBoolean bStatusBoolean) {
        this.set(loopEnable, (BValue)bStatusBoolean, null);
    }

    public BFacets getInputFacets() {
        return (BFacets)this.get(inputFacets);
    }

    public void setInputFacets(BFacets bFacets) {
        this.set(inputFacets, (BValue)bFacets, null);
    }

    public BStatusNumeric getControlledVariable() {
        return (BStatusNumeric)this.get(controlledVariable);
    }

    public void setControlledVariable(BStatusNumeric bStatusNumeric) {
        this.set(controlledVariable, (BValue)bStatusNumeric, null);
    }

    public BStatusNumeric getSetpoint() {
        return (BStatusNumeric)this.get(setpoint);
    }

    public void setSetpoint(BStatusNumeric bStatusNumeric) {
        this.set(setpoint, (BValue)bStatusNumeric, null);
    }

    public BRelTime getExecuteTime() {
        return (BRelTime)this.get(executeTime);
    }

    public void setExecuteTime(BRelTime bRelTime) {
        this.set(executeTime, (BValue)bRelTime, null);
    }

    public int getActualTime() {
        return this.getInt(actualTime);
    }

    public void setActualTime(int n) {
        this.setInt(actualTime, n, null);
    }

    public BLoopAction getLoopAction() {
        return (BLoopAction)this.get(loopAction);
    }

    public void setLoopAction(BLoopAction bLoopAction) {
        this.set(loopAction, (BValue)bLoopAction, null);
    }

    public BDisableAction getDisableAction() {
        return (BDisableAction)this.get(disableAction);
    }

    public void setDisableAction(BDisableAction bDisableAction) {
        this.set(disableAction, (BValue)bDisableAction, null);
    }

    public BFacets getTuningFacets() {
        return (BFacets)this.get(tuningFacets);
    }

    public void setTuningFacets(BFacets bFacets) {
        this.set(tuningFacets, (BValue)bFacets, null);
    }

    public double getProportionalConstant() {
        return this.getDouble(proportionalConstant);
    }

    public void setProportionalConstant(double d) {
        this.setDouble(proportionalConstant, d, null);
    }

    public double getIntegralConstant() {
        return this.getDouble(integralConstant);
    }

    public void setIntegralConstant(double d) {
        this.setDouble(integralConstant, d, null);
    }

    public double getDerivativeConstant() {
        return this.getDouble(derivativeConstant);
    }

    public void setDerivativeConstant(double d) {
        this.setDouble(derivativeConstant, d, null);
    }

    public double getBias() {
        return this.getDouble(bias);
    }

    public void setBias(double d) {
        this.setDouble(bias, d, null);
    }

    public double getMaximumOutput() {
        return this.getDouble(maximumOutput);
    }

    public void setMaximumOutput(double d) {
        this.setDouble(maximumOutput, d, null);
    }

    public double getMinimumOutput() {
        return this.getDouble(minimumOutput);
    }

    public void setMinimumOutput(double d) {
        this.setDouble(minimumOutput, d, null);
    }

    public BRelTime getRampTime() {
        return (BRelTime)this.get(rampTime);
    }

    public void setRampTime(BRelTime bRelTime) {
        this.set(rampTime, (BValue)bRelTime, null);
    }

    public void resetIntegral() {
        this.invoke(resetIntegral, null, null);
    }

    public void timerExpired() {
        this.invoke(timerExpired, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public boolean isIntegral() {
        double d = this.getIntegralConstant();
        boolean bl = false;
        if (Double.isNaN(d) || d == 0.0) {
            bl = true;
        }
        return bl ^ true;
    }

    public BFacets getSlotFacets(Slot slot) {
        if (slot.equals((Object)controlledVariable) || slot.equals((Object)setpoint)) {
            return this.getInputFacets();
        }
        if (slot.equals((Object)proportionalConstant) || slot.equals((Object)integralConstant) || slot.equals((Object)derivativeConstant)) {
            return this.getTuningFacets();
        }
        return super.getSlotFacets(slot);
    }

    public void doResetIntegral() {
        this.clearIntegralTerms();
    }

    public void doTimerExpired() {
        if (!this.getLoopEnable().getBoolean()) {
            if (this.ticket != null) {
                this.ticket.cancel();
            }
            this.lastExecuteTime = 0L;
        }
        this.calculatePoint();
    }

    public void started() throws Exception {
        super.started();
        this.initTimer();
        this.kPortionalCurrent = this.getProportionalConstant();
        this.kIntegralCurrent = this.getIntegralConstant();
        this.kPkIconst = this.kPortionalCurrent * this.kIntegralCurrent / 60.0;
        this.rampConst = Math.abs(this.getMaximumOutput() - this.getMinimumOutput());
        this.rampStartTicks = Clock.ticks();
        this.rampEndTicks = this.rampStartTicks + this.getRampTime().getMillis();
    }

    private final void initTimer() {
        if (this.ticket != null) {
            this.ticket.cancel();
        }
        this.ticket = Clock.schedulePeriodically((BComponent)this, (BRelTime)this.getExecuteTime(), (Action)timerExpired, null);
    }

    public void onExecute(BStatusValue bStatusValue, Context context) {
        if (!this.isRunning()) {
            return;
        }
        ((BStatusNumeric)bStatusValue).setStatus(this.pidOutput.getStatus());
        ((BStatusNumeric)bStatusValue).setValue(this.pidOutput.getValue());
    }

    public void calculatePoint() {
        double d;
        boolean bl;
        this.debug = false;
        try {
            this.debug = ((BBoolean)this.get("debug")).getBoolean();
        }
        catch (Exception exception) {}
        this.loopEnabled = bl = this.getLoopEnable().getBoolean();
        this.lastStatusInhibit = bl;
        double d2 = this.getProportionalConstant();
        double d3 = this.getIntegralConstant();
        double d4 = this.getDerivativeConstant();
        double d5 = this.getMaximumOutput();
        double d6 = this.getMinimumOutput();
        long l = Clock.ticks();
        double d7 = this.getSetpoint().getValue();
        double d8 = this.getControlledVariable().getValue();
        boolean bl2 = false;
        BDisableAction bDisableAction = this.getDisableAction();
        this.rampConst = Math.abs(this.getMaximumOutput() - this.getMinimumOutput());
        if (Double.isNaN(d7) || Double.isNaN(d8)) {
            this.pidOutput.setStatusFault(true);
            bl2 = true;
        } else {
            this.pidOutput.setStatusFault(false);
        }
        if (this.lastExecuteTime == 0L) {
            this.lastExecuteTime = l;
        }
        long l2 = l - this.lastExecuteTime;
        this.setActualTime((int)l2);
        double d9 = (double)l2 / 1000.0;
        if (!this.loopEnabled) {
            double d10 = Double.NaN;
            if (bDisableAction == BDisableAction.zero) {
                d10 = 0.0;
            } else if (bDisableAction == BDisableAction.maxValue) {
                d10 = this.getMaximumOutput();
            } else if (bDisableAction == BDisableAction.minValue) {
                d10 = this.getMinimumOutput();
            }
            if (!Double.isNaN(d10)) {
                this.pidOutput.setValue(d10);
                this.errorSum = this.getLoopAction() == BLoopAction.direct ? -(d10 / this.kPkIconst) : d10 / this.kPkIconst;
            }
            this.lastExecuteTime = 0L;
            return;
        }
        if (bl2) {
            return;
        }
        double d11 = this.getSetpoint().getValue() - this.getControlledVariable().getValue();
        if (d3 != 0.0) {
            d = d9 * d11;
            this.errorSum += d;
            this.kPkIconst = d2 * d3 / 60.0;
            if (this.getLoopAction() == BLoopAction.direct) {
                if (-this.errorSum > d5 / this.kPkIconst) {
                    this.errorSum = -(d5 / this.kPkIconst);
                } else if (-this.errorSum < d6 / this.kPkIconst) {
                    this.errorSum = -(d6 / this.kPkIconst);
                }
            } else if (this.errorSum > d5 / this.kPkIconst) {
                this.errorSum = d5 / this.kPkIconst;
            } else if (this.errorSum < d6 / this.kPkIconst) {
                this.errorSum = d6 / this.kPkIconst;
            }
        }
        if (Double.isNaN(this.errorSum) || Double.isInfinite(this.errorSum)) {
            this.errorSum = 0.0;
        }
        d = d11 * d2;
        double d12 = 0.0;
        d12 = d2 * d3 * this.errorSum / 60.0;
        double d13 = d2 * d4 * (d11 - this.lastError) / d9;
        this.lastError = d11;
        double d14 = d + d12 + d13;
        if (Double.isNaN(d14)) {
            return;
        }
        if (this.getLoopAction() == BLoopAction.direct) {
            d14 = -d14;
        }
        if (!this.isIntegral()) {
            d14 += this.getBias();
        }
        if (d14 > d5) {
            d14 = d5;
        } else if (d14 < d6) {
            d14 = d6;
        }
        if (this.debug) {
            System.out.println("pGain: " + d + " iGain: " + d12 + " dGain: " + d13 + "\nerrorSum: " + this.errorSum + " error: " + d11 + " pv: " + d14 + " deltaSecs: " + d9 + " out: " + this.getOut().getValue());
        }
        if (l < this.rampEndTicks) {
            double d15 = this.rampConst * (double)l2 / (double)this.getRampTime().getMillis();
            if (this.getOut().getValue() > d14) {
                double d16 = this.getOut().getValue() - d15;
                if (d14 < d16) {
                    this.errorSum = this.errorSum * d16 / d14;
                    d14 = d16;
                }
            } else {
                double d17 = this.getOut().getValue() + d15;
                if (d14 > d17) {
                    this.errorSum = this.errorSum * d17 / d14;
                    d14 = d17;
                }
            }
        }
        this.pidOutput.setValue(d14);
        this.lastExecuteTime = l;
        this.doExecute();
    }

    private final void clearIntegralTerms() {
        this.lastExecuteTime = 0L;
        this.errorSum = this.getLoopAction() == BLoopAction.direct ? -(this.getMaximumOutput() / this.kPkIconst) : this.getMinimumOutput() / this.kPkIconst;
        if (Double.isNaN(this.errorSum)) {
            this.errorSum = 0.0;
        }
        if (this.debug) {
            System.out.println("Clearing integral term...");
        }
    }

    public void changed(Property property, Context context) {
        if (!this.isRunning()) {
            return;
        }
        super.changed(property, context);
        if (property.equals((Object)executeTime)) {
            if (this.getExecuteTime().getMillis() < LOOP_MIN_EXECUTE_TIME) {
                this.setExecuteTime(BRelTime.make((long)LOOP_MIN_EXECUTE_TIME));
            } else if (this.getExecuteTime().getMillis() > LOOP_MAX_EXECUTE_TIME) {
                this.setExecuteTime(BRelTime.make((long)LOOP_MAX_EXECUTE_TIME));
            }
            this.initTimer();
        } else if (property.equals((Object)proportionalConstant)) {
            double d = this.getProportionalConstant();
            if (d != 0.0) {
                this.errorSum = this.errorSum * this.kPortionalCurrent / d;
            }
            this.kPortionalCurrent = d;
        } else if (property.equals((Object)integralConstant)) {
            double d = this.getIntegralConstant();
            if (d != 0.0) {
                this.errorSum = this.errorSum * this.kIntegralCurrent / d;
            }
            this.kIntegralCurrent = d;
        } else if (property.equals((Object)loopEnable)) {
            if (this.getLoopEnable().getBoolean()) {
                this.rampConst = Math.abs(this.getMaximumOutput() - this.getMinimumOutput());
                this.rampStartTicks = Clock.ticks();
                this.rampEndTicks = this.rampStartTicks + this.getRampTime().getMillis();
                this.calculatePoint();
                if (this.isRunning()) {
                    this.initTimer();
                }
            } else {
                if (this.ticket != null) {
                    this.ticket.cancel();
                }
                BDisableAction bDisableAction = this.getDisableAction();
                double d = Double.NaN;
                if (bDisableAction == BDisableAction.zero) {
                    d = 0.0;
                } else if (bDisableAction == BDisableAction.maxValue) {
                    d = this.getMaximumOutput();
                } else if (bDisableAction == BDisableAction.minValue) {
                    d = this.getMinimumOutput();
                }
                if (!Double.isNaN(d)) {
                    this.pidOutput.setValue(d);
                    this.errorSum = this.getLoopAction() == BLoopAction.direct ? -(d / this.kPkIconst) : d / this.kPkIconst;
                }
                this.lastExecuteTime = 0L;
                if (this.debug) {
                    System.out.println("loop disabled:  errorSum " + this.errorSum);
                    System.out.println("loop disabled:  outValue " + d);
                    System.out.println("loop disabled:  kPkIconst " + this.kPkIconst);
                }
            }
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.lastUpdateValue = Double.NaN;
        this.lastStatusInhibit = false;
        this.errorSum = 0.0;
        this.lastError = 0.0;
        this.debug = false;
        this.pidOutput = new BStatusNumeric();
    }

    public BLoopPoint() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$kitControl$BLoopPoint;
        if (clazz == null) {
            clazz = class$com$tridium$kitControl$BLoopPoint = BLoopPoint.class("[Lcom.tridium.kitControl.BLoopPoint;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        LOOP_MAX_EXECUTE_TIME = 60000L;
        LOOP_MIN_EXECUTE_TIME = 100L;
        LOOP_DEFAULT_EXECUTE_TIME = 500L;
    }
}

