/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platHwScanTitan;

import com.tridium.platHwScan.BBaseBoard;
import com.tridium.platHwScan.BHardwareScanService;
import com.tridium.platHwScan.enums.BHwScanStatusEnum;
import com.tridium.platHwScan.enums.BPortTypeEnum;
import com.tridium.platHwScan.optionCards.BOptionCard;
import com.tridium.platHwScan.optionCards.BOptionSlot;
import com.tridium.platHwScan.ports.BEthernetPort;
import com.tridium.platHwScan.ports.BPort;
import com.tridium.platHwScan.util.BHardwareRef;
import java.util.Vector;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;
import javax.baja.util.Lexicon;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BTitanBoard
extends BBaseBoard {
    public static final Property LAN1 = BTitanBoard.newProperty((int)1, (BValue)new BEthernetPort("en0"), null);
    public static final Property LAN2 = BTitanBoard.newProperty((int)1, (BValue)new BEthernetPort("en2"), null);
    public static final Property COM1 = BTitanBoard.newProperty((int)1, (BValue)new BPort(BPortTypeEnum.rs485, "tridium:serial", "COM"), null);
    public static final Property COM2 = BTitanBoard.newProperty((int)1, (BValue)new BPort(BPortTypeEnum.rs485, "tridium:serial", "COM"), null);
    public static final Property optionSlot1 = BTitanBoard.newProperty((int)1, (BValue)new BOptionSlot(1), null);
    public static final Property optionSlot2 = BTitanBoard.newProperty((int)1, (BValue)new BOptionSlot(2), null);
    public static final Property optionSlot3 = BTitanBoard.newProperty((int)1, (BValue)new BOptionSlot(3), null);
    public static final Property optionSlot4 = BTitanBoard.newProperty((int)1, (BValue)new BOptionSlot(4), null);
    public static final Type TYPE;
    private static final Lexicon lex;
    private static final String BASE_BOARD_CODE = "TITAN";
    private static final String VIEW = "pxView";
    private static final String IMAGES_DIR = "imageDir";
    private static final int BASE_LAN_PORT = 3;
    private static final int BASE_LON_PORT = 1;
    private static final int BASE_SERIAL_PORT = 3;
    public static final int HARDWARE_REF_COUNT = 11;
    static /* synthetic */ Class class$com$tridium$platHwScanTitan$BTitanBoard;
    static /* synthetic */ Class class$com$tridium$platHwScan$ports$BPort;

    public BEthernetPort getLAN1() {
        return (BEthernetPort)this.get(LAN1);
    }

    public void setLAN1(BEthernetPort bEthernetPort) {
        this.set(LAN1, (BValue)bEthernetPort, null);
    }

    public BEthernetPort getLAN2() {
        return (BEthernetPort)this.get(LAN2);
    }

    public void setLAN2(BEthernetPort bEthernetPort) {
        this.set(LAN2, (BValue)bEthernetPort, null);
    }

    public BPort getCOM1() {
        return (BPort)this.get(COM1);
    }

    public void setCOM1(BPort bPort) {
        this.set(COM1, (BValue)bPort, null);
    }

    public BPort getCOM2() {
        return (BPort)this.get(COM2);
    }

    public void setCOM2(BPort bPort) {
        this.set(COM2, (BValue)bPort, null);
    }

    public BOptionSlot getOptionSlot1() {
        return (BOptionSlot)this.get(optionSlot1);
    }

    public void setOptionSlot1(BOptionSlot bOptionSlot) {
        this.set(optionSlot1, (BValue)bOptionSlot, null);
    }

    public BOptionSlot getOptionSlot2() {
        return (BOptionSlot)this.get(optionSlot2);
    }

    public void setOptionSlot2(BOptionSlot bOptionSlot) {
        this.set(optionSlot2, (BValue)bOptionSlot, null);
    }

    public BOptionSlot getOptionSlot3() {
        return (BOptionSlot)this.get(optionSlot3);
    }

    public void setOptionSlot3(BOptionSlot bOptionSlot) {
        this.set(optionSlot3, (BValue)bOptionSlot, null);
    }

    public BOptionSlot getOptionSlot4() {
        return (BOptionSlot)this.get(optionSlot4);
    }

    public void setOptionSlot4(BOptionSlot bOptionSlot) {
        this.set(optionSlot4, (BValue)bOptionSlot, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        BComplex bComplex = this.getParent();
        if (bComplex instanceof BHardwareScanService) {
            BHardwareScanService bHardwareScanService = (BHardwareScanService)bComplex;
            Action action = bHardwareScanService.getAction("scan");
            String string = Flags.encodeToString((int)bHardwareScanService.getFlags((Slot)action));
            string = TextUtil.replace((String)string, (String)"h", (String)"");
            bHardwareScanService.setFlags((Slot)action, Flags.decodeFromString((String)string));
        }
        super.started();
    }

    public void autoConfig(Array array, boolean bl) {
        this.simulation = bl;
        this.setProductModel("JACE-8000");
        this.initializeStandardPorts();
        this.nextSerialPort = 3;
        this.nextLonPort = 1;
        this.nextLanPort = 3;
        int n = 1;
        while (n <= 4) {
            BOptionSlot bOptionSlot = (BOptionSlot)this.get("optionSlot" + n);
            if (array.size() >= n * 2 - 1) {
                this.configureOptionSlot(bOptionSlot, (String)array.get(n * 2 - 2), (String)array.get(n * 2 - 1));
            } else {
                this.configureOptionSlot(bOptionSlot, "FF", "FF");
            }
            ++n;
        }
    }

    public String getBoardCode() {
        return BASE_BOARD_CODE;
    }

    public Vector getHardwareRefs() {
        Vector<BHardwareRef> vector = new Vector<BHardwareRef>();
        int n = 1;
        while (n <= 11) {
            switch (n) {
                case 1: {
                    vector.addElement(new BHardwareRef(n, this.getBaseUnitText(), lex.getText("HardwareRef.electricalGround")));
                    break;
                }
                case 2: {
                    vector.addElement(new BHardwareRef(n, this.getBaseUnitText(), lex.getText("HardwareRef.powerConnector")));
                    break;
                }
                case 3: {
                    vector.addElement(new BHardwareRef(n, this.getBaseUnitText(), lex.getText("HardwareRef.powerConnector")));
                    break;
                }
                case 4: {
                    vector.addElement(this.makeBaseboardCommRef(n, this.getCOM1()));
                    break;
                }
                case 5: {
                    vector.addElement(this.makeBaseboardCommRef(n, this.getCOM2()));
                    break;
                }
                case 6: {
                    vector.addElement(this.makeBaseboardCommRef(n, (BPort)this.getLAN2()));
                    break;
                }
                case 7: {
                    vector.addElement(this.makeBaseboardCommRef(n, (BPort)this.getLAN1()));
                    break;
                }
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    BOptionSlot bOptionSlot = (BOptionSlot)this.get("optionSlot" + (n - 7));
                    vector.addElement(this.makeSlotRef(n, bOptionSlot));
                    if (bOptionSlot.isEmpty()) break;
                    BOptionCard bOptionCard = (BOptionCard)bOptionSlot.getContents();
                    bOptionCard.lease(1);
                    Class clazz = class$com$tridium$platHwScan$ports$BPort;
                    if (clazz == null) {
                        clazz = BTitanBoard.class("[Lcom.tridium.platHwScan.ports.BPort;", false);
                    }
                    BPort[] bPortArray = (BPort[])bOptionCard.getChildren(clazz);
                    int n2 = 0;
                    while (n2 < bPortArray.length) {
                        vector.addElement(this.makePortRef(n, n2 + 1, bPortArray[n2]));
                        ++n2;
                    }
                    break;
                }
            }
            ++n;
        }
        return vector;
    }

    public String getImagesDirectory() {
        return lex.getText(IMAGES_DIR);
    }

    public String getView(BObject bObject) {
        return lex.getText(VIEW);
    }

    public void configureOptionSlot(BOptionSlot bOptionSlot, String string, String string2) {
        bOptionSlot.removeAll();
        if (!string.equalsIgnoreCase("FF") || !string2.equalsIgnoreCase("FF")) {
            BOptionCard bOptionCard = BOptionCard.lookup((String)(string + ' ' + string2));
            if (bOptionCard == null) {
                bOptionSlot.addCard(new BOptionCard(BHardwareScanService.lex.getText("unknownOptionCard", new Object[]{string, string2}), string + ' ' + string2));
            } else {
                BOptionCard bOptionCard2 = (BOptionCard)bOptionCard.newCopy(true);
                bOptionSlot.addCard(bOptionCard2);
                BPort[] bPortArray = bOptionCard2.getPorts();
                int n = 0;
                while (n < bPortArray.length) {
                    if (bPortArray[n] != null) {
                        BPort bPort = bPortArray[n];
                        bOptionCard2.rename(bOptionCard2.getProperty(bPort.getName()), this.makePortName(n + 1, bPort.getPrefix()), null);
                        if (!this.simulation) {
                            bPort.initOwnerAndStatus();
                        }
                    }
                    ++n;
                }
            }
        }
        if (bOptionSlot.isEmpty()) {
            bOptionSlot.add("Contents", (BValue)BHwScanStatusEnum.empty, 3);
        }
    }

    private final void initializeStandardPorts() {
        this.setDisplayName(COM1, BFormat.make((String)("COM".toUpperCase() + '1')), null);
        this.setDisplayName(COM2, BFormat.make((String)("COM".toUpperCase() + '2')), null);
        this.setDisplayName(LAN1, BFormat.make((String)("LAN".toUpperCase() + '1')), null);
        this.setDisplayName(LAN2, BFormat.make((String)("LAN".toUpperCase() + '2')), null);
        if (!this.simulation) {
            this.getCOM1().initOwnerAndStatus();
            this.getCOM2().initOwnerAndStatus();
            this.getLAN1().initStatus();
            this.getLAN2().initStatus();
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$platHwScanTitan$BTitanBoard;
        if (clazz == null) {
            clazz = class$com$tridium$platHwScanTitan$BTitanBoard = BTitanBoard.class("[Lcom.tridium.platHwScanTitan.BTitanBoard;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        Class clazz2 = class$com$tridium$platHwScanTitan$BTitanBoard;
        if (clazz2 == null) {
            clazz2 = class$com$tridium$platHwScanTitan$BTitanBoard = BTitanBoard.class("[Lcom.tridium.platHwScanTitan.BTitanBoard;", false);
        }
        lex = Lexicon.make((Class)clazz2);
    }
}

