/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.dust.util;

import com.tridium.dust.messages.MoteProfile;
import com.tridium.dust.objects.BChannelProfile;
import com.tridium.dust.util.Special;
import java.util.Date;
import javax.baja.control.BNumericPoint;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.xml.XContent;
import javax.baja.xml.XElem;

public class Datasheet100_0001
extends Special {
    public BChannelProfile[] getChannels(MoteProfile moteProfile) {
        BChannelProfile[] bChannelProfileArray = new BChannelProfile[2];
        BChannelProfile bChannelProfile = new BChannelProfile();
        bChannelProfile.setChId("temp");
        bChannelProfile.setEnable(true);
        bChannelProfile.setDescription("Temperature");
        bChannelProfile.setDataUnits(BUnit.getUnit((String)"celsius"));
        bChannelProfileArray[0] = bChannelProfile;
        bChannelProfile = new BChannelProfile();
        bChannelProfile.setChId("rh");
        bChannelProfile.setEnable(true);
        bChannelProfile.setDescription("Percent Relative Humidity");
        bChannelProfile.setDataUnits(BUnit.getUnit((String)"percent relative humidity"));
        bChannelProfileArray[1] = bChannelProfile;
        return bChannelProfileArray;
    }

    public Type[] getPointTypes() {
        return new Type[]{BNumericPoint.TYPE};
    }

    public XElem[] getSamples(XElem xElem) {
        XElem xElem2 = xElem.elem("payload");
        if (xElem2 == null) {
            return null;
        }
        String string = xElem2.string();
        int n = this.parseHex(string, 2, 2);
        int n2 = this.parseHex(string, 4, 2);
        double d = (double)(n * 4 + n2 * 100) / 100.0;
        n = this.parseHex(string, 8, 2);
        n2 = this.parseHex(string, 10, 2);
        double d2 = (double)(n * 4 + n2 * 100) / 100.0;
        long l = xElem2.getl("time", System.currentTimeMillis());
        String string2 = null;
        try {
            string2 = new Date(l).toString();
        }
        catch (Exception exception) {
            string2 = new Date().toString();
        }
        XElem[] xElemArray = new XElem[2];
        XElem xElem3 = new XElem("sample").addAttr("chId", "temp");
        xElem3.addContent((XContent)new XElem("time").addText(string2));
        xElem3.addContent((XContent)new XElem("val").addText(String.valueOf(d)));
        xElemArray[0] = xElem3;
        xElem3 = new XElem("sample").addAttr("chId", "rh");
        xElem3.addContent((XContent)new XElem("time").addText(string2));
        xElem3.addContent((XContent)new XElem("val").addText(String.valueOf(d2)));
        xElemArray[1] = xElem3;
        return xElemArray;
    }

    int parseHex(String string, int n, int n2) {
        return Integer.parseInt(string.substring(n, n + n2), 16);
    }
}

