/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.dust.point;

import com.tridium.dust.BDustNetwork;
import com.tridium.dust.BSmartMeshClient;
import com.tridium.dust.messages.ActuateReq;
import com.tridium.dust.messages.MethodResponse;
import com.tridium.dust.messages.Notification;
import com.tridium.dust.point.BDustPointDeviceExt;
import com.tridium.dust.point.BDustPointFolder;
import com.tridium.dust.util.BDustSubscription;
import com.tridium.dust.util.BIDustPollable;
import com.tridium.dust.util.Special;
import java.util.Date;
import javax.baja.control.BBooleanPoint;
import javax.baja.control.BControlPoint;
import javax.baja.control.BNumericPoint;
import javax.baja.control.BStringPoint;
import javax.baja.driver.point.BProxyExt;
import javax.baja.driver.point.BReadWriteMode;
import javax.baja.driver.util.BPollFrequency;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;
import javax.baja.xml.XElem;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BDustProxyExt
extends BProxyExt
implements BIDustPollable {
    public static final Property moteId = BDustProxyExt.newProperty((int)0, (String)"", null);
    public static final Property moteMac = BDustProxyExt.newProperty((int)0, (String)"", null);
    public static final Property channelId = BDustProxyExt.newProperty((int)0, (String)"", null);
    public static final Property sampleTime = BDustProxyExt.newProperty((int)3, (String)"", null);
    public static final Property mode = BDustProxyExt.newProperty((int)65, (BValue)BReadWriteMode.readWrite, null);
    public static final Property pollFrequency = BDustProxyExt.newProperty((int)4, (BValue)BPollFrequency.normal, null);
    public static final Property asyncNotification = BDustProxyExt.newProperty((int)3, (BValue)BDustSubscription.unsubscribed, null);
    public static final Action performWrite = BDustProxyExt.newAction((int)0, null);
    public static final Type TYPE;
    private String cid;
    private BDustPointDeviceExt deviceExt;
    private BDustPointFolder folder;
    private String mid;
    private boolean readSubscribed;
    static /* synthetic */ Class class$com$tridium$dust$point$BDustProxyExt;

    public String getMoteId() {
        return this.getString(moteId);
    }

    public void setMoteId(String string) {
        this.setString(moteId, string, null);
    }

    public String getMoteMac() {
        return this.getString(moteMac);
    }

    public void setMoteMac(String string) {
        this.setString(moteMac, string, null);
    }

    public String getChannelId() {
        return this.getString(channelId);
    }

    public void setChannelId(String string) {
        this.setString(channelId, string, null);
    }

    public String getSampleTime() {
        return this.getString(sampleTime);
    }

    public void setSampleTime(String string) {
        this.setString(sampleTime, string, null);
    }

    public BReadWriteMode getMode() {
        return (BReadWriteMode)this.get(mode);
    }

    public void setMode(BReadWriteMode bReadWriteMode) {
        this.set(mode, (BValue)bReadWriteMode, null);
    }

    public BPollFrequency getPollFrequency() {
        return (BPollFrequency)this.get(pollFrequency);
    }

    public void setPollFrequency(BPollFrequency bPollFrequency) {
        this.set(pollFrequency, (BValue)bPollFrequency, null);
    }

    public BDustSubscription getAsyncNotification() {
        return (BDustSubscription)this.get(asyncNotification);
    }

    public void setAsyncNotification(BDustSubscription bDustSubscription) {
        this.set(asyncNotification, (BValue)bDustSubscription, null);
    }

    public void performWrite() {
        this.invoke(performWrite, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (context != Context.decoding && (property == channelId || property == moteId || property == moteMac)) {
            if (this.getAsyncNotification().isSubscribed()) {
                this.getDustPointDeviceExt().unsubscribe(this, this.mid, this.cid, context);
                this.setAsyncNotification(BDustSubscription.unsubscribed);
            }
            if (this.readSubscribed) {
                this.getDustPointDeviceExt().subscribe(this, this.mid(), this.cid(), context);
            }
        }
    }

    public void doPerformWrite() {
        try {
            ActuateReq actuateReq;
            BSmartMeshClient bSmartMeshClient;
            XElem xElem;
            MethodResponse methodResponse;
            BStatusValue bStatusValue = this.getWriteValue();
            if (!(bStatusValue instanceof BStatusBoolean)) {
                throw new IllegalStateException("Only digital points can be actuated.");
            }
            BStatusBoolean bStatusBoolean = (BStatusBoolean)bStatusValue;
            String string = "0";
            if (bStatusBoolean.getBoolean()) {
                string = "1";
            }
            if ((methodResponse = new MethodResponse(xElem = (bSmartMeshClient = this.getSmartMeshClient()).send((actuateReq = new ActuateReq(bSmartMeshClient.getControlToken(), Integer.parseInt(this.getMoteId().trim()), this.getChannelId(), string)).encode()))).isOk()) {
                this.writeOk(bStatusValue);
            } else {
                this.writeFail(methodResponse.getMessage());
            }
        }
        catch (Exception exception) {
            this.getSmartMeshClient().getLog().error("Write failed: " + this.toPathString(), (Throwable)exception);
            this.writeFail(exception.getMessage());
        }
    }

    public Type getDeviceExtType() {
        return BDustPointDeviceExt.TYPE;
    }

    public BDustPointFolder getFolder() {
        if (this.folder == null) {
            BComplex bComplex = this.getParent();
            while (bComplex != null) {
                if (bComplex instanceof BDustPointFolder) {
                    this.folder = (BDustPointFolder)bComplex;
                    break;
                }
                bComplex = bComplex.getParent();
            }
        }
        return this.folder;
    }

    public BSmartMeshClient getSmartMeshClient() {
        return (BSmartMeshClient)this.getDevice();
    }

    public BDustPointDeviceExt getDustPointDeviceExt() {
        if (this.deviceExt == null) {
            this.deviceExt = (BDustPointDeviceExt)this.getDeviceExt();
        }
        return this.deviceExt;
    }

    public BDustNetwork getDustNetwork() {
        return this.getSmartMeshClient().getDustNetwork();
    }

    public boolean isReadSubscribed() {
        return this.readSubscribed;
    }

    public void poll() {
        if (this.getAsyncNotification().isUnsubscribed()) {
            this.read();
        }
    }

    public IFuture post(Action action, BValue bValue, Context context) {
        this.getDustNetwork().enqueue((Runnable)new Invocation((BComponent)this, action, bValue, context));
        return null;
    }

    public void read() {
    }

    public void readSubscribed(Context context) {
    }

    public void readUnsubscribed(Context context) {
    }

    public void setStale(boolean bl, Context context) {
        super.setStale(bl, context);
        if (bl) {
            this.read();
        }
    }

    public void started() throws Exception {
        super.start();
        if (this.get("special") != null) {
            Special special = Special.getSpecial(this.get("special").toString());
            Special.setMoteSpecial(this.getMoteMac(), special);
        }
        this.dustReadSubscribed(null);
    }

    public final void stopped() throws Exception {
        this.dustReadUnsubscribed(null);
        this.deviceExt = null;
        this.folder = null;
        super.stopped();
    }

    public boolean write(Context context) {
        if (this.getWriteValue().getStatus().isNull()) {
            return false;
        }
        this.performWrite();
        return true;
    }

    protected void dustReadSubscribed(Context context) {
        if (this.readSubscribed) {
            return;
        }
        this.readSubscribed = true;
        this.setAsyncNotification(BDustSubscription.pending);
        this.getDustPointDeviceExt().subscribe(this, this.mid(), this.cid(), context);
    }

    protected void dustReadUnsubscribed(Context context) {
        if (!this.readSubscribed) {
            return;
        }
        this.readSubscribed = false;
        if (this.getAsyncNotification().isSubscribed()) {
            this.getDustPointDeviceExt().unsubscribe(this, this.mid, this.cid, context);
        } else {
            this.getSmartMeshClient().getPollScheduler().unsubscribe(this);
        }
        this.setAsyncNotification(BDustSubscription.unsubscribed);
    }

    protected BStatusValue makeVal(String string) {
        BControlPoint bControlPoint = (BControlPoint)this.getParent();
        BStatusNumeric bStatusNumeric = null;
        if (bControlPoint instanceof BNumericPoint) {
            bStatusNumeric = new BStatusNumeric(Double.parseDouble(string));
        } else if (bControlPoint instanceof BBooleanPoint) {
            bStatusNumeric = string.equals("0") ? new BStatusBoolean(false) : (string.equals("1") ? new BStatusBoolean(true) : new BStatusBoolean(string.toLowerCase().equals("true")));
        } else if (bControlPoint instanceof BStringPoint) {
            bStatusNumeric = new BStatusString(string);
        } else {
            this.getNetwork().getLog().error("Read failure: " + this.toPathString(), (Throwable)new Exception());
        }
        return bStatusNumeric;
    }

    protected void processRead(Notification notification, int n) {
        String string = notification.getSampleValue(n);
        String string2 = notification.getSampleTime(n);
        BStatusValue bStatusValue = this.makeVal(string);
        if (bStatusValue != null) {
            try {
                this.setSampleTime(new Date(Long.parseLong(string2)).toString());
            }
            catch (Exception exception) {
                this.setSampleTime(string2);
            }
            this.readOk(bStatusValue);
        }
    }

    protected void subscribeFail() {
        this.setAsyncNotification(BDustSubscription.unsubscribed);
        this.getSmartMeshClient().getPollScheduler().subscribe(this);
    }

    protected void subscribeOk() {
        this.setAsyncNotification(BDustSubscription.subscribed);
    }

    private final String cid() {
        this.cid = this.getChannelId();
        return this.cid;
    }

    private final String mid() {
        this.mid = this.getMoteMac();
        return this.mid;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.deviceExt = null;
        this.folder = null;
        this.readSubscribed = false;
    }

    public BDustProxyExt() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$dust$point$BDustProxyExt;
        if (clazz == null) {
            clazz = class$com$tridium$dust$point$BDustProxyExt = BDustProxyExt.class("[Lcom.tridium.dust.point.BDustProxyExt;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

