/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.dust.alarm;

import javax.baja.alarm.BAlarmDatabase;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.alarm.BSourceState;
import javax.baja.data.BIDataValue;
import javax.baja.driver.alarm.BAlarmDeviceExt;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BString;
import javax.baja.sys.Clock;
import javax.baja.sys.Cursor;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.xml.XElem;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BDustAlarmDeviceExt
extends BAlarmDeviceExt {
    public static final Property alarmClass = BDustAlarmDeviceExt.newProperty((int)0, (String)"defaultAlarmClass", (BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"alarm:DeviceExtAlarmClassFE")));
    public static final Type TYPE;
    static /* synthetic */ Class class$com$tridium$dust$alarm$BDustAlarmDeviceExt;

    public String getAlarmClass() {
        return this.getString(alarmClass);
    }

    public void setAlarmClass(String string) {
        this.setString(alarmClass, string, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BBoolean doAckAlarm(BAlarmRecord bAlarmRecord) throws Exception {
        return BBoolean.TRUE;
    }

    public void doRouteAlarm(BAlarmRecord bAlarmRecord) throws Exception {
    }

    public void processNotification(XElem xElem) {
        try {
            BAlarmService bAlarmService = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
            XElem[] xElemArray = xElem.elems();
            int n = 0;
            while (n < xElemArray.length) {
                BOrd[] bOrdArray;
                Object object;
                XElem xElem2 = xElemArray[n];
                String string = xElem2.name();
                if (string.equals("alarmOpen")) {
                    object = this.makeAlarm(xElem, true);
                    bOrdArray = this.getAlarmDesc(xElem2);
                    if (bOrdArray == null) {
                        System.out.println("Unexpected alarm structure: ");
                        xElem.dump();
                        return;
                    }
                    object.addAlarmFacet("msgText", (BIDataValue)BString.make((String)bOrdArray.name()));
                    bAlarmService.routeAlarm(object);
                    return;
                }
                if (string.equals("alarmClose")) {
                    object = this.getAlarmOpenId(xElem2);
                    if (object != null) {
                        bOrdArray = new BOrd[]{this.getSlotPathOrd(), BOrd.make((String)object)};
                        BOrdList bOrdList = BOrdList.make((BOrd[])bOrdArray);
                        BAlarmDatabase bAlarmDatabase = bAlarmService.getAlarmDb();
                        Cursor cursor = bAlarmDatabase.getAlarmsForSource(bOrdList);
                        while (cursor.next()) {
                            BAlarmRecord bAlarmRecord = (BAlarmRecord)cursor.get();
                            bAlarmRecord.setSourceState(BSourceState.normal);
                            BAbsTime bAbsTime = Clock.time();
                            bAlarmRecord.setNormalTime(bAbsTime);
                            bAlarmRecord.ackAlarm();
                            bAlarmDatabase.update(bAlarmRecord);
                        }
                    }
                } else if (string.equals("netMoteJoin") || string.equals("netMoteLive") || string.equals("netMoteUnknown")) {
                    xElem.dump();
                    object = this.makeAlarm(xElem, false);
                    object.addAlarmFacet("msgText", (BIDataValue)BString.make((String)string));
                    bAlarmService.routeAlarm(object);
                    return;
                }
                ++n;
            }
        }
        catch (Exception exception) {
            System.out.println("Unrecognized event:");
            xElem.dump();
        }
    }

    private final XElem getAlarmDesc(XElem xElem) {
        XElem[] xElemArray = xElem.elems();
        if (xElemArray != null) {
            int n = 0;
            while (n < xElemArray.length) {
                if (!xElemArray[n].name().startsWith("alarm")) {
                    return xElemArray[n];
                }
                ++n;
            }
        }
        return xElem;
    }

    private final String getAlarmOpenId(XElem xElem) {
        Object var2_2 = null;
        XElem[] xElemArray = xElem.elems();
        if (xElemArray != null) {
            int n = 0;
            while (n < xElemArray.length) {
                if (xElemArray[n].name().equals("alarmOpenEventId")) {
                    return xElemArray[n].string();
                }
                ++n;
            }
        }
        return null;
    }

    private final BAlarmRecord makeAlarm(XElem xElem, boolean bl) {
        BAlarmRecord bAlarmRecord = new BAlarmRecord();
        bAlarmRecord.setAckRequired(false);
        bAlarmRecord.addAlarmFacet("sourceName", (BIDataValue)BString.make((String)this.getParent().getName()));
        XElem[] xElemArray = xElem.elems();
        BOrd bOrd = null;
        int n = 0;
        while (n < xElemArray.length) {
            XElem xElem2 = xElemArray[n];
            String string = xElem2.name();
            if (string.equals("timeStamp")) {
                bAlarmRecord.addAlarmFacet("deviceTimeStamp", (BIDataValue)BString.make((String)xElem2.string()));
            } else if (string.equals("eventId")) {
                bOrd = BOrd.make((String)("dust:" + xElem2.string()));
                bAlarmRecord.addAlarmFacet("eventId", (BIDataValue)BString.make((String)xElem2.string()));
            }
            ++n;
        }
        if (bl && bOrd != null) {
            bAlarmRecord.setSourceState(BSourceState.offnormal);
        } else {
            bAlarmRecord.setSourceState(BSourceState.alert);
        }
        if (bOrd != null) {
            bOrd = BOrd.make((String)"dust:unknown");
        }
        BOrd[] bOrdArray = new BOrd[]{this.getSlotPathOrd(), bOrd};
        bAlarmRecord.setSource(BOrdList.make((BOrd[])bOrdArray));
        return bAlarmRecord;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$dust$alarm$BDustAlarmDeviceExt;
        if (clazz == null) {
            clazz = class$com$tridium$dust$alarm$BDustAlarmDeviceExt = BDustAlarmDeviceExt.class("[Lcom.tridium.dust.alarm.BDustAlarmDeviceExt;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

