/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.test;

import com.tridium.sys.Nre;
import com.tridium.testng.TestRunnerNg;
import com.tridium.util.ArrayUtil;
import com.tridium.util.CommandLineArguments;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.baja.registry.ModuleInfo;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.ModuleNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.sys.TypeException;
import javax.baja.test.BISystemTest;
import javax.baja.test.BTest;

public class TestRunner {
    public int totalTypes;
    public int totalMethods;
    public static int totalMethodsPassed = 0;
    public static int totalMethodsFailed = 0;
    public static int totalMethodsSkipped = 0;
    public int totalVerifies;
    private ArrayList failures = new ArrayList();
    private boolean testng = false;
    private static TestRunnerNg ngRunner = new TestRunnerNg();

    public void run(String string) {
        try {
            this.start();
            if (string.equals("all")) {
                this.runAll();
            } else if (string.indexOf(58) < 0) {
                ModuleInfo moduleInfo = null;
                try {
                    moduleInfo = Sys.getRegistry().getModule(string + "Test");
                }
                catch (ModuleNotFoundException moduleNotFoundException) {
                    moduleInfo = Sys.getRegistry().getModule(string);
                }
                this.run(moduleInfo);
            } else if (string.indexOf(46) < 0) {
                Type type = null;
                int n = string.indexOf(58);
                String string2 = string.substring(0, n);
                String string3 = string.substring(n + 1);
                String string4 = string2 + "Test:" + string3;
                try {
                    type = Sys.getType((String)string4);
                }
                catch (ModuleNotFoundException moduleNotFoundException) {
                    type = Sys.getType((String)string);
                }
                this.run(type);
            } else {
                int n = string.indexOf(58);
                int n2 = string.indexOf(46);
                String string5 = string.substring(0, n);
                String string6 = string.substring(n + 1, n2);
                String string7 = string5 + "Test:" + string6;
                String string8 = string.substring(0, n2);
                String string9 = string.substring(n2 + 1);
                Type type = null;
                try {
                    type = Sys.getType((String)string7);
                }
                catch (ModuleNotFoundException moduleNotFoundException) {
                    type = Sys.getType((String)string8);
                }
                Method method = type.getTypeClass().getMethod(string9, new Class[0]);
                this.run(type, method);
            }
            this.end();
        }
        catch (Throwable throwable) {
            System.out.println();
            System.out.println("ERROR Invalid test target: " + string);
            throwable.printStackTrace();
            System.out.println();
        }
    }

    public void runAll() {
        if (this.testng) {
            ngRunner.run();
            return;
        }
        TypeInfo[] typeInfoArray = Sys.getRegistry().getConcreteTypes(BTest.TYPE.getTypeInfo());
        for (int i = 0; i < typeInfoArray.length; ++i) {
            try {
                if (typeInfoArray[i].is(BISystemTest.TYPE)) continue;
                this.run(typeInfoArray[i].getTypeSpec().getResolvedType());
                continue;
            }
            catch (TypeException typeException) {
                System.out.println("ERROR Can not resolve type: " + typeInfoArray[i]);
                System.out.println("      Reason: " + typeException.getCause());
                this.failures.add(typeInfoArray[i] + ".test");
                if (!(typeException.getCause() instanceof OutOfMemoryError)) continue;
                System.gc();
            }
        }
    }

    public void run(ModuleInfo moduleInfo) {
        if (this.testng) {
            ngRunner.run(moduleInfo);
            return;
        }
        TypeInfo[] typeInfoArray = moduleInfo.getTypes();
        for (int i = 0; i < typeInfoArray.length; ++i) {
            TypeInfo typeInfo = typeInfoArray[i];
            if (typeInfo.isAbstract() || !typeInfo.is(BTest.TYPE) || typeInfo.is(BISystemTest.TYPE)) continue;
            try {
                this.run(typeInfo.getTypeSpec().getResolvedType());
                continue;
            }
            catch (TypeException typeException) {
                System.out.println("ERROR Can not resolve type: " + typeInfo);
                System.out.println("      Reason: " + typeException.getCause());
                this.failures.add(typeInfo + ".test");
                if (!(typeException.getCause() instanceof OutOfMemoryError)) continue;
                System.gc();
            }
        }
    }

    public void run(Type type) {
        if (this.testng) {
            ngRunner.run(type);
            return;
        }
        this.start(type);
        ++this.totalTypes;
        try {
            Method[] methodArray = ((BTest)type.getInstance()).list();
            for (int i = 0; i < methodArray.length; ++i) {
                this.run(type, methodArray[i]);
            }
        }
        catch (Throwable throwable) {
            System.out.println("ERROR: Invalid test type: " + type);
            throwable.printStackTrace();
        }
        this.end(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Type type, Method method) {
        if (this.testng) {
            ngRunner.run(type, method);
            return;
        }
        BTest bTest = null;
        try {
            bTest = (BTest)type.getInstance();
        }
        catch (Throwable throwable) {
            System.out.println("ERROR: Invalid test type: " + type);
            throwable.printStackTrace();
            return;
        }
        ++this.totalMethods;
        try {
            this.start(type, method);
            bTest.setup();
            method.invoke((Object)bTest, new Object[0]);
            this.passed(type, method, bTest.verifyCount);
            ++totalMethodsPassed;
            this.totalVerifies += bTest.verifyCount;
        }
        catch (InvocationTargetException invocationTargetException) {
            this.failed(type, method, invocationTargetException.getTargetException());
            ++totalMethodsFailed;
        }
        catch (Throwable throwable) {
            this.failed(type, method, throwable);
            ++totalMethodsFailed;
        }
        finally {
            try {
                bTest.cleanup();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            try {
                bTest.privateCleanup();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public void start() {
    }

    public void end() {
        if (this.testng) {
            return;
        }
        String string = this.totalMethods == 0 ? "*** No tests ran" : (totalMethodsFailed == 0 ? "*** All tests passed!!!" : "*** " + totalMethodsFailed + " failures");
        System.out.println();
        System.out.println("  totalTypes:         " + this.totalTypes);
        System.out.println("  totalMethods:       " + this.totalMethods);
        System.out.println("  totalMethodsPassed: " + totalMethodsPassed);
        System.out.println("  totalMethodsFailed: " + totalMethodsFailed);
        System.out.println("  totalVerifies:      " + this.totalVerifies);
        if (this.failures.size() > 0) {
            System.out.println();
            System.out.println("Failures:");
            for (int i = 0; i < this.failures.size(); ++i) {
                System.out.println("  " + this.failures.get(i));
            }
        }
        System.out.println();
        System.out.println(string);
        System.out.println();
    }

    public void start(Type type) {
        System.out.println("#### " + type + " ####");
    }

    public void end(Type type) {
        System.out.println();
    }

    public void start(Type type, Method method) {
        System.out.println("-- " + type + "." + method.getName());
    }

    public void passed(Type type, Method method, int n) {
        System.out.println("   Passed [" + n + " verifies]");
    }

    public void failed(Type type, Method method, Throwable throwable) {
        System.out.println("   FAILED");
        throwable.printStackTrace();
        this.failures.add(type.toString() + "." + method.getName());
    }

    public static void usage() {
        System.out.println();
        System.out.println("usage:");
        System.out.println("  test <target> [testNGOptions]");
        System.out.println("target:");
        System.out.println("  all");
        System.out.println("  <module>");
        System.out.println("  <module>:<type>");
        System.out.println("  <module>:<type>.<method>");
        System.out.println("testNGOptions:");
        System.out.println("  -btest            Run tests based on BTest");
        System.out.println("  -v:<n>            Set TestNG output verbosity level ( 1 - 10)");
        System.out.println("  -groups:<a,b,c>   Comma-separated list of TestNG group names to test");
        System.out.println("  -excludegroups:<a,b,c>  Comma-separated list of TestNG group names to skip");
        System.out.println("  -output:<path>    Set the location for TestNG output");
        System.out.println();
    }

    public static void main(String[] stringArray) {
        CommandLineArguments commandLineArguments;
        Nre.boot();
        if (stringArray.length > 0 && stringArray[0].equals(TestRunner.class.getName())) {
            stringArray = (String[])ArrayUtil.removeOne((Object[])stringArray, (int)0);
        }
        if ((commandLineArguments = new CommandLineArguments(stringArray)).hasHelpOption() || commandLineArguments.parameters.length == 0) {
            TestRunner.usage();
            throw new RuntimeException();
        }
        TestRunner testRunner = new TestRunner();
        testRunner.testng = false;
        if (!commandLineArguments.hasOption("btest")) {
            testRunner.testng = true;
            TestRunner.setTestNGOptions(commandLineArguments);
        }
        testRunner.run(commandLineArguments.parameters[0]);
        if (!commandLineArguments.hasOption("btest")) {
            totalMethodsFailed = ngRunner.getFailed();
            totalMethodsPassed = ngRunner.getPassed();
            totalMethodsSkipped = ngRunner.getSkipped();
        } else {
            System.exit(0);
        }
    }

    private static void setTestNGOptions(CommandLineArguments commandLineArguments) {
        String string;
        String string2;
        if (commandLineArguments.hasOption("groups") && (string2 = commandLineArguments.getOption("groups")) != null) {
            ngRunner.setGroups(string2);
        }
        if (commandLineArguments.hasOption("excludegroups") && (string2 = commandLineArguments.getOption("excludegroups")) != null) {
            ngRunner.setExcludeGroups(string2);
        }
        if (commandLineArguments.hasOption("v")) {
            int n = 1;
            String string3 = commandLineArguments.getOption("v");
            if (string3 != null) {
                n = Integer.parseInt(string3);
                if (n < 0) {
                    n = 0;
                }
                if (n > 10) {
                    n = 10;
                }
            }
            ngRunner.setVerbosity(n);
        }
        if (commandLineArguments.hasOption("output") && (string = commandLineArguments.getOption("output")) != null) {
            ngRunner.setReportDirectory(string);
        }
    }
}

