/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.test;

import com.tridium.sys.Nre;
import com.tridium.sys.station.Station;
import com.tridium.testng.TestRunnerNg;
import java.io.File;
import java.io.InputStream;
import java.io.StringBufferInputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Comparator;
import javax.baja.io.ValueDocDecoder;
import javax.baja.naming.BLocalHost;
import javax.baja.naming.BOrd;
import javax.baja.nav.BINavNode;
import javax.baja.space.BComponentSpace;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFloat;
import javax.baja.sys.BObject;
import javax.baja.sys.BStation;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.test.TestException;

public abstract class BTest
extends BObject {
    public static final Type TYPE = Sys.loadType(BTest.class);
    int verifyCount = 0;
    protected BStation station = null;
    private static TestStationHandler stationHandler = null;
    private static Object testStationMonitor = new Object();
    private boolean junit = false;

    public Type getType() {
        return TYPE;
    }

    public void setup() throws Exception {
    }

    public void cleanup() throws Exception {
    }

    public Method[] list() throws Exception {
        ArrayList<Method> arrayList = new ArrayList<Method>();
        Method[] methodArray = ((Object)((Object)this)).getClass().getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            Method method = methodArray[i];
            if (!method.getName().startsWith("test")) continue;
            arrayList.add(method);
        }
        return arrayList.toArray(new Method[arrayList.size()]);
    }

    public void verify(boolean bl) {
        if (bl) {
            this.pass();
        } else {
            this.fail("verify(false)");
        }
    }

    public void verify(boolean bl, String string) {
        if (bl) {
            this.pass();
        } else {
            this.fail(string);
        }
    }

    public void fail() {
        this.fail("fail()");
    }

    public void verifyEq(Object object, Object object2) {
        if (object == null) {
            if (object2 == null) {
                this.pass();
            } else {
                this.fail(object + " != " + object2);
            }
        } else if (object2 != null && object.equals(object2)) {
            int n;
            int n2 = object.hashCode();
            if (n2 != (n = object2.hashCode())) {
                this.fail(object + " != " + object2 + " (hashCodes not equal, " + n2 + " != " + n + ")");
            } else {
                this.pass();
            }
        } else {
            this.fail(object + " != " + object2);
        }
    }

    public void verifyEq(Object object, Object object2, Comparator comparator) {
        if (object == null) {
            if (object2 == null) {
                this.pass();
            } else {
                this.fail(object + " != " + object2);
            }
        } else if (object2 != null && comparator.compare(object, object2) == 0) {
            this.pass();
        } else {
            this.fail(object + " != " + object2);
        }
    }

    public void verifyEquivalent(BObject bObject, BObject bObject2) {
        if (bObject == null) {
            if (bObject2 == null) {
                this.pass();
            } else {
                this.fail(bObject + " != " + bObject2);
            }
        } else if (bObject2 != null && bObject.equivalent((Object)bObject2)) {
            this.pass();
        } else {
            this.fail(bObject + " != " + bObject2);
        }
    }

    public void verifySame(Object object, Object object2) {
        if (object == object2) {
            this.pass();
        } else {
            this.fail(object + " !== " + object2);
        }
    }

    public void verifyValuesEq(Object[] objectArray, Object[] objectArray2) {
        if (objectArray == null || objectArray2 == null) {
            if (objectArray == objectArray2) {
                this.pass();
            } else {
                this.fail(BTest.toString(objectArray) + " != " + BTest.toString(objectArray2));
            }
        } else {
            boolean bl = true;
            if (objectArray.length != objectArray2.length) {
                bl = false;
            } else {
                for (int i = 0; i < objectArray.length; ++i) {
                    if (objectArray[i] == null || objectArray2[i] == null) {
                        if (objectArray[i] == objectArray2[i]) continue;
                        bl = false;
                        break;
                    }
                    if (objectArray[i].equals(objectArray2[i])) continue;
                    bl = false;
                    break;
                }
            }
            if (bl) {
                this.pass();
            } else {
                this.fail(BTest.toString(objectArray) + " != " + BTest.toString(objectArray2));
            }
        }
    }

    public void verifyValuesSame(Object[] objectArray, Object[] objectArray2) {
        if (objectArray == null || objectArray2 == null) {
            if (objectArray == objectArray2) {
                this.pass();
            } else {
                this.fail(BTest.toString(objectArray) + " !== " + BTest.toString(objectArray2));
            }
        } else {
            boolean bl = true;
            if (objectArray.length != objectArray2.length) {
                bl = false;
            } else {
                for (int i = 0; i < objectArray.length; ++i) {
                    if (objectArray[i] == objectArray2[i]) continue;
                    bl = false;
                    break;
                }
            }
            if (bl) {
                this.pass();
            } else {
                this.fail(BTest.toString(objectArray) + " !== " + BTest.toString(objectArray2));
            }
        }
    }

    public void verifyValuesEquivalent(BComplex[] bComplexArray, BComplex[] bComplexArray2) {
        if (bComplexArray == null || bComplexArray2 == null) {
            if (bComplexArray == bComplexArray2) {
                this.pass();
            } else {
                this.fail(BTest.toString(bComplexArray) + " != " + BTest.toString(bComplexArray2));
            }
        } else {
            boolean bl = true;
            if (bComplexArray.length != bComplexArray2.length) {
                bl = false;
            } else {
                for (int i = 0; i < bComplexArray.length; ++i) {
                    if (bComplexArray[i] == null || bComplexArray2[i] == null) {
                        if (bComplexArray[i] == bComplexArray2[i]) continue;
                        bl = false;
                        break;
                    }
                    if (bComplexArray[i].equivalent((Object)bComplexArray2[i])) continue;
                    bl = false;
                    break;
                }
            }
            if (bl) {
                this.pass();
            } else {
                this.fail(BTest.toString(bComplexArray) + " != " + BTest.toString(bComplexArray2));
            }
        }
    }

    public void verifyValuesSame(int[] nArray, int[] nArray2) {
        if (nArray == null || nArray2 == null) {
            if (nArray == nArray2) {
                this.pass();
            } else {
                this.fail(this.asString(nArray) + " !== " + this.asString(nArray2));
            }
        } else {
            boolean bl = true;
            if (nArray.length != nArray2.length) {
                bl = false;
            } else {
                for (int i = 0; i < nArray.length; ++i) {
                    if (nArray[i] == nArray2[i]) continue;
                    bl = false;
                    break;
                }
            }
            if (bl) {
                this.pass();
            } else {
                this.fail(this.asString(nArray) + " !== " + this.asString(nArray2));
            }
        }
    }

    public void verifyEq(boolean bl, boolean bl2) {
        if (bl == bl2) {
            this.pass();
        } else {
            this.fail(bl + " != " + bl2);
        }
    }

    public void verifyEq(int n, int n2) {
        if (n == n2) {
            this.pass();
        } else {
            this.fail(n + " != " + n2);
        }
    }

    public void verifyEq(long l, long l2) {
        if (l == l2) {
            this.pass();
        } else {
            this.fail(l + "L != " + l2 + "L");
        }
    }

    public void verifyEq(float f, float f2) {
        if (BFloat.equals((float)f, (float)f2)) {
            this.pass();
        } else {
            this.fail(f + "f != " + f2 + "f");
        }
    }

    public void verifyEq(double d, double d2) {
        if (BDouble.equals((double)d, (double)d2)) {
            this.pass();
        } else {
            this.fail(d + " != " + d2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TestStationHandler createTestStation(String string) throws Exception {
        Object object = testStationMonitor;
        synchronized (object) {
            while (stationHandler != null) {
                testStationMonitor.wait();
            }
            stationHandler = new TestStationHandler(string);
        }
        return stationHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TestStationHandler createTestStation(BOrd bOrd) throws Exception {
        Object object = testStationMonitor;
        synchronized (object) {
            while (stationHandler != null) {
                testStationMonitor.wait();
            }
            stationHandler = new TestStationHandler(bOrd);
        }
        return stationHandler;
    }

    public static TestStationHandler createTestStation() throws Exception {
        return BTest.createTestStation("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<bajaObjectGraph version=\"1.0\">\r\n<p h=\"1\" m=\"b=baja\" t=\"b:Station\">\r\n</p>\r\n</bajaObjectGraph>");
    }

    public BStation getTestStation() {
        if (this.station != null) {
            return this.station;
        }
        this.station = new BStation();
        this.station.setStationName("test");
        BComponentSpace bComponentSpace = new BComponentSpace("station", null, BOrd.make((String)"station:"));
        BLocalHost.INSTANCE.addNavChild((BINavNode)bComponentSpace);
        bComponentSpace.setRootComponent((BComponent)this.station);
        Station.station = this.station;
        Station.space = bComponentSpace;
        Nre.stationHome = new File(Sys.getBajaHome() + File.separator + "test" + File.separator + "station");
        return this.station;
    }

    public void startTestStation() {
        BStation bStation = this.getTestStation();
        if (bStation.isRunning()) {
            return;
        }
        Station.stationStarted = true;
        Nre.serviceManager.startAllServices();
        bStation.start();
    }

    public void stopTestStation() {
        BStation bStation = this.getTestStation();
        if (!bStation.isRunning()) {
            return;
        }
        Nre.serviceManager.stopAllServices();
        bStation.stop();
    }

    public void clearTestStation() {
        this.stopTestStation();
        this.privateCleanup();
        this.station = null;
    }

    void privateCleanup() {
        if (this.station != null) {
            BLocalHost.INSTANCE.removeNavChild((BINavNode)this.station.getSpace());
            Nre.serviceManager.clearAllServices();
        }
    }

    public static String toString(Object[] objectArray) {
        if (objectArray == null) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        for (int i = 0; i < objectArray.length; ++i) {
            if (i > 10) {
                stringBuffer.append(", ...");
                break;
            }
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(objectArray[i]);
        }
        return stringBuffer.append("]").toString();
    }

    public boolean isJunit() {
        return this.junit;
    }

    public void setJunit(boolean bl) {
        this.junit = bl;
    }

    private void pass() {
        if (this.junit) {
            TestRunnerNg.pass();
        } else {
            ++this.verifyCount;
        }
    }

    private void fail(String string) {
        if (!this.junit) {
            throw new TestException(string);
        }
        TestRunnerNg.fail(string);
    }

    private String asString(int[] nArray) {
        if (nArray == null) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        for (int i = 0; i < nArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(Integer.toString(nArray[i]));
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public static class TestStationHandler {
        private BStation station = null;

        private TestStationHandler(String string) throws Exception {
            this(new ValueDocDecoder((InputStream)new StringBufferInputStream(string)));
        }

        private TestStationHandler(BOrd bOrd) throws Exception {
            this(new ValueDocDecoder(bOrd));
        }

        private TestStationHandler(ValueDocDecoder valueDocDecoder) throws Exception {
            BComponentSpace bComponentSpace = new BComponentSpace("station", null, BOrd.make((String)"station:"));
            BLocalHost.INSTANCE.addNavChild((BINavNode)bComponentSpace);
            Station.space = bComponentSpace;
            this.station = new BStation();
            this.station.setStationName("test");
            if (valueDocDecoder != null) {
                BComponent bComponent = (BComponent)valueDocDecoder.decodeDocument();
                if (bComponent instanceof BStation) {
                    this.station = (BStation)bComponent;
                } else {
                    this.station.add("test", (BValue)bComponent, null);
                }
            }
            Station.station = this.station;
            bComponentSpace.setRootComponent((BComponent)this.station);
            Nre.stationHome = new File(Sys.getBajaHome() + File.separator + "test" + File.separator + "station");
        }

        public void startStation() {
            if (this.station.isRunning()) {
                return;
            }
            Station.stationStarted = true;
            Nre.clearPlatform();
            Nre.loadPlatform();
            Nre.serviceManager.startAllServices();
            this.station.start();
        }

        public void stopStation() {
            if (!this.station.isRunning()) {
                return;
            }
            Nre.serviceManager.stopAllServices();
            Nre.clearPlatform();
            this.station.stop();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void releaseStation() {
            this.stopStation();
            Object object = testStationMonitor;
            synchronized (object) {
                BLocalHost.INSTANCE.removeNavChild((BINavNode)this.station.getSpace());
                BComponent[] bComponentArray = Nre.serviceManager.getAllServices();
                for (int i = 0; i < bComponentArray.length; ++i) {
                    Nre.serviceManager.unregister(bComponentArray[i]);
                }
                Nre.serviceManager.clearAllServices();
                Station.stationStarted = false;
                if (this.station.getSlot("test") != null) {
                    this.station.remove("test");
                }
                this.station = null;
                stationHandler = null;
                testStationMonitor.notify();
            }
        }

        public BStation getStation() {
            return this.station;
        }
    }
}

